/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.craftgui;

import binnie.Binnie;
import binnie.core.AbstractMod;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.Gene;
import binnie.core.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.ControlTextEdit;
import binnie.core.gui.controls.scroll.ControlScrollableContent;
import binnie.core.gui.controls.tab.ControlTab;
import binnie.core.gui.controls.tab.ControlTabBar;
import binnie.core.gui.events.EventHandler;
import binnie.core.gui.events.EventTextEdit;
import binnie.core.gui.events.EventValueChanged;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.Position;
import binnie.core.gui.minecraft.MinecraftGUI;
import binnie.core.gui.minecraft.control.ControlPlayerInventory;
import binnie.core.gui.minecraft.control.ControlTabIcon;
import binnie.core.gui.window.Panel;
import binnie.genetics.Genetics;
import binnie.genetics.genetics.Engineering;
import binnie.genetics.genetics.GeneTracker;
import binnie.genetics.machine.craftgui.ControlGeneScroll;
import binnie.genetics.machine.craftgui.WindowMachine;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WindowGeneBank
extends WindowMachine {
    public boolean isNei;
    ControlGeneScroll genes;

    public WindowGeneBank(EntityPlayer player, IInventory inventory, Side side) {
        this(player, inventory, side, false);
    }

    public WindowGeneBank(EntityPlayer player, IInventory inventory, Side side, boolean isNEI) {
        super(320, 224, player, inventory, side);
        this.isNei = isNEI;
    }

    @Override
    public void receiveGuiNBTOnServer(EntityPlayer player, String name, NBTTagCompound nbt) {
        Gene gene;
        super.receiveGuiNBTOnServer(player, name, nbt);
        if (name.equals("gene-select") && (gene = new Gene(nbt.func_74775_l("gene"))) != null) {
            ItemStack held = this.getHeldItemStack();
            ItemStack converted = Engineering.addGene(held, gene);
            this.getPlayer().field_71071_by.func_70437_b(converted);
            this.getPlayer().field_71071_by.func_70296_d();
            if (this.getPlayer() instanceof EntityPlayerMP) {
                ((EntityPlayerMP)this.getPlayer()).func_71120_a(player.field_71069_bz);
            }
        }
    }

    @Override
    public void initialiseServer() {
        GeneTracker tracker = GeneTracker.getTracker(this.getWorld(), this.getUsername());
        if (tracker != null) {
            tracker.synchToPlayer(this.getPlayer());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initialiseClient() {
        super.initialiseClient();
        this.addEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                if (event.value instanceof BreedingSystem) {
                    WindowGeneBank.this.genes.setValue((BreedingSystem)event.value);
                }
            }
        });
        int boxX = 100;
        int x = 16;
        int y = 32;
        new ControlPlayerInventory(this, x, 32);
        boxX = x += 124;
        int geneBoxWidth = 120;
        new Panel(this, boxX + 24, 32, 120, 120, MinecraftGUI.PanelType.BLACK);
        new Panel(this, boxX + 24 + 120, 32, 14, 120, MinecraftGUI.PanelType.GRAY);
        ControlScrollableContent<ControlGeneScroll> scroll = new ControlScrollableContent<ControlGeneScroll>(this, boxX + 24 + 2, 34, 130, 116, 12);
        ControlTextEdit edit = new ControlTextEdit(this, boxX + 27 + 120 - 70, 18, 80, 12);
        this.addEventHandler(new EventTextEdit.Handler(){

            @Override
            public void onEvent(EventTextEdit event) {
                String value = (String)event.getValue();
                if (value == null) {
                    value = "";
                }
                WindowGeneBank.this.genes.setFilter(value);
            }
        }.setOrigin(EventHandler.Origin.SELF, edit));
        this.genes = new ControlGeneScroll(scroll, 1, 1, 120, 116);
        scroll.setScrollableContent(this.genes);
        this.genes.setGenes(Binnie.GENETICS.beeBreedingSystem);
        ControlTabBar<BreedingSystem> tabBar = new ControlTabBar<BreedingSystem>((IWidget)this, boxX, 32, 24, 120, Position.LEFT, Binnie.GENETICS.getActiveSystems()){

            @Override
            public ControlTab<BreedingSystem> createTab(int x, int y, int w, int h, BreedingSystem value) {
                return new ControlTabIcon<BreedingSystem>((ControlTabBar)this, x, y, w, h, value){

                    @Override
                    public void getTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
                        tooltip.add(((BreedingSystem)this.getValue()).toString());
                        int totalGenes = 0;
                        int seqGenes = 0;
                        GeneTracker tracker = GeneTracker.getTracker(WindowGeneBank.this.getWorld(), WindowGeneBank.this.getUsername());
                        Map<IChromosomeType, List<IAllele>> genes = Binnie.GENETICS.getChromosomeMap(((BreedingSystem)this.getValue()).getSpeciesRoot());
                        for (Map.Entry<IChromosomeType, List<IAllele>> entry : genes.entrySet()) {
                            totalGenes += entry.getValue().size();
                            for (IAllele allele : entry.getValue()) {
                                Gene gene = new Gene(allele, entry.getKey(), ((BreedingSystem)this.getValue()).getSpeciesRoot());
                                if (!tracker.isSequenced(gene)) continue;
                                ++seqGenes;
                            }
                        }
                        tooltip.add("" + seqGenes + "/" + totalGenes + " Genes");
                    }
                };
            }
        };
        tabBar.setValue(Binnie.GENETICS.beeBreedingSystem);
        ControlTabBar<List<String>> infoTabs = new ControlTabBar<List<String>>((IWidget)this, (boxX -= 8) + 8, 160, 16, 50, Position.LEFT, Arrays.asList("Info", "Stats", "Ranking"));
        Panel panelProject = new Panel(this, boxX + 24, 160, 140, 50, MinecraftGUI.PanelType.BLACK);
        int totalGenes = 0;
        int seqGenes = 0;
        for (BreedingSystem system : Binnie.GENETICS.getActiveSystems()) {
            GeneTracker tracker = GeneTracker.getTracker(this.getWorld(), this.getUsername());
            Map<IChromosomeType, List<IAllele>> genes = Binnie.GENETICS.getChromosomeMap(system.getSpeciesRoot());
            for (Map.Entry<IChromosomeType, List<IAllele>> entry : genes.entrySet()) {
                totalGenes += entry.getValue().size();
                for (IAllele allele : entry.getValue()) {
                    Gene gene = new Gene(allele, entry.getKey(), system.getSpeciesRoot());
                    if (!tracker.isSequenced(gene)) continue;
                    ++seqGenes;
                }
            }
        }
        new ControlText((IWidget)panelProject, new Point(4, 4), "\u00a7nFull Genome Project");
        new ControlText((IWidget)panelProject, new Point(4, 18), "\u00a7oSequenced \u00a7r" + seqGenes + "/" + totalGenes + " \u00a7oGenes");
    }

    @Override
    public String getTitle() {
        return "Gene Bank";
    }

    @Override
    protected AbstractMod getMod() {
        return Genetics.instance;
    }

    @Override
    protected String getBackgroundTextureName() {
        return "GeneBank";
    }

    public static class ChromosomeType {
        IChromosomeType chromosome;
        BreedingSystem system;

        public ChromosomeType(IChromosomeType chromosome, BreedingSystem system) {
            this.chromosome = chromosome;
            this.system = system;
        }

        public String toString() {
            return this.system.getChromosomeName(this.chromosome);
        }
    }
}

