/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.acclimatiser;

import binnie.core.gui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.GeneticMachine;
import binnie.genetics.machine.acclimatiser.Acclimatiser;
import binnie.genetics.machine.acclimatiser.AcclimatiserLogic;
import binnie.genetics.machine.acclimatiser.ValidatorAcclimatiserItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PackageAcclimatiser
extends GeneticMachine.PackageGeneticBase
implements IMachineInformation {
    public PackageAcclimatiser() {
        super("acclimatiser", GeneticsTexture.ACCLIMATISER, 9857609, true);
    }

    @Override
    public void createMachine(final Machine machine) {
        new ComponentGeneticGUI(machine, GeneticsGUI.ACCLIMATISER);
        ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
        InventorySlot slotTarget = inventory.addSlot(4, "process");
        slotTarget.setValidator(new SlotValidator.Individual());
        slotTarget.setReadOnly();
        slotTarget.forbidExtraction();
        for (InventorySlot slot : inventory.addSlotArray(Acclimatiser.SLOT_RESERVE, "input")) {
            slot.forbidExtraction();
            slot.setValidator(new SlotValidator.Individual());
        }
        for (InventorySlot slot : inventory.addSlotArray(Acclimatiser.SLOT_DRONE, "output")) {
            slot.setReadOnly();
            slot.setValidator(new SlotValidator.Individual());
        }
        for (InventorySlot slot : inventory.addSlotArray(Acclimatiser.SLOT_ACCLIMATISER, "acclimatiser")) {
            slot.setValidator(new ValidatorAcclimatiserItem());
        }
        ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
        transfer.addRestock(Acclimatiser.SLOT_RESERVE, 4, 1);
        transfer.addStorage(4, Acclimatiser.SLOT_DRONE, new ComponentInventoryTransfer.Condition(){

            @Override
            public boolean fulfilled(ItemStack stack) {
                return !Acclimatiser.canAcclimatise(stack, machine.getMachineUtil().getNonEmptyStacks(Acclimatiser.SLOT_ACCLIMATISER));
            }
        });
        new ComponentPowerReceptor(machine, 5000);
        new AcclimatiserLogic(machine);
    }

    @Override
    public TileEntity createTileEntity() {
        return new TileEntityMachine(this);
    }

    @Override
    public void register() {
    }
}

