/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block;

import binnie.core.IInitializable;
import binnie.core.Mods;
import binnie.core.block.ItemMetadata;
import binnie.core.liquid.ILiquidType;
import binnie.core.util.RecipeUtil;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.block.BlockETDecorativeLeaves;
import binnie.extratrees.block.BlockETDefaultLeaves;
import binnie.extratrees.block.BlockHops;
import binnie.extratrees.block.EnumETLog;
import binnie.extratrees.block.EnumShrubLog;
import binnie.extratrees.block.ItemBlockETDecorativeLeaves;
import binnie.extratrees.block.PlankType;
import binnie.extratrees.block.decor.BlockHedge;
import binnie.extratrees.block.decor.BlockMultiFence;
import binnie.extratrees.block.decor.MultiFenceRecipeEmbedded;
import binnie.extratrees.block.decor.MultiFenceRecipeSize;
import binnie.extratrees.block.decor.MultiFenceRecipeSolid;
import binnie.extratrees.block.property.PropertyETType;
import binnie.extratrees.block.wood.BlockETDoor;
import binnie.extratrees.block.wood.BlockETFence;
import binnie.extratrees.block.wood.BlockETLog;
import binnie.extratrees.block.wood.BlockETPlank;
import binnie.extratrees.block.wood.BlockETSlab;
import binnie.extratrees.block.wood.BlockShrubLog;
import binnie.extratrees.block.wood.ItemBlockETWood;
import binnie.extratrees.block.wood.ItemBlockETWoodDoor;
import binnie.extratrees.block.wood.ItemETSlab;
import binnie.extratrees.genetics.ETTreeDefinition;
import binnie.extratrees.item.ExtraTreeLiquid;
import binnie.extratrees.worldgen.VillageCreationExtraTrees;
import com.google.common.base.Preconditions;
import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IWoodAccess;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.ForestryAPI;
import forestry.api.recipes.RecipeManagers;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.WoodAccess;
import forestry.arboriculture.blocks.BlockForestryFenceGate;
import forestry.arboriculture.blocks.BlockForestryStairs;
import forestry.arboriculture.items.ItemBlockLeaves;
import forestry.core.fluids.Fluids;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModuleBlocks
implements IInitializable {
    public List<BlockETLog> logs;
    public List<BlockETLog> logsFireproof;
    public List<BlockETPlank> planks;
    public List<BlockETPlank> planksFireproof;
    public List<BlockETSlab> slabs;
    public List<BlockETSlab> slabsDouble;
    public List<BlockETSlab> slabsFireproof;
    public List<BlockETSlab> slabsDoubleFireproof;
    public List<BlockForestryStairs<EnumETLog>> stairs;
    public List<BlockForestryStairs<EnumETLog>> stairsFireproof;
    public List<BlockETFence> fences;
    public List<BlockETFence> fencesFireproof;
    public List<BlockForestryFenceGate<EnumETLog>> fenceGates;
    public List<BlockForestryFenceGate<EnumETLog>> fenceGatesFireproof;
    public List<BlockETDoor> doors;
    public List<BlockETDecorativeLeaves> leavesDecorative;
    public Map<String, ItemStack> speciesToLeavesDecorative;
    public List<BlockETDefaultLeaves> leavesDefault;
    public Block blockDoor;
    public BlockMultiFence blockMultiFence;
    public BlockHedge blockHedge;
    public BlockShrubLog shrubLog;
    public BlockHops hops;

    private static void registerOreDictWildcard(String oreDictName, Block block) {
        OreDictionary.registerOre((String)oreDictName, (ItemStack)new ItemStack(block, 1, Short.MAX_VALUE));
    }

    public static ItemStack getDecorativeLeaves(String speciesUid) {
        ItemStack itemStack = ExtraTrees.blocks().speciesToLeavesDecorative.get(speciesUid);
        return itemStack.func_77946_l();
    }

    @Override
    public void preInit() {
        String speciesUid;
        String name;
        BlockForestryStairs stair;
        EnumETLog woodType;
        int meta;
        BlockETSlab slabDouble;
        int i;
        WoodAccess woodAccess = WoodAccess.getInstance();
        PlankType.setup();
        this.logs = BlockETLog.create(false);
        this.logsFireproof = BlockETLog.create(true);
        for (BlockETLog blockETLog : this.logs) {
            ExtraTrees.proxy.registerBlock(blockETLog, (ItemBlock)new ItemBlockETWood<BlockETLog>(blockETLog));
            ModuleBlocks.registerOreDictWildcard("logWood", (Block)blockETLog);
        }
        this.logsFireproof = BlockETLog.create(true);
        for (BlockETLog blockETLog : this.logsFireproof) {
            ExtraTrees.proxy.registerBlock(blockETLog, (ItemBlock)new ItemBlockETWood<BlockETLog>(blockETLog));
            ModuleBlocks.registerOreDictWildcard("logWood", (Block)blockETLog);
        }
        woodAccess.registerLogs(this.logs);
        woodAccess.registerLogs(this.logsFireproof);
        this.planks = BlockETPlank.create(false);
        for (BlockETPlank blockETPlank : this.planks) {
            ExtraTrees.proxy.registerBlock(blockETPlank, (ItemBlock)new ItemBlockETWood<BlockETPlank>(blockETPlank));
            ModuleBlocks.registerOreDictWildcard("plankWood", (Block)blockETPlank);
        }
        this.planksFireproof = BlockETPlank.create(true);
        for (BlockETPlank blockETPlank : this.planksFireproof) {
            ExtraTrees.proxy.registerBlock(blockETPlank, (ItemBlock)new ItemBlockETWood<BlockETPlank>(blockETPlank));
            ModuleBlocks.registerOreDictWildcard("plankWood", (Block)blockETPlank);
        }
        woodAccess.registerPlanks(this.planks);
        woodAccess.registerPlanks(this.planksFireproof);
        this.slabs = BlockETSlab.create(false, false);
        this.slabsDouble = BlockETSlab.create(false, true);
        for (i = 0; i < this.slabs.size(); ++i) {
            BlockETSlab blockETSlab = this.slabs.get(i);
            slabDouble = this.slabsDouble.get(i);
            ExtraTrees.proxy.registerBlock(blockETSlab, (ItemBlock)new ItemETSlab(blockETSlab, blockETSlab, slabDouble));
            ExtraTrees.proxy.registerBlock(slabDouble, (ItemBlock)new ItemETSlab(slabDouble, blockETSlab, slabDouble));
            ModuleBlocks.registerOreDictWildcard("slabWood", (Block)blockETSlab);
        }
        this.slabsFireproof = BlockETSlab.create(true, false);
        this.slabsDoubleFireproof = BlockETSlab.create(true, true);
        for (i = 0; i < this.slabsFireproof.size(); ++i) {
            BlockETSlab blockETSlab = this.slabsFireproof.get(i);
            slabDouble = this.slabsDoubleFireproof.get(i);
            ExtraTrees.proxy.registerBlock(blockETSlab, (ItemBlock)new ItemETSlab(blockETSlab, blockETSlab, slabDouble));
            ExtraTrees.proxy.registerBlock(slabDouble, (ItemBlock)new ItemETSlab(slabDouble, blockETSlab, slabDouble));
            ModuleBlocks.registerOreDictWildcard("slabWood", (Block)blockETSlab);
        }
        woodAccess.registerSlabs(this.slabs);
        woodAccess.registerSlabs(this.slabsFireproof);
        this.stairs = new ArrayList<BlockForestryStairs<EnumETLog>>();
        for (BlockETPlank blockETPlank : this.planks) {
            for (IBlockState iBlockState : blockETPlank.func_176194_O().func_177619_a()) {
                meta = blockETPlank.func_176201_c(iBlockState);
                woodType = blockETPlank.getWoodType(meta);
                stair = new BlockForestryStairs(false, iBlockState, (Enum)woodType);
                name = "stairs." + (Object)((Object)woodType);
                stair.setRegistryName(new ResourceLocation("extratrees", name));
                stair.func_149663_c(name);
                ExtraTrees.proxy.registerBlock(stair, (ItemBlock)new ItemBlockETWood<BlockForestryStairs>(stair));
                this.stairs.add((BlockForestryStairs<EnumETLog>)stair);
                ModuleBlocks.registerOreDictWildcard("stairWood", (Block)stair);
            }
        }
        this.stairsFireproof = new ArrayList<BlockForestryStairs<EnumETLog>>();
        for (BlockETPlank blockETPlank : this.planksFireproof) {
            for (IBlockState iBlockState : blockETPlank.func_176194_O().func_177619_a()) {
                meta = blockETPlank.func_176201_c(iBlockState);
                woodType = blockETPlank.getWoodType(meta);
                stair = new BlockForestryStairs(true, iBlockState, (Enum)woodType);
                name = "stairs.fireproof." + (Object)((Object)woodType);
                stair.setRegistryName(new ResourceLocation("extratrees", name));
                stair.func_149663_c(name);
                ExtraTrees.proxy.registerBlock(stair, (ItemBlock)new ItemBlockETWood<BlockForestryStairs>(stair));
                this.stairsFireproof.add((BlockForestryStairs<EnumETLog>)stair);
                ModuleBlocks.registerOreDictWildcard("stairWood", (Block)stair);
            }
        }
        woodAccess.registerStairs(this.stairs);
        woodAccess.registerStairs(this.stairsFireproof);
        this.fences = BlockETFence.create(false);
        for (BlockETFence blockETFence : this.fences) {
            ExtraTrees.proxy.registerBlock(blockETFence, (ItemBlock)new ItemBlockETWood<BlockETFence>(blockETFence));
            ModuleBlocks.registerOreDictWildcard("fenceWood", (Block)blockETFence);
            FMLInterModComms.sendMessage((String)"forestry", (String)"add-fence-block", (String)blockETFence.getRegistryName().toString());
        }
        this.fencesFireproof = BlockETFence.create(true);
        for (BlockETFence blockETFence : this.fencesFireproof) {
            ExtraTrees.proxy.registerBlock(blockETFence, (ItemBlock)new ItemBlockETWood<BlockETFence>(blockETFence));
            ModuleBlocks.registerOreDictWildcard("fenceWood", (Block)blockETFence);
            FMLInterModComms.sendMessage((String)"forestry", (String)"add-fence-block", (String)blockETFence.getRegistryName().toString());
        }
        woodAccess.registerFences(this.fences);
        woodAccess.registerFences(this.fencesFireproof);
        this.fenceGates = new ArrayList<BlockForestryFenceGate<EnumETLog>>();
        this.fenceGatesFireproof = new ArrayList<BlockForestryFenceGate<EnumETLog>>();
        for (Iterator<Object> iterator : PlankType.ExtraTreePlanks.VALUES) {
            EnumETLog woodType2 = ((PlankType.ExtraTreePlanks)((Object)iterator)).getWoodType();
            BlockForestryFenceGate fenceGate = new BlockForestryFenceGate(false, (Enum)woodType2);
            String name2 = "fence.gates." + (Object)((Object)woodType2);
            fenceGate.setRegistryName(new ResourceLocation("extratrees", name2));
            fenceGate.func_149663_c(name2);
            ExtraTrees.proxy.registerBlock(fenceGate, (ItemBlock)new ItemBlockETWood<BlockForestryFenceGate>(fenceGate));
            ModuleBlocks.registerOreDictWildcard("fenceGateWood", (Block)fenceGate);
            this.fenceGates.add((BlockForestryFenceGate<EnumETLog>)fenceGate);
            FMLInterModComms.sendMessage((String)"forestry", (String)"add-fence-block", (String)fenceGate.getRegistryName().toString());
            BlockForestryFenceGate fenceGateFireproof = new BlockForestryFenceGate(true, (Enum)woodType2);
            String nameFireproof = "fence.gates.fireproof." + (Object)((Object)woodType2);
            fenceGateFireproof.setRegistryName(new ResourceLocation("extratrees", nameFireproof));
            fenceGateFireproof.func_149663_c(nameFireproof);
            ExtraTrees.proxy.registerBlock(fenceGateFireproof, (ItemBlock)new ItemBlockETWood<BlockForestryFenceGate>(fenceGateFireproof));
            ModuleBlocks.registerOreDictWildcard("fenceGateWood", (Block)fenceGateFireproof);
            this.fenceGatesFireproof.add((BlockForestryFenceGate<EnumETLog>)fenceGateFireproof);
            FMLInterModComms.sendMessage((String)"forestry", (String)"add-fence-block", (String)fenceGateFireproof.getRegistryName().toString());
        }
        woodAccess.registerFenceGates(new ArrayList<BlockForestryFenceGate<EnumETLog>>(this.fenceGates));
        woodAccess.registerFenceGates(new ArrayList<BlockForestryFenceGate<EnumETLog>>(this.fenceGatesFireproof));
        this.doors = new ArrayList<BlockETDoor>();
        for (Iterator<Object> iterator : EnumETLog.VALUES) {
            if (!((EnumETLog)((Object)iterator)).hasProducts()) continue;
            BlockETDoor door = new BlockETDoor((EnumETLog)((Object)iterator));
            ExtraTrees.proxy.registerBlock(door, (ItemBlock)new ItemBlockETWoodDoor(door));
            ModuleBlocks.registerOreDictWildcard("doorWood", (Block)door);
            this.doors.add(door);
        }
        this.registerDoors(woodAccess, this.doors);
        this.blockMultiFence = new BlockMultiFence();
        ExtraTrees.proxy.registerBlock(this.blockMultiFence, (ItemBlock)new ItemMetadata((Block)this.blockMultiFence));
        this.leavesDefault = BlockETDefaultLeaves.create();
        Map speciesToLeavesDefault = PluginArboriculture.getBlocks().speciesToLeavesDefault;
        for (BlockETDefaultLeaves leaves : this.leavesDefault) {
            ExtraTrees.proxy.registerBlock(leaves, (ItemBlock)new ItemBlockLeaves((Block)leaves));
            ModuleBlocks.registerOreDictWildcard("treeLeaves", (Block)leaves);
            PropertyETType propertyETType = leaves.getVariant();
            for (ETTreeDefinition treeDefinition : propertyETType.func_177700_c()) {
                Preconditions.checkNotNull((Object)((Object)treeDefinition));
                speciesUid = treeDefinition.getUID();
                IBlockState blockState = leaves.func_176223_P().func_177226_a((IProperty)propertyETType, (Comparable)((Object)treeDefinition));
                speciesToLeavesDefault.put(speciesUid, blockState);
            }
        }
        this.leavesDecorative = BlockETDecorativeLeaves.create();
        this.speciesToLeavesDecorative = new HashMap<String, ItemStack>();
        for (BlockETDecorativeLeaves leaves : this.leavesDecorative) {
            ExtraTrees.proxy.registerBlock(leaves, (ItemBlock)new ItemBlockETDecorativeLeaves(leaves));
            ModuleBlocks.registerOreDictWildcard("treeLeaves", leaves);
            for (IBlockState state : leaves.func_176194_O().func_177619_a()) {
                ETTreeDefinition treeDefinition;
                treeDefinition = (ETTreeDefinition)((Object)state.func_177229_b((IProperty)leaves.getVariant()));
                speciesUid = treeDefinition.getUID();
                int meta2 = leaves.func_176201_c(state);
                this.speciesToLeavesDecorative.put(speciesUid, new ItemStack((Block)leaves, 1, meta2));
            }
        }
        this.shrubLog = new BlockShrubLog();
        ExtraTrees.proxy.registerBlock(this.shrubLog, (ItemBlock)new ItemBlockETWood<BlockShrubLog>(this.shrubLog));
        woodAccess.register((IWoodType)EnumShrubLog.INSTANCE, WoodBlockKind.LOG, false, this.shrubLog.func_176203_a(0), new ItemStack((Block)this.shrubLog, 1, 0));
        woodAccess.register((IWoodType)EnumShrubLog.INSTANCE, WoodBlockKind.LOG, true, this.shrubLog.func_176203_a(1), new ItemStack((Block)this.shrubLog, 1, 1));
        this.hops = new BlockHops();
        ExtraTrees.proxy.registerBlock((Block)this.hops);
        VillageCreationExtraTrees.registerVillageComponents();
    }

    public void registerDoors(WoodAccess woodAccess, List<BlockETDoor> blocks) {
        for (BlockETDoor block : blocks) {
            this.registerWithoutVariants(woodAccess, block, WoodBlockKind.DOOR);
        }
    }

    private <T extends Block> void registerWithoutVariants(WoodAccess woodAccess, T woodTyped, WoodBlockKind woodBlockKind) {
        boolean fireproof = ((IWoodTyped)woodTyped).isFireproof();
        IBlockState blockState = woodTyped.func_176223_P();
        IWoodType woodType = ((IWoodTyped)woodTyped).getWoodType(0);
        ItemStack itemStack = new ItemStack(woodTyped);
        if (!(woodType instanceof EnumVanillaWoodType)) {
            PluginArboriculture.proxy.registerWoodModel(woodTyped, false);
        }
        woodAccess.register(woodType, woodBlockKind, fireproof, blockState, itemStack);
    }

    @Override
    public void init() {
        VillageCreationExtraTrees villageHandler = new VillageCreationExtraTrees();
        VillagerRegistry villagerRegistry = VillagerRegistry.instance();
        villagerRegistry.registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)villageHandler);
        RecipeSorter.register((String)"extratrees:multifence", MultiFenceRecipeSize.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        RecipeSorter.register((String)"extratrees:multifence2", MultiFenceRecipeEmbedded.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        RecipeSorter.register((String)"extratrees:multifence3", MultiFenceRecipeSolid.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
    }

    @Override
    public void postInit() {
        RecipeUtil recipeUtil = new RecipeUtil("extratrees");
        for (BlockETLog log : this.logs) {
            ItemStack logInput = new ItemStack((Block)log, 1, Short.MAX_VALUE);
            ItemStack coalOutput = new ItemStack(Items.field_151044_h, 1, 1);
            GameRegistry.addSmelting((ItemStack)logInput, (ItemStack)coalOutput, (float)0.15f);
        }
        IWoodAccess woodAccess = TreeManager.woodAccess;
        for (EnumETLog enumETLog : EnumETLog.VALUES) {
            ItemStack itemStack = woodAccess.getStack((IWoodType)enumETLog, WoodBlockKind.LOG, false);
            ItemStack planks = enumETLog.getPlank().getStack(false);
            ItemStack fireproofLogs = woodAccess.getStack((IWoodType)enumETLog, WoodBlockKind.LOG, true);
            ItemStack fireproofPlanks = enumETLog.getPlank().getStack(true);
            planks.func_190920_e(4);
            recipeUtil.addShapelessRecipe(enumETLog.getUid() + "_planks", planks.func_77946_l(), itemStack.func_77946_l());
            fireproofPlanks.func_190920_e(4);
            recipeUtil.addShapelessRecipe(enumETLog.getUid() + "_fireproof_planks", fireproofPlanks.func_77946_l(), fireproofLogs);
            if (!ForestryAPI.enabledPlugins.containsAll(Arrays.asList("forestry.factory", "forestry.apiculture"))) continue;
            itemStack.func_190920_e(1);
            fireproofLogs.func_190920_e(1);
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, Fluids.GLASS.getFluid(500), fireproofLogs.func_77946_l(), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), Mods.Forestry.item("refractory_wax"), Character.valueOf('X'), itemStack.func_77946_l()});
        }
        for (Enum enum_ : PlankType.ExtraTreePlanks.VALUES) {
            for (boolean fireproof : new boolean[]{false, true}) {
                ItemStack planks = woodAccess.getStack((IWoodType)((PlankType.ExtraTreePlanks)enum_).getWoodType(), WoodBlockKind.PLANKS, fireproof);
                ItemStack slabs = woodAccess.getStack((IWoodType)((PlankType.ExtraTreePlanks)enum_).getWoodType(), WoodBlockKind.SLAB, fireproof);
                ItemStack fences = woodAccess.getStack((IWoodType)((PlankType.ExtraTreePlanks)enum_).getWoodType(), WoodBlockKind.FENCE, fireproof);
                ItemStack fenceGates = woodAccess.getStack((IWoodType)((PlankType.ExtraTreePlanks)enum_).getWoodType(), WoodBlockKind.FENCE_GATE, fireproof);
                ItemStack stairs = woodAccess.getStack((IWoodType)((PlankType.ExtraTreePlanks)enum_).getWoodType(), WoodBlockKind.STAIRS, fireproof);
                String plankUid = ((PlankType.ExtraTreePlanks)enum_).getWoodType().getUid();
                if (fireproof) {
                    plankUid = plankUid + "_fireproof";
                }
                stairs.func_190920_e(4);
                recipeUtil.addRecipe(plankUid + "_stairs", stairs.func_77946_l(), "#  ", "## ", "###", Character.valueOf('#'), planks.func_77946_l());
                slabs.func_190920_e(6);
                recipeUtil.addRecipe(plankUid + "_slabs", slabs.func_77946_l(), "###", Character.valueOf('#'), planks.func_77946_l());
                fences.func_190920_e(3);
                planks.func_190920_e(1);
                recipeUtil.addRecipe(plankUid + "_fences", fences.func_77946_l(), "#X#", "#X#", Character.valueOf('#'), planks.func_77946_l(), Character.valueOf('X'), "stickWood");
                fenceGates.func_190920_e(1);
                planks.func_190920_e(1);
                recipeUtil.addRecipe(plankUid + "_fence_gates", fenceGates.func_77946_l(), "X#X", "X#X", Character.valueOf('#'), planks.func_77946_l(), Character.valueOf('X'), "stickWood");
                if (fireproof) continue;
                ItemStack doors = woodAccess.getStack((IWoodType)((PlankType.ExtraTreePlanks)enum_).getWoodType(), WoodBlockKind.DOOR, false);
                doors.func_190920_e(3);
                planks.func_190920_e(1);
                recipeUtil.addRecipe(plankUid + "_doors", doors.func_77946_l(), "## ", "## ", "## ", Character.valueOf('#'), planks.func_77946_l());
            }
            if (!ForestryAPI.enabledPlugins.containsAll(Arrays.asList("forestry.factory", "forestry.apiculture"))) continue;
            ItemStack itemStack = woodAccess.getStack((IWoodType)((PlankType.ExtraTreePlanks)enum_).getWoodType(), WoodBlockKind.PLANKS, false);
            ItemStack fireproofPlanks = woodAccess.getStack((IWoodType)((PlankType.ExtraTreePlanks)enum_).getWoodType(), WoodBlockKind.PLANKS, true);
            itemStack.func_190920_e(1);
            fireproofPlanks.func_190920_e(5);
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, Fluids.GLASS.getFluid(500), fireproofPlanks.func_77946_l(), new Object[]{"X#X", "#X#", "X#X", Character.valueOf('#'), Mods.Forestry.item("refractory_wax"), Character.valueOf('X'), itemStack.func_77946_l()});
        }
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)new MultiFenceRecipeSize());
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)new MultiFenceRecipeEmbedded());
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)new MultiFenceRecipeSolid());
        this.addSqueezer((IWoodType)EnumVanillaWoodType.SPRUCE, ExtraTreeLiquid.Resin, 50);
    }

    public void addSqueezer(IWoodType log, ILiquidType liquid, int amount, float pulpChance) {
        FluidStack liquidStack = liquid.get(amount);
        ItemStack logStack = TreeManager.woodAccess.getStack(log, WoodBlockKind.LOG, false);
        RecipeManagers.squeezerManager.addRecipe(10, logStack, liquidStack, Mods.Forestry.stack("wood_pulp"), (int)(100.0f * pulpChance));
    }

    public void addSqueezer(IWoodType log, ILiquidType liquid, int amount) {
        this.addSqueezer(log, liquid, amount, 0.5f);
    }
}

