/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol.drink;

import binnie.extratrees.alcohol.Alcohol;
import binnie.extratrees.alcohol.AlcoholEffect;
import binnie.extratrees.alcohol.Glassware;
import binnie.extratrees.alcohol.drink.DrinkManager;
import binnie.extratrees.alcohol.drink.FluidHandlerItemGlassware;
import binnie.extratrees.alcohol.drink.IDrinkLiquid;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDrink
extends ItemFood
implements IItemModelRegister {
    public ItemDrink() {
        super(0, 0.0f, false);
        this.func_77637_a(Tabs.tabArboriculture);
        this.func_77655_b("drink");
        this.setRegistryName("drink");
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77848_i();
    }

    public Glassware getGlassware(ItemStack container) {
        NBTTagCompound nbt = container.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("glassware")) {
            return Glassware.BeerMug;
        }
        return Glassware.values()[nbt.func_74765_d("glassware")];
    }

    public ItemStack getStack(Glassware glass, @Nullable FluidStack fluid, int amount) {
        ItemStack stack = new ItemStack((Item)this, amount);
        this.saveGlassware(glass, stack);
        this.saveFluid(fluid, stack);
        return stack;
    }

    public ItemStack getStack(Glassware glass, @Nullable FluidStack fluid) {
        return this.getStack(glass, fluid, 1);
    }

    public void saveGlassware(Glassware container, ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74777_a("glassware", (short)container.ordinal());
    }

    public void saveFluid(@Nullable FluidStack fluid, ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        if (fluid == null) {
            nbt.func_82580_o("fluid");
        } else {
            NBTTagCompound liq = new NBTTagCompound();
            fluid.writeToNBT(liq);
            nbt.func_74782_a("fluid", (NBTBase)liq);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (Glassware glassware : Glassware.values()) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{glassware.getLocation()});
        }
        manager.registerItemModel(item, stack -> {
            Glassware glassware = this.getGlassware(stack);
            return glassware.getLocation();
        });
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FluidHandlerItemGlassware(stack, this.getGlassware(stack));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Glassware glassware : Glassware.values()) {
                items.add((Object)this.getStack(glassware, null));
            }
            items.add((Object)this.getStack(Glassware.Wine, Alcohol.RedWine.get(Glassware.Wine.getCapacity())));
        }
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
        IDrinkLiquid liquid = fluid == null ? null : DrinkManager.getLiquid(fluid.getFluid());
        String liquidName = liquid == null ? null : liquid.getName();
        return this.getGlassware(stack).getName(liquidName);
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        super.func_77849_c(stack, world, player);
        AlcoholEffect.makeDrunk(player, 2.1f);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        if (FluidUtil.getFluidContained((ItemStack)itemStack) != null) {
            return EnumAction.DRINK;
        }
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 16;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return super.func_77659_a(world, player, hand);
    }
}

