/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.geometry;

import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.Position;

public class Border {
    public static final Border ZERO = new Border(0);
    int t;
    int b;
    int l;
    int r;

    public Border(int pad) {
        this(pad, pad, pad, pad);
    }

    public Border(int tb, int rl) {
        this(tb, rl, tb, rl);
    }

    public Border(int t, int rl, int b) {
        this(t, rl, b, rl);
    }

    public Border(int t, int r, int b, int l) {
        this.t = t;
        this.b = b;
        this.l = l;
        this.r = r;
    }

    public Border(Position edge, int n) {
        this(edge == Position.Top ? n : 0, edge == Position.RIGHT ? n : 0, edge == Position.BOTTOM ? n : 0, edge == Position.LEFT ? n : 0);
    }

    public Border(Border padding) {
        this(padding.t(), padding.r(), padding.b(), padding.l());
    }

    public int t() {
        return this.t;
    }

    public int b() {
        return this.b;
    }

    public int l() {
        return this.l;
    }

    public int r() {
        return this.r;
    }

    public int t(int n) {
        this.t = n;
        return this.t;
    }

    public int b(int n) {
        this.b = n;
        return this.b;
    }

    public int l(int n) {
        this.l = n;
        return this.l;
    }

    public int r(int n) {
        this.r = n;
        return this.r;
    }

    public boolean isNonZero() {
        return (float)this.t != 0.0f || (float)this.b != 0.0f || (float)this.l != 0.0f || (float)this.r != 0.0f;
    }

    @Deprecated
    public Point tl() {
        return new Point(this.l(), this.t());
    }

    @Deprecated
    public Point tr() {
        return new Point(this.r(), this.t());
    }

    @Deprecated
    public Point bl() {
        return new Point(this.l(), this.b());
    }

    @Deprecated
    public Point br() {
        return new Point(this.r(), this.b());
    }

    public Border add(Border o) {
        return new Border(this.t() + o.t(), this.r() + o.r(), this.b() + o.b(), this.l() + o.l());
    }

    public String toString() {
        return this.t() + "-" + this.r() + "-" + this.b() + "-" + this.l();
    }
}

