package binnie.genetics.genetics;

import javax.annotation.Nullable;
import java.util.ArrayList;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

import com.mojang.authlib.GameProfile;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.ISpeciesRoot;

import binnie.core.genetics.Gene;
import binnie.core.network.packet.MessageNBT;
import binnie.genetics.Genetics;
import binnie.genetics.api.IGene;
import binnie.genetics.core.GeneticsPacket;

public class GeneTracker extends WorldSavedData {
	private ArrayList<IGene> discoveredGenes;

	@Nullable
	private GameProfile username;

	public GeneTracker(String s, @Nullable GameProfile username) {
		super(s);
		discoveredGenes = new ArrayList<>();
		this.username = username;
	}

	public GeneTracker(String s) {
		super(s);
		discoveredGenes = new ArrayList<>();
	}

	protected static GeneTracker getCommonTracker(EntityPlayer player) {
		return getTracker(player.field_70170_p, null);
	}

	public static GeneTracker getTracker(World world, @Nullable GameProfile player) {
		String filename = "GeneTracker." + ((player == null) ? "common" : player.getId());
		GeneTracker tracker = (GeneTracker) world.func_72943_a(GeneTracker.class, filename);
		if (tracker == null) {
			tracker = new GeneTracker(filename, player);
			world.func_72823_a(filename, tracker);
		} else {
			tracker.username = player;
		}
		return tracker;
	}

	public void synchToPlayer(EntityPlayer player) {
		NBTTagCompound nbttagcompound = new NBTTagCompound();
		func_189551_b(nbttagcompound);
		Genetics.proxy.sendToPlayer(new MessageNBT(GeneticsPacket.GENE_TRACKER_SYNC.ordinal(), nbttagcompound), player);
	}

	@Override
	public void func_76184_a(NBTTagCompound nbt) {
		for (ISpeciesRoot root : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
			if (!nbt.func_74764_b(root.getUID())) {
				continue;
			}

			NBTTagCompound nbtRoot = nbt.func_74775_l(root.getUID());
			for (IChromosomeType chromo : root.getKaryotype()) {
				if (!nbtRoot.func_74764_b("" + chromo.ordinal())) {
					continue;
				}

				NBTTagList nbtChromo = nbtRoot.func_150295_c("" + chromo.ordinal(), 8);
				for (int i = 0; i < nbtChromo.func_74745_c(); ++i) {
					String uid = nbtChromo.func_150307_f(i);
					IAllele allele = AlleleManager.alleleRegistry.getAllele(uid);
					if (allele == null) {
						continue;
					}

					Gene gene = new Gene(allele, chromo, root);
					if (!discoveredGenes.contains(gene)) {
						discoveredGenes.add(gene);
					}
				}
			}
		}
	}

	@Override
	public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
		for (ISpeciesRoot root : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
			NBTTagCompound nbtRoot = new NBTTagCompound();
			for (IChromosomeType chromo : root.getKaryotype()) {
				NBTTagList nbtChromo = new NBTTagList();
				for (IGene gene : discoveredGenes) {
					if (gene.getSpeciesRoot() == root && gene.getChromosome() == chromo) {
						nbtChromo.func_74742_a(new NBTTagString(gene.getAllele().getUID()));
					}
				}
				nbtRoot.func_74782_a("" + chromo.ordinal(), nbtChromo);
			}
			nbt.func_74782_a(root.getUID(), nbtRoot);
		}
		return nbt;
	}

	public void registerGene(IGene iGene) {
		if (!discoveredGenes.contains(iGene)) {
			discoveredGenes.add(iGene);
		}
		func_76185_a();
	}

	public int getGenesSequenced() {
		return discoveredGenes.size();
	}

	public boolean isSequenced(Gene gene) {
		return discoveredGenes.contains(gene);
	}
}
