package binnie.extratrees.block.decor;

import binnie.Constants;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

import net.minecraftforge.common.ForgeHooks;

import binnie.extratrees.block.WoodManager;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MultiFenceRecipeSolid extends IForgeRegistryEntry.Impl<IRecipe> implements IRecipe {
	private ItemStack cached = ItemStack.field_190927_a;

	public MultiFenceRecipeSolid() {
		setRegistryName(new ResourceLocation(Constants.EXTRA_TREES_MOD_ID, "multi_fence_solid"));
	}

	@Override
	public boolean func_77569_a(final InventoryCrafting inv, final World world) {
		for (int row = 0; row < 3; ++row) {
			ItemStack a = inv.func_70301_a(row * 3);
			ItemStack b = inv.func_70301_a(row * 3 + 1);
			ItemStack c = inv.func_70301_a(row * 3 + 2);
			if (!a.func_190926_b() && !b.func_190926_b() && !c.func_190926_b()) {
				FenceType type = WoodManager.getFenceType(a);
				FenceType type2 = WoodManager.getFenceType(b);
				FenceType type3 = WoodManager.getFenceType(c);
				if (type != null && type2 != null && type3 != null && type.equals(type2) && type.equals(type3)) {
					FenceDescription fenceDescription = WoodManager.getFenceDescription(a);
					if (fenceDescription != null) {
						FenceType fenceType = new FenceType(type.size, true, type.solid);
						this.cached = WoodManager.getFence(fenceDescription.getPlankType(), fenceDescription.getSecondaryPlankType(), fenceType, 2);
						return true;
					}
				}
			}
		}
		return false;
	}

	@Override
	public ItemStack func_77572_b(final InventoryCrafting inv) {
		return this.func_77571_b();
	}

	@Override
	public boolean func_194133_a(int width, int height) {
		return width >= 3 && height >= 3;
	}

	@Override
	public ItemStack func_77571_b() {
		return (this.cached.func_190926_b()) ? new ItemStack(Blocks.field_180407_aO) : this.cached;
	}

	@Override
	public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
		return ForgeHooks.defaultRecipeGetRemainingItems(inv);
	}
}
