package binnie.botany.modules;

import com.google.common.collect.ImmutableSet;

import java.util.Set;

import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

import binnie.Constants;
import binnie.botany.Botany;
import binnie.botany.api.gardening.EnumAcidity;
import binnie.botany.api.gardening.EnumMoisture;
import binnie.botany.farming.CircuitGarden;
import binnie.botany.items.EnumTubeInsulate;
import binnie.botany.items.EnumTubeMaterial;
import binnie.botany.items.ItemInsulatedTube;
import binnie.core.Mods;
import binnie.core.util.RecipeUtil;
import binnie.modules.BinnieModule;
import binnie.modules.Module;

@BinnieModule(moduleID = BotanyModuleUIDs.FARMING, moduleContainerID = Constants.BOTANY_MOD_ID, name = "Farming", unlocalizedDescription = "botany.module.farming")
public class ModuleFarming extends Module {
	public ItemInsulatedTube insulatedTube;

	@Override
	public Set<String> getDependencyUids() {
		return ImmutableSet.of(BotanyModuleUIDs.FLOWERS);
	}

	@Override
	public void registerItemsAndBlocks() {
		insulatedTube = new ItemInsulatedTube();
		Botany.proxy.registerItem(insulatedTube);
	}

	@Override
	public void init() {
		ItemStack yellow = new ItemStack(Blocks.field_150327_N, 1);
		ItemStack red = new ItemStack(Blocks.field_150328_O, 1);
		ItemStack blue = new ItemStack(Blocks.field_150328_O, 1, 7);
		for (boolean manual : new boolean[]{true, false}) {
			for (boolean fertilised : new boolean[]{true, false}) {
				for (EnumMoisture moist : EnumMoisture.values()) {
					ItemStack icon;
					if (moist == EnumMoisture.DRY) {
						icon = yellow;
					} else if (moist == EnumMoisture.NORMAL) {
						icon = red;
					} else {
						icon = blue;
					}
					int insulate = 2 - moist.ordinal();
					if (fertilised) {
						insulate += 3;
					}
					new CircuitGarden(moist, null, manual, fertilised, new ItemStack(insulatedTube, 1, 128 * insulate), icon);
					new CircuitGarden(moist, EnumAcidity.ACID, manual, fertilised, new ItemStack(insulatedTube, 1, 1 + 128 * insulate), icon);
					new CircuitGarden(moist, EnumAcidity.NEUTRAL, manual, fertilised, new ItemStack(insulatedTube, 1, 2 + 128 * insulate), icon);
					new CircuitGarden(moist, EnumAcidity.ALKALINE, manual, fertilised, new ItemStack(insulatedTube, 1, 3 + 128 * insulate), icon);
				}
			}
		}
	}

	@Override
	public void postInit() {
		for (EnumTubeMaterial mat: EnumTubeMaterial.VALUES) {
			RecipeUtil recipeUtil = new RecipeUtil(Constants.BOTANY_MOD_ID);
			for (EnumTubeInsulate insulate : EnumTubeInsulate.VALUES) {
				ItemStack tubes = new ItemStack(insulatedTube, 2, mat.ordinal() + 128 * insulate.ordinal());
				ItemStack insulateStack = ItemInsulatedTube.getInsulateStack(tubes);
				ItemStack forestryTube = new ItemStack(Mods.Forestry.item("thermionic_tubes"), 1, mat.ordinal());
				String recipeName = "thermionic_tubes_" + insulate.getUid() + "_" + mat.getUid();
				recipeUtil.addShapelessRecipe(recipeName, tubes, forestryTube, forestryTube, insulateStack);
			}
		}
	}
}
