package binnie.botany.items;

import com.google.common.base.Preconditions;

import javax.annotation.Nullable;
import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.core.config.Config;
import forestry.core.items.IColoredItem;

import binnie.Binnie;
import binnie.botany.CreativeTabBotany;
import binnie.botany.api.genetics.EnumFlowerChromosome;
import binnie.botany.api.genetics.EnumFlowerStage;
import binnie.botany.api.genetics.IAlleleFlowerSpecies;
import binnie.botany.api.genetics.IFlower;
import binnie.botany.api.genetics.IFlowerGenome;
import binnie.botany.api.genetics.IFlowerType;
import binnie.botany.blocks.BlockFlower;
import binnie.botany.core.BotanyCore;
import binnie.botany.genetics.Flower;
import binnie.botany.modules.ModuleFlowers;
import binnie.core.util.I18N;

public class ItemFlowerGE extends Item implements IColoredItem, IItemModelRegister {
	private EnumFlowerStage type;
	private String tag;

	public ItemFlowerGE(String name, EnumFlowerStage type, String tag) {
		this.type = type;
		this.tag = tag;
		func_77637_a(CreativeTabBotany.instance);
		func_77655_b(name);
		setRegistryName(name);
		field_77787_bX = true;
	}

	@Override
	public boolean func_77645_m() {
		return false;
	}

	@Override
	public boolean isRepairable() {
		return false;
	}

	@Override
	public boolean func_77651_p() {
		return true;
	}

	@Override
	public boolean func_77636_d(ItemStack itemstack) {
		if (!itemstack.func_77942_o()) {
			return false;
		}
		IIndividual individual = getIndividual(itemstack);
		return individual != null && individual.hasEffect();
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
		IFlower individual = (IFlower) getIndividual(itemStack);
		if (individual == null) {
			list.add(TextFormatting.DARK_RED + I18N.localise("item.botany.flower.destroy"));
			return;
		}

		IFlowerGenome genome = individual.getGenome();
		//Colors
		String primaryColor = genome.getPrimaryColor().getColorName();
		String secondaryColor = genome.getSecondaryColor().getColorName();
		String stemColor = genome.getStemColor().getColorName();
		String colorInfo;
		if (!primaryColor.equals(secondaryColor)) {
			colorInfo = I18N.localise("item.botany.grammar.flower.secondary");
		} else {
			colorInfo = I18N.localise("item.botany.grammar.flower");
		}
		list.add(TextFormatting.YELLOW + colorInfo.replaceAll("%PRIMARY", primaryColor).replaceAll("%SECONDARY", secondaryColor).replaceAll("%STEM", stemColor));

		if (individual.isAnalyzed()) {
			if (GuiScreen.func_146272_n()) {
				individual.addTooltip(list);
			} else {
				list.add(TextFormatting.ITALIC + "<" + I18N.localise("for.gui.tooltip.tmi") + ">");
			}
		} else {
			list.add("<" + I18N.localise("for.gui.unknown") + ">");
		}
	}

	@Nullable
	protected IIndividual getIndividual(ItemStack itemstack) {
		NBTTagCompound tagCompound = itemstack.func_77978_p();
		if (tagCompound == null) {
			return null;
		}
		return new Flower(tagCompound);
	}

	private IAlleleFlowerSpecies getPrimarySpecies(ItemStack itemstack) {
		IFlower tree = BotanyCore.getFlowerRoot().getMember(itemstack);
		if (tree == null) {
			return (IAlleleFlowerSpecies) BotanyCore.getFlowerRoot().getDefaultTemplate()[EnumFlowerChromosome.SPECIES.ordinal()];
		}
		return tree.getGenome().getPrimary();
	}

	@Override
	public String func_77653_i(ItemStack itemstack) {
		if (!itemstack.func_77942_o()) {
			return I18N.localise("item.botany.flower.corrupted.name");
		}
		IIndividual individual = getIndividual(itemstack);
		if (individual != null) {
			return individual.getDisplayName() + (!tag.isEmpty() ? " " + I18N.localise("item.botany." + tag + ".name") : "");
		}
		return I18N.localise("item.botany.flower.corrupted.name");
	}

	@Override
	public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
		if (this.func_194125_a(tab)) {
			addCreativeItems(items, true);
		}
	}

	public void addCreativeItems(NonNullList<ItemStack> itemList, boolean hideSecrets) {
		for (IIndividual individual : BotanyCore.getFlowerRoot().getIndividualTemplates()) {
			if (hideSecrets && individual.isSecret() && !Config.isDebug) {
				continue;
			}
			itemList.add(BotanyCore.getFlowerRoot().getMemberStack(individual.copy(), type));
		}
	}

	@Override
	public int getColorFromItemstack(ItemStack stack, int tintIndex) {
		IFlower flower = BotanyCore.getFlowerRoot().getMember(stack);
		if (flower == null) {
			return 0xffffff;
		}
		if (tintIndex == 0) {
			return flower.getGenome().getStemColor().getColor(flower.isWilted());
		}
		return (tintIndex == 1)
				? flower.getGenome().getPrimaryColor().getColor(flower.isWilted())
				: flower.getGenome().getSecondaryColor().getColor(flower.isWilted());
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void registerModel(Item item, IModelManager manager) {
		for (IFlowerType flowerType : (List<IFlowerType>) BlockFlower.FLOWER.func_177700_c()) {
			flowerType.registerModels(item, manager, type);
		}
		manager.registerItemModel(item, new BotanyMeshDefinition());
	}

	@Override
	public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
		ItemStack stack = player.func_184586_b(hand);
		if (type == EnumFlowerStage.POLLEN) {
			return pollinateFlower(world, pos, player, stack);
		}
		return placeFlower(player, stack, world, pos, hand, facing, hitX, hitY, hitZ);
	}

	private EnumActionResult pollinateFlower(World world, BlockPos pos, EntityPlayer player, ItemStack stack){
		IFlower flower = Binnie.GENETICS.getFlowerRoot().getMember(stack);
		TileEntity target = world.func_175625_s(pos);
		if (!(target instanceof IPollinatable)) {
			return EnumActionResult.PASS;
		}
		IPollinatable pollinatable = (IPollinatable) target;
		if (!pollinatable.canMateWith(flower)) {
			return EnumActionResult.FAIL;
		}
		pollinatable.mateWith(flower);
		if (!player.field_71075_bZ.field_75098_d) {
			stack.func_190918_g(1);
		}
		return EnumActionResult.SUCCESS;
	}

	private EnumActionResult placeFlower(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ){
		IBlockState blockState = world.func_180495_p(pos);
		Block block = blockState.func_177230_c();

		if (!block.func_176200_f(world, pos)) {
			pos = pos.func_177972_a(facing);
		}

		if (stack.func_190916_E() != 0 && player.func_175151_a(pos, facing, stack) && world.func_190527_a(ModuleFlowers.flower, pos, false, facing, null)) {
			int i = func_77647_b(stack.func_77960_j());
			IBlockState stateForPlacement = ModuleFlowers.flower.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, i, player, hand);

			if (placeBlockAt(stack, player, world, pos, facing, hitX, hitY, hitZ, stateForPlacement)) {
				SoundType soundType = block.getSoundType(stateForPlacement, world, pos, player);
				world.func_184133_a(player, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0F) / 2.0F, soundType.func_185847_b() * 0.8F);
				stack.func_190918_g(1);
			}

			return EnumActionResult.SUCCESS;
		}
		return EnumActionResult.FAIL;
	}

	public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
		if (!world.func_180501_a(pos, newState, 3)) {
			return false;
		}

		IBlockState state = world.func_180495_p(pos);
		if (state.func_177230_c() == ModuleFlowers.flower) {
			ItemBlock.func_179224_a(world, player, pos, stack);
			ModuleFlowers.flower.func_180633_a(world, pos, state, player, stack);
		}

		return true;
	}

	@SideOnly(Side.CLIENT)
	private class BotanyMeshDefinition implements ItemMeshDefinition {
		@Override
		public ModelResourceLocation func_178113_a(ItemStack stack) {
			IFlower flower = BotanyCore.getFlowerRoot().getMember(stack);
			Preconditions.checkNotNull(flower);
			IAlleleFlowerSpecies flowerSpecies = flower.getGenome().getPrimary();
			return flowerSpecies.getFlowerModel(type, flower.hasFlowered());
		}
	}
}
