package binnie.botany.blocks;

import javax.annotation.Nullable;
import java.util.List;
import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import com.mojang.authlib.GameProfile;

import net.minecraftforge.client.model.ModelLoader;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IStateMapperRegister;
import forestry.core.blocks.IColoredBlock;

import binnie.botany.Botany;
import binnie.botany.api.genetics.IFlower;
import binnie.botany.api.genetics.IFlowerGenome;
import binnie.botany.api.genetics.IFlowerRoot;
import binnie.botany.api.genetics.IFlowerType;
import binnie.botany.blocks.properties.PropertyFlower;
import binnie.botany.core.BotanyCore;
import binnie.botany.genetics.EnumFlowerType;
import binnie.botany.genetics.FlowerDefinition;
import binnie.botany.models.StateMapperFlower;
import binnie.botany.modules.ModuleFlowers;
import binnie.botany.network.PacketID;
import binnie.botany.tile.TileEntityFlower;
import binnie.core.BinnieCore;
import binnie.core.network.packet.MessageNBT;
import binnie.core.util.TileUtil;

import net.minecraft.block.Block.EnumOffsetType;

public class BlockFlower extends BlockContainer implements IColoredBlock, IStateMapperRegister {
	public static final AxisAlignedBB FLOWER_BLOCK_AABB = new AxisAlignedBB(0.3D, 0.0D, 0.3D, 0.7D, 0.6D, 0.7D);
	/* PROPERTIES */
	public static final PropertyFlower FLOWER = new PropertyFlower("flower", IFlowerType.class);
	public static final PropertyInteger SECTION = PropertyInteger.func_177719_a("section", 0, EnumFlowerType.highestSection - 1);
	public static final PropertyBool FLOWERED = PropertyBool.func_177716_a("flowered");
	public static final PropertyBool SEED = PropertyBool.func_177716_a("seed");

	public BlockFlower() {
		super(Material.field_151585_k);
		func_149675_a(true);
		setRegistryName("flower");
		func_149672_a(SoundType.field_185850_c);
	}

	@Override
	public TileEntity func_149915_a(World world, int meta) {
		return new TileEntityFlower();
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void registerStateMapper() {
		ModelLoader.setCustomStateMapper(this, new StateMapperFlower());
	}

	@Override
	public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
		ItemStack heldItem = player.func_184614_ca();
		if (heldItem.func_190926_b() || heldItem.func_77973_b() != BinnieCore.getFieldKit() || !player.func_70093_af()) {
			return false;
		}
		if (world.field_72995_K) {
			return true;
		}

		TileEntity tile = world.func_175625_s(pos);
		if (!(tile instanceof TileEntityFlower)) {
			return true;
		}

		TileEntityFlower tileFlower = (TileEntityFlower) tile;
		IFlower flower = tileFlower.getFlower();
		if (flower == null) {
			return true;
		}

		IFlowerGenome flowerGenome = flower.getGenome();
		NBTTagCompound info = new NBTTagCompound();
		info.func_74778_a("Species", flowerGenome.getPrimary().getUID());
		info.func_74778_a("Species2", flowerGenome.getSecondary().getUID());
		info.func_74776_a("Age", flower.getAge() / flowerGenome.getLifespan());
		info.func_74777_a("Colour", (short) flowerGenome.getPrimaryColor().getID());
		info.func_74777_a("Colour2", (short) flowerGenome.getSecondaryColor().getID());
		info.func_74757_a("Wilting", flower.isWilted());
		info.func_74757_a("Flowered", flower.hasFlowered());
		Botany.proxy.sendToPlayer(new MessageNBT(PacketID.FIELDKIT.ordinal(), info), player);
		heldItem.func_77972_a(1, player);
		return true;
	}

	@Override
	@Nullable
	public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
		return null;
	}

	@Override
	public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
		TileEntity tile = source.func_175625_s(pos);
		if (tile instanceof TileEntityFlower) {
			TileEntityFlower flower = (TileEntityFlower) tile;
			if (flower.getType().getSections() > 1) {
				return field_185505_j;
			}
		}
		return FLOWER_BLOCK_AABB.func_191194_a(func_190949_e(state, source, pos));
	}

	@Override
	public boolean func_149662_c(IBlockState state) {
		return false;
	}

	@Override
	public boolean func_149686_d(IBlockState state) {
		return false;
	}

	@Override
	public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
		super.func_180633_a(world, pos, state, placer, stack);
		IFlowerRoot flowerRoot = BotanyCore.getFlowerRoot();
		TileEntity flower = world.func_175625_s(pos);
		if (!BinnieCore.getBinnieProxy().isSimulating(world)) {
			if (flower != null && flower instanceof TileEntityFlower) {
				IFlower f = flowerRoot.getMember(stack);
				if (f != null) {
					((TileEntityFlower) flower).setRender(new TileEntityFlower.RenderInfo(f, (TileEntityFlower) flower));
				}
			}
			return;
		}

		TileEntity below = world.func_175625_s(pos.func_177977_b());
		if (flower != null && flower instanceof TileEntityFlower) {
			if (below instanceof TileEntityFlower) {
				((TileEntityFlower) flower).setSection(((TileEntityFlower) below).getSection());
			} else {
				GameProfile owner = (placer instanceof EntityPlayer) ? ((EntityPlayer) placer).func_146103_bH() : null;
				((TileEntityFlower) flower).create(stack, owner);
			}
		}
		flowerRoot.tryGrowSection(world, pos);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public int colorMultiplier(IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int tintIndex) {
		if (world != null && pos != null) {
			TileEntity tile = world.func_175625_s(pos);
			if (tile instanceof TileEntityFlower) {
				TileEntityFlower flower = (TileEntityFlower) tile;
				if (tintIndex == 0) {
					return flower.getStemColour();
				} else if (tintIndex == 1) {
					return flower.getPrimaryColour();
				}
				return flower.getSecondaryColour();
			}
		}
		return 0xffffff;
	}

	@Override
	public boolean func_176196_c(World world, BlockPos pos) {
		return super.func_176196_c(world, pos) && canBlockStay(world, pos);
	}

	public boolean canBlockStay(World world, BlockPos pos) {
		TileEntity tile = world.func_175625_s(pos);
		IBlockState downState = world.func_180495_p(pos.func_177977_b());
		if (tile instanceof TileEntityFlower && ((TileEntityFlower) tile).getSection() > 0) {
			return downState.func_177230_c() == ModuleFlowers.flower;
		}
		return canPlaceBlockOn(downState.func_177230_c());
	}

	protected boolean canPlaceBlockOn(Block block) {
		return block == Blocks.field_150349_c
				|| block == Blocks.field_150346_d
				|| block == Blocks.field_150458_ak
				|| BotanyCore.getGardening().isSoil(block);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public EnumBlockRenderType func_149645_b(IBlockState state) {
		return EnumBlockRenderType.MODEL;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public EnumOffsetType func_176218_Q() {
		return EnumOffsetType.XZ;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
		TileEntityFlower flower = TileUtil.getTile(world, pos, TileEntityFlower.class);
		if (flower != null && flower.getType() != null) {
			state = state.func_177226_a(FLOWER, flower.getType());
			state = state.func_177226_a(FLOWERED, flower.isFlowered());
			state = state.func_177226_a(SECTION, flower.getRenderSection());
			state = state.func_177226_a(SEED, flower.getAge() == 0);
		} else {
			state = state.func_177226_a(FLOWER, FlowerDefinition.Dandelion.getSpecies().getType());
			state = state.func_177226_a(FLOWERED, false);
			state = state.func_177226_a(SEED, false);
		}
		return state;
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, FLOWER, FLOWERED, SECTION, SEED);
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return 0;
	}

	@Override
	public BlockRenderLayer func_180664_k() {
		return BlockRenderLayer.CUTOUT;
	}

	@Override
	public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
		checkAndDropBlock(worldIn, pos);
		TileEntity tile = worldIn.func_175625_s(pos);
		if (tile instanceof TileEntityFlower) {
			TileEntityFlower flower = (TileEntityFlower) tile;
			if (flower.getSection() == 0 && flower.getFlower() != null && flower.getFlower().getAge() > 0 && flower.getFlower().getGenome().getPrimary().getType().getSections() > 1 && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != ModuleFlowers.flower) {
				func_176226_b(worldIn, pos, worldIn.func_180495_p(pos), 0);
				worldIn.func_175698_g(pos);
			}
		}
	}

	@Override
	public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
		TileEntity tile = world.func_175625_s(pos);
		if (tile instanceof TileEntityFlower) {
			((TileEntityFlower) tile).randomUpdate(rand);
			checkAndDropBlock(world, pos);
			return;
		}
		world.func_175698_g(pos);
	}

	protected void checkAndDropBlock(World world, BlockPos pos) {
		if (!canBlockStay(world, pos)) {
			func_176226_b(world, pos, world.func_180495_p(pos), 0);
			world.func_175698_g(pos);
		}
	}

	@Override
	public NonNullList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
		NonNullList<ItemStack> drops = NonNullList.func_191196_a();
		TileEntity tile = world.func_175625_s(pos);
		if (tile instanceof TileEntityFlower && ((TileEntityFlower) tile).getSection() == 0) {
			ItemStack flower = ((TileEntityFlower) tile).getItemStack();
			if (!flower.func_190926_b()) {
				drops.add(flower);
			}
		}
		return drops;
	}

	@Override
	public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
		List<ItemStack> drops = getDrops(world, pos, world.func_180495_p(pos), 0);
		boolean hasBeenBroken = world.func_175698_g(pos);
		if (hasBeenBroken && BinnieCore.getBinnieProxy().isSimulating(world) && drops.size() > 0 && (player == null || !player.field_71075_bZ.field_75098_d)) {
			for (ItemStack drop : drops) {
				func_180635_a(world, pos, drop);
			}
		}
		return hasBeenBroken;
	}
}
