/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine;

import binnie.core.machines.IMachine;
import binnie.core.machines.IMachineType;
import binnie.core.machines.Machine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.MachinePackage;
import binnie.core.machines.component.IInteraction;
import binnie.core.machines.network.INetwork;
import binnie.genetics.Genetics;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.machine.GeneticMachine;
import binnie.genetics.machine.ModuleMachine;
import binnie.genetics.machine.acclimatiser.PackageAcclimatiser;
import binnie.genetics.machine.analyser.PackageAnalyser;
import binnie.genetics.machine.genepool.PackageGenepool;
import binnie.genetics.machine.incubator.PackageIncubator;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum LaboratoryMachine implements IMachineType
{
    LabMachine(PackageLabMachine.class),
    Analyser(PackageAnalyser.class),
    Incubator(PackageIncubator.class),
    Genepool(PackageGenepool.class),
    Acclimatiser(PackageAcclimatiser.class);

    Class<? extends MachinePackage> clss;

    private LaboratoryMachine(Class<? extends MachinePackage> clss) {
        this.clss = clss;
    }

    @Override
    public Class<? extends MachinePackage> getPackageClass() {
        return this.clss;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public ItemStack get(int amount) {
        Genetics.machine();
        return new ItemStack((Block)ModuleMachine.packageLabMachine.getBlock(), amount, this.ordinal());
    }

    public static class ComponentGUIHolder
    extends MachineComponent
    implements INetwork.TilePacketSync,
    IInteraction.RightClick {
        @Nonnull
        private ItemStack stack = ItemStack.field_190927_a;

        public ComponentGUIHolder(IMachine machine) {
            super(machine);
        }

        public ItemStack getStack() {
            return this.stack;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbttagcompound) {
            super.readFromNBT(nbttagcompound);
            this.stack = new ItemStack(nbttagcompound.func_74775_l("Item"));
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound1) {
            NBTTagCompound nbttagcompound = super.writeToNBT(nbttagcompound1);
            NBTTagCompound nbt = new NBTTagCompound();
            if (!this.stack.func_190926_b()) {
                this.stack.func_77955_b(nbt);
            }
            nbttagcompound.func_74782_a("Item", (NBTBase)nbt);
            return nbttagcompound;
        }

        @Override
        public void syncToNBT(NBTTagCompound nbt) {
            this.writeToNBT(nbt);
        }

        @Override
        public void syncFromNBT(NBTTagCompound nbt) {
            this.readFromNBT(nbt);
        }

        @Override
        public void onDestruction() {
            super.onDestruction();
            if (!this.stack.func_190926_b()) {
                float f = this.getMachine().getWorld().field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = this.getMachine().getWorld().field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f3 = this.getMachine().getWorld().field_73012_v.nextFloat() * 0.8f + 0.1f;
                if (this.stack.func_190916_E() == 0) {
                    this.stack.func_190920_e(1);
                }
                EntityItem entityitem = new EntityItem(this.getMachine().getWorld(), (double)((float)this.getMachine().getTileEntity().func_174877_v().func_177958_n() + f), (double)((float)this.getMachine().getTileEntity().func_174877_v().func_177956_o() + f2), (double)((float)this.getMachine().getTileEntity().func_174877_v().func_177952_p() + f3), this.stack.func_77946_l());
                float accel = 0.05f;
                entityitem.field_70159_w = (float)this.getMachine().getWorld().field_73012_v.nextGaussian() * 0.05f;
                entityitem.field_70181_x = (float)this.getMachine().getWorld().field_73012_v.nextGaussian() * 0.05f + 0.2f;
                entityitem.field_70179_y = (float)this.getMachine().getWorld().field_73012_v.nextGaussian() * 0.05f;
                this.getMachine().getWorld().func_72838_d((Entity)entityitem);
            }
        }

        @Override
        public void onRightClick(World p0, EntityPlayer p1, BlockPos pos) {
        }
    }

    public static class PackageLabMachine
    extends GeneticMachine.PackageGeneticBase {
        public PackageLabMachine() {
            super("lab_machine", GeneticsTexture.LAB_MACHINE, 0xFFFFFF, false);
        }

        @Override
        public void createMachine(Machine machine) {
            new ComponentGUIHolder(machine);
        }
    }
}

