/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst.tree;

import binnie.botany.api.EnumFlowerChromosome;
import binnie.botany.api.IFlower;
import binnie.core.genetics.Tolerance;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.util.I18N;
import binnie.genetics.gui.analyst.ControlAnalystPage;
import binnie.genetics.gui.analyst.ControlBiome;
import binnie.genetics.gui.analyst.ControlToleranceBar;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBee;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IButterfly;
import java.util.ArrayList;
import net.minecraft.init.Biomes;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class AnalystPageClimate
extends ControlAnalystPage {
    public AnalystPageClimate(IWidget parent, Area area, IIndividual ind) {
        super(parent, area);
        this.setColor(26163);
        EnumTemperature temp = ind.getGenome().getPrimary().getTemperature();
        EnumTolerance tempTol = EnumTolerance.NONE;
        EnumHumidity humid = ind.getGenome().getPrimary().getHumidity();
        EnumTolerance humidTol = EnumTolerance.NONE;
        if (ind instanceof IBee) {
            tempTol = ((IAlleleTolerance)ind.getGenome().getActiveAllele((IChromosomeType)EnumBeeChromosome.TEMPERATURE_TOLERANCE)).getValue();
            humidTol = ((IAlleleTolerance)ind.getGenome().getActiveAllele((IChromosomeType)EnumBeeChromosome.HUMIDITY_TOLERANCE)).getValue();
        }
        if (ind instanceof IFlower) {
            tempTol = ((IAlleleTolerance)ind.getGenome().getActiveAllele((IChromosomeType)EnumFlowerChromosome.TEMPERATURE_TOLERANCE)).getValue();
            humidTol = EnumTolerance.BOTH_5;
        }
        if (ind instanceof IButterfly) {
            tempTol = ((IAlleleTolerance)ind.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.TEMPERATURE_TOLERANCE)).getValue();
            humidTol = ((IAlleleTolerance)ind.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.HUMIDITY_TOLERANCE)).getValue();
        }
        int y = 4;
        new ControlTextCentered((IWidget)this, y, TextFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        new ControlText(this, new Area(4, y += 16, this.getWidth() - 8, 14), I18N.localise("genetics.gui.analyst.climate.temp"), TextJustification.MIDDLE_CENTER).setColor(this.getColor());
        this.createTemperatureBar(this, (this.getWidth() - 100) / 2, y += 12, 100, 10, temp, tempTol);
        y += 16;
        if (!(ind instanceof IFlower)) {
            new ControlText(this, new Area(4, y, this.getWidth() - 8, 14), I18N.localise("genetics.gui.analyst.climate.hum"), TextJustification.MIDDLE_CENTER).setColor(this.getColor());
            this.createHumidity(this, (this.getWidth() - 100) / 2, y += 12, 100, 10, humid, humidTol);
            y += 16;
        }
        new ControlText(this, new Area(4, y, this.getWidth() - 8, 14), I18N.localise("genetics.gui.analyst.climate.biomes"), TextJustification.MIDDLE_CENTER).setColor(this.getColor());
        y += 12;
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (biome == null || biome == Biomes.field_76776_l || !Tolerance.canTolerate(temp, EnumTemperature.getFromBiome((Biome)biome), tempTol) || !Tolerance.canTolerate(humid, EnumHumidity.getFromValue((float)biome.func_76727_i()), humidTol)) continue;
            boolean match = false;
            for (Biome eBiome : biomes) {
                if (!biome.func_185359_l().contains(eBiome.func_185359_l()) || EnumHumidity.getFromValue((float)eBiome.func_76727_i()) != EnumHumidity.getFromValue((float)biome.func_76727_i()) || EnumTemperature.getFromBiome((Biome)eBiome) != EnumTemperature.getFromBiome((Biome)biome)) continue;
                match = true;
            }
            if (match) continue;
            biomes.add(biome);
        }
        int maxBiomePerLine = (this.getWidth() + 2 - 16) / 18;
        int biomeListX = (this.getWidth() - (Math.min(maxBiomePerLine, biomes.size()) * 18 - 2)) / 2;
        int dx = 0;
        int dy = 0;
        for (Biome biome2 : biomes) {
            new ControlBiome(this, biomeListX + dx, y + dy, 16, 16, biome2);
            if ((dx += 18) < 18 * maxBiomePerLine) continue;
            dx = 0;
            dy += 18;
        }
        this.setSize(new Point(this.getWidth(), y + dy + 18 + 8));
    }

    protected void createTemperatureBar(IWidget parent, int x, int y, int w, int h, EnumTemperature value, EnumTolerance tol) {
        new ControlToleranceBar<EnumTemperature>(parent, x, y, w, h, EnumTemperature.class){

            @Override
            protected String getName(EnumTemperature value) {
                return value.name;
            }

            @Override
            protected int getColour(EnumTemperature value) {
                return (new int[]{65531, 7912447, 5242672, 0xFFFF00, 16753152, 0xFF0000})[value.ordinal() - 1];
            }
        }.setValues(value, tol);
    }

    protected void createHumidity(IWidget parent, int x, int y, int w, int h, EnumHumidity value, EnumTolerance tol) {
        new ControlToleranceBar<EnumHumidity>(parent, x, y, w, h, EnumHumidity.class){

            @Override
            protected String getName(EnumHumidity value) {
                return value.name;
            }

            @Override
            protected int getColour(EnumHumidity value) {
                return (new int[]{16770979, 1769216, 3177727})[value.ordinal()];
            }
        }.setValues(value, tol);
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.climate.title");
    }
}

