/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.models;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.ISpriteRegister;
import forestry.api.core.IStateMapperRegister;
import forestry.core.blocks.IColoredBlock;
import forestry.core.items.IColoredItem;
import forestry.core.models.BlockModelEntry;
import forestry.core.models.ModelEntry;
import forestry.core.utils.ModelUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelManager
implements IModelManager {
    private static final List<BlockModelEntry> customBlockModels = new ArrayList<BlockModelEntry>();
    private static final List<ModelEntry> customModels = new ArrayList<ModelEntry>();
    private static final List<ISpriteRegister> spriteRegister = new ArrayList<ISpriteRegister>();
    public static IModelState defaultFenceState;
    private final String modID;
    private final List<IItemModelRegister> itemModelRegisters = new ArrayList<IItemModelRegister>();
    private final List<IStateMapperRegister> stateMapperRegisters = new ArrayList<IStateMapperRegister>();
    private final List<IColoredBlock> blockColorList = new ArrayList<IColoredBlock>();
    private final List<IColoredItem> itemColorList = new ArrayList<IColoredItem>();

    public ModelManager(String modID) {
        this.modID = modID;
    }

    public static IModelState getDefaultFenceState() {
        return defaultFenceState;
    }

    @SideOnly(value=Side.CLIENT)
    public static void reloadSprites() {
        for (ISpriteRegister spriteRegister : ModelManager.spriteRegister) {
            if (spriteRegister == null) continue;
            spriteRegister.registerSprites(ForestryAPI.textureManager);
        }
    }

    public static void registerCustomModels(ModelBakeEvent event) {
        IRegistry registry = event.getModelRegistry();
        for (BlockModelEntry blockModelEntry : customBlockModels) {
            registry.func_82595_a((Object)blockModelEntry.blockModelLocation, (Object)blockModelEntry.model);
            if (blockModelEntry.itemModelLocation == null) continue;
            registry.func_82595_a((Object)blockModelEntry.itemModelLocation, (Object)blockModelEntry.model);
        }
        for (ModelEntry modelEntry : customModels) {
            registry.func_82595_a((Object)modelEntry.modelLocation, (Object)modelEntry.model);
        }
        SimpleModelState defaultBlockState = ModelUtil.loadModelState((ResourceLocation)new ResourceLocation("minecraft:models/block/block"));
        SimpleModelState simpleModelState = ModelUtil.loadModelState((ResourceLocation)new ResourceLocation("minecraft:models/block/fence_inventory"));
        defaultFenceState = ModelManager.mergeStates((IModelState)defaultBlockState, (IModelState)simpleModelState);
    }

    private static IModelState mergeStates(IModelState state, IModelState secondaryState) {
        HashMap tMap = Maps.newHashMap();
        TRSRTransformation guiTransformation = (TRSRTransformation)secondaryState.apply(Optional.of(ItemCameraTransforms.TransformType.GUI)).get();
        tMap.putAll(PerspectiveMapWrapper.getTransforms((IModelState)state));
        tMap.put(ItemCameraTransforms.TransformType.GUI, guiTransformation);
        return new SimpleModelState(ImmutableMap.copyOf((Map)tMap));
    }

    public static void registerCustomBlockModel(BlockModelEntry index) {
        customBlockModels.add(index);
    }

    public static void registerCustomModel(ModelEntry index) {
        customModels.add(index);
    }

    public void registerItemModel(Item item, int meta, String identifier) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)this.getModelLocation(identifier));
    }

    public void registerItemModel(Item item, int meta, String modID, String identifier) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)this.getModelLocation(modID, identifier));
    }

    public void registerItemModel(Item item, int meta) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)this.getModelLocation(item));
    }

    public void registerItemModel(Item item, ItemMeshDefinition definition) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)definition);
    }

    public ModelResourceLocation getModelLocation(Item item) {
        String itemName = item.getRegistryName().func_110623_a();
        return this.getModelLocation(itemName);
    }

    public ModelResourceLocation getModelLocation(String identifier) {
        return this.getModelLocation(this.modID, identifier);
    }

    public ModelResourceLocation getModelLocation(String modID, String identifier) {
        return new ModelResourceLocation(new ResourceLocation(modID, identifier), "inventory");
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockClient(Block block) {
        if (block instanceof IItemModelRegister) {
            this.itemModelRegisters.add((IItemModelRegister)block);
        }
        if (block instanceof IStateMapperRegister) {
            this.stateMapperRegisters.add((IStateMapperRegister)block);
        }
        if (block instanceof IColoredBlock) {
            this.blockColorList.add((IColoredBlock)block);
        }
        if (block instanceof ISpriteRegister) {
            spriteRegister.add((ISpriteRegister)block);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemClient(Item item) {
        if (item instanceof IItemModelRegister) {
            this.itemModelRegisters.add((IItemModelRegister)item);
        }
        if (item instanceof IColoredItem) {
            this.itemColorList.add((IColoredItem)item);
        }
        if (item instanceof ISpriteRegister) {
            spriteRegister.add((ISpriteRegister)item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (IItemModelRegister itemModelRegister : this.itemModelRegisters) {
            Item item = null;
            if (itemModelRegister instanceof Block) {
                item = Item.func_150898_a((Block)((Block)itemModelRegister));
            } else if (itemModelRegister instanceof Item) {
                item = (Item)itemModelRegister;
            }
            if (item == null) continue;
            itemModelRegister.registerModel(item, (IModelManager)this);
        }
        for (IStateMapperRegister stateMapperRegister : this.stateMapperRegisters) {
            stateMapperRegister.registerStateMapper();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemAndBlockColors() {
        Minecraft minecraft = Minecraft.func_71410_x();
        BlockColors blockColors = minecraft.func_184125_al();
        for (IColoredBlock blockColor : this.blockColorList) {
            if (!(blockColor instanceof Block)) continue;
            blockColors.func_186722_a((IBlockColor)ColoredBlockBlockColor.INSTANCE, new Block[]{(Block)blockColor});
        }
        ItemColors itemColors = minecraft.getItemColors();
        for (IColoredItem itemColor : this.itemColorList) {
            if (!(itemColor instanceof Item)) continue;
            itemColors.func_186730_a((IItemColor)ColoredItemItemColor.INSTANCE, new Item[]{(Item)itemColor});
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class ColoredBlockBlockColor
    implements IBlockColor {
        public static final ColoredBlockBlockColor INSTANCE = new ColoredBlockBlockColor();

        private ColoredBlockBlockColor() {
        }

        public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
            Block block = state.func_177230_c();
            if (block instanceof IColoredBlock) {
                return ((IColoredBlock)block).colorMultiplier(state, worldIn, pos, tintIndex);
            }
            return 0xFFFFFF;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class ColoredItemItemColor
    implements IItemColor {
        public static final ColoredItemItemColor INSTANCE = new ColoredItemItemColor();

        private ColoredItemItemColor() {
        }

        public int func_186726_a(ItemStack stack, int tintIndex) {
            Item item = stack.func_77973_b();
            if (item instanceof IColoredItem) {
                return ((IColoredItem)item).getColorFromItemstack(stack, tintIndex);
            }
            return 0xFFFFFF;
        }
    }
}

