/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.inventory.IChargedSlots;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.IProcess;
import binnie.core.machines.power.ITankMachine;
import binnie.core.machines.power.PowerSystem;
import binnie.core.util.ItemStackSet;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class MachineUtil {
    private static final Random DAMAGE_RANDOM = new Random();
    private IMachine machine;

    public MachineUtil(IMachine machine) {
        this.machine = machine;
    }

    public IInventory getInventory() {
        return this.machine.getInterface(IInventory.class);
    }

    public ITankMachine getTankContainer() {
        return this.machine.getInterface(ITankMachine.class);
    }

    public IPoweredMachine getPoweredMachine() {
        return this.machine.getInterface(IPoweredMachine.class);
    }

    public boolean isSlotEmpty(int slot) {
        return this.getInventory().func_70301_a(slot).func_190926_b();
    }

    public IFluidTank getTank(int id) {
        return this.getTankContainer().getTanks()[id];
    }

    public boolean spaceInTank(int id, int amount) {
        IFluidTank tank = this.getTank(id);
        int space = tank.getCapacity() - tank.getFluidAmount();
        return amount <= space;
    }

    public ItemStack getStack(int slot) {
        return this.getInventory().func_70301_a(slot);
    }

    public void deleteStack(int slot) {
        this.setStack(slot, ItemStack.field_190927_a);
    }

    public ItemStack decreaseStack(int slot, int amount) {
        return this.getInventory().func_70298_a(slot, amount);
    }

    public void setStack(int slot, ItemStack stack) {
        this.getInventory().func_70299_a(slot, stack);
    }

    public void fillTank(int id, FluidStack liquidStack) {
        IFluidTank tank = this.getTank(id);
        tank.fill(liquidStack, true);
    }

    public void addStack(int slot, ItemStack addition) {
        ItemStack merge = this.getStack(slot);
        if (merge.func_190926_b()) {
            this.setStack(slot, addition);
        } else if (merge.func_77969_a(addition) && merge.func_190916_E() + addition.func_190916_E() <= merge.func_77976_d()) {
            merge.func_190917_f(addition.func_190916_E());
            this.setStack(slot, merge);
        }
    }

    @Nullable
    public FluidStack drainTank(int tank, int amount) {
        return this.getTank(tank).drain(amount, true);
    }

    public boolean liquidInTank(int tankIndex, int amount) {
        IFluidTank tank = this.getTank(tankIndex);
        FluidStack drain = tank.drain(amount, false);
        return drain != null && drain.amount == amount;
    }

    public void damageItem(ItemStack item, int slot, int damage) {
        if (damage < 0) {
            item.func_77964_b(Math.max(0, item.func_77952_i() + damage));
        } else if (item.func_96631_a(damage, DAMAGE_RANDOM, null)) {
            this.setStack(slot, ItemStack.field_190927_a);
        }
        this.setStack(slot, item);
    }

    public boolean isTankEmpty(int tankInput) {
        return this.getTank(tankInput).getFluidAmount() == 0;
    }

    @Nullable
    public FluidStack getFluid(int tankInput) {
        return this.getTank(tankInput).getFluid();
    }

    public ItemStack[] getStacks(int[] slots) {
        return this.getStacks(slots, false);
    }

    public ItemStack[] getStacks(int[] slots, boolean copy) {
        ItemStack[] stacks = new ItemStack[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            ItemStack stack = this.getStack(slots[i]);
            if (copy) {
                stack = stack.func_77946_l();
            }
            stacks[i] = stack;
        }
        return stacks;
    }

    public boolean hasIngredients(int[] recipe, int[] inventory) {
        ItemStackSet requiredStacks = new ItemStackSet();
        Collections.addAll(requiredStacks, this.getStacks(recipe));
        ItemStackSet inventoryStacks = new ItemStackSet();
        Collections.addAll(inventoryStacks, this.getStacks(inventory));
        requiredStacks.removeAll(inventoryStacks);
        return requiredStacks.isEmpty();
    }

    public boolean removeIngredients(int[] recipe, int[] inventorySlots) {
        if (!this.hasIngredients(recipe, inventorySlots)) {
            return false;
        }
        NonNullList<ItemStack> requiredStacks = this.getNonEmptyStacks(recipe, true);
        block0: for (ItemStack requiredStack : requiredStacks) {
            IInventory inventory = this.getInventory();
            for (int slot : inventorySlots) {
                ItemStack stackInSlot = this.getStack(slot);
                if (stackInSlot.func_190926_b() || !ItemStack.func_179545_c((ItemStack)requiredStack, (ItemStack)stackInSlot) || !ItemStack.func_77970_a((ItemStack)requiredStack, (ItemStack)stackInSlot)) continue;
                if (requiredStack.func_190916_E() >= stackInSlot.func_190916_E()) {
                    requiredStack.func_190918_g(stackInSlot.func_190916_E());
                    inventory.func_70304_b(slot);
                    continue;
                }
                stackInSlot.func_190918_g(requiredStack.func_190916_E());
                requiredStack.func_190920_e(0);
                continue block0;
            }
        }
        return true;
    }

    public void useEnergyMJ(float powerUsage) {
        this.getPoweredMachine().getInterface().useEnergy(PowerSystem.MJ, powerUsage, true);
    }

    public boolean hasEnergyMJ(float powerUsage) {
        return this.getPoweredMachine().getInterface().useEnergy(PowerSystem.MJ, powerUsage, false) >= (double)powerUsage;
    }

    public float getSlotCharge(int slot) {
        return this.machine.getInterface(IChargedSlots.class).getCharge(slot);
    }

    public void useCharge(int slot, float loss) {
        this.machine.getInterface(IChargedSlots.class).alterCharge(slot, -loss);
    }

    public Random getRandom() {
        return new Random();
    }

    public void refreshBlock() {
        BlockPos pos = this.machine.getTileEntity().func_174877_v();
        World world = this.machine.getWorld();
        IBlockState blockState = world.func_180495_p(pos);
        this.machine.getWorld().func_184138_a(pos, blockState, blockState, 0);
    }

    public IProcess getProcess() {
        return this.machine.getInterface(IProcess.class);
    }

    public NonNullList<ItemStack> getNonEmptyStacks(int[] slots) {
        return this.getNonEmptyStacks(slots, false);
    }

    public NonNullList<ItemStack> getNonEmptyStacks(int[] slots, boolean copy) {
        NonNullList stacks = NonNullList.func_191196_a();
        for (ItemStack stack : this.getStacks(slots, copy)) {
            if (stack.func_190926_b()) continue;
            stacks.add((Object)stack);
        }
        return stacks;
    }

    public boolean isServer() {
        return BinnieCore.getBinnieProxy().isSimulating(this.machine.getWorld());
    }
}

