/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.events;

import binnie.core.gui.IWidget;
import binnie.core.gui.events.Event;

public abstract class EventHandler<E extends Event> {
    Class<? extends E> eventClass;
    Origin origin = Origin.ANY;
    IWidget relative = null;

    public EventHandler(Class<? extends E> eventClass) {
        this.eventClass = eventClass;
    }

    public EventHandler<E> setOrigin(Origin origin, IWidget relative) {
        this.origin = origin;
        this.relative = relative;
        return this;
    }

    public abstract void onEvent(E var1);

    public final boolean handles(Event event) {
        return this.eventClass.isInstance(event) && this.origin.isOrigin(event.getOrigin(), this.relative);
    }

    public static enum Origin {
        ANY,
        SELF,
        PARENT,
        DIRECT_CHILD;


        public boolean isOrigin(IWidget origin, IWidget test) {
            switch (this) {
                case ANY: {
                    return true;
                }
                case DIRECT_CHILD: {
                    return test.getChildren().contains(origin);
                }
                case PARENT: {
                    return test.getParent() == origin;
                }
                case SELF: {
                    return test == origin;
                }
            }
            return false;
        }
    }
}

