/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.controls;

import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.controls.core.IControlValue;
import binnie.core.gui.events.EventHandler;
import binnie.core.gui.events.EventKey;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.events.EventTextEdit;
import binnie.core.gui.events.EventWidget;
import binnie.core.gui.resource.minecraft.CraftGUITexture;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ControlTextEdit
extends Control
implements IControlValue<String> {
    private GuiTextField field = new GuiTextField(0, this.getWindow().getGui().getFontRenderer(), 0, 0, 10, 10);
    private String cachedValue = "";

    public ControlTextEdit(IWidget parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.addAttribute(Attribute.CAN_FOCUS);
        this.addAttribute(Attribute.MOUSE_OVER);
        this.field.func_146185_a(false);
        this.addEventHandler(new EventKey.Down.Handler(){

            @Override
            public void onEvent(EventKey.Down event) {
                ControlTextEdit.this.field.func_146201_a(event.getCharacter(), event.getKey());
                String text = ControlTextEdit.this.getValue();
                if (!text.equals(ControlTextEdit.this.cachedValue)) {
                    ControlTextEdit.this.cachedValue = text;
                    ControlTextEdit.this.callEvent(new EventTextEdit((IWidget)ControlTextEdit.this, ControlTextEdit.this.cachedValue));
                    ControlTextEdit.this.onTextEdit(ControlTextEdit.this.cachedValue);
                }
            }
        }.setOrigin(EventHandler.Origin.SELF, this));
        this.addEventHandler(new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                ControlTextEdit.this.field.func_146192_a(ControlTextEdit.this.getRelativeMousePosition().xPos(), ControlTextEdit.this.getRelativeMousePosition().yPos(), event.getButton());
            }
        }.setOrigin(EventHandler.Origin.SELF, this));
        this.addEventHandler(new EventWidget.GainFocus.Handler(){

            @Override
            public void onEvent(EventWidget.GainFocus event) {
                ControlTextEdit.this.field.func_146195_b(true);
            }
        }.setOrigin(EventHandler.Origin.SELF, this));
        this.addEventHandler(new EventWidget.LoseFocus.Handler(){

            @Override
            public void onEvent(EventWidget.LoseFocus event) {
                ControlTextEdit.this.field.func_146195_b(false);
            }
        }.setOrigin(EventHandler.Origin.SELF, this));
    }

    @Override
    public String getValue() {
        return this.field.func_146179_b() == null ? "" : this.field.func_146179_b();
    }

    @Override
    public void setValue(String value) {
        if (!this.getValue().equals(value)) {
            this.field.func_146180_a(value);
            this.field.func_146190_e(0);
        }
    }

    @Override
    public void onUpdateClient() {
    }

    protected void onTextEdit(String value) {
    }

    @Override
    public void onRenderBackground(int guiWidth, int guiHeight) {
        CraftGUI.RENDER.texture((Object)CraftGUITexture.SLOT, this.getArea());
        this.renderTextField();
    }

    protected void renderTextField() {
        this.field.field_146218_h = this.getWidth();
        this.field.field_146219_i = this.getHeight();
        this.field.field_146209_f = (int)(((float)this.getHeight() - 8.0f) / 2.0f);
        this.field.field_146210_g = (int)(((float)this.getHeight() - 8.0f) / 2.0f);
        this.field.func_146194_f();
    }
}

