/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.Binnie;
import binnie.botany.api.IFlowerRoot;
import binnie.botany.genetics.FlowerBreedingSystem;
import binnie.botany.genetics.FlowerColorAllele;
import binnie.core.BinnieCore;
import binnie.core.ManagerBase;
import binnie.core.genetics.BeeBreedingSystem;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.MothBreedingSystem;
import binnie.core.genetics.Tolerance;
import binnie.core.genetics.TreeBreedingSystem;
import com.google.common.base.Preconditions;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterflyRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ManagerGenetics
extends ManagerBase {
    private final Map<ISpeciesRoot, BreedingSystem> BREEDING_SYSTEMS = new LinkedHashMap<ISpeciesRoot, BreedingSystem>();
    public BreedingSystem beeBreedingSystem;
    public BreedingSystem treeBreedingSystem;
    public BreedingSystem mothBreedingSystem;
    public BreedingSystem flowerBreedingSystem;
    private List<IChromosomeType> invalidChromosomeTypes = new ArrayList<IChromosomeType>();
    private Map<ISpeciesRoot, Map<IChromosomeType, List<IAllele>>> chromosomeArray = new LinkedHashMap<ISpeciesRoot, Map<IChromosomeType, List<IAllele>>>();

    @Override
    public void preInit() {
        if (BinnieCore.isApicultureActive()) {
            this.beeBreedingSystem = new BeeBreedingSystem();
        }
        if (BinnieCore.isArboricultureActive()) {
            this.treeBreedingSystem = new TreeBreedingSystem();
        }
        if (BinnieCore.isLepidopteryActive()) {
            this.mothBreedingSystem = new MothBreedingSystem();
        }
        if (BinnieCore.isBotanyActive()) {
            this.flowerBreedingSystem = new FlowerBreedingSystem();
        }
    }

    @Override
    public void postInit() {
        this.refreshData();
    }

    public boolean isSpeciesDiscovered(IAlleleSpecies species, World world, boolean nei) {
        return true;
    }

    public ITreeRoot getTreeRoot() {
        return TreeManager.treeRoot;
    }

    public IBeeRoot getBeeRoot() {
        return BeeManager.beeRoot;
    }

    public IButterflyRoot getButterflyRoot() {
        return ButterflyManager.butterflyRoot;
    }

    public IFlowerRoot getFlowerRoot() {
        return (IFlowerRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootFlowers");
    }

    @Nullable
    public BreedingSystem getSystem(String string) {
        for (BreedingSystem system : this.BREEDING_SYSTEMS.values()) {
            if (!system.getIdent().equals(string)) continue;
            return system;
        }
        return null;
    }

    public BreedingSystem getSystem(ISpeciesRoot root) {
        String rootUID = root.getUID();
        BreedingSystem system = this.getSystem(rootUID);
        Preconditions.checkState((system != null ? 1 : 0) != 0, (String)"Could not find system for species root %s", (Object)rootUID);
        return system;
    }

    public ISpeciesRoot getSpeciesRoot(IAlleleSpecies species) {
        return species.getRoot();
    }

    public IAllele getToleranceAllele(EnumTolerance tol) {
        return AlleleManager.alleleRegistry.getAllele(Tolerance.values()[tol.ordinal()].getUID());
    }

    public int[] getTolerance(EnumTolerance tol) {
        return Tolerance.values()[tol.ordinal()].getBounds();
    }

    public Collection<BreedingSystem> getActiveSystems() {
        return this.BREEDING_SYSTEMS.values();
    }

    public void registerBreedingSystem(BreedingSystem system) {
        this.BREEDING_SYSTEMS.put(system.getSpeciesRoot(), system);
    }

    @Nullable
    public BreedingSystem getConversionSystem(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (BreedingSystem system : this.getActiveSystems()) {
                if (system.getConversion(stack) == null) continue;
                return system;
            }
        }
        return null;
    }

    public ItemStack getConversionStack(ItemStack stack) {
        BreedingSystem system;
        if (!stack.func_190926_b() && (system = this.getConversionSystem(stack)) != null) {
            return system.getConversionStack(stack);
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public IIndividual getConversion(ItemStack stack) {
        BreedingSystem system = this.getConversionSystem(stack);
        return system == null ? null : system.getConversion(stack);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.refreshData();
    }

    private void refreshData() {
        this.loadAlleles();
        for (BreedingSystem system : Binnie.GENETICS.getActiveSystems()) {
            system.calculateArrays();
        }
    }

    private void loadAlleles() {
        this.invalidChromosomeTypes.clear();
        for (ISpeciesRoot root : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
            BreedingSystem system = this.getSystem(root);
            LinkedHashMap chromosomeMap = new LinkedHashMap();
            for (IChromosomeType chromosome : root.getKaryotype()) {
                TreeSet<IAllele> alleles = new TreeSet<IAllele>(new ComparatorAllele());
                for (IIndividual individual : root.getIndividualTemplates()) {
                    IGenome genome = individual.getGenome();
                    IAllele a1 = genome.getActiveAllele(chromosome);
                    IAllele a2 = genome.getInactiveAllele(chromosome);
                    if (chromosome.getAlleleClass().isInstance(a1)) {
                        alleles.add(a1);
                    }
                    if (!chromosome.getAlleleClass().isInstance(a2)) continue;
                    alleles.add(a2);
                }
                system.addExtraAlleles(chromosome, alleles);
                if (alleles.size() == 0) {
                    this.invalidChromosomeTypes.add(chromosome);
                    continue;
                }
                ArrayList<IAllele> alleleList = new ArrayList<IAllele>();
                alleleList.addAll(alleles);
                chromosomeMap.put(chromosome, alleleList);
            }
            this.chromosomeArray.put(root, chromosomeMap);
        }
    }

    public Map<IChromosomeType, List<IAllele>> getChromosomeMap(ISpeciesRoot root) {
        return this.chromosomeArray.get(root);
    }

    public Collection<IChromosomeType> getActiveChromosomes(ISpeciesRoot root) {
        return this.getChromosomeMap(root).keySet();
    }

    public boolean isInvalidChromosome(IChromosomeType type) {
        return this.invalidChromosomeTypes.contains(type);
    }

    static class ComparatorAllele
    implements Comparator<IAllele> {
        ComparatorAllele() {
        }

        @Override
        public int compare(IAllele o1, IAllele o2) {
            if (o1 == null || o2 == null) {
                throw new NullPointerException("Allele is null!");
            }
            if (o1 instanceof IAlleleFloat && o2 instanceof IAlleleFloat) {
                return Float.valueOf(((IAlleleFloat)o1).getValue()).compareTo(Float.valueOf(((IAlleleFloat)o2).getValue()));
            }
            if (o1 instanceof IAlleleInteger && o2 instanceof IAlleleInteger && !(o1 instanceof FlowerColorAllele)) {
                return Integer.valueOf(((IAlleleInteger)o1).getValue()).compareTo(((IAlleleInteger)o2).getValue());
            }
            if (o1.getAlleleName() != null && o2.getAlleleName() != null) {
                return o1.getAlleleName().compareTo(o2.getAlleleName());
            }
            return o1.getUID().compareTo(o2.getUID());
        }
    }
}

