/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.genetics;

import binnie.botany.api.EnumFlowerChromosome;
import binnie.botany.api.IAlleleFlowerSpecies;
import binnie.botany.api.IColorMix;
import binnie.botany.api.IFlower;
import binnie.botany.api.IFlowerColor;
import binnie.botany.api.IFlowerGenome;
import binnie.botany.api.IFlowerMutation;
import binnie.botany.core.BotanyCore;
import binnie.botany.genetics.FlowerGenome;
import binnie.core.util.I18N;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.Individual;
import forestry.core.utils.Translator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class Flower
extends Individual
implements IFlower {
    public IFlowerGenome genome;
    @Nullable
    public IFlowerGenome mate;
    private int age;
    private boolean wilting;
    private boolean flowered;

    public Flower(NBTTagCompound nbt) {
        super(nbt);
        this.age = nbt.func_74764_b("Age") ? nbt.func_74762_e("Age") : 0;
        boolean bl = this.wilting = nbt.func_74764_b("Wilt") && nbt.func_74767_n("Wilt");
        this.flowered = nbt.func_74764_b("Flowered") ? nbt.func_74767_n("Flowered") : this.age > 0;
        this.genome = nbt.func_74764_b("Genome") ? new FlowerGenome(nbt.func_74775_l("Genome")) : BotanyCore.getFlowerRoot().templateAsGenome(BotanyCore.getFlowerRoot().getDefaultTemplate());
        if (nbt.func_74764_b("Mate")) {
            this.mate = new FlowerGenome(nbt.func_74775_l("Mate"));
        }
    }

    public Flower(IFlowerGenome genome, int age) {
        this.genome = genome;
        this.age = age;
        this.wilting = false;
        this.flowered = age > 0;
    }

    public String getDisplayName() {
        IAlleleFlowerSpecies species = this.getGenome().getPrimary();
        String name = species.getAlleleName();
        if (this.age == 0) {
            name = name + "";
        }
        return name;
    }

    public void addTooltip(List<String> list) {
        IAlleleFlowerSpecies primary = this.genome.getPrimary();
        IAlleleFlowerSpecies secondary = this.genome.getSecondary();
        if (!this.isPureBred(EnumFlowerChromosome.SPECIES)) {
            list.add(TextFormatting.BLUE + Translator.translateToLocal((String)"for.bees.hybrid").replaceAll("%PRIMARY", primary.getAlleleName()).replaceAll("%SECONDARY", secondary.getAlleleName()));
        }
        list.add(TextFormatting.GOLD + I18N.localise("item.botany.flower.age", this.getAge()));
        list.add(TextFormatting.GREEN + "T: " + this.getGenome().getPrimary().getTemperature() + " / " + this.getGenome().getToleranceTemperature());
        list.add(TextFormatting.AQUA + "M: " + (Object)((Object)this.getGenome().getPrimary().getMoisture()) + " / " + this.getGenome().getToleranceMoisture());
        list.add(TextFormatting.AQUA + "pH: " + this.getGenome().getPrimary().getHumidity() + " / " + this.getGenome().getTolerancePH());
        list.add(TextFormatting.GOLD + "Fert: " + this.getGenome().getFertility() + "x");
    }

    public String getIdent() {
        return this.getGenome().getPrimary().getUID();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound2) {
        NBTTagCompound nbttagcompound = super.writeToNBT(nbttagcompound2);
        nbttagcompound.func_74768_a("Age", this.age);
        nbttagcompound.func_74757_a("Wilt", this.wilting);
        nbttagcompound.func_74757_a("Flowered", this.flowered);
        NBTTagCompound nbtGenome = new NBTTagCompound();
        this.genome.writeToNBT(nbtGenome);
        nbttagcompound.func_74782_a("Genome", (NBTBase)nbtGenome);
        if (this.mate != null) {
            NBTTagCompound nbtMate = new NBTTagCompound();
            this.mate.writeToNBT(nbtMate);
            nbttagcompound.func_74782_a("Mate", (NBTBase)nbtMate);
        }
        return nbttagcompound;
    }

    @Override
    public IFlowerGenome getGenome() {
        return this.genome;
    }

    private IChromosome inheritChromosome(Random rand, IChromosome parentFirst, IChromosome parentSecond) {
        IAllele choiceFirst = rand.nextBoolean() ? parentFirst.getPrimaryAllele() : parentFirst.getSecondaryAllele();
        IAllele choiceSecond = rand.nextBoolean() ? parentSecond.getPrimaryAllele() : parentSecond.getSecondaryAllele();
        if (rand.nextBoolean()) {
            return new Chromosome(choiceFirst, choiceSecond);
        }
        return new Chromosome(choiceSecond, choiceFirst);
    }

    @Override
    public void mate(IFlower other) {
        this.mate = new FlowerGenome(other.getGenome().getChromosomes());
    }

    @Override
    @Nullable
    public IFlowerGenome getMate() {
        return this.mate;
    }

    public IFlower copy() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new Flower(nbttagcompound);
    }

    @Override
    public int getAge() {
        return this.age;
    }

    @Override
    public void setAge(int i) {
        this.age = i;
    }

    @Override
    public void age() {
        if (this.age < 15) {
            ++this.age;
        }
    }

    @Override
    public int getMaxAge() {
        return this.getGenome().getLifespan();
    }

    @Override
    public boolean isWilted() {
        return this.wilting;
    }

    @Override
    public void setWilted(boolean wilted) {
        this.wilting = wilted;
    }

    @Override
    public boolean hasFlowered() {
        return this.flowered;
    }

    @Override
    public void setFlowered(boolean flowered) {
        this.flowered = flowered;
    }

    @Override
    public void removeMate() {
        this.mate = null;
    }

    @Override
    public IFlower getOffspring(World world, BlockPos pos) {
        if (this.mate != null) {
            IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
            IChromosome[] parentFirst = this.mutateSpecies(world, pos, this.genome, this.mate);
            IChromosome[] parentSecond = this.mutateSpecies(world, pos, this.mate, this.genome);
            for (int i = 0; i < parentFirst.length; ++i) {
                if (parentFirst[i] == null || parentSecond[i] == null) continue;
                chromosomes[i] = Chromosome.inheritChromosome((Random)world.field_73012_v, (IChromosome)parentFirst[i], (IChromosome)parentSecond[i]);
            }
            return new Flower(new FlowerGenome(chromosomes), 0);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        return new Flower(nbt);
    }

    private IChromosome[] mutateSpecies(World world, BlockPos pos, IFlowerGenome genomeFirst, IFlowerGenome genomeSecond) {
        IFlowerGenome genome2;
        IFlowerGenome genome0;
        IAlleleFlowerSpecies alleleSecond;
        IAlleleFlowerSpecies alleleFrist;
        IChromosome[] parentFirst = genomeFirst.getChromosomes();
        IChromosome[] parentSecond = genomeSecond.getChromosomes();
        if (world.field_73012_v.nextBoolean()) {
            alleleFrist = (IAlleleFlowerSpecies)parentFirst[EnumTreeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            alleleSecond = (IAlleleFlowerSpecies)parentSecond[EnumTreeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeFirst;
            genome2 = genomeSecond;
        } else {
            alleleFrist = (IAlleleFlowerSpecies)parentSecond[EnumTreeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            alleleSecond = (IAlleleFlowerSpecies)parentFirst[EnumTreeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeSecond;
            genome2 = genomeFirst;
        }
        IFlowerColor colorFirst = genome0.getPrimaryColor();
        IFlowerColor colorSecond = genome2.getPrimaryColor();
        if (colorFirst != colorSecond) {
            for (IColorMix mutation : BotanyCore.getFlowerRoot().getColorMixes(true)) {
                if (!mutation.isMutation(colorFirst, colorSecond) || !(world.field_73012_v.nextFloat() * 100.0f < (float)mutation.getChance())) continue;
                parentFirst[EnumFlowerChromosome.PRIMARY.ordinal()] = new Chromosome((IAllele)mutation.getResult().getAllele());
            }
        }
        if ((colorFirst = genome0.getSecondaryColor()) != (colorSecond = genome2.getSecondaryColor())) {
            for (IColorMix mutation : BotanyCore.getFlowerRoot().getColorMixes(true)) {
                if (!mutation.isMutation(colorFirst, colorSecond) || !(world.field_73012_v.nextFloat() * 100.0f < (float)mutation.getChance())) continue;
                parentFirst[EnumFlowerChromosome.SECONDARY.ordinal()] = new Chromosome((IAllele)mutation.getResult().getAllele());
            }
        }
        if ((colorFirst = genome0.getStemColor()) != (colorSecond = genome2.getStemColor())) {
            for (IColorMix mutation : BotanyCore.getFlowerRoot().getColorMixes(true)) {
                if (!mutation.isMutation(colorFirst, colorSecond) || !(world.field_73012_v.nextFloat() * 100.0f < (float)mutation.getChance())) continue;
                parentFirst[EnumFlowerChromosome.STEM.ordinal()] = new Chromosome((IAllele)mutation.getResult().getAllele());
            }
        }
        IChromosome[] template = null;
        for (IFlowerMutation iFlowerMutation : BotanyCore.getFlowerRoot().getMutations(true)) {
            float chance = iFlowerMutation.getChance(world, pos, alleleFrist, alleleSecond, genome0, genome2);
            if (!(chance > 0.0f) || !(world.field_73012_v.nextFloat() * 100.0f < chance) || template != null) continue;
            template = BotanyCore.getFlowerRoot().templateAsChromosomes(iFlowerMutation.getTemplate());
        }
        if (template != null) {
            parentFirst = template;
        }
        return parentFirst;
    }
}

