package binnie.extratrees.carpentry;

import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;

import forestry.api.core.Tabs;

import binnie.core.util.I18N;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.block.PlankType;

public class BlockCarpentry extends BlockDesign {
	public BlockCarpentry(String name) {
		super(DesignSystem.Wood, Material.field_151575_d);
		this.func_149647_a(Tabs.tabArboriculture);
		this.setRegistryName(name);
		this.func_149752_b(5.0f);
		this.func_149711_c(2.0f);
		this.func_149672_a(SoundType.field_185848_a);
	}

	@Override
	public ItemStack getCreativeStack(final IDesign design) {
		return ModuleCarpentry.getItemStack(this, PlankType.ExtraTreePlanks.Apple, PlankType.VanillaPlanks.BIRCH, design);
	}

	@Override
	public String getBlockName(final DesignBlock design) {
		return I18N.localise("extratrees.block.woodentile.name", design.getDesign().getName());
	}
}
