package binnie.extratrees.block.decor;

import javax.annotation.Nullable;
import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.arboriculture.PluginArboriculture;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.models.BlockModelEntry;

import binnie.core.block.BlockMetadata;
import binnie.core.block.IBlockMetadata;
import binnie.core.block.TileEntityMetadata;
import binnie.core.models.DefaultStateMapper;
import binnie.core.models.ModelManager;
import binnie.core.util.I18N;
import binnie.extratrees.block.IPlankType;
import binnie.extratrees.block.PlankType;
import binnie.extratrees.block.WoodManager;
import binnie.extratrees.models.ModelMultiFence;

public class BlockMultiFence extends BlockFence implements IBlockMetadata, IStateMapperRegister, IItemModelRegister, IBlockFence {
	public BlockMultiFence() {
		super(Material.field_151575_d, MapColor.field_151663_o);
		this.func_149647_a(Tabs.tabArboriculture);
		this.setRegistryName("multifence");
		this.func_149752_b(5.0f);
		this.func_149711_c(2.0f);
		this.func_149672_a(SoundType.field_185848_a);
	}

	public FenceDescription getDescription(final int meta) {
		return WoodManager.getFenceDescription(meta);
	}

	@Override
	public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
		TileEntity tileentity = world.func_175625_s(pos);
		return tileentity != null && tileentity.func_145842_c(id, param);
	}

	@Override
	public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
		return BlockMetadata.getBlockDroppedAsList(this, world, pos);
	}

	@Override
	public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
		return BlockMetadata.breakBlock(this, player, world, pos);
	}

	@Override
	public TileEntity func_149915_a(final World var1, final int i) {
		return new TileEntityMetadata();
	}

	@Override
	public boolean hasTileEntity(IBlockState state) {
		return true;
	}

	@Override
	public int getPlacedMeta(final ItemStack stack, final World world, final BlockPos pos, final EnumFacing clickedBlock) {
		return TileEntityMetadata.getItemDamage(stack);
	}

	@Override
	public int getDroppedMeta(IBlockState state, final int tileMeta) {
		return tileMeta;
	}

	@Override
	public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
		return true;
	}

	@Override
	public void func_180663_b(World world, BlockPos pos, IBlockState state) {
		super.func_180663_b(world, pos, state);
		world.func_175713_t(pos);
	}

	@Override
	public boolean isWood(final IBlockAccess world, final BlockPos pos) {
		return true;
	}

	@Override
	public int getFlammability(final IBlockAccess world, final BlockPos pos, final EnumFacing face) {
		return 20;
	}

	@Override
	public boolean isFlammable(final IBlockAccess world, final BlockPos pos, final EnumFacing face) {
		return true;
	}

	@Override
	public int getFireSpreadSpeed(final IBlockAccess world, final BlockPos pos, final EnumFacing face) {
		return 5;
	}

	@Override
	public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
		return BlockMetadata.getPickBlock(world, pos);
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new ExtendedBlockState(this, new IProperty[]{field_176526_a, field_176525_b, field_176528_N, field_176527_M}, new IUnlistedProperty[]{UnlistedBlockPos.POS, UnlistedBlockAccess.BLOCKACCESS});
	}

	@Override
	public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
		return ((IExtendedBlockState) state).withProperty(UnlistedBlockPos.POS, pos).withProperty(UnlistedBlockAccess.BLOCKACCESS, world);
	}

	@Override
	public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> itemList) {
		for (FenceType type : FenceType.values()) {
			itemList.add(WoodManager.getFence(PlankType.VanillaPlanks.SPRUCE, PlankType.VanillaPlanks.BIRCH, type, 1));
		}
	}

	@SideOnly(Side.CLIENT)
	@Nullable
	public TextureAtlasSprite getSprite(int meta, boolean secondary) {
		FenceDescription desc = getDescription(meta);
		if (desc != null) {
			IPlankType type = secondary ? desc.getSecondaryPlankType() : desc.getPlankType();
			return type.getSprite();
		}
		return null;
	}

	@Override
	public String getDisplayName(ItemStack itemStack) {
		int meta = TileEntityMetadata.getItemDamage(itemStack);
		IPlankType typeFirst = this.getDescription(meta).getPlankType();
		IPlankType typeSecond = this.getDescription(meta).getSecondaryPlankType();
		boolean twoTypes = typeFirst != typeSecond;
		FenceType fenceType = this.getDescription(meta).getFenceType();
		String woodGrammar = I18N.localise("extratrees.block.multifence" + (twoTypes ? "2" : "") + ".grammar");

		woodGrammar = woodGrammar.replaceAll("%PREFIX", fenceType.getPrefix());
		woodGrammar = woodGrammar.replaceAll("%TYPE", typeSecond.getDesignMaterialName());
		woodGrammar = woodGrammar.replaceAll("%WOOD", typeFirst.getDesignMaterialName());
		return woodGrammar;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerStateMapper() {
		ResourceLocation registryName = getRegistryName();
		ModelLoader.setCustomStateMapper(this, new DefaultStateMapper(registryName));
		ModelManager.registerCustomBlockModel(new BlockModelEntry(
			new ModelResourceLocation(registryName, "normal"),
			new ModelResourceLocation(registryName, "inventory"),
			new ModelMultiFence(), this
		));
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		manager.registerItemModel(item, new FenceMeshDefinition());
	}

	private class FenceMeshDefinition implements ItemMeshDefinition {

		@Override
		public ModelResourceLocation func_178113_a(ItemStack stack) {
			return new ModelResourceLocation(getRegistryName(), "inventory");
		}
	}
}
