package binnie.botany.gardening;

import javax.annotation.Nullable;
import java.util.List;

import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import binnie.botany.api.EnumSoilType;
import binnie.core.util.I18N;

public class ItemSoil extends ItemBlock {
	private final EnumSoilType type;
	private final boolean noWeed;

	public ItemSoil(BlockSoil block) {
		super(block);
		type = block.getType();
		noWeed = block.isWeedKilled();
		field_77787_bX = true;
	}

	@Override
	public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
		String info = "";
		info += BlockSoil.getMoisture(stack, true, true);
		if (info.length() > 0) {
			info += ", ";
		}

		info += BlockSoil.getPH(stack, true, true);
		if (info.length() > 0) {
			tooltip.add(info);
		}

		if (noWeed) {
			tooltip.add(TextFormatting.GREEN + I18N.localise("botany.soil.weedkiller"));
		}
	}

	@Override
	public String func_77653_i(ItemStack stack) {
		return func_77657_g(stack).trim();
	}

	@Override
	public int func_77647_b(int damage) {
		return damage;
	}
}
