/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.core.Binnie;
import binnie.core.liquid.BlockBinnieFluid;
import binnie.core.liquid.FluidContainerType;
import binnie.core.util.I18N;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidType {
    private ResourceLocation textureFlowing;
    private ResourceLocation textureStill;
    private int color;
    private int containerColor;
    private int transparency;
    private String unlocalizedName;
    private final String identifier;
    private ContainerShowHandler showHandler = t -> true;
    private ContainerPlaceHandler placeHandler = t -> true;
    private boolean flammable = false;
    private int flammability = 0;

    public FluidType(String identifier, String unlocalizedName, int color) {
        ResourceLocation texture;
        this.identifier = "binnie." + identifier;
        this.unlocalizedName = unlocalizedName.toLowerCase();
        this.color = color;
        this.containerColor = color;
        this.textureFlowing = texture = new ResourceLocation("binniecore", "blocks/liquids/blank");
        this.textureStill = texture;
    }

    public FluidType setFlammable(boolean flammable) {
        this.flammable = flammable;
        return this;
    }

    public FluidType setFlammability(int flammability) {
        this.flammability = flammability;
        return this;
    }

    public Block makeBlock() {
        return new BlockBinnieFluid(this, this.flammability, this.flammable);
    }

    public final Color getParticleColor() {
        return new Color(this.color);
    }

    @Nullable
    public final Fluid getFluid() {
        return FluidRegistry.getFluid((String)this.identifier);
    }

    public FluidType setTextures(ResourceLocation texture) {
        this.textureFlowing = texture;
        this.textureStill = texture;
        return this;
    }

    public FluidType setTextureFlowing(ResourceLocation textureFlowing) {
        this.textureFlowing = textureFlowing;
        return this;
    }

    public ResourceLocation getFlowing() {
        return this.textureFlowing;
    }

    public FluidType setTextureStill(ResourceLocation textureStill) {
        this.textureStill = textureStill;
        return this;
    }

    public ResourceLocation getStill() {
        return this.textureStill;
    }

    public String getDisplayName() {
        return I18N.localise(this.unlocalizedName);
    }

    public String getTranslationKey() {
        return this.unlocalizedName;
    }

    public FluidType setTranslationKey(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
        return this;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public FluidStack get(int amount) {
        return Binnie.LIQUID.getFluidStack(this.getIdentifier(), amount);
    }

    public FluidStack get() {
        return this.get(1000);
    }

    public FluidType setColor(int color) {
        this.color = color;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public FluidType setContainerColor(int containerColor) {
        this.containerColor = containerColor;
        return this;
    }

    public int getContainerColor() {
        return this.containerColor;
    }

    public FluidType setTransparency(double transparency) {
        this.transparency = (int)(Math.min(1.0, transparency + 0.3) * 255.0);
        return this;
    }

    public FluidType setTransparency(int transparency) {
        this.transparency = transparency;
        return this;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public FluidType setPlaceHandler(ContainerPlaceHandler placeHandler) {
        this.placeHandler = placeHandler;
        return this;
    }

    public FluidType setShowHandler(ContainerShowHandler showHandler) {
        this.showHandler = showHandler;
        return this;
    }

    public boolean canPlaceIn(FluidContainerType type) {
        return this.placeHandler.canPlaceIn(type);
    }

    public boolean showInCreative(FluidContainerType type) {
        return this.showHandler.showInCreative(type);
    }

    public FluidType getDefinition() {
        return this;
    }

    public static interface ContainerPlaceHandler {
        public boolean canPlaceIn(FluidContainerType var1);
    }

    public static interface ContainerShowHandler {
        public boolean showInCreative(FluidContainerType var1);
    }
}

