/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gen;

import binnie.extratrees.worldgen.BlockType;
import binnie.extratrees.worldgen.BlockTypeLeaf;
import binnie.extratrees.worldgen.BlockTypeLog;
import binnie.extratrees.worldgen.BlockTypeVoid;
import binnie.extratrees.worldgen.WorldGenBlockType;
import com.mojang.authlib.GameProfile;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.tiles.TileUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BinnieWorldGenTree
extends WorldGenTree {
    protected final ITreeGenData treeGen;
    protected World world;
    protected Random rand;
    protected BlockPos pos;
    protected final int minHeight;
    protected final int maxHeight;
    protected int requiredHeight;
    protected int heightVariation;
    protected boolean spawnPods;
    protected final int minPodHeight;
    protected WorldGenBlockType leaf;
    protected WorldGenBlockType wood;
    protected final WorldGenBlockType vine;
    protected final WorldGenBlockType air;
    protected float bushiness;

    public BinnieWorldGenTree(ITreeGenData tree, int requiredHeight, int variation) {
        super(tree, requiredHeight, variation);
        this.minHeight = 3;
        this.maxHeight = 80;
        this.requiredHeight = requiredHeight;
        this.heightVariation = variation;
        this.minPodHeight = 3;
        this.vine = new BlockType(Blocks.field_150395_bd.func_176223_P());
        this.air = new BlockTypeVoid();
        this.bushiness = 0.0f;
        this.spawnPods = tree.allowsFruitBlocks();
        this.treeGen = tree;
    }

    protected int randBetween(int a, int b) {
        return a + this.rand.nextInt(b - a);
    }

    protected float randBetween(float a, float b) {
        return a + this.rand.nextFloat() * (b - a);
    }

    public boolean canGrow() {
        return this.treeGen.canGrow(this.world, this.pos, this.treeGen.getGirth(), this.height) != null;
    }

    protected int determineGirth(int base) {
        return base;
    }

    protected int modifyByHeight(int val, int min, int max) {
        int determined = Math.round((float)val * this.treeGen.getHeightModifier());
        return determined < min ? min : Math.min(determined, max);
    }

    protected int determineHeight(int required, int variation) {
        int determined = Math.round((float)(required + this.rand.nextInt(variation)) * this.treeGen.getHeightModifier());
        return determined < this.minHeight ? this.minHeight : Math.min(determined, this.maxHeight);
    }

    public WorldGenBlockType getLeaf() {
        return this.leaf != null ? this.leaf : (this.leaf = new BlockTypeLeaf(null));
    }

    public WorldGenBlockType getLeaf(GameProfile owner) {
        this.leaf = new BlockTypeLeaf(owner);
        return this.leaf;
    }

    public WorldGenBlockType getWood() {
        return new BlockTypeLog(this.treeGen);
    }

    public final boolean generate(World world, Random random, BlockPos pos, boolean force) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)this.rand, (BlockPos)pos)) {
            return false;
        }
        GameProfile owner = BinnieWorldGenTree.getOwner(world, pos);
        this.world = world;
        this.rand = random;
        this.leaf = this.getLeaf(owner);
        this.wood = this.getWood();
        this.girth = this.treeGen.getGirth();
        this.height = this.determineHeight(this.requiredHeight, this.heightVariation);
        BlockPos genPos = force ? pos : this.getValidGrowthPos(world, pos);
        this.pos = genPos;
        this.preGenerate(world, random, this.pos);
        if (!force && !this.canGrow()) {
            return false;
        }
        this.generateTrunk();
        this.generateLeaves();
        if (this.tree.allowsFruitBlocks()) {
            this.generateExtras();
        }
        return true;
    }

    private void generateTrunk() {
        for (int ty = 0; ty < this.height; ++ty) {
            for (int tx = 0; tx < this.girth; ++tx) {
                for (int tz = 0; tz < this.girth; ++tz) {
                    this.addBlock(this.pos.func_177982_a(tx, this.height - ty - 1, tz), this.wood, true);
                }
            }
        }
    }

    @Nullable
    private static GameProfile getOwner(World world, BlockPos pos) {
        TileTreeContainer tile = (TileTreeContainer)TileUtil.getTile((IBlockAccess)world, (BlockPos)pos, TileTreeContainer.class);
        if (tile == null) {
            return null;
        }
        return tile.getOwnerHandler().getOwner();
    }

    protected void generateLeaves() {
        float leafSpawn = this.height;
        float width = (float)this.height * this.randBetween(0.35f, 0.4f);
        if ((double)width < 1.2) {
            width = 1.55f;
        }
        float f = leafSpawn;
        leafSpawn = f - 1.0f;
        this.generateCylinder(new Vector(0.0f, f, 0.0f), width - 1.0f, 1, this.leaf, false);
        float f2 = leafSpawn;
        leafSpawn = f2 - 1.0f;
        this.generateCylinder(new Vector(0.0f, f2, 0.0f), width, 1, this.leaf, false);
        this.generateCylinder(new Vector(0.0f, leafSpawn, 0.0f), width - 0.5f, 1, this.leaf, false);
    }

    protected void generateExtras() {
        for (int b = this.minPodHeight; b < this.height; ++b) {
            for (EnumFacing face : EnumFacing.field_176754_o) {
                BlockPos podPos = this.pos.func_177971_a(face.func_176730_m()).func_177982_a(0, b, 0);
                if (!this.world.func_175623_d(podPos)) continue;
                this.treeGen.trySpawnFruitBlock(this.world, this.rand, this.pos.func_177971_a(face.func_176730_m()).func_177982_a(0, b, 0));
            }
        }
    }

    protected void generateSupportStems(int height, int girth, float chance, float maxHeight) {
        int offset = 1;
        for (int x = -offset; x < girth + offset; ++x) {
            for (int z = -offset; z < girth + offset; ++z) {
                if (x == -offset && z == -offset || x == girth + offset && z == girth + offset || x == -offset && z == girth + offset || x == girth + offset && z == -offset) continue;
                int stemHeight = this.rand.nextInt(Math.round((float)height * maxHeight));
                if (!(this.rand.nextFloat() < chance)) continue;
                for (int i = 0; i < stemHeight; ++i) {
                    this.addWood(new BlockPos(x, i, z), true);
                }
            }
        }
    }

    protected final void clearBlock(int x, int y, int z) {
        this.air.setBlock(this.world, this.treeGen, this.pos, this.rand);
    }

    protected final void addBlock(BlockPos pos, WorldGenBlockType type, boolean doReplace) {
        if (doReplace || this.world.func_175623_d(pos)) {
            type.setBlock(this.world, this.treeGen, pos, this.rand);
        }
    }

    protected final void addWood(BlockPos pos, boolean doReplace) {
        this.addBlock(pos, this.wood, doReplace);
    }

    protected final void addLeaf(BlockPos pos, boolean doReplace) {
        this.addBlock(pos, this.leaf, doReplace);
    }

    protected final void addVine(BlockPos pos) {
        this.addBlock(pos, this.vine, false);
    }

    protected final void generateCuboid(Vector start, Vector area, WorldGenBlockType block, boolean doReplace) {
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    this.addBlock(this.pos, block, doReplace);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    protected final void generateCylinder(Vector center2, float radius, int height, WorldGenBlockType block, boolean doReplace) {
        float centerOffset = (float)(this.girth - 1) / 2.0f;
        Vector center3 = new Vector(center2.x + centerOffset, center2.y, center2.z + centerOffset);
        Vector start = new Vector(center3.x - radius, center3.y, center3.z - radius);
        Vector area = new Vector(radius * 2.0f + 1.0f, height, radius * 2.0f + 1.0f);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    Vector vector = new Vector(x, y, z);
                    Vector vector2 = new Vector(center3.x, y, center3.z);
                    if (Vector.distance(vector, vector2) <= (double)radius + 0.01 && (Vector.distance(new Vector(x, y, z), new Vector(center3.x, y, center3.z)) < (double)(radius - 0.5f) || this.rand.nextFloat() >= this.bushiness)) {
                        this.addBlock(this.pos.func_177982_a(x, y, z), block, doReplace);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    protected final void generateCircle(Vector center, float radius, int width, int height, WorldGenBlockType block, boolean doReplace) {
        this.generateCircle(center, radius, width, height, block, 1.0f, doReplace);
    }

    protected final void generateCircle(Vector center2, float radius, int width, int height, WorldGenBlockType block, float chance, boolean doReplace) {
        float centerOffset = this.girth % 2 == 0 ? 0.5f : 0.0f;
        Vector center3 = new Vector(center2.x + centerOffset, center2.y, center2.z + centerOffset);
        Vector start = new Vector(center3.x - radius, center3.y, center3.z - radius);
        Vector area = new Vector(radius * 2.0f + 1.0f, height, radius * 2.0f + 1.0f);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    double distance;
                    if (this.rand.nextFloat() <= chance && (double)(radius - (float)width) - 0.01 < (distance = Vector.distance(new Vector(x, y, z), new Vector(center3.x, y, center3.z))) && distance <= (double)radius + 0.01) {
                        this.addBlock(new BlockPos(x, y, z), block, doReplace);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    protected final void generateSphere(Vector center2, int radius, WorldGenBlockType block, boolean doReplace) {
        float centerOffset = (float)(this.girth - 1) / 2.0f;
        Vector center3 = new Vector(center2.x + centerOffset, center2.y, center2.z + centerOffset);
        Vector start = new Vector(center3.x - (float)radius, center3.y - (float)radius, center3.z - (float)radius);
        Vector area = new Vector(radius * 2 + 1, radius * 2 + 1, radius * 2 + 1);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    Vector vector = new Vector(x, y, z);
                    Vector vector2 = new Vector(center3.x, center3.y, center3.z);
                    if (Vector.distance(vector, vector2) <= (double)radius + 0.01) {
                        this.addBlock(new BlockPos(x, y, z), block, doReplace);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    static class Vector {
        final float x;
        final float y;
        final float z;

        public Vector(float f, float h, float g) {
            this.x = f;
            this.y = h;
            this.z = g;
        }

        public static double distance(Vector a, Vector b) {
            return Math.sqrt(Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0) + Math.pow(a.z - b.z, 2.0));
        }
    }
}

