package binnie.botany.genetics;

import binnie.botany.api.BotanyAPI;
import binnie.botany.api.genetics.EnumFlowerColor;
import forestry.api.genetics.AlleleManager;

import static binnie.botany.api.genetics.EnumFlowerColor.*;

public final class FlowerColorMutations {
	private FlowerColorMutations() {

	}

	public static void registerFlowerColorAlleles() {
		for (EnumFlowerColor color : values()) {
			AlleleManager.alleleRegistry.registerAllele(color.getFlowerColorAllele());
		}
	}

	public static void registerFlowerColorMutations() {
		addMix(Blue, Aquamarine, SteelBlue, 55);
		addMix(Blue, Black, Navy, 85);
		addMix(Brown, Aquamarine, Gray, 50);
		addMix(Brown, Black, Maroon, 90);
		addMix(Brown, Blue, Indigo, 85);
		addMix(CadetBlue, Aquamarine, MediumAquamarine, 100);
		addMix(CadetBlue, Black, DarkSlateGray, 75);
		addMix(CadetBlue, Blue, SlateBlue, 85);
		addMix(Chocolate, Aquamarine, DarkKhaki, 65);
		addMix(Chocolate, Blue, DarkSlateBlue, 65);
		addMix(Chocolate, Brown, Sienna, 100);
		addMix(Coral, Aquamarine, DarkKhaki, 65);
		addMix(Coral, Black, Sienna, 65);
		addMix(Coral, Blue, DarkViolet, 65);
		addMix(Coral, Brown, IndianRed, 95);
		addMix(Coral, CadetBlue, RosyBrown, 80);
		addMix(Coral, Chocolate, Peru, 115);
		addMix(Crimson, Aquamarine, RosyBrown, 45);
		addMix(Crimson, Black, Maroon, 80);
		addMix(Crimson, Blue, Indigo, 85);
		addMix(Crimson, Brown, IndianRed, 115);
		addMix(Crimson, Chocolate, Red, 100);
		addMix(Crimson, Coral, IndianRed, 105);
		addMix(Cyan, Aquamarine, Turquoise, 115);
		addMix(Cyan, Blue, DodgerBlue, 60);
		addMix(Cyan, Brown, CadetBlue, 50);
		addMix(Cyan, CadetBlue, DarkTurquoise, 100);
		addMix(Cyan, Chocolate, MediumAquamarine, 65);
		addMix(Cyan, Coral, MediumAquamarine, 65);
		addMix(Cyan, Crimson, SlateGray, 50);
		addMix(DarkGoldenrod, Aquamarine, DarkSeaGreen, 80);
		addMix(DarkGoldenrod, Blue, DarkSlateBlue, 55);
		addMix(DarkGoldenrod, Brown, Sienna, 85);
		addMix(DarkGoldenrod, CadetBlue, OliveDrab, 90);
		addMix(DarkGoldenrod, Chocolate, Peru, 110);
		addMix(DarkGoldenrod, Coral, Peru, 100);
		addMix(DarkGoldenrod, Crimson, Sienna, 85);
		addMix(DarkGoldenrod, Cyan, MediumSeaGreen, 75);
		addMix(DarkGray, Aquamarine, MediumAquamarine, 95);
		addMix(DarkGray, Black, DimGray, 70);
		addMix(DarkGray, Blue, SlateBlue, 75);
		addMix(DarkGray, Brown, IndianRed, 85);
		addMix(DarkGray, Chocolate, Peru, 95);
		addMix(DarkGray, Coral, DarkSalmon, 100);
		addMix(DarkGray, Crimson, IndianRed, 90);
		addMix(DarkGray, Cyan, DarkTurquoise, 95);
		addMix(DarkGray, DarkGoldenrod, DarkKhaki, 100);
		addMix(DarkGreen, Aquamarine, MediumSeaGreen, 75);
		addMix(DarkGreen, Blue, DarkSlateBlue, 65);
		addMix(DarkGreen, CadetBlue, SeaGreen, 90);
		addMix(DarkGreen, Chocolate, DarkOliveGreen, 70);
		addMix(DarkGreen, Coral, Olive, 60);
		addMix(DarkGreen, Crimson, Sienna, 55);
		addMix(DarkGreen, Cyan, MediumSeaGreen, 70);
		addMix(DarkGreen, DarkGoldenrod, DarkOliveGreen, 85);
		addMix(DarkGreen, DarkGray, SeaGreen, 85);
		addMix(DarkKhaki, Aquamarine, DarkSeaGreen, 100);
		addMix(DarkKhaki, Black, DarkOliveGreen, 60);
		addMix(DarkKhaki, Brown, Chocolate, 75);
		addMix(DarkKhaki, CadetBlue, DarkSeaGreen, 95);
		addMix(DarkKhaki, Chocolate, Peru, 95);
		addMix(DarkKhaki, Coral, SandyBrown, 90);
		addMix(DarkKhaki, Crimson, IndianRed, 75);
		addMix(DarkKhaki, Cyan, MediumAquamarine, 90);
		addMix(DarkKhaki, DarkGoldenrod, Goldenrod, 110);
		addMix(DarkKhaki, DarkGray, Tan, 105);
		addMix(DarkKhaki, DarkGreen, OliveDrab, 85);
		addMix(DarkOliveGreen, Aquamarine, MediumSeaGreen, 80);
		addMix(DarkOliveGreen, Blue, DarkSlateBlue, 50);
		addMix(DarkOliveGreen, Brown, Sienna, 80);
		addMix(DarkOliveGreen, CadetBlue, SeaGreen, 95);
		addMix(DarkOliveGreen, Chocolate, DarkGoldenrod, 85);
		addMix(DarkOliveGreen, Coral, Peru, 75);
		addMix(DarkOliveGreen, Crimson, Brown, 70);
		addMix(DarkOliveGreen, Cyan, LightSeaGreen, 75);
		addMix(DarkOliveGreen, DarkGoldenrod, Olive, 100);
		addMix(DarkOliveGreen, DarkGreen, Green, 115);
		addMix(DarkOliveGreen, DarkKhaki, OliveDrab, 95);
		addMix(DarkOrange, Aquamarine, DarkKhaki, 70);
		addMix(DarkOrange, Black, Sienna, 60);
		addMix(DarkOrange, Blue, Violet, 55);
		addMix(DarkOrange, Brown, Chocolate, 85);
		addMix(DarkOrange, CadetBlue, DarkGoldenrod, 80);
		addMix(DarkOrange, Chocolate, Peru, 115);
		addMix(DarkOrange, Coral, SandyBrown, 115);
		addMix(DarkOrange, Crimson, Red, 90);
		addMix(DarkOrange, Cyan, DarkSeaGreen, 70);
		addMix(DarkOrange, DarkGoldenrod, Peru, 110);
		addMix(DarkOrange, DarkGray, Peru, 95);
		addMix(DarkOrange, DarkGreen, Olive, 70);
		addMix(DarkOrange, DarkKhaki, Goldenrod, 100);
		addMix(DarkOrange, DarkOliveGreen, DarkGoldenrod, 80);
		addMix(DarkSalmon, Aquamarine, DarkSeaGreen, 75);
		addMix(DarkSalmon, Black, Sienna, 65);
		addMix(DarkSalmon, Blue, SlateBlue, 70);
		addMix(DarkSalmon, Brown, IndianRed, 95);
		addMix(DarkSalmon, CadetBlue, DarkGray, 85);
		addMix(DarkSalmon, Chocolate, Coral, 110);
		addMix(DarkSalmon, Coral, Salmon, 120);
		addMix(DarkSalmon, Crimson, IndianRed, 100);
		addMix(DarkSalmon, Cyan, MediumAquamarine, 75);
		addMix(DarkSalmon, DarkGoldenrod, Peru, 100);
		addMix(DarkSalmon, DarkGray, RosyBrown, 105);
		addMix(DarkSalmon, DarkGreen, Olive, 65);
		addMix(DarkSalmon, DarkKhaki, Tan, 95);
		addMix(DarkSalmon, DarkOliveGreen, Peru, 80);
		addMix(DarkSalmon, DarkOrange, SandyBrown, 110);
		addMix(DarkSeaGreen, Aquamarine, MediumAquamarine, 110);
		addMix(DarkSeaGreen, Black, DarkOliveGreen, 60);
		addMix(DarkSeaGreen, Blue, RoyalBlue, 60);
		addMix(DarkSeaGreen, Brown, Sienna, 65);
		addMix(DarkSeaGreen, CadetBlue, MediumAquamarine, 105);
		addMix(DarkSeaGreen, Chocolate, DarkGoldenrod, 80);
		addMix(DarkSeaGreen, Coral, Tan, 80);
		addMix(DarkSeaGreen, Crimson, IndianRed, 60);
		addMix(DarkSeaGreen, Cyan, Turquoise, 100);
		addMix(DarkSeaGreen, DarkGoldenrod, DarkKhaki, 95);
		addMix(DarkSeaGreen, DarkGreen, SeaGreen, 90);
		addMix(DarkSeaGreen, DarkKhaki, YellowGreen, 110);
		addMix(DarkSeaGreen, DarkOliveGreen, OliveDrab, 100);
		addMix(DarkSeaGreen, DarkOrange, Goldenrod, 85);
		addMix(DarkSeaGreen, DarkSalmon, Tan, 85);
		addMix(DarkSlateBlue, Aquamarine, CadetBlue, 60);
		addMix(DarkSlateBlue, Blue, Indigo, 110);
		addMix(DarkSlateBlue, Brown, Purple, 90);
		addMix(DarkSlateBlue, CadetBlue, RoyalBlue, 85);
		addMix(DarkSlateBlue, Chocolate, Brown, 75);
		addMix(DarkSlateBlue, Coral, IndianRed, 70);
		addMix(DarkSlateBlue, Crimson, MediumVioletRed, 90);
		addMix(DarkSlateBlue, Cyan, DeepSkyBlue, 60);
		addMix(DarkSlateBlue, DarkGoldenrod, Sienna, 65);
		addMix(DarkSlateBlue, DarkGreen, DarkSlateGray, 75);
		addMix(DarkSlateBlue, DarkKhaki, Gray, 55);
		addMix(DarkSlateBlue, DarkOliveGreen, DimGray, 70);
		addMix(DarkSlateBlue, DarkOrange, Sienna, 60);
		addMix(DarkSlateBlue, DarkSeaGreen, SlateGray, 65);
		addMix(DarkSlateGray, Aquamarine, LightSeaGreen, 70);
		addMix(DarkSlateGray, Blue, Navy, 95);
		addMix(DarkSlateGray, CadetBlue, Teal, 95);
		addMix(DarkSlateGray, Chocolate, Sienna, 80);
		addMix(DarkSlateGray, Coral, Sienna, 75);
		addMix(DarkSlateGray, Crimson, Brown, 80);
		addMix(DarkSlateGray, Cyan, LightSeaGreen, 70);
		addMix(DarkSlateGray, DarkGoldenrod, DarkOliveGreen, 85);
		addMix(DarkSlateGray, DarkGray, Gray, 85);
		addMix(DarkSlateGray, DarkGreen, DarkOliveGreen, 100);
		addMix(DarkSlateGray, DarkKhaki, DarkOliveGreen, 75);
		addMix(DarkSlateGray, DarkOrange, DarkGoldenrod, 70);
		addMix(DarkSlateGray, DarkSalmon, Gray, 75);
		addMix(DarkSlateGray, DarkSeaGreen, SeaGreen, 80);
		addMix(DarkTurquoise, Aquamarine, Turquoise, 110);
		addMix(DarkTurquoise, Black, Teal, 55);
		addMix(DarkTurquoise, Blue, RoyalBlue, 65);
		addMix(DarkTurquoise, Brown, Teal, 60);
		addMix(DarkTurquoise, CadetBlue, LightSeaGreen, 115);
		addMix(DarkTurquoise, Chocolate, SeaGreen, 70);
		addMix(DarkTurquoise, Coral, DarkSeaGreen, 70);
		addMix(DarkTurquoise, Crimson, SlateGray, 55);
		addMix(DarkTurquoise, Cyan, Turquoise, 115);
		addMix(DarkTurquoise, DarkGoldenrod, MediumSeaGreen, 80);
		addMix(DarkTurquoise, DarkGray, LightSeaGreen, 100);
		addMix(DarkTurquoise, DarkGreen, SeaGreen, 80);
		addMix(DarkTurquoise, DarkKhaki, MediumAquamarine, 95);
		addMix(DarkTurquoise, DarkOliveGreen, SeaGreen, 85);
		addMix(DarkTurquoise, DarkOrange, DarkSeaGreen, 75);
		addMix(DarkTurquoise, DarkSalmon, LightSeaGreen, 80);
		addMix(DarkTurquoise, DarkSeaGreen, MediumAquamarine, 105);
		addMix(DarkTurquoise, DarkSlateBlue, SteelBlue, 70);
		addMix(DarkTurquoise, DarkSlateGray, Teal, 80);
		addMix(DarkViolet, Aquamarine, MediumPurple, 60);
		addMix(DarkViolet, Black, Indigo, 85);
		addMix(DarkViolet, Brown, Purple, 90);
		addMix(DarkViolet, CadetBlue, SlateBlue, 90);
		addMix(DarkViolet, Chocolate, MediumVioletRed, 70);
		addMix(DarkViolet, Coral, MediumVioletRed, 75);
		addMix(DarkViolet, Crimson, MediumVioletRed, 90);
		addMix(DarkViolet, Cyan, SteelBlue, 60);
		addMix(DarkViolet, DarkGoldenrod, MediumVioletRed, 55);
		addMix(DarkViolet, DarkGray, MediumOrchid, 85);
		addMix(DarkViolet, DarkKhaki, MediumOrchid, 50);
		addMix(DarkViolet, DarkOliveGreen, Purple, 55);
		addMix(DarkViolet, DarkOrange, IndianRed, 60);
		addMix(DarkViolet, DarkSalmon, MediumOrchid, 75);
		addMix(DarkViolet, DarkSeaGreen, MediumOrchid, 70);
		addMix(DarkViolet, DarkSlateBlue, Indigo, 110);
		addMix(DarkViolet, DarkSlateGray, Indigo, 100);
		addMix(DarkViolet, DarkTurquoise, RoyalBlue, 70);
		addMix(DeepPink, Blue, DarkViolet, 90);
		addMix(DeepPink, Brown, Crimson, 100);
		addMix(DeepPink, CadetBlue, MediumVioletRed, 80);
		addMix(DeepPink, Chocolate, IndianRed, 85);
		addMix(DeepPink, Coral, IndianRed, 95);
		addMix(DeepPink, Crimson, IndianRed, 105);
		addMix(DeepPink, Cyan, MediumPurple, 45);
		addMix(DeepPink, DarkGoldenrod, IndianRed, 70);
		addMix(DeepPink, DarkGray, PaleVioletRed, 95);
		addMix(DeepPink, DarkKhaki, PaleVioletRed, 65);
		addMix(DeepPink, DarkOliveGreen, MediumVioletRed, 60);
		addMix(DeepPink, DarkOrange, Salmon, 80);
		addMix(DeepPink, DarkSalmon, PaleVioletRed, 95);
		addMix(DeepPink, DarkSeaGreen, PaleVioletRed, 55);
		addMix(DeepPink, DarkSlateBlue, MediumVioletRed, 90);
		addMix(DeepPink, DarkSlateGray, MediumVioletRed, 90);
		addMix(DeepPink, DarkTurquoise, MediumPurple, 55);
		addMix(DeepPink, DarkViolet, MediumVioletRed, 100);
		addMix(DeepSkyBlue, Aquamarine, DarkTurquoise, 90);
		addMix(DeepSkyBlue, Blue, RoyalBlue, 75);
		addMix(DeepSkyBlue, Brown, SteelBlue, 60);
		addMix(DeepSkyBlue, CadetBlue, SkyBlue, 105);
		addMix(DeepSkyBlue, Chocolate, CadetBlue, 70);
		addMix(DeepSkyBlue, Coral, CadetBlue, 70);
		addMix(DeepSkyBlue, Crimson, SlateBlue, 60);
		addMix(DeepSkyBlue, Cyan, SkyBlue, 105);
		addMix(DeepSkyBlue, DarkGoldenrod, MediumSeaGreen, 70);
		addMix(DeepSkyBlue, DarkGray, SkyBlue, 105);
		addMix(DeepSkyBlue, DarkGreen, Teal, 65);
		addMix(DeepSkyBlue, DarkKhaki, LightSeaGreen, 75);
		addMix(DeepSkyBlue, DarkOliveGreen, CadetBlue, 70);
		addMix(DeepSkyBlue, DarkOrange, DarkSeaGreen, 70);
		addMix(DeepSkyBlue, DarkSalmon, CadetBlue, 80);
		addMix(DeepSkyBlue, DarkSeaGreen, DarkTurquoise, 85);
		addMix(DeepSkyBlue, DarkSlateBlue, SteelBlue, 75);
		addMix(DeepSkyBlue, DarkSlateGray, SteelBlue, 80);
		addMix(DeepSkyBlue, DarkTurquoise, SkyBlue, 110);
		addMix(DeepSkyBlue, DarkViolet, RoyalBlue, 70);
		addMix(DeepSkyBlue, DeepPink, MediumPurple, 55);
		addMix(DimGray, Aquamarine, MediumAquamarine, 80);
		addMix(DimGray, Blue, DarkSlateBlue, 90);
		addMix(DimGray, CadetBlue, SlateGray, 100);
		addMix(DimGray, Chocolate, Sienna, 95);
		addMix(DimGray, Coral, IndianRed, 90);
		addMix(DimGray, Crimson, Brown, 100);
		addMix(DimGray, Cyan, LightSeaGreen, 80);
		addMix(DimGray, DarkGoldenrod, Olive, 95);
		addMix(DimGray, DarkGray, Gray, 105);
		addMix(DimGray, DarkGreen, DarkOliveGreen, 100);
		addMix(DimGray, DarkOrange, Peru, 90);
		addMix(DimGray, DarkSalmon, RosyBrown, 95);
		addMix(DimGray, DarkTurquoise, CadetBlue, 90);
		addMix(DimGray, DarkViolet, Purple, 95);
		addMix(DimGray, DeepPink, MediumVioletRed, 95);
		addMix(DimGray, DeepSkyBlue, SteelBlue, 90);
		addMix(DodgerBlue, Aquamarine, SkyBlue, 80);
		addMix(DodgerBlue, Black, DarkSlateBlue, 75);
		addMix(DodgerBlue, Blue, SlateBlue, 90);
		addMix(DodgerBlue, Brown, SlateBlue, 75);
		addMix(DodgerBlue, CadetBlue, SteelBlue, 100);
		addMix(DodgerBlue, Chocolate, SlateGray, 75);
		addMix(DodgerBlue, Crimson, SlateBlue, 75);
		addMix(DodgerBlue, Cyan, DeepSkyBlue, 85);
		addMix(DodgerBlue, DarkGoldenrod, CadetBlue, 70);
		addMix(DodgerBlue, DarkGray, SteelBlue, 100);
		addMix(DodgerBlue, DarkGreen, Teal, 65);
		addMix(DodgerBlue, DarkKhaki, CadetBlue, 65);
		addMix(DodgerBlue, DarkOliveGreen, SteelBlue, 70);
		addMix(DodgerBlue, DarkOrange, Gray, 70);
		addMix(DodgerBlue, DarkSalmon, SlateGray, 80);
		addMix(DodgerBlue, DarkSeaGreen, DeepSkyBlue, 80);
		addMix(DodgerBlue, DarkSlateBlue, RoyalBlue, 90);
		addMix(DodgerBlue, DarkSlateGray, SteelBlue, 90);
		addMix(DodgerBlue, DarkTurquoise, DeepSkyBlue, 95);
		addMix(DodgerBlue, DarkViolet, SlateBlue, 90);
		addMix(DodgerBlue, DeepPink, SlateBlue, 80);
		addMix(DodgerBlue, DimGray, SteelBlue, 95);
		addMix(Gold, Aquamarine, YellowGreen, 90);
		addMix(Gold, Brown, Peru, 65);
		addMix(Gold, CadetBlue, DarkKhaki, 85);
		addMix(Gold, Chocolate, Orange, 90);
		addMix(Gold, Coral, Orange, 90);
		addMix(Gold, Crimson, Chocolate, 65);
		addMix(Gold, Cyan, PaleGreen, 80);
		addMix(Gold, DarkGoldenrod, Goldenrod, 105);
		addMix(Gold, DarkGray, DarkKhaki, 95);
		addMix(Gold, DarkGreen, OliveDrab, 75);
		addMix(Gold, DarkKhaki, Khaki, 110);
		addMix(Gold, DarkOliveGreen, DarkKhaki, 85);
		addMix(Gold, DarkOrange, Orange, 100);
		addMix(Gold, DarkSalmon, Goldenrod, 90);
		addMix(Gold, DarkSeaGreen, DarkKhaki, 95);
		addMix(Gold, DarkSlateGray, Olive, 65);
		addMix(Gold, DarkTurquoise, LimeGreen, 80);
		addMix(Gold, DeepPink, Coral, 55);
		addMix(Gold, DeepSkyBlue, DarkSeaGreen, 65);
		addMix(Gold, DimGray, DarkKhaki, 80);
		addMix(Gold, DodgerBlue, DarkSeaGreen, 60);
		addMix(Goldenrod, Aquamarine, YellowGreen, 85);
		addMix(Goldenrod, Blue, DarkSlateBlue, 45);
		addMix(Goldenrod, Brown, Chocolate, 80);
		addMix(Goldenrod, CadetBlue, DarkKhaki, 90);
		addMix(Goldenrod, Chocolate, Peru, 105);
		addMix(Goldenrod, Coral, DarkOrange, 100);
		addMix(Goldenrod, Crimson, Chocolate, 80);
		addMix(Goldenrod, Cyan, MediumAquamarine, 80);
		addMix(Goldenrod, DarkGoldenrod, Orange, 115);
		addMix(Goldenrod, DarkGray, DarkKhaki, 100);
		addMix(Goldenrod, DarkGreen, OliveDrab, 80);
		addMix(Goldenrod, DarkKhaki, DarkGoldenrod, 110);
		addMix(Goldenrod, DarkOliveGreen, Olive, 90);
		addMix(Goldenrod, DarkOrange, Orange, 110);
		addMix(Goldenrod, DarkSalmon, SandyBrown, 100);
		addMix(Goldenrod, DarkSeaGreen, DarkKhaki, 95);
		addMix(Goldenrod, DarkSlateGray, Olive, 75);
		addMix(Goldenrod, DarkTurquoise, MediumSeaGreen, 80);
		addMix(Goldenrod, DarkViolet, MediumVioletRed, 50);
		addMix(Goldenrod, DeepPink, IndianRed, 65);
		addMix(Goldenrod, DeepSkyBlue, DarkSeaGreen, 70);
		addMix(Goldenrod, DimGray, DarkGoldenrod, 90);
		addMix(Goldenrod, DodgerBlue, CadetBlue, 65);
		addMix(Goldenrod, Gold, Orange, 115);
		addMix(Gray, Aquamarine, MediumAquamarine, 90);
		addMix(Gray, Blue, DarkSlateBlue, 85);
		addMix(Gray, CadetBlue, SlateGray, 105);
		addMix(Gray, Chocolate, Peru, 100);
		addMix(Gray, Coral, DarkSalmon, 95);
		addMix(Gray, Crimson, IndianRed, 95);
		addMix(Gray, Cyan, DarkTurquoise, 90);
		addMix(Gray, DarkGoldenrod, Olive, 100);
		addMix(Gray, DarkGray, SlateGray, 115);
		addMix(Gray, DarkGreen, DarkOliveGreen, 95);
		addMix(Gray, DarkOrange, Peru, 95);
		addMix(Gray, DarkSalmon, RosyBrown, 100);
		addMix(Gray, DarkSlateGray, DimGray, 100);
		addMix(Gray, DarkTurquoise, CadetBlue, 95);
		addMix(Gray, DarkViolet, Purple, 90);
		addMix(Gray, DeepPink, MediumVioletRed, 95);
		addMix(Gray, DeepSkyBlue, CadetBlue, 100);
		addMix(Gray, DimGray, SlateGray, 120);
		addMix(Gray, DodgerBlue, SteelBlue, 100);
		addMix(Gray, Gold, DarkKhaki, 85);
		addMix(Gray, Goldenrod, DarkGoldenrod, 95);
		addMix(Green, Aquamarine, MediumSeaGreen, 85);
		addMix(Green, Black, DarkGreen, 85);
		addMix(Green, Blue, DarkSlateBlue, 60);
		addMix(Green, Brown, DarkOliveGreen, 60);
		addMix(Green, CadetBlue, SeaGreen, 95);
		addMix(Green, Chocolate, Olive, 70);
		addMix(Green, Coral, Olive, 65);
		addMix(Green, Cyan, MediumSeaGreen, 80);
		addMix(Green, DarkGoldenrod, OliveDrab, 90);
		addMix(Green, DarkGray, SeaGreen, 90);
		addMix(Green, DarkGreen, DarkOliveGreen, 120);
		addMix(Green, DarkKhaki, OliveDrab, 95);
		addMix(Green, DarkOliveGreen, DarkGreen, 115);
		addMix(Green, DarkOrange, Olive, 70);
		addMix(Green, DarkSalmon, OliveDrab, 70);
		addMix(Green, DarkSeaGreen, MediumSeaGreen, 100);
		addMix(Green, DarkSlateBlue, DarkSlateGray, 70);
		addMix(Green, DarkSlateGray, DarkGreen, 95);
		addMix(Green, DarkTurquoise, MediumSeaGreen, 85);
		addMix(Green, DeepSkyBlue, SeaGreen, 70);
		addMix(Green, DimGray, DarkGreen, 100);
		addMix(Green, DodgerBlue, Teal, 65);
		addMix(Green, Gold, YellowGreen, 80);
		addMix(Green, Goldenrod, OliveDrab, 85);
		addMix(Green, Gray, SeaGreen, 100);
		addMix(HotPink, Aquamarine, Thistle, 50);
		addMix(HotPink, Blue, DarkViolet, 80);
		addMix(HotPink, Brown, IndianRed, 90);
		addMix(HotPink, CadetBlue, Plum, 85);
		addMix(HotPink, Chocolate, IndianRed, 85);
		addMix(HotPink, Coral, Salmon, 95);
		addMix(HotPink, Crimson, DeepPink, 100);
		addMix(HotPink, Cyan, SkyBlue, 55);
		addMix(HotPink, DarkGoldenrod, Salmon, 70);
		addMix(HotPink, DarkGray, PaleVioletRed, 100);
		addMix(HotPink, DarkKhaki, RosyBrown, 70);
		addMix(HotPink, DarkOliveGreen, IndianRed, 60);
		addMix(HotPink, DarkOrange, Coral, 80);
		addMix(HotPink, DarkSalmon, PaleVioletRed, 100);
		addMix(HotPink, DarkSeaGreen, RosyBrown, 60);
		addMix(HotPink, DarkSlateBlue, MediumOrchid, 85);
		addMix(HotPink, DarkTurquoise, DodgerBlue, 60);
		addMix(HotPink, DarkViolet, MediumOrchid, 95);
		addMix(HotPink, DeepPink, PaleVioletRed, 115);
		addMix(HotPink, DeepSkyBlue, DodgerBlue, 65);
		addMix(HotPink, DimGray, PaleVioletRed, 95);
		addMix(HotPink, DodgerBlue, MediumPurple, 85);
		addMix(HotPink, Gold, SandyBrown, 60);
		addMix(HotPink, Goldenrod, DarkSalmon, 70);
		addMix(HotPink, Gray, PaleVioletRed, 100);
		addMix(IndianRed, Aquamarine, DarkGray, 55);
		addMix(IndianRed, Black, Maroon, 80);
		addMix(IndianRed, Blue, DarkViolet, 80);
		addMix(IndianRed, Brown, Crimson, 110);
		addMix(IndianRed, CadetBlue, RosyBrown, 80);
		addMix(IndianRed, Chocolate, Red, 105);
		addMix(IndianRed, Coral, Salmon, 110);
		addMix(IndianRed, Crimson, Brown, 115);
		addMix(IndianRed, Cyan, CadetBlue, 60);
		addMix(IndianRed, DarkGoldenrod, Chocolate, 90);
		addMix(IndianRed, DarkGray, RosyBrown, 100);
		addMix(IndianRed, DarkGreen, DarkOliveGreen, 60);
		addMix(IndianRed, DarkKhaki, Peru, 85);
		addMix(IndianRed, DarkOliveGreen, Sienna, 80);
		addMix(IndianRed, DarkOrange, Chocolate, 95);
		addMix(IndianRed, DarkSalmon, Salmon, 110);
		addMix(IndianRed, DarkSeaGreen, Peru, 75);
		addMix(IndianRed, DarkSlateBlue, MediumVioletRed, 90);
		addMix(IndianRed, DarkTurquoise, CadetBlue, 65);
		addMix(IndianRed, DarkViolet, MediumVioletRed, 90);
		addMix(IndianRed, DeepPink, PaleVioletRed, 110);
		addMix(IndianRed, DeepSkyBlue, SteelBlue, 70);
		addMix(IndianRed, DodgerBlue, MediumPurple, 80);
		addMix(IndianRed, Gold, Orange, 75);
		addMix(IndianRed, Goldenrod, Peru, 85);
		addMix(IndianRed, Gray, RosyBrown, 100);
		addMix(IndianRed, Green, DarkOliveGreen, 60);
		addMix(IndianRed, HotPink, PaleVioletRed, 105);
		addMix(Indigo, Black, Navy, 95);
		addMix(Indigo, Blue, Navy, 110);
		addMix(Indigo, Brown, Purple, 90);
		addMix(Indigo, CadetBlue, DarkSlateBlue, 80);
		addMix(Indigo, Coral, MediumVioletRed, 65);
		addMix(Indigo, Crimson, Purple, 85);
		addMix(Indigo, DarkGoldenrod, Brown, 55);
		addMix(Indigo, DarkGray, SlateBlue, 70);
		addMix(Indigo, DarkOrange, Brown, 55);
		addMix(Indigo, DarkSalmon, MediumVioletRed, 65);
		addMix(Indigo, DarkSlateBlue, Navy, 115);
		addMix(Indigo, DarkSlateGray, DarkSlateBlue, 100);
		addMix(Indigo, DarkTurquoise, RoyalBlue, 55);
		addMix(Indigo, DarkViolet, Purple, 110);
		addMix(Indigo, DeepPink, Purple, 90);
		addMix(Indigo, DeepSkyBlue, RoyalBlue, 60);
		addMix(Indigo, DimGray, DarkSlateBlue, 90);
		addMix(Indigo, DodgerBlue, SlateBlue, 80);
		addMix(Indigo, Goldenrod, Brown, 45);
		addMix(Indigo, Gray, DarkSlateBlue, 85);
		addMix(Indigo, Green, DarkSlateGray, 65);
		addMix(Indigo, HotPink, MediumVioletRed, 80);
		addMix(Indigo, IndianRed, Purple, 85);
		addMix(Khaki, Aquamarine, PaleGreen, 100);
		addMix(Khaki, Brown, Peru, 65);
		addMix(Khaki, CadetBlue, DarkSeaGreen, 90);
		addMix(Khaki, Chocolate, Goldenrod, 85);
		addMix(Khaki, Coral, SandyBrown, 90);
		addMix(Khaki, Crimson, Salmon, 65);
		addMix(Khaki, Cyan, Aquamarine, 90);
		addMix(Khaki, DarkGoldenrod, Goldenrod, 100);
		addMix(Khaki, DarkGray, DarkKhaki, 100);
		addMix(Khaki, DarkGreen, OliveDrab, 75);
		addMix(Khaki, DarkKhaki, Wheat, 115);
		addMix(Khaki, DarkOliveGreen, DarkKhaki, 85);
		addMix(Khaki, DarkOrange, Goldenrod, 95);
		addMix(Khaki, DarkSalmon, Tan, 95);
		addMix(Khaki, DarkSeaGreen, DarkKhaki, 105);
		addMix(Khaki, DarkSlateBlue, Gray, 50);
		addMix(Khaki, DarkSlateGray, DarkSeaGreen, 65);
		addMix(Khaki, DarkTurquoise, MediumAquamarine, 90);
		addMix(Khaki, DeepPink, PaleVioletRed, 60);
		addMix(Khaki, DeepSkyBlue, Turquoise, 75);
		addMix(Khaki, DimGray, DarkKhaki, 85);
		addMix(Khaki, DodgerBlue, SkyBlue, 60);
		addMix(Khaki, Gold, Yellow, 115);
		addMix(Khaki, Goldenrod, Gold, 110);
		addMix(Khaki, Gray, DarkKhaki, 90);
		addMix(Khaki, Green, YellowGreen, 85);
		addMix(Khaki, HotPink, DarkSalmon, 65);
		addMix(Khaki, IndianRed, SandyBrown, 75);
		addMix(Lavender, Aquamarine, PaleTurquoise, 95);
		addMix(Lavender, Blue, MediumPurple, 65);
		addMix(Lavender, Brown, RosyBrown, 70);
		addMix(Lavender, CadetBlue, SkyBlue, 95);
		addMix(Lavender, Chocolate, DarkSalmon, 85);
		addMix(Lavender, Coral, DarkSalmon, 90);
		addMix(Lavender, Crimson, PaleVioletRed, 80);
		addMix(Lavender, Cyan, PaleTurquoise, 95);
		addMix(Lavender, DarkGoldenrod, Tan, 85);
		addMix(Lavender, DarkGray, LightGray, 110);
		addMix(Lavender, DarkGreen, DarkSeaGreen, 65);
		addMix(Lavender, DarkKhaki, Wheat, 90);
		addMix(Lavender, DarkOliveGreen, DarkGray, 75);
		addMix(Lavender, DarkOrange, SandyBrown, 85);
		addMix(Lavender, DarkSalmon, Pink, 95);
		addMix(Lavender, DarkSeaGreen, PaleTurquoise, 95);
		addMix(Lavender, DarkSlateBlue, MediumPurple, 70);
		addMix(Lavender, DarkSlateGray, DarkGray, 70);
		addMix(Lavender, DarkTurquoise, PaleTurquoise, 95);
		addMix(Lavender, DarkViolet, MediumOrchid, 75);
		addMix(Lavender, DeepPink, HotPink, 85);
		addMix(Lavender, DeepSkyBlue, SkyBlue, 95);
		addMix(Lavender, DimGray, DarkGray, 85);
		addMix(Lavender, DodgerBlue, LightSteelBlue, 95);
		addMix(Lavender, Gold, Khaki, 85);
		addMix(Lavender, Goldenrod, Tan, 85);
		addMix(Lavender, Gray, DarkGray, 95);
		addMix(Lavender, Green, DarkSeaGreen, 75);
		addMix(Lavender, HotPink, Plum, 95);
		addMix(Lavender, IndianRed, RosyBrown, 85);
		addMix(Lavender, Indigo, MediumPurple, 55);
		addMix(Lavender, Khaki, LemonChiffon, 90);
		addMix(LemonChiffon, Aquamarine, PaleGreen, 105);
		addMix(LemonChiffon, Blue, MediumPurple, 45);
		addMix(LemonChiffon, Brown, DarkSalmon, 65);
		addMix(LemonChiffon, CadetBlue, DarkSeaGreen, 90);
		addMix(LemonChiffon, Chocolate, SandyBrown, 85);
		addMix(LemonChiffon, Coral, SandyBrown, 90);
		addMix(LemonChiffon, Crimson, Salmon, 70);
		addMix(LemonChiffon, Cyan, Aquamarine, 95);
		addMix(LemonChiffon, DarkGoldenrod, DarkKhaki, 95);
		addMix(LemonChiffon, DarkGray, LightGray, 100);
		addMix(LemonChiffon, DarkGreen, DarkSeaGreen, 75);
		addMix(LemonChiffon, DarkKhaki, Khaki, 110);
		addMix(LemonChiffon, DarkOliveGreen, DarkKhaki, 80);
		addMix(LemonChiffon, DarkOrange, Orange, 95);
		addMix(LemonChiffon, DarkSalmon, Tan, 95);
		addMix(LemonChiffon, DarkSeaGreen, Khaki, 105);
		addMix(LemonChiffon, DarkSlateBlue, DarkGray, 55);
		addMix(LemonChiffon, DarkSlateGray, DarkSeaGreen, 65);
		addMix(LemonChiffon, DarkTurquoise, Turquoise, 95);
		addMix(LemonChiffon, DarkViolet, Violet, 50);
		addMix(LemonChiffon, DeepPink, HotPink, 65);
		addMix(LemonChiffon, DeepSkyBlue, PaleTurquoise, 80);
		addMix(LemonChiffon, DimGray, DarkGray, 80);
		addMix(LemonChiffon, DodgerBlue, SkyBlue, 70);
		addMix(LemonChiffon, Gold, Khaki, 105);
		addMix(LemonChiffon, Goldenrod, Khaki, 100);
		addMix(LemonChiffon, Gray, DarkGray, 90);
		addMix(LemonChiffon, Green, DarkSeaGreen, 80);
		addMix(LemonChiffon, HotPink, Pink, 75);
		addMix(LemonChiffon, IndianRed, DarkSalmon, 80);
		addMix(LemonChiffon, Khaki, Wheat, 115);
		addMix(LightGray, Aquamarine, PaleTurquoise, 100);
		addMix(LightGray, Black, DimGray, 45);
		addMix(LightGray, Blue, RoyalBlue, 65);
		addMix(LightGray, Brown, RosyBrown, 75);
		addMix(LightGray, CadetBlue, SkyBlue, 100);
		addMix(LightGray, Chocolate, SandyBrown, 90);
		addMix(LightGray, Coral, DarkSalmon, 95);
		addMix(LightGray, Crimson, PaleVioletRed, 85);
		addMix(LightGray, Cyan, Turquoise, 100);
		addMix(LightGray, DarkGoldenrod, Tan, 95);
		addMix(LightGray, DarkGray, LightSteelBlue, 115);
		addMix(LightGray, DarkGreen, SeaGreen, 75);
		addMix(LightGray, DarkKhaki, Wheat, 105);
		addMix(LightGray, DarkOliveGreen, DarkSeaGreen, 85);
		addMix(LightGray, DarkOrange, SandyBrown, 95);
		addMix(LightGray, DarkSalmon, RosyBrown, 100);
		addMix(LightGray, DarkSlateGray, Gray, 75);
		addMix(LightGray, DarkTurquoise, Turquoise, 100);
		addMix(LightGray, DarkViolet, MediumOrchid, 75);
		addMix(LightGray, DeepPink, HotPink, 90);
		addMix(LightGray, DeepSkyBlue, SkyBlue, 100);
		addMix(LightGray, DimGray, DarkGray, 95);
		addMix(LightGray, DodgerBlue, DeepSkyBlue, 95);
		addMix(LightGray, Gold, Khaki, 95);
		addMix(LightGray, Goldenrod, DarkKhaki, 100);
		addMix(LightGray, Gray, DarkGray, 100);
		addMix(LightGray, Green, MediumSeaGreen, 85);
		addMix(LightGray, HotPink, Plum, 95);
		addMix(LightGray, IndianRed, RosyBrown, 90);
		addMix(LightGray, Indigo, MediumPurple, 55);
		addMix(LightGray, Khaki, LemonChiffon, 105);
		addMix(LightGray, LemonChiffon, Wheat, 110);
		addMix(LightSeaGreen, Aquamarine, Turquoise, 105);
		addMix(LightSeaGreen, Black, DarkSlateGray, 65);
		addMix(LightSeaGreen, Blue, RoyalBlue, 70);
		addMix(LightSeaGreen, Brown, DimGray, 60);
		addMix(LightSeaGreen, CadetBlue, DarkTurquoise, 120);
		addMix(LightSeaGreen, Chocolate, OliveDrab, 75);
		addMix(LightSeaGreen, Cyan, DarkTurquoise, 110);
		addMix(LightSeaGreen, DarkGoldenrod, OliveDrab, 85);
		addMix(LightSeaGreen, DarkGray, CadetBlue, 105);
		addMix(LightSeaGreen, DarkGreen, SeaGreen, 90);
		addMix(LightSeaGreen, DarkKhaki, DarkSeaGreen, 95);
		addMix(LightSeaGreen, DarkOliveGreen, SeaGreen, 95);
		addMix(LightSeaGreen, DarkOrange, OliveDrab, 75);
		addMix(LightSeaGreen, DarkSalmon, CadetBlue, 80);
		addMix(LightSeaGreen, DarkSeaGreen, MediumAquamarine, 110);
		addMix(LightSeaGreen, DarkSlateBlue, SteelBlue, 75);
		addMix(LightSeaGreen, DarkSlateGray, Teal, 90);
		addMix(LightSeaGreen, DarkTurquoise, Turquoise, 120);
		addMix(LightSeaGreen, DarkViolet, SlateBlue, 75);
		addMix(LightSeaGreen, DeepPink, MediumOrchid, 65);
		addMix(LightSeaGreen, DeepSkyBlue, SkyBlue, 105);
		addMix(LightSeaGreen, DimGray, Teal, 95);
		addMix(LightSeaGreen, DodgerBlue, DeepSkyBlue, 95);
		addMix(LightSeaGreen, Gold, YellowGreen, 85);
		addMix(LightSeaGreen, Goldenrod, DarkSeaGreen, 85);
		addMix(LightSeaGreen, Gray, CadetBlue, 100);
		addMix(LightSeaGreen, Green, SeaGreen, 95);
		addMix(LightSeaGreen, IndianRed, Gray, 70);
		addMix(LightSeaGreen, Indigo, RoyalBlue, 65);
		addMix(LightSeaGreen, Khaki, DarkSeaGreen, 90);
		addMix(LightSeaGreen, Lavender, DarkTurquoise, 95);
		addMix(LightSeaGreen, LemonChiffon, MediumAquamarine, 95);
		addMix(LightSeaGreen, LightGray, DarkTurquoise, 100);
		addMix(LightSteelBlue, Aquamarine, PaleTurquoise, 95);
		addMix(LightSteelBlue, Black, DimGray, 55);
		addMix(LightSteelBlue, Blue, RoyalBlue, 80);
		addMix(LightSteelBlue, Brown, RosyBrown, 75);
		addMix(LightSteelBlue, CadetBlue, SkyBlue, 105);
		addMix(LightSteelBlue, Chocolate, DarkSalmon, 85);
		addMix(LightSteelBlue, Coral, RosyBrown, 90);
		addMix(LightSteelBlue, Crimson, PaleVioletRed, 80);
		addMix(LightSteelBlue, Cyan, DarkTurquoise, 100);
		addMix(LightSteelBlue, DarkGoldenrod, DarkKhaki, 85);
		addMix(LightSteelBlue, DarkGray, LightGray, 115);
		addMix(LightSteelBlue, DarkGreen, SeaGreen, 70);
		addMix(LightSteelBlue, DarkKhaki, DarkSeaGreen, 90);
		addMix(LightSteelBlue, DarkOliveGreen, CadetBlue, 80);
		addMix(LightSteelBlue, DarkOrange, Tan, 85);
		addMix(LightSteelBlue, DarkSalmon, RosyBrown, 95);
		addMix(LightSteelBlue, DarkSeaGreen, MediumAquamarine, 95);
		addMix(LightSteelBlue, DarkSlateBlue, MediumPurple, 80);
		addMix(LightSteelBlue, DarkSlateGray, SlateGray, 80);
		addMix(LightSteelBlue, DarkTurquoise, SkyBlue, 105);
		addMix(LightSteelBlue, DarkViolet, MediumPurple, 85);
		addMix(LightSteelBlue, DeepPink, HotPink, 85);
		addMix(LightSteelBlue, DeepSkyBlue, SkyBlue, 110);
		addMix(LightSteelBlue, DimGray, SlateGray, 95);
		addMix(LightSteelBlue, DodgerBlue, DeepSkyBlue, 105);
		addMix(LightSteelBlue, Gold, Khaki, 80);
		addMix(LightSteelBlue, Goldenrod, DarkKhaki, 85);
		addMix(LightSteelBlue, Gray, DarkGray, 105);
		addMix(LightSteelBlue, Green, MediumSeaGreen, 75);
		addMix(LightSteelBlue, HotPink, Plum, 90);
		addMix(LightSteelBlue, IndianRed, RosyBrown, 85);
		addMix(LightSteelBlue, Indigo, SlateBlue, 65);
		addMix(LightSteelBlue, Khaki, LemonChiffon, 85);
		addMix(LightSteelBlue, Lavender, LightGray, 115);
		addMix(LightSteelBlue, LemonChiffon, LightGray, 95);
		addMix(LightSteelBlue, LightGray, Lavender, 115);
		addMix(LightSteelBlue, LightSeaGreen, DarkTurquoise, 100);
		addMix(Lime, Aquamarine, SpringGreen, 105);
		addMix(Lime, CadetBlue, LimeGreen, 85);
		addMix(Lime, Chocolate, YellowGreen, 60);
		addMix(Lime, Coral, YellowGreen, 55);
		addMix(Lime, Cyan, SpringGreen, 90);
		addMix(Lime, DarkGoldenrod, LimeGreen, 80);
		addMix(Lime, DarkGray, LimeGreen, 90);
		addMix(Lime, DarkGreen, LimeGreen, 80);
		addMix(Lime, DarkKhaki, LimeGreen, 100);
		addMix(Lime, DarkOliveGreen, LimeGreen, 85);
		addMix(Lime, DarkOrange, YellowGreen, 65);
		addMix(Lime, DarkSalmon, LimeGreen, 65);
		addMix(Lime, DarkSeaGreen, LimeGreen, 105);
		addMix(Lime, DarkSlateBlue, MediumSeaGreen, 50);
		addMix(Lime, DarkSlateGray, MediumSeaGreen, 65);
		addMix(Lime, DarkTurquoise, SpringGreen, 90);
		addMix(Lime, DeepSkyBlue, SpringGreen, 65);
		addMix(Lime, DimGray, LimeGreen, 80);
		addMix(Lime, DodgerBlue, MediumSeaGreen, 55);
		addMix(Lime, Gold, YellowGreen, 95);
		addMix(Lime, Goldenrod, LimeGreen, 85);
		addMix(Lime, Gray, LimeGreen, 85);
		addMix(Lime, Green, LimeGreen, 90);
		addMix(Lime, IndianRed, LimeGreen, 45);
		addMix(Lime, Khaki, PaleGreen, 100);
		addMix(Lime, Lavender, PaleGreen, 85);
		addMix(Lime, LemonChiffon, PaleGreen, 100);
		addMix(Lime, LightGray, SpringGreen, 95);
		addMix(Lime, LightSeaGreen, LimeGreen, 90);
		addMix(Lime, LightSteelBlue, SpringGreen, 80);
		addMix(LimeGreen, Aquamarine, SpringGreen, 105);
		addMix(LimeGreen, Black, DarkGreen, 55);
		addMix(LimeGreen, Blue, SteelBlue, 50);
		addMix(LimeGreen, Brown, DarkOliveGreen, 45);
		addMix(LimeGreen, CadetBlue, MediumSeaGreen, 95);
		addMix(LimeGreen, Chocolate, OliveDrab, 65);
		addMix(LimeGreen, Coral, DarkKhaki, 60);
		addMix(LimeGreen, Cyan, SpringGreen, 90);
		addMix(LimeGreen, DarkGoldenrod, OliveDrab, 90);
		addMix(LimeGreen, DarkGray, MediumSeaGreen, 95);
		addMix(LimeGreen, DarkGreen, Green, 90);
		addMix(LimeGreen, DarkKhaki, YellowGreen, 105);
		addMix(LimeGreen, DarkOliveGreen, OliveDrab, 95);
		addMix(LimeGreen, DarkOrange, YellowGreen, 70);
		addMix(LimeGreen, DarkSalmon, YellowGreen, 70);
		addMix(LimeGreen, DarkSeaGreen, MediumSeaGreen, 110);
		addMix(LimeGreen, DarkSlateBlue, SeaGreen, 55);
		addMix(LimeGreen, DarkSlateGray, SeaGreen, 75);
		addMix(LimeGreen, DarkTurquoise, MediumSeaGreen, 95);
		addMix(LimeGreen, DarkViolet, DimGray, 55);
		addMix(LimeGreen, DeepSkyBlue, MediumAquamarine, 70);
		addMix(LimeGreen, DimGray, SeaGreen, 85);
		addMix(LimeGreen, DodgerBlue, LightSeaGreen, 65);
		addMix(LimeGreen, Gold, YellowGreen, 95);
		addMix(LimeGreen, Goldenrod, YellowGreen, 90);
		addMix(LimeGreen, Gray, MediumSeaGreen, 90);
		addMix(LimeGreen, Green, MediumSeaGreen, 105);
		addMix(LimeGreen, IndianRed, OliveDrab, 55);
		addMix(LimeGreen, Indigo, DarkSlateGray, 50);
		addMix(LimeGreen, Khaki, YellowGreen, 100);
		addMix(LimeGreen, Lavender, DarkSeaGreen, 85);
		addMix(LimeGreen, LemonChiffon, PaleGreen, 100);
		addMix(LimeGreen, LightGray, DarkSeaGreen, 95);
		addMix(LimeGreen, LightSeaGreen, MediumSeaGreen, 100);
		addMix(LimeGreen, LightSteelBlue, DarkSeaGreen, 85);
		addMix(LimeGreen, Lime, SpringGreen, 115);
		addMix(Magenta, Aquamarine, Violet, 70);
		addMix(Magenta, Black, Purple, 70);
		addMix(Magenta, Blue, DarkViolet, 95);
		addMix(Magenta, Brown, MediumVioletRed, 85);
		addMix(Magenta, CadetBlue, MediumOrchid, 95);
		addMix(Magenta, Chocolate, DeepPink, 75);
		addMix(Magenta, Coral, DeepPink, 80);
		addMix(Magenta, Crimson, DeepPink, 90);
		addMix(Magenta, Cyan, MediumPurple, 65);
		addMix(Magenta, DarkGoldenrod, DeepPink, 60);
		addMix(Magenta, DarkGray, MediumOrchid, 95);
		addMix(Magenta, DarkKhaki, HotPink, 55);
		addMix(Magenta, DarkOliveGreen, MediumVioletRed, 50);
		addMix(Magenta, DarkOrange, DeepPink, 65);
		addMix(Magenta, DarkSalmon, HotPink, 85);
		addMix(Magenta, DarkSeaGreen, MediumOrchid, 50);
		addMix(Magenta, DarkSlateBlue, DarkViolet, 90);
		addMix(Magenta, DarkSlateGray, DarkViolet, 90);
		addMix(Magenta, DarkTurquoise, MediumPurple, 75);
		addMix(Magenta, DarkViolet, MediumOrchid, 105);
		addMix(Magenta, DeepPink, HotPink, 110);
		addMix(Magenta, DeepSkyBlue, MediumPurple, 70);
		addMix(Magenta, DimGray, MediumOrchid, 90);
		addMix(Magenta, DodgerBlue, SlateBlue, 85);
		addMix(Magenta, Goldenrod, DeepPink, 55);
		addMix(Magenta, Gray, MediumOrchid, 95);
		addMix(Magenta, HotPink, Violet, 110);
		addMix(Magenta, IndianRed, DeepPink, 95);
		addMix(Magenta, Indigo, DarkViolet, 90);
		addMix(Magenta, Khaki, HotPink, 50);
		addMix(Magenta, Lavender, Violet, 90);
		addMix(Magenta, LemonChiffon, Violet, 60);
		addMix(Magenta, LightGray, Violet, 90);
		addMix(Magenta, LightSeaGreen, MediumPurple, 80);
		addMix(Magenta, LightSteelBlue, MediumOrchid, 95);
		addMix(Maroon, Blue, Indigo, 80);
		addMix(Maroon, Chocolate, Sienna, 95);
		addMix(Maroon, Coral, Sienna, 85);
		addMix(Maroon, Crimson, Brown, 105);
		addMix(Maroon, DarkGoldenrod, Sienna, 85);
		addMix(Maroon, DarkGray, Brown, 75);
		addMix(Maroon, DarkKhaki, Sienna, 65);
		addMix(Maroon, DarkOrange, Sienna, 80);
		addMix(Maroon, DarkSalmon, Brown, 80);
		addMix(Maroon, DarkSeaGreen, Sienna, 55);
		addMix(Maroon, DarkTurquoise, DarkSlateGray, 50);
		addMix(Maroon, DarkViolet, Purple, 85);
		addMix(Maroon, DeepPink, Crimson, 90);
		addMix(Maroon, DeepSkyBlue, RoyalBlue, 50);
		addMix(Maroon, DimGray, Brown, 95);
		addMix(Maroon, DodgerBlue, DarkSlateBlue, 70);
		addMix(Maroon, Gold, Chocolate, 55);
		addMix(Maroon, Goldenrod, Sienna, 70);
		addMix(Maroon, Gray, Brown, 90);
		addMix(Maroon, Green, Olive, 60);
		addMix(Maroon, HotPink, Crimson, 80);
		addMix(Maroon, IndianRed, Brown, 100);
		addMix(Maroon, Indigo, Purple, 90);
		addMix(Maroon, Khaki, Chocolate, 55);
		addMix(Maroon, Lavender, RosyBrown, 60);
		addMix(Maroon, LemonChiffon, DarkSalmon, 55);
		addMix(Maroon, LightGray, IndianRed, 65);
		addMix(Maroon, LightSeaGreen, DimGray, 60);
		addMix(Maroon, Magenta, MediumVioletRed, 75);
		addMix(MediumAquamarine, Aquamarine, Turquoise, 115);
		addMix(MediumAquamarine, Black, DarkSlateGray, 55);
		addMix(MediumAquamarine, Blue, RoyalBlue, 60);
		addMix(MediumAquamarine, Brown, Gray, 55);
		addMix(MediumAquamarine, CadetBlue, LightSeaGreen, 110);
		addMix(MediumAquamarine, Chocolate, DarkKhaki, 75);
		addMix(MediumAquamarine, Coral, Tan, 70);
		addMix(MediumAquamarine, Crimson, RosyBrown, 55);
		addMix(MediumAquamarine, Cyan, Turquoise, 110);
		addMix(MediumAquamarine, DarkGoldenrod, DarkSeaGreen, 85);
		addMix(MediumAquamarine, DarkGray, DarkSeaGreen, 100);
		addMix(MediumAquamarine, DarkGreen, SeaGreen, 85);
		addMix(MediumAquamarine, DarkKhaki, DarkSeaGreen, 105);
		addMix(MediumAquamarine, DarkOliveGreen, SeaGreen, 90);
		addMix(MediumAquamarine, DarkOrange, DarkKhaki, 75);
		addMix(MediumAquamarine, DarkSalmon, DarkSeaGreen, 80);
		addMix(MediumAquamarine, DarkSeaGreen, MediumSeaGreen, 115);
		addMix(MediumAquamarine, DarkSlateBlue, SlateGray, 65);
		addMix(MediumAquamarine, DarkSlateGray, Teal, 80);
		addMix(MediumAquamarine, DarkTurquoise, Turquoise, 115);
		addMix(MediumAquamarine, DarkViolet, SlateBlue, 70);
		addMix(MediumAquamarine, DeepPink, PaleVioletRed, 45);
		addMix(MediumAquamarine, DeepSkyBlue, DarkTurquoise, 95);
		addMix(MediumAquamarine, DimGray, CadetBlue, 90);
		addMix(MediumAquamarine, DodgerBlue, DeepSkyBlue, 85);
		addMix(MediumAquamarine, Gold, YellowGreen, 90);
		addMix(MediumAquamarine, Goldenrod, DarkKhaki, 90);
		addMix(MediumAquamarine, Gray, CadetBlue, 95);
		addMix(MediumAquamarine, Green, MediumSeaGreen, 95);
		addMix(MediumAquamarine, HotPink, Thistle, 55);
		addMix(MediumAquamarine, IndianRed, DarkGray, 65);
		addMix(MediumAquamarine, Indigo, SlateBlue, 55);
		addMix(MediumAquamarine, Khaki, DarkSeaGreen, 100);
		addMix(MediumAquamarine, Lavender, PaleTurquoise, 95);
		addMix(MediumAquamarine, LemonChiffon, DarkSeaGreen, 100);
		addMix(MediumAquamarine, LightGray, PaleTurquoise, 100);
		addMix(MediumAquamarine, LightSeaGreen, Turquoise, 115);
		addMix(MediumAquamarine, LightSteelBlue, PaleTurquoise, 100);
		addMix(MediumAquamarine, Lime, LimeGreen, 100);
		addMix(MediumAquamarine, LimeGreen, MediumSeaGreen, 110);
		addMix(MediumAquamarine, Magenta, MediumOrchid, 75);
		addMix(MediumAquamarine, Maroon, DimGray, 50);
		addMix(MediumOrchid, Aquamarine, LightSteelBlue, 70);
		addMix(MediumOrchid, Black, Purple, 75);
		addMix(MediumOrchid, Blue, DarkViolet, 100);
		addMix(MediumOrchid, Brown, MediumVioletRed, 90);
		addMix(MediumOrchid, CadetBlue, MediumPurple, 95);
		addMix(MediumOrchid, Chocolate, PaleVioletRed, 80);
		addMix(MediumOrchid, Coral, PaleVioletRed, 85);
		addMix(MediumOrchid, Crimson, MediumVioletRed, 95);
		addMix(MediumOrchid, Cyan, DodgerBlue, 70);
		addMix(MediumOrchid, DarkGoldenrod, IndianRed, 65);
		addMix(MediumOrchid, DarkGray, Plum, 95);
		addMix(MediumOrchid, DarkKhaki, RosyBrown, 60);
		addMix(MediumOrchid, DarkOrange, IndianRed, 70);
		addMix(MediumOrchid, DarkSalmon, PaleVioletRed, 85);
		addMix(MediumOrchid, DarkSeaGreen, Plum, 55);
		addMix(MediumOrchid, DarkSlateBlue, SlateBlue, 100);
		addMix(MediumOrchid, DarkSlateGray, DarkSlateBlue, 95);
		addMix(MediumOrchid, DarkTurquoise, DodgerBlue, 75);
		addMix(MediumOrchid, DeepPink, MediumVioletRed, 110);
		addMix(MediumOrchid, DeepSkyBlue, DodgerBlue, 75);
		addMix(MediumOrchid, DimGray, MediumPurple, 95);
		addMix(MediumOrchid, DodgerBlue, RoyalBlue, 95);
		addMix(MediumOrchid, Gold, SandyBrown, 50);
		addMix(MediumOrchid, Goldenrod, RosyBrown, 60);
		addMix(MediumOrchid, Gray, MediumPurple, 100);
		addMix(MediumOrchid, HotPink, Violet, 110);
		addMix(MediumOrchid, IndianRed, MediumVioletRed, 95);
		addMix(MediumOrchid, Indigo, DarkViolet, 100);
		addMix(MediumOrchid, Khaki, RosyBrown, 55);
		addMix(MediumOrchid, Lavender, Plum, 90);
		addMix(MediumOrchid, LemonChiffon, Plum, 65);
		addMix(MediumOrchid, LightGray, Plum, 90);
		addMix(MediumOrchid, LightSeaGreen, SteelBlue, 80);
		addMix(MediumOrchid, LightSteelBlue, Plum, 95);
		addMix(MediumOrchid, Maroon, MediumVioletRed, 80);
		addMix(MediumPurple, Aquamarine, SkyBlue, 75);
		addMix(MediumPurple, Black, DarkSlateBlue, 75);
		addMix(MediumPurple, Blue, SlateBlue, 100);
		addMix(MediumPurple, Brown, MediumVioletRed, 85);
		addMix(MediumPurple, CadetBlue, SlateGray, 95);
		addMix(MediumPurple, Chocolate, PaleVioletRed, 80);
		addMix(MediumPurple, Coral, PaleVioletRed, 80);
		addMix(MediumPurple, Crimson, MediumVioletRed, 90);
		addMix(MediumPurple, Cyan, DeepSkyBlue, 75);
		addMix(MediumPurple, DarkGoldenrod, RosyBrown, 65);
		addMix(MediumPurple, DarkGreen, DarkSlateGray, 70);
		addMix(MediumPurple, DarkKhaki, RosyBrown, 65);
		addMix(MediumPurple, DarkOliveGreen, DimGray, 65);
		addMix(MediumPurple, DarkOrange, DarkSalmon, 70);
		addMix(MediumPurple, DarkSalmon, PaleVioletRed, 85);
		addMix(MediumPurple, DarkSeaGreen, SlateGray, 80);
		addMix(MediumPurple, DarkSlateBlue, SlateBlue, 105);
		addMix(MediumPurple, DarkSlateGray, SlateBlue, 95);
		addMix(MediumPurple, DarkTurquoise, DodgerBlue, 85);
		addMix(MediumPurple, DarkViolet, SlateBlue, 110);
		addMix(MediumPurple, DeepPink, MediumOrchid, 100);
		addMix(MediumPurple, DeepSkyBlue, DodgerBlue, 90);
		addMix(MediumPurple, DimGray, SlateBlue, 100);
		addMix(MediumPurple, DodgerBlue, RoyalBlue, 105);
		addMix(MediumPurple, Gold, Tan, 55);
		addMix(MediumPurple, Goldenrod, RosyBrown, 65);
		addMix(MediumPurple, Green, Teal, 70);
		addMix(MediumPurple, HotPink, MediumOrchid, 105);
		addMix(MediumPurple, IndianRed, PaleVioletRed, 95);
		addMix(MediumPurple, Indigo, DarkViolet, 95);
		addMix(MediumPurple, Khaki, Thistle, 60);
		addMix(MediumPurple, Lavender, Plum, 95);
		addMix(MediumPurple, LemonChiffon, Thistle, 65);
		addMix(MediumPurple, LightGray, Plum, 90);
		addMix(MediumPurple, LightSeaGreen, SteelBlue, 85);
		addMix(MediumPurple, Lime, MediumSeaGreen, 60);
		addMix(MediumPurple, LimeGreen, CadetBlue, 65);
		addMix(MediumPurple, Magenta, MediumOrchid, 110);
		addMix(MediumPurple, Maroon, Purple, 80);
		addMix(MediumPurple, MediumAquamarine, DodgerBlue, 80);
		addMix(MediumPurple, MediumOrchid, SlateBlue, 115);
		addMix(MediumSeaGreen, Aquamarine, MediumAquamarine, 105);
		addMix(MediumSeaGreen, Black, DarkGreen, 65);
		addMix(MediumSeaGreen, Blue, RoyalBlue, 60);
		addMix(MediumSeaGreen, Brown, DarkOliveGreen, 55);
		addMix(MediumSeaGreen, CadetBlue, LightSeaGreen, 105);
		addMix(MediumSeaGreen, Chocolate, OliveDrab, 70);
		addMix(MediumSeaGreen, Coral, DarkKhaki, 65);
		addMix(MediumSeaGreen, Crimson, Sienna, 50);
		addMix(MediumSeaGreen, Cyan, MediumAquamarine, 100);
		addMix(MediumSeaGreen, DarkGoldenrod, OliveDrab, 90);
		addMix(MediumSeaGreen, DarkGray, DarkSeaGreen, 100);
		addMix(MediumSeaGreen, DarkGreen, SeaGreen, 95);
		addMix(MediumSeaGreen, DarkKhaki, DarkSeaGreen, 105);
		addMix(MediumSeaGreen, DarkOliveGreen, SeaGreen, 100);
		addMix(MediumSeaGreen, DarkOrange, DarkKhaki, 75);
		addMix(MediumSeaGreen, DarkSalmon, DarkSeaGreen, 75);
		addMix(MediumSeaGreen, DarkSeaGreen, MediumAquamarine, 115);
		addMix(MediumSeaGreen, DarkSlateBlue, Teal, 70);
		addMix(MediumSeaGreen, DarkSlateGray, SeaGreen, 85);
		addMix(MediumSeaGreen, DarkTurquoise, MediumAquamarine, 105);
		addMix(MediumSeaGreen, DarkViolet, SlateBlue, 65);
		addMix(MediumSeaGreen, DeepSkyBlue, LightSeaGreen, 85);
		addMix(MediumSeaGreen, DimGray, SeaGreen, 95);
		addMix(MediumSeaGreen, DodgerBlue, CadetBlue, 75);
		addMix(MediumSeaGreen, Gold, YellowGreen, 90);
		addMix(MediumSeaGreen, Goldenrod, YellowGreen, 90);
		addMix(MediumSeaGreen, Gray, SeaGreen, 100);
		addMix(MediumSeaGreen, Green, SeaGreen, 105);
		addMix(MediumSeaGreen, HotPink, Gray, 45);
		addMix(MediumSeaGreen, Indigo, DarkSlateBlue, 60);
		addMix(MediumSeaGreen, Khaki, DarkSeaGreen, 95);
		addMix(MediumSeaGreen, Lavender, MediumAquamarine, 90);
		addMix(MediumSeaGreen, LemonChiffon, DarkSeaGreen, 95);
		addMix(MediumSeaGreen, LightGray, MediumAquamarine, 95);
		addMix(MediumSeaGreen, LightSeaGreen, MediumAquamarine, 110);
		addMix(MediumSeaGreen, LightSteelBlue, MediumAquamarine, 90);
		addMix(MediumSeaGreen, Lime, LimeGreen, 105);
		addMix(MediumSeaGreen, Magenta, MediumOrchid, 70);
		addMix(MediumSeaGreen, Maroon, DarkOliveGreen, 50);
		addMix(MediumSeaGreen, MediumAquamarine, DarkSeaGreen, 115);
		addMix(MediumSeaGreen, MediumOrchid, SlateGray, 75);
		addMix(MediumSeaGreen, MediumPurple, SlateGray, 75);
		addMix(MediumVioletRed, Black, Purple, 85);
		addMix(MediumVioletRed, Blue, DarkViolet, 95);
		addMix(MediumVioletRed, Chocolate, Crimson, 85);
		addMix(MediumVioletRed, Coral, IndianRed, 85);
		addMix(MediumVioletRed, Crimson, DeepPink, 105);
		addMix(MediumVioletRed, Cyan, SteelBlue, 45);
		addMix(MediumVioletRed, DarkGoldenrod, IndianRed, 70);
		addMix(MediumVioletRed, DarkGray, PaleVioletRed, 90);
		addMix(MediumVioletRed, DarkKhaki, PaleVioletRed, 60);
		addMix(MediumVioletRed, DarkOrange, IndianRed, 70);
		addMix(MediumVioletRed, DarkSalmon, PaleVioletRed, 90);
		addMix(MediumVioletRed, DarkSeaGreen, PaleVioletRed, 55);
		addMix(MediumVioletRed, DarkSlateBlue, Purple, 100);
		addMix(MediumVioletRed, DarkSlateGray, Purple, 100);
		addMix(MediumVioletRed, DarkTurquoise, RoyalBlue, 55);
		addMix(MediumVioletRed, DarkViolet, Purple, 110);
		addMix(MediumVioletRed, DeepSkyBlue, SlateBlue, 60);
		addMix(MediumVioletRed, DimGray, Purple, 100);
		addMix(MediumVioletRed, DodgerBlue, SlateBlue, 80);
		addMix(MediumVioletRed, Gold, Coral, 50);
		addMix(MediumVioletRed, Goldenrod, IndianRed, 60);
		addMix(MediumVioletRed, HotPink, DeepPink, 105);
		addMix(MediumVioletRed, IndianRed, DeepPink, 105);
		addMix(MediumVioletRed, Indigo, Purple, 100);
		addMix(MediumVioletRed, Khaki, PaleVioletRed, 55);
		addMix(MediumVioletRed, Lavender, Violet, 80);
		addMix(MediumVioletRed, LemonChiffon, PaleVioletRed, 60);
		addMix(MediumVioletRed, LightGray, PaleVioletRed, 85);
		addMix(MediumVioletRed, LightSeaGreen, SlateBlue, 65);
		addMix(MediumVioletRed, LightSteelBlue, MediumOrchid, 80);
		addMix(MediumVioletRed, Magenta, MediumOrchid, 105);
		addMix(MediumVioletRed, Maroon, Brown, 95);
		addMix(MediumVioletRed, MediumPurple, MediumOrchid, 105);
		addMix(MistyRose, Aquamarine, PaleTurquoise, 90);
		addMix(MistyRose, Blue, MediumPurple, 65);
		addMix(MistyRose, Brown, RosyBrown, 75);
		addMix(MistyRose, CadetBlue, LightGray, 85);
		addMix(MistyRose, Chocolate, DarkSalmon, 90);
		addMix(MistyRose, Coral, DarkSalmon, 100);
		addMix(MistyRose, Crimson, PaleVioletRed, 85);
		addMix(MistyRose, Cyan, PaleTurquoise, 90);
		addMix(MistyRose, DarkGoldenrod, Tan, 90);
		addMix(MistyRose, DarkGray, LightGray, 105);
		addMix(MistyRose, DarkGreen, DarkSeaGreen, 65);
		addMix(MistyRose, DarkKhaki, Wheat, 100);
		addMix(MistyRose, DarkOliveGreen, DarkKhaki, 75);
		addMix(MistyRose, DarkOrange, SandyBrown, 95);
		addMix(MistyRose, DarkSalmon, Pink, 105);
		addMix(MistyRose, DarkSeaGreen, LemonChiffon, 90);
		addMix(MistyRose, DarkSlateBlue, Plum, 65);
		addMix(MistyRose, DarkSlateGray, DarkGray, 65);
		addMix(MistyRose, DarkTurquoise, PaleTurquoise, 90);
		addMix(MistyRose, DarkViolet, Violet, 70);
		addMix(MistyRose, DeepPink, HotPink, 90);
		addMix(MistyRose, DeepSkyBlue, SkyBlue, 90);
		addMix(MistyRose, DimGray, DarkGray, 85);
		addMix(MistyRose, DodgerBlue, LightSteelBlue, 85);
		addMix(MistyRose, Gold, Khaki, 95);
		addMix(MistyRose, Goldenrod, Tan, 95);
		addMix(MistyRose, Gray, DarkGray, 95);
		addMix(MistyRose, Green, DarkSeaGreen, 70);
		addMix(MistyRose, HotPink, Pink, 95);
		addMix(MistyRose, IndianRed, RosyBrown, 90);
		addMix(MistyRose, Indigo, MediumOrchid, 50);
		addMix(MistyRose, Khaki, Wheat, 100);
		addMix(MistyRose, LemonChiffon, Wheat, 105);
		addMix(MistyRose, LightSeaGreen, PaleTurquoise, 85);
		addMix(MistyRose, LightSteelBlue, Lavender, 105);
		addMix(MistyRose, Lime, PaleGreen, 80);
		addMix(MistyRose, LimeGreen, PaleGreen, 80);
		addMix(MistyRose, Magenta, Violet, 85);
		addMix(MistyRose, Maroon, IndianRed, 60);
		addMix(MistyRose, MediumAquamarine, PaleTurquoise, 90);
		addMix(MistyRose, MediumOrchid, Plum, 85);
		addMix(MistyRose, MediumPurple, Plum, 85);
		addMix(MistyRose, MediumSeaGreen, DarkSeaGreen, 85);
		addMix(MistyRose, MediumVioletRed, HotPink, 80);
		addMix(Navy, Blue, Indigo, 110);
		addMix(Navy, Brown, Purple, 85);
		addMix(Navy, CadetBlue, DarkSlateBlue, 75);
		addMix(Navy, Coral, Purple, 60);
		addMix(Navy, Crimson, Purple, 80);
		addMix(Navy, DarkGray, DarkSlateBlue, 65);
		addMix(Navy, DarkGreen, DarkSlateGray, 65);
		addMix(Navy, DarkOliveGreen, DarkSlateBlue, 55);
		addMix(Navy, DarkOrange, Brown, 50);
		addMix(Navy, DarkSeaGreen, RoyalBlue, 55);
		addMix(Navy, DarkSlateBlue, Indigo, 110);
		addMix(Navy, DarkSlateGray, DarkSlateBlue, 95);
		addMix(Navy, DarkTurquoise, SteelBlue, 55);
		addMix(Navy, DarkViolet, Indigo, 105);
		addMix(Navy, DeepPink, Purple, 80);
		addMix(Navy, DeepSkyBlue, RoyalBlue, 60);
		addMix(Navy, DimGray, DarkSlateBlue, 90);
		addMix(Navy, DodgerBlue, DarkSlateBlue, 80);
		addMix(Navy, Gray, DarkSlateBlue, 80);
		addMix(Navy, Green, Teal, 60);
		addMix(Navy, HotPink, Purple, 75);
		addMix(Navy, IndianRed, Purple, 80);
		addMix(Navy, LightGray, SlateBlue, 50);
		addMix(Navy, LightSeaGreen, RoyalBlue, 65);
		addMix(Navy, LightSteelBlue, SlateBlue, 60);
		addMix(Navy, Magenta, DarkViolet, 85);
		addMix(Navy, Maroon, Purple, 85);
		addMix(Navy, MediumAquamarine, RoyalBlue, 50);
		addMix(Navy, MediumOrchid, DarkSlateBlue, 90);
		addMix(Navy, MediumPurple, DarkSlateBlue, 90);
		addMix(Navy, MediumVioletRed, Indigo, 95);
		addMix(Olive, Aquamarine, DarkSeaGreen, 85);
		addMix(Olive, Blue, DarkSlateBlue, 45);
		addMix(Olive, Brown, Sienna, 80);
		addMix(Olive, CadetBlue, OliveDrab, 95);
		addMix(Olive, Chocolate, DarkGoldenrod, 95);
		addMix(Olive, Coral, Peru, 85);
		addMix(Olive, Crimson, Sienna, 75);
		addMix(Olive, Cyan, MediumSeaGreen, 80);
		addMix(Olive, DarkGray, OliveDrab, 95);
		addMix(Olive, DarkGreen, Green, 105);
		addMix(Olive, DarkKhaki, OliveDrab, 110);
		addMix(Olive, DarkOliveGreen, OliveDrab, 110);
		addMix(Olive, DarkOrange, DarkGoldenrod, 95);
		addMix(Olive, DarkSalmon, DarkGoldenrod, 90);
		addMix(Olive, DarkSeaGreen, OliveDrab, 100);
		addMix(Olive, DarkSlateBlue, DimGray, 60);
		addMix(Olive, DarkSlateGray, DarkOliveGreen, 90);
		addMix(Olive, DarkTurquoise, MediumSeaGreen, 85);
		addMix(Olive, DarkViolet, MediumVioletRed, 50);
		addMix(Olive, DeepPink, IndianRed, 60);
		addMix(Olive, DeepSkyBlue, MediumSeaGreen, 70);
		addMix(Olive, DimGray, DarkOliveGreen, 100);
		addMix(Olive, DodgerBlue, Teal, 60);
		addMix(Olive, Gold, Goldenrod, 95);
		addMix(Olive, Goldenrod, DarkGoldenrod, 105);
		addMix(Olive, Gray, OliveDrab, 100);
		addMix(Olive, Green, OliveDrab, 110);
		addMix(Olive, HotPink, IndianRed, 60);
		addMix(Olive, IndianRed, Peru, 80);
		addMix(Olive, Khaki, DarkKhaki, 95);
		addMix(Olive, Lavender, DarkKhaki, 75);
		addMix(Olive, LemonChiffon, DarkKhaki, 90);
		addMix(Olive, LightGray, DarkKhaki, 90);
		addMix(Olive, LightSeaGreen, SeaGreen, 90);
		addMix(Olive, LightSteelBlue, DarkKhaki, 80);
		addMix(Olive, Lime, LimeGreen, 90);
		addMix(Olive, LimeGreen, OliveDrab, 100);
		addMix(Olive, Magenta, MediumVioletRed, 45);
		addMix(Olive, Maroon, Sienna, 80);
		addMix(Olive, MediumAquamarine, OliveDrab, 95);
		addMix(Olive, MediumOrchid, IndianRed, 55);
		addMix(Olive, MediumPurple, Gray, 60);
		addMix(Olive, MediumSeaGreen, OliveDrab, 100);
		addMix(Olive, MediumVioletRed, Brown, 60);
		addMix(Olive, MistyRose, DarkKhaki, 85);
		addMix(Olive, Navy, Gray, 50);
		addMix(OliveDrab, Aquamarine, DarkSeaGreen, 90);
		addMix(OliveDrab, Black, DarkOliveGreen, 75);
		addMix(OliveDrab, Brown, Sienna, 70);
		addMix(OliveDrab, CadetBlue, SeaGreen, 95);
		addMix(OliveDrab, Chocolate, DarkGoldenrod, 85);
		addMix(OliveDrab, Coral, DarkGoldenrod, 75);
		addMix(OliveDrab, Crimson, Sienna, 65);
		addMix(OliveDrab, Cyan, MediumAquamarine, 85);
		addMix(OliveDrab, DarkGoldenrod, Olive, 100);
		addMix(OliveDrab, DarkGray, DarkSeaGreen, 100);
		addMix(OliveDrab, DarkGreen, Green, 105);
		addMix(OliveDrab, DarkKhaki, Olive, 110);
		addMix(OliveDrab, DarkOliveGreen, Olive, 115);
		addMix(OliveDrab, DarkOrange, DarkGoldenrod, 85);
		addMix(OliveDrab, DarkSalmon, DarkGoldenrod, 85);
		addMix(OliveDrab, DarkSeaGreen, MediumSeaGreen, 110);
		addMix(OliveDrab, DarkSlateBlue, DimGray, 55);
		addMix(OliveDrab, DarkSlateGray, DarkOliveGreen, 90);
		addMix(OliveDrab, DarkTurquoise, MediumSeaGreen, 90);
		addMix(OliveDrab, DeepPink, IndianRed, 50);
		addMix(OliveDrab, DeepSkyBlue, LightSeaGreen, 70);
		addMix(OliveDrab, DimGray, DarkOliveGreen, 100);
		addMix(OliveDrab, DodgerBlue, CadetBlue, 65);
		addMix(OliveDrab, Gold, DarkKhaki, 95);
		addMix(OliveDrab, Goldenrod, Olive, 100);
		addMix(OliveDrab, Gray, DarkOliveGreen, 100);
		addMix(OliveDrab, Green, SeaGreen, 115);
		addMix(OliveDrab, HotPink, RosyBrown, 55);
		addMix(OliveDrab, IndianRed, DarkGoldenrod, 70);
		addMix(OliveDrab, Khaki, DarkKhaki, 100);
		addMix(OliveDrab, Lavender, DarkSeaGreen, 80);
		addMix(OliveDrab, LemonChiffon, DarkKhaki, 90);
		addMix(OliveDrab, LightGray, DarkSeaGreen, 90);
		addMix(OliveDrab, LightSeaGreen, MediumSeaGreen, 95);
		addMix(OliveDrab, LightSteelBlue, DarkSeaGreen, 80);
		addMix(OliveDrab, Lime, LimeGreen, 95);
		addMix(OliveDrab, LimeGreen, MediumSeaGreen, 105);
		addMix(OliveDrab, Maroon, Sienna, 70);
		addMix(OliveDrab, MediumAquamarine, MediumSeaGreen, 100);
		addMix(OliveDrab, MediumOrchid, RosyBrown, 50);
		addMix(OliveDrab, MediumPurple, Gray, 55);
		addMix(OliveDrab, MediumSeaGreen, SeaGreen, 110);
		addMix(OliveDrab, MediumVioletRed, Brown, 50);
		addMix(OliveDrab, MistyRose, DarkKhaki, 80);
		addMix(Orange, Aquamarine, YellowGreen, 80);
		addMix(Orange, Blue, Plum, 45);
		addMix(Orange, Brown, Chocolate, 80);
		addMix(Orange, CadetBlue, DarkKhaki, 85);
		addMix(Orange, Chocolate, DarkOrange, 105);
		addMix(Orange, Coral, DarkOrange, 105);
		addMix(Orange, Crimson, Chocolate, 80);
		addMix(Orange, Cyan, DarkSeaGreen, 75);
		addMix(Orange, DarkGoldenrod, Goldenrod, 110);
		addMix(Orange, DarkGray, Goldenrod, 95);
		addMix(Orange, DarkGreen, Olive, 70);
		addMix(Orange, DarkKhaki, Goldenrod, 105);
		addMix(Orange, DarkOliveGreen, DarkGoldenrod, 85);
		addMix(Orange, DarkOrange, SandyBrown, 120);
		addMix(Orange, DarkSalmon, SandyBrown, 105);
		addMix(Orange, DarkSeaGreen, DarkKhaki, 90);
		addMix(Orange, DarkSlateBlue, Peru, 55);
		addMix(Orange, DarkSlateGray, DarkGoldenrod, 70);
		addMix(Orange, DarkTurquoise, DarkSeaGreen, 80);
		addMix(Orange, DarkViolet, IndianRed, 55);
		addMix(Orange, DeepPink, Salmon, 70);
		addMix(Orange, DeepSkyBlue, DarkSeaGreen, 70);
		addMix(Orange, DimGray, DarkGoldenrod, 85);
		addMix(Orange, DodgerBlue, DarkSeaGreen, 65);
		addMix(Orange, Gold, Goldenrod, 110);
		addMix(Orange, Goldenrod, DarkGoldenrod, 120);
		addMix(Orange, Gray, DarkGoldenrod, 90);
		addMix(Orange, Green, OliveDrab, 75);
		addMix(Orange, HotPink, Coral, 75);
		addMix(Orange, IndianRed, Peru, 90);
		addMix(Orange, Khaki, Gold, 105);
		addMix(Orange, Lavender, Tan, 85);
		addMix(Orange, LemonChiffon, Gold, 100);
		addMix(Orange, LightGray, Goldenrod, 95);
		addMix(Orange, LightSeaGreen, DarkKhaki, 80);
		addMix(Orange, LightSteelBlue, Tan, 85);
		addMix(Orange, Lime, YellowGreen, 75);
		addMix(Orange, LimeGreen, YellowGreen, 80);
		addMix(Orange, Magenta, PaleVioletRed, 60);
		addMix(Orange, Maroon, Chocolate, 70);
		addMix(Orange, MediumAquamarine, DarkKhaki, 80);
		addMix(Orange, MediumOrchid, Salmon, 65);
		addMix(Orange, MediumPurple, DarkSalmon, 65);
		addMix(Orange, MediumSeaGreen, DarkKhaki, 80);
		addMix(Orange, MediumVioletRed, Red, 65);
		addMix(Orange, MistyRose, SandyBrown, 95);
		addMix(Orange, Olive, DarkGoldenrod, 95);
		addMix(Orange, OliveDrab, Goldenrod, 90);
		addMix(PaleGreen, Aquamarine, SpringGreen, 115);
		addMix(PaleGreen, Blue, SteelBlue, 50);
		addMix(PaleGreen, Brown, DarkKhaki, 45);
		addMix(PaleGreen, CadetBlue, MediumAquamarine, 95);
		addMix(PaleGreen, Chocolate, DarkKhaki, 65);
		addMix(PaleGreen, Coral, DarkKhaki, 65);
		addMix(PaleGreen, Cyan, Aquamarine, 100);
		addMix(PaleGreen, DarkGoldenrod, YellowGreen, 85);
		addMix(PaleGreen, DarkGray, DarkSeaGreen, 95);
		addMix(PaleGreen, DarkGreen, MediumSeaGreen, 80);
		addMix(PaleGreen, DarkKhaki, YellowGreen, 105);
		addMix(PaleGreen, DarkOliveGreen, DarkSeaGreen, 85);
		addMix(PaleGreen, DarkOrange, DarkKhaki, 75);
		addMix(PaleGreen, DarkSalmon, DarkKhaki, 75);
		addMix(PaleGreen, DarkSeaGreen, MediumAquamarine, 110);
		addMix(PaleGreen, DarkSlateBlue, CadetBlue, 55);
		addMix(PaleGreen, DarkSlateGray, MediumSeaGreen, 70);
		addMix(PaleGreen, DarkTurquoise, MediumAquamarine, 95);
		addMix(PaleGreen, DarkViolet, MediumPurple, 55);
		addMix(PaleGreen, DeepSkyBlue, Turquoise, 75);
		addMix(PaleGreen, DimGray, DarkSeaGreen, 80);
		addMix(PaleGreen, DodgerBlue, DarkTurquoise, 65);
		addMix(PaleGreen, Gold, YellowGreen, 95);
		addMix(PaleGreen, Goldenrod, YellowGreen, 90);
		addMix(PaleGreen, Gray, DarkSeaGreen, 90);
		addMix(PaleGreen, Green, LimeGreen, 90);
		addMix(PaleGreen, IndianRed, DarkKhaki, 55);
		addMix(PaleGreen, Khaki, YellowGreen, 105);
		addMix(PaleGreen, Lavender, Aquamarine, 90);
		addMix(PaleGreen, LightGray, DarkSeaGreen, 100);
		addMix(PaleGreen, LightSeaGreen, MediumAquamarine, 100);
		addMix(PaleGreen, LightSteelBlue, MediumAquamarine, 90);
		addMix(PaleGreen, Lime, SpringGreen, 115);
		addMix(PaleGreen, LimeGreen, SpringGreen, 115);
		addMix(PaleGreen, MediumAquamarine, Aquamarine, 110);
		addMix(PaleGreen, MediumOrchid, DarkGray, 65);
		addMix(PaleGreen, MediumPurple, CadetBlue, 65);
		addMix(PaleGreen, MediumSeaGreen, LimeGreen, 110);
		addMix(PaleGreen, MistyRose, LemonChiffon, 90);
		addMix(PaleGreen, Olive, YellowGreen, 90);
		addMix(PaleGreen, OliveDrab, LimeGreen, 95);
		addMix(PaleGreen, Orange, Khaki, 80);
		addMix(PaleTurquoise, Aquamarine, Turquoise, 110);
		addMix(PaleTurquoise, Blue, RoyalBlue, 65);
		addMix(PaleTurquoise, Brown, RosyBrown, 60);
		addMix(PaleTurquoise, CadetBlue, DarkTurquoise, 105);
		addMix(PaleTurquoise, Chocolate, Tan, 75);
		addMix(PaleTurquoise, Coral, Tan, 80);
		addMix(PaleTurquoise, Crimson, PaleVioletRed, 65);
		addMix(PaleTurquoise, Cyan, Turquoise, 115);
		addMix(PaleTurquoise, DarkGoldenrod, DarkKhaki, 85);
		addMix(PaleTurquoise, DarkGray, SkyBlue, 105);
		addMix(PaleTurquoise, DarkGreen, MediumSeaGreen, 75);
		addMix(PaleTurquoise, DarkKhaki, DarkSeaGreen, 95);
		addMix(PaleTurquoise, DarkOliveGreen, DarkSeaGreen, 80);
		addMix(PaleTurquoise, DarkOrange, DarkKhaki, 80);
		addMix(PaleTurquoise, DarkSalmon, LightGray, 85);
		addMix(PaleTurquoise, DarkSeaGreen, MediumAquamarine, 105);
		addMix(PaleTurquoise, DarkSlateBlue, SteelBlue, 65);
		addMix(PaleTurquoise, DarkSlateGray, CadetBlue, 75);
		addMix(PaleTurquoise, DarkTurquoise, Turquoise, 115);
		addMix(PaleTurquoise, DarkViolet, MediumPurple, 75);
		addMix(PaleTurquoise, DeepPink, Plum, 75);
		addMix(PaleTurquoise, DeepSkyBlue, SkyBlue, 105);
		addMix(PaleTurquoise, DimGray, CadetBlue, 85);
		addMix(PaleTurquoise, DodgerBlue, DeepSkyBlue, 90);
		addMix(PaleTurquoise, Gold, Khaki, 90);
		addMix(PaleTurquoise, Goldenrod, DarkKhaki, 85);
		addMix(PaleTurquoise, Gray, CadetBlue, 95);
		addMix(PaleTurquoise, Green, MediumSeaGreen, 80);
		addMix(PaleTurquoise, HotPink, Plum, 80);
		addMix(PaleTurquoise, IndianRed, RosyBrown, 70);
		addMix(PaleTurquoise, Indigo, MediumPurple, 50);
		addMix(PaleTurquoise, Khaki, LemonChiffon, 95);
		addMix(PaleTurquoise, Lavender, SkyBlue, 105);
		addMix(PaleTurquoise, LightGray, SkyBlue, 110);
		addMix(PaleTurquoise, LightSeaGreen, DarkTurquoise, 110);
		addMix(PaleTurquoise, LightSteelBlue, SkyBlue, 110);
		addMix(PaleTurquoise, Lime, SpringGreen, 95);
		addMix(PaleTurquoise, LimeGreen, PaleGreen, 95);
		addMix(PaleTurquoise, Magenta, Violet, 85);
		addMix(PaleTurquoise, Maroon, RosyBrown, 50);
		addMix(PaleTurquoise, MediumAquamarine, Turquoise, 110);
		addMix(PaleTurquoise, MediumOrchid, Plum, 85);
		addMix(PaleTurquoise, MediumPurple, LightSteelBlue, 85);
		addMix(PaleTurquoise, MediumSeaGreen, MediumAquamarine, 100);
		addMix(PaleTurquoise, MediumVioletRed, Plum, 70);
		addMix(PaleTurquoise, MistyRose, LightGray, 95);
		addMix(PaleTurquoise, Olive, DarkSeaGreen, 85);
		addMix(PaleTurquoise, OliveDrab, DarkSeaGreen, 85);
		addMix(PaleTurquoise, Orange, DarkKhaki, 85);
		addMix(PaleTurquoise, PaleGreen, Aquamarine, 100);
		addMix(PaleVioletRed, Aquamarine, DarkGray, 55);
		addMix(PaleVioletRed, Blue, DarkViolet, 85);
		addMix(PaleVioletRed, Brown, IndianRed, 100);
		addMix(PaleVioletRed, CadetBlue, RosyBrown, 80);
		addMix(PaleVioletRed, Chocolate, IndianRed, 95);
		addMix(PaleVioletRed, Coral, Salmon, 100);
		addMix(PaleVioletRed, Crimson, IndianRed, 105);
		addMix(PaleVioletRed, Cyan, SkyBlue, 50);
		addMix(PaleVioletRed, DarkGoldenrod, Chocolate, 80);
		addMix(PaleVioletRed, DarkGray, RosyBrown, 100);
		addMix(PaleVioletRed, DarkGreen, DarkOliveGreen, 55);
		addMix(PaleVioletRed, DarkKhaki, DarkSalmon, 75);
		addMix(PaleVioletRed, DarkOliveGreen, Sienna, 70);
		addMix(PaleVioletRed, DarkOrange, Coral, 85);
		addMix(PaleVioletRed, DarkSalmon, Salmon, 105);
		addMix(PaleVioletRed, DarkSeaGreen, RosyBrown, 70);
		addMix(PaleVioletRed, DarkSlateBlue, MediumVioletRed, 90);
		addMix(PaleVioletRed, DarkTurquoise, CadetBlue, 60);
		addMix(PaleVioletRed, DarkViolet, MediumOrchid, 95);
		addMix(PaleVioletRed, DeepPink, HotPink, 115);
		addMix(PaleVioletRed, DeepSkyBlue, DodgerBlue, 70);
		addMix(PaleVioletRed, DodgerBlue, MediumPurple, 85);
		addMix(PaleVioletRed, Gold, SandyBrown, 65);
		addMix(PaleVioletRed, Goldenrod, Peru, 80);
		addMix(PaleVioletRed, Gray, RosyBrown, 100);
		addMix(PaleVioletRed, Green, DarkOliveGreen, 55);
		addMix(PaleVioletRed, HotPink, DeepPink, 120);
		addMix(PaleVioletRed, Indigo, Purple, 85);
		addMix(PaleVioletRed, Khaki, DarkSalmon, 70);
		addMix(PaleVioletRed, Lavender, Thistle, 95);
		addMix(PaleVioletRed, LemonChiffon, Pink, 80);
		addMix(PaleVioletRed, LightGray, Pink, 95);
		addMix(PaleVioletRed, LightSeaGreen, SlateGray, 65);
		addMix(PaleVioletRed, LightSteelBlue, Plum, 90);
		addMix(PaleVioletRed, LimeGreen, DarkSeaGreen, 50);
		addMix(PaleVioletRed, Magenta, MediumOrchid, 105);
		addMix(PaleVioletRed, Maroon, Brown, 90);
		addMix(PaleVioletRed, MediumAquamarine, DarkGray, 60);
		addMix(PaleVioletRed, MediumOrchid, HotPink, 105);
		addMix(PaleVioletRed, MediumPurple, MediumOrchid, 100);
		addMix(PaleVioletRed, MediumSeaGreen, Gray, 55);
		addMix(PaleVioletRed, MediumVioletRed, DeepPink, 110);
		addMix(PaleVioletRed, MistyRose, Pink, 95);
		addMix(PaleVioletRed, Navy, Purple, 80);
		addMix(PaleVioletRed, Olive, Peru, 70);
		addMix(PaleVioletRed, OliveDrab, Peru, 65);
		addMix(PaleVioletRed, Orange, SandyBrown, 80);
		addMix(PaleVioletRed, PaleGreen, DarkKhaki, 55);
		addMix(PaleVioletRed, PaleTurquoise, Thistle, 80);
		addMix(Peru, Aquamarine, DarkSeaGreen, 75);
		addMix(Peru, Blue, DarkSlateBlue, 60);
		addMix(Peru, Brown, Sienna, 95);
		addMix(Peru, Chocolate, DarkOrange, 120);
		addMix(Peru, Coral, Chocolate, 115);
		addMix(Peru, Crimson, IndianRed, 95);
		addMix(Peru, Cyan, MediumAquamarine, 75);
		addMix(Peru, DarkGoldenrod, Goldenrod, 115);
		addMix(Peru, DarkGray, Tan, 100);
		addMix(Peru, DarkGreen, DarkOliveGreen, 80);
		addMix(Peru, DarkKhaki, Goldenrod, 105);
		addMix(Peru, DarkOliveGreen, Olive, 90);
		addMix(Peru, DarkOrange, SandyBrown, 115);
		addMix(Peru, DarkSalmon, SandyBrown, 115);
		addMix(Peru, DarkSeaGreen, DarkKhaki, 90);
		addMix(Peru, DarkTurquoise, MediumSeaGreen, 80);
		addMix(Peru, DarkViolet, MediumVioletRed, 65);
		addMix(Peru, DeepPink, IndianRed, 85);
		addMix(Peru, DeepSkyBlue, CadetBlue, 75);
		addMix(Peru, DodgerBlue, SlateGray, 75);
		addMix(Peru, Gold, Goldenrod, 100);
		addMix(Peru, Goldenrod, DarkGoldenrod, 110);
		addMix(Peru, Green, OliveDrab, 80);
		addMix(Peru, HotPink, Salmon, 85);
		addMix(Peru, IndianRed, Chocolate, 100);
		addMix(Peru, Indigo, MediumVioletRed, 65);
		addMix(Peru, Khaki, Goldenrod, 95);
		addMix(Peru, Lavender, Tan, 90);
		addMix(Peru, LemonChiffon, Tan, 95);
		addMix(Peru, LightGray, Tan, 95);
		addMix(Peru, LightSeaGreen, DarkSeaGreen, 80);
		addMix(Peru, LightSteelBlue, Tan, 90);
		addMix(Peru, Lime, LimeGreen, 75);
		addMix(Peru, LimeGreen, OliveDrab, 80);
		addMix(Peru, Magenta, DeepPink, 70);
		addMix(Peru, Maroon, Sienna, 90);
		addMix(Peru, MediumAquamarine, DarkSeaGreen, 85);
		addMix(Peru, MediumOrchid, PaleVioletRed, 75);
		addMix(Peru, MediumPurple, PaleVioletRed, 75);
		addMix(Peru, MediumSeaGreen, OliveDrab, 80);
		addMix(Peru, MediumVioletRed, IndianRed, 80);
		addMix(Peru, MistyRose, Tan, 95);
		addMix(Peru, Olive, DarkGoldenrod, 100);
		addMix(Peru, OliveDrab, Olive, 95);
		addMix(Peru, Orange, DarkOrange, 115);
		addMix(Peru, PaleGreen, DarkKhaki, 80);
		addMix(Peru, PaleTurquoise, DarkKhaki, 85);
		addMix(Peru, PaleVioletRed, Salmon, 90);
		addMix(Pink, Aquamarine, PaleTurquoise, 75);
		addMix(Pink, Blue, SlateBlue, 70);
		addMix(Pink, Brown, IndianRed, 85);
		addMix(Pink, CadetBlue, DarkGray, 80);
		addMix(Pink, Chocolate, DarkSalmon, 90);
		addMix(Pink, Coral, DarkSalmon, 100);
		addMix(Pink, Crimson, PaleVioletRed, 90);
		addMix(Pink, Cyan, PaleTurquoise, 60);
		addMix(Pink, DarkGoldenrod, SandyBrown, 85);
		addMix(Pink, DarkGray, Thistle, 105);
		addMix(Pink, DarkGreen, OliveDrab, 60);
		addMix(Pink, DarkKhaki, Tan, 90);
		addMix(Pink, DarkOliveGreen, Tan, 70);
		addMix(Pink, DarkOrange, SandyBrown, 95);
		addMix(Pink, DarkSalmon, Salmon, 110);
		addMix(Pink, DarkSeaGreen, Tan, 80);
		addMix(Pink, DarkSlateGray, Gray, 65);
		addMix(Pink, DarkTurquoise, SkyBlue, 65);
		addMix(Pink, DarkViolet, MediumOrchid, 80);
		addMix(Pink, DeepPink, HotPink, 100);
		addMix(Pink, DeepSkyBlue, SkyBlue, 80);
		addMix(Pink, DimGray, RosyBrown, 90);
		addMix(Pink, DodgerBlue, LightSteelBlue, 85);
		addMix(Pink, Gold, Goldenrod, 80);
		addMix(Pink, Goldenrod, SandyBrown, 90);
		addMix(Pink, Gray, RosyBrown, 95);
		addMix(Pink, Green, DarkSeaGreen, 60);
		addMix(Pink, HotPink, PaleVioletRed, 105);
		addMix(Pink, IndianRed, Salmon, 100);
		addMix(Pink, Indigo, MediumOrchid, 60);
		addMix(Pink, Khaki, Wheat, 90);
		addMix(Pink, Lavender, Thistle, 105);
		addMix(Pink, LemonChiffon, MistyRose, 95);
		addMix(Pink, LightGray, MistyRose, 105);
		addMix(Pink, LightSeaGreen, CadetBlue, 70);
		addMix(Pink, LightSteelBlue, Thistle, 100);
		addMix(Pink, Lime, LimeGreen, 60);
		addMix(Pink, LimeGreen, DarkSeaGreen, 65);
		addMix(Pink, Magenta, Violet, 95);
		addMix(Pink, Maroon, IndianRed, 65);
		addMix(Pink, MediumAquamarine, LightGray, 75);
		addMix(Pink, MediumOrchid, Plum, 95);
		addMix(Pink, MediumPurple, Plum, 95);
		addMix(Pink, MediumSeaGreen, DarkSeaGreen, 70);
		addMix(Pink, MediumVioletRed, HotPink, 90);
		addMix(Pink, MistyRose, Thistle, 115);
		addMix(Pink, Navy, SlateBlue, 50);
		addMix(Pink, Olive, Tan, 75);
		addMix(Pink, OliveDrab, DarkKhaki, 75);
		addMix(Pink, Orange, SandyBrown, 90);
		addMix(Pink, PaleGreen, LemonChiffon, 70);
		addMix(Pink, PaleTurquoise, LightGray, 80);
		addMix(Pink, PaleVioletRed, HotPink, 105);
		addMix(Pink, Peru, DarkSalmon, 95);
		addMix(Plum, Aquamarine, SkyBlue, 80);
		addMix(Plum, Blue, SlateBlue, 80);
		addMix(Plum, Brown, PaleVioletRed, 85);
		addMix(Plum, CadetBlue, LightSteelBlue, 90);
		addMix(Plum, Chocolate, Salmon, 85);
		addMix(Plum, Coral, Salmon, 90);
		addMix(Plum, Crimson, PaleVioletRed, 90);
		addMix(Plum, Cyan, SkyBlue, 75);
		addMix(Plum, DarkGoldenrod, DarkSalmon, 75);
		addMix(Plum, DarkGray, Thistle, 105);
		addMix(Plum, DarkKhaki, RosyBrown, 75);
		addMix(Plum, DarkOliveGreen, RosyBrown, 65);
		addMix(Plum, DarkOrange, DarkSalmon, 80);
		addMix(Plum, DarkSalmon, Pink, 95);
		addMix(Plum, DarkSeaGreen, DarkGray, 70);
		addMix(Plum, DarkSlateBlue, MediumPurple, 80);
		addMix(Plum, DarkTurquoise, SkyBlue, 80);
		addMix(Plum, DarkViolet, MediumOrchid, 90);
		addMix(Plum, DeepPink, HotPink, 105);
		addMix(Plum, DeepSkyBlue, DodgerBlue, 80);
		addMix(Plum, Gold, Tan, 65);
		addMix(Plum, Goldenrod, DarkSalmon, 75);
		addMix(Plum, Gray, RosyBrown, 100);
		addMix(Plum, Green, SeaGreen, 50);
		addMix(Plum, HotPink, Violet, 115);
		addMix(Plum, IndianRed, PaleVioletRed, 95);
		addMix(Plum, Indigo, MediumOrchid, 70);
		addMix(Plum, Khaki, MistyRose, 70);
		addMix(Plum, Lavender, Thistle, 105);
		addMix(Plum, LemonChiffon, MistyRose, 80);
		addMix(Plum, LightGray, Thistle, 100);
		addMix(Plum, LightSeaGreen, SkyBlue, 80);
		addMix(Plum, LightSteelBlue, Thistle, 105);
		addMix(Plum, Lime, LimeGreen, 45);
		addMix(Plum, LimeGreen, DarkSeaGreen, 50);
		addMix(Plum, Magenta, Violet, 105);
		addMix(Plum, Maroon, MediumVioletRed, 70);
		addMix(Plum, MediumAquamarine, LightSteelBlue, 85);
		addMix(Plum, MediumOrchid, Violet, 105);
		addMix(Plum, MediumPurple, Violet, 105);
		addMix(Plum, MediumSeaGreen, CadetBlue, 80);
		addMix(Plum, MediumVioletRed, MediumOrchid, 100);
		addMix(Plum, MistyRose, Thistle, 105);
		addMix(Plum, Navy, SlateBlue, 65);
		addMix(Plum, Olive, Tan, 65);
		addMix(Plum, OliveDrab, Tan, 60);
		addMix(Plum, Orange, SandyBrown, 75);
		addMix(Plum, PaleGreen, DarkSeaGreen, 55);
		addMix(Plum, PaleTurquoise, Lavender, 90);
		addMix(Plum, PaleVioletRed, HotPink, 110);
		addMix(Plum, Peru, RosyBrown, 85);
		addMix(Plum, Pink, Thistle, 110);
		addMix(Purple, Aquamarine, MediumPurple, 50);
		addMix(Purple, Black, Indigo, 95);
		addMix(Purple, Blue, Indigo, 105);
		addMix(Purple, Brown, MediumVioletRed, 95);
		addMix(Purple, CadetBlue, DarkSlateBlue, 80);
		addMix(Purple, Chocolate, Brown, 75);
		addMix(Purple, Coral, MediumVioletRed, 70);
		addMix(Purple, Crimson, MediumVioletRed, 95);
		addMix(Purple, Cyan, SteelBlue, 50);
		addMix(Purple, DarkGoldenrod, Brown, 60);
		addMix(Purple, DarkGray, MediumVioletRed, 80);
		addMix(Purple, DarkOrange, Crimson, 60);
		addMix(Purple, DarkSalmon, MediumVioletRed, 75);
		addMix(Purple, DarkSlateBlue, Indigo, 110);
		addMix(Purple, DarkSlateGray, Indigo, 105);
		addMix(Purple, DarkTurquoise, RoyalBlue, 60);
		addMix(Purple, DarkViolet, Indigo, 115);
		addMix(Purple, DeepPink, MediumVioletRed, 100);
		addMix(Purple, DeepSkyBlue, RoyalBlue, 60);
		addMix(Purple, DodgerBlue, SlateBlue, 80);
		addMix(Purple, Goldenrod, IndianRed, 50);
		addMix(Purple, HotPink, MediumVioletRed, 90);
		addMix(Purple, IndianRed, MediumVioletRed, 90);
		addMix(Purple, Lavender, MediumOrchid, 65);
		addMix(Purple, LemonChiffon, PaleVioletRed, 50);
		addMix(Purple, LightGray, MediumOrchid, 70);
		addMix(Purple, LightSeaGreen, DarkSlateBlue, 65);
		addMix(Purple, LightSteelBlue, MediumOrchid, 70);
		addMix(Purple, Magenta, DarkViolet, 95);
		addMix(Purple, MediumAquamarine, SlateBlue, 60);
		addMix(Purple, MediumOrchid, DarkViolet, 105);
		addMix(Purple, MediumPurple, DarkViolet, 100);
		addMix(Purple, MistyRose, PaleVioletRed, 65);
		addMix(Purple, Navy, Indigo, 110);
		addMix(Purple, Olive, Brown, 55);
		addMix(Purple, Orange, IndianRed, 50);
		addMix(Purple, PaleTurquoise, MediumPurple, 65);
		addMix(Purple, PaleVioletRed, MediumVioletRed, 95);
		addMix(Purple, Peru, MediumVioletRed, 70);
		addMix(Purple, Pink, MediumOrchid, 70);
		addMix(Purple, Plum, MediumOrchid, 80);
		addMix(Red, Aquamarine, DarkSalmon, 50);
		addMix(Red, Black, Maroon, 75);
		addMix(Red, Blue, Magenta, 70);
		addMix(Red, Brown, Crimson, 110);
		addMix(Red, CadetBlue, IndianRed, 75);
		addMix(Red, Crimson, IndianRed, 115);
		addMix(Red, DarkGoldenrod, Chocolate, 90);
		addMix(Red, DarkGray, IndianRed, 90);
		addMix(Red, DarkGreen, Maroon, 55);
		addMix(Red, DarkKhaki, Chocolate, 80);
		addMix(Red, DarkOliveGreen, Brown, 70);
		addMix(Red, DarkOrange, Coral, 100);
		addMix(Red, DarkSalmon, IndianRed, 105);
		addMix(Red, DarkSeaGreen, IndianRed, 65);
		addMix(Red, DarkSlateBlue, Brown, 80);
		addMix(Red, DarkSlateGray, Brown, 75);
		addMix(Red, DarkTurquoise, DimGray, 60);
		addMix(Red, DarkViolet, MediumVioletRed, 80);
		addMix(Red, DeepPink, Crimson, 95);
		addMix(Red, DeepSkyBlue, Plum, 60);
		addMix(Red, DimGray, Brown, 95);
		addMix(Red, DodgerBlue, MediumVioletRed, 75);
		addMix(Red, Gold, Chocolate, 75);
		addMix(Red, Goldenrod, Chocolate, 85);
		addMix(Red, Gray, Crimson, 95);
		addMix(Red, Green, Sienna, 50);
		addMix(Red, HotPink, IndianRed, 95);
		addMix(Red, IndianRed, Crimson, 110);
		addMix(Red, Indigo, Brown, 75);
		addMix(Red, Khaki, Coral, 75);
		addMix(Red, Lavender, Salmon, 80);
		addMix(Red, LemonChiffon, Salmon, 75);
		addMix(Red, LightGray, IndianRed, 85);
		addMix(Red, LightSeaGreen, Sienna, 60);
		addMix(Red, LightSteelBlue, IndianRed, 80);
		addMix(Red, Magenta, DeepPink, 85);
		addMix(Red, Maroon, Brown, 100);
		addMix(Red, MediumAquamarine, IndianRed, 60);
		addMix(Red, MediumOrchid, DeepPink, 85);
		addMix(Red, MediumPurple, MediumVioletRed, 80);
		addMix(Red, MediumSeaGreen, Sienna, 55);
		addMix(Red, MediumVioletRed, Crimson, 95);
		addMix(Red, MistyRose, Salmon, 85);
		addMix(Red, Olive, Sienna, 75);
		addMix(Red, OliveDrab, Sienna, 65);
		addMix(Red, Orange, Coral, 90);
		addMix(Red, PaleGreen, Peru, 50);
		addMix(Red, PaleTurquoise, IndianRed, 65);
		addMix(Red, PaleVioletRed, Crimson, 100);
		addMix(Red, Peru, Chocolate, 105);
		addMix(Red, Pink, Salmon, 90);
		addMix(Red, Plum, IndianRed, 85);
		addMix(Red, Purple, Crimson, 80);
		addMix(RosyBrown, Aquamarine, DarkSeaGreen, 75);
		addMix(RosyBrown, Blue, SlateBlue, 80);
		addMix(RosyBrown, Brown, IndianRed, 95);
		addMix(RosyBrown, CadetBlue, DarkGray, 90);
		addMix(RosyBrown, Chocolate, Peru, 105);
		addMix(RosyBrown, Coral, DarkSalmon, 105);
		addMix(RosyBrown, Crimson, IndianRed, 100);
		addMix(RosyBrown, Cyan, DarkTurquoise, 75);
		addMix(RosyBrown, DarkGoldenrod, Peru, 95);
		addMix(RosyBrown, DarkGreen, DarkOliveGreen, 75);
		addMix(RosyBrown, DarkKhaki, Tan, 95);
		addMix(RosyBrown, DarkOrange, Peru, 100);
		addMix(RosyBrown, DarkSalmon, Salmon, 115);
		addMix(RosyBrown, DarkSeaGreen, DarkGray, 85);
		addMix(RosyBrown, DarkSlateGray, DimGray, 80);
		addMix(RosyBrown, DarkTurquoise, CadetBlue, 80);
		addMix(RosyBrown, DarkViolet, MediumOrchid, 85);
		addMix(RosyBrown, DeepPink, PaleVioletRed, 105);
		addMix(RosyBrown, DeepSkyBlue, SkyBlue, 85);
		addMix(RosyBrown, DimGray, Gray, 100);
		addMix(RosyBrown, DodgerBlue, SteelBlue, 90);
		addMix(RosyBrown, Gold, Goldenrod, 85);
		addMix(RosyBrown, Goldenrod, Peru, 95);
		addMix(RosyBrown, Green, OliveDrab, 75);
		addMix(RosyBrown, HotPink, PaleVioletRed, 105);
		addMix(RosyBrown, IndianRed, PaleVioletRed, 110);
		addMix(RosyBrown, Indigo, Purple, 80);
		addMix(RosyBrown, Khaki, Tan, 90);
		addMix(RosyBrown, Lavender, Thistle, 100);
		addMix(RosyBrown, LemonChiffon, Tan, 90);
		addMix(RosyBrown, LightGray, DarkGray, 105);
		addMix(RosyBrown, LightSeaGreen, CadetBlue, 85);
		addMix(RosyBrown, LightSteelBlue, Thistle, 100);
		addMix(RosyBrown, Lime, LimeGreen, 65);
		addMix(RosyBrown, LimeGreen, DarkSeaGreen, 75);
		addMix(RosyBrown, Magenta, MediumOrchid, 95);
		addMix(RosyBrown, Maroon, Brown, 85);
		addMix(RosyBrown, MediumAquamarine, DarkSeaGreen, 80);
		addMix(RosyBrown, MediumOrchid, PaleVioletRed, 100);
		addMix(RosyBrown, MediumPurple, Plum, 100);
		addMix(RosyBrown, MediumSeaGreen, DarkSeaGreen, 80);
		addMix(RosyBrown, MediumVioletRed, DeepPink, 100);
		addMix(RosyBrown, MistyRose, Pink, 105);
		addMix(RosyBrown, Navy, DarkSlateBlue, 75);
		addMix(RosyBrown, Olive, DarkGoldenrod, 90);
		addMix(RosyBrown, OliveDrab, Olive, 85);
		addMix(RosyBrown, Orange, SandyBrown, 95);
		addMix(RosyBrown, PaleGreen, DarkSeaGreen, 75);
		addMix(RosyBrown, PaleTurquoise, DarkGray, 85);
		addMix(RosyBrown, PaleVioletRed, HotPink, 115);
		addMix(RosyBrown, Peru, DarkSalmon, 105);
		addMix(RosyBrown, Pink, Thistle, 110);
		addMix(RosyBrown, Plum, Thistle, 105);
		addMix(RosyBrown, Purple, MediumVioletRed, 85);
		addMix(RosyBrown, Red, IndianRed, 100);
		addMix(RoyalBlue, Aquamarine, DeepSkyBlue, 70);
		addMix(RoyalBlue, Black, DarkSlateBlue, 80);
		addMix(RoyalBlue, Blue, SlateBlue, 105);
		addMix(RoyalBlue, Brown, DarkSlateBlue, 85);
		addMix(RoyalBlue, CadetBlue, SteelBlue, 95);
		addMix(RoyalBlue, Crimson, Purple, 85);
		addMix(RoyalBlue, Cyan, DeepSkyBlue, 75);
		addMix(RoyalBlue, DarkGoldenrod, Gray, 65);
		addMix(RoyalBlue, DarkGray, SteelBlue, 95);
		addMix(RoyalBlue, DarkGreen, DarkSlateGray, 70);
		addMix(RoyalBlue, DarkKhaki, SlateGray, 60);
		addMix(RoyalBlue, DarkOliveGreen, SteelBlue, 70);
		addMix(RoyalBlue, DarkOrange, RosyBrown, 65);
		addMix(RoyalBlue, DarkSalmon, MediumPurple, 80);
		addMix(RoyalBlue, DarkSeaGreen, SteelBlue, 75);
		addMix(RoyalBlue, DarkSlateBlue, SlateBlue, 110);
		addMix(RoyalBlue, DarkSlateGray, SlateBlue, 95);
		addMix(RoyalBlue, DarkTurquoise, DodgerBlue, 85);
		addMix(RoyalBlue, DarkViolet, Blue, 105);
		addMix(RoyalBlue, DeepPink, DarkViolet, 90);
		addMix(RoyalBlue, DeepSkyBlue, DodgerBlue, 95);
		addMix(RoyalBlue, DimGray, SlateBlue, 100);
		addMix(RoyalBlue, DodgerBlue, SteelBlue, 110);
		addMix(RoyalBlue, Gold, DarkKhaki, 50);
		addMix(RoyalBlue, Goldenrod, Gray, 60);
		addMix(RoyalBlue, Gray, SteelBlue, 100);
		addMix(RoyalBlue, Green, Teal, 65);
		addMix(RoyalBlue, HotPink, MediumPurple, 90);
		addMix(RoyalBlue, IndianRed, MediumPurple, 85);
		addMix(RoyalBlue, Indigo, DarkSlateBlue, 100);
		addMix(RoyalBlue, Khaki, DarkGray, 55);
		addMix(RoyalBlue, Lavender, LightSteelBlue, 85);
		addMix(RoyalBlue, LemonChiffon, LightSteelBlue, 65);
		addMix(RoyalBlue, LightGray, LightSteelBlue, 85);
		addMix(RoyalBlue, LightSeaGreen, SteelBlue, 85);
		addMix(RoyalBlue, LightSteelBlue, DodgerBlue, 100);
		addMix(RoyalBlue, Lime, MediumSeaGreen, 55);
		addMix(RoyalBlue, LimeGreen, LightSeaGreen, 60);
		addMix(RoyalBlue, Magenta, DarkViolet, 95);
		addMix(RoyalBlue, Maroon, Purple, 80);
		addMix(RoyalBlue, MediumAquamarine, DodgerBlue, 80);
		addMix(RoyalBlue, MediumOrchid, SlateBlue, 105);
		addMix(RoyalBlue, MediumPurple, SlateBlue, 115);
		addMix(RoyalBlue, MediumSeaGreen, SteelBlue, 75);
		addMix(RoyalBlue, MediumVioletRed, DarkViolet, 95);
		addMix(RoyalBlue, MistyRose, LightSteelBlue, 80);
		addMix(RoyalBlue, Navy, DarkSlateBlue, 95);
		addMix(RoyalBlue, Olive, DimGray, 60);
		addMix(RoyalBlue, OliveDrab, SlateGray, 65);
		addMix(RoyalBlue, PaleGreen, CadetBlue, 60);
		addMix(RoyalBlue, PaleTurquoise, DodgerBlue, 80);
		addMix(RoyalBlue, PaleVioletRed, MediumPurple, 90);
		addMix(RoyalBlue, Pink, MediumPurple, 85);
		addMix(RoyalBlue, Plum, MediumPurple, 95);
		addMix(RoyalBlue, Purple, DarkSlateBlue, 95);
		addMix(RoyalBlue, Red, MediumVioletRed, 75);
		addMix(RoyalBlue, RosyBrown, MediumPurple, 90);
		addMix(Salmon, Aquamarine, DarkKhaki, 60);
		addMix(Salmon, Black, Brown, 65);
		addMix(Salmon, Blue, DarkViolet, 70);
		addMix(Salmon, Brown, IndianRed, 95);
		addMix(Salmon, CadetBlue, RosyBrown, 80);
		addMix(Salmon, Chocolate, Coral, 110);
		addMix(Salmon, Coral, DarkSalmon, 120);
		addMix(Salmon, Crimson, IndianRed, 105);
		addMix(Salmon, Cyan, LightSeaGreen, 65);
		addMix(Salmon, DarkGoldenrod, Peru, 95);
		addMix(Salmon, DarkGray, RosyBrown, 100);
		addMix(Salmon, DarkGreen, Olive, 60);
		addMix(Salmon, DarkKhaki, SandyBrown, 90);
		addMix(Salmon, DarkOliveGreen, Peru, 75);
		addMix(Salmon, DarkOrange, Coral, 105);
		addMix(Salmon, DarkSalmon, Coral, 120);
		addMix(Salmon, DarkSeaGreen, Tan, 75);
		addMix(Salmon, DarkSlateBlue, MediumVioletRed, 75);
		addMix(Salmon, DarkTurquoise, CadetBlue, 70);
		addMix(Salmon, DarkViolet, MediumVioletRed, 80);
		addMix(Salmon, DeepPink, PaleVioletRed, 105);
		addMix(Salmon, DeepSkyBlue, SlateGray, 70);
		addMix(Salmon, DimGray, IndianRed, 95);
		addMix(Salmon, DodgerBlue, MediumPurple, 80);
		addMix(Salmon, Gold, Orange, 80);
		addMix(Salmon, Goldenrod, SandyBrown, 95);
		addMix(Salmon, Gray, RosyBrown, 100);
		addMix(Salmon, Green, Olive, 60);
		addMix(Salmon, HotPink, PaleVioletRed, 105);
		addMix(Salmon, IndianRed, DarkSalmon, 115);
		addMix(Salmon, Indigo, MediumVioletRed, 70);
		addMix(Salmon, Khaki, SandyBrown, 85);
		addMix(Salmon, Lavender, Pink, 95);
		addMix(Salmon, LemonChiffon, DarkSalmon, 85);
		addMix(Salmon, LightGray, DarkSalmon, 100);
		addMix(Salmon, LightSeaGreen, DarkGray, 70);
		addMix(Salmon, LightSteelBlue, RosyBrown, 90);
		addMix(Salmon, Lime, YellowGreen, 50);
		addMix(Salmon, LimeGreen, DarkKhaki, 55);
		addMix(Salmon, Magenta, HotPink, 90);
		addMix(Salmon, Maroon, Crimson, 85);
		addMix(Salmon, MediumAquamarine, Tan, 70);
		addMix(Salmon, MediumOrchid, PaleVioletRed, 90);
		addMix(Salmon, MediumPurple, PaleVioletRed, 90);
		addMix(Salmon, MediumSeaGreen, DarkKhaki, 65);
		addMix(Salmon, MediumVioletRed, DeepPink, 95);
		addMix(Salmon, MistyRose, Pink, 100);
		addMix(Salmon, Navy, Purple, 65);
		addMix(Salmon, Olive, Peru, 80);
		addMix(Salmon, OliveDrab, Peru, 75);
		addMix(Salmon, Orange, DarkOrange, 95);
		addMix(Salmon, PaleGreen, DarkKhaki, 60);
		addMix(Salmon, PaleTurquoise, MistyRose, 80);
		addMix(Salmon, PaleVioletRed, IndianRed, 110);
		addMix(Salmon, Peru, Coral, 105);
		addMix(Salmon, Pink, DarkSalmon, 110);
		addMix(Salmon, Plum, PaleVioletRed, 100);
		addMix(Salmon, Purple, MediumVioletRed, 80);
		addMix(Salmon, Red, IndianRed, 110);
		addMix(Salmon, RosyBrown, DarkSalmon, 110);
		addMix(Salmon, RoyalBlue, MediumPurple, 80);
		addMix(SandyBrown, Aquamarine, DarkSeaGreen, 80);
		addMix(SandyBrown, Black, Sienna, 60);
		addMix(SandyBrown, Blue, SlateBlue, 55);
		addMix(SandyBrown, Brown, Chocolate, 85);
		addMix(SandyBrown, CadetBlue, Tan, 85);
		addMix(SandyBrown, Chocolate, Peru, 110);
		addMix(SandyBrown, Coral, DarkSalmon, 115);
		addMix(SandyBrown, Crimson, IndianRed, 90);
		addMix(SandyBrown, Cyan, MediumAquamarine, 75);
		addMix(SandyBrown, DarkGoldenrod, Peru, 110);
		addMix(SandyBrown, DarkGray, Tan, 100);
		addMix(SandyBrown, DarkGreen, Olive, 70);
		addMix(SandyBrown, DarkKhaki, Tan, 105);
		addMix(SandyBrown, DarkOliveGreen, DarkGoldenrod, 85);
		addMix(SandyBrown, DarkOrange, Orange, 120);
		addMix(SandyBrown, DarkSalmon, Coral, 115);
		addMix(SandyBrown, DarkSeaGreen, DarkKhaki, 90);
		addMix(SandyBrown, DarkSlateBlue, RosyBrown, 65);
		addMix(SandyBrown, DarkTurquoise, DarkSeaGreen, 80);
		addMix(SandyBrown, DarkViolet, MediumVioletRed, 65);
		addMix(SandyBrown, DeepPink, PaleVioletRed, 80);
		addMix(SandyBrown, DeepSkyBlue, CadetBlue, 75);
		addMix(SandyBrown, DimGray, Peru, 90);
		addMix(SandyBrown, DodgerBlue, SlateGray, 75);
		addMix(SandyBrown, Gold, Goldenrod, 105);
		addMix(SandyBrown, Goldenrod, Orange, 115);
		addMix(SandyBrown, Gray, Peru, 95);
		addMix(SandyBrown, Green, OliveDrab, 75);
		addMix(SandyBrown, HotPink, Salmon, 85);
		addMix(SandyBrown, IndianRed, Coral, 100);
		addMix(SandyBrown, Indigo, MediumVioletRed, 55);
		addMix(SandyBrown, Khaki, Tan, 100);
		addMix(SandyBrown, Lavender, Tan, 95);
		addMix(SandyBrown, LemonChiffon, Wheat, 100);
		addMix(SandyBrown, LightGray, Tan, 100);
		addMix(SandyBrown, LightSeaGreen, DarkSeaGreen, 80);
		addMix(SandyBrown, LightSteelBlue, Tan, 90);
		addMix(SandyBrown, Lime, YellowGreen, 75);
		addMix(SandyBrown, LimeGreen, YellowGreen, 80);
		addMix(SandyBrown, Magenta, HotPink, 70);
		addMix(SandyBrown, Maroon, Sienna, 75);
		addMix(SandyBrown, MediumAquamarine, DarkKhaki, 85);
		addMix(SandyBrown, MediumOrchid, PaleVioletRed, 75);
		addMix(SandyBrown, MediumPurple, RosyBrown, 75);
		addMix(SandyBrown, MediumSeaGreen, DarkKhaki, 80);
		addMix(SandyBrown, MediumVioletRed, IndianRed, 75);
		addMix(SandyBrown, MistyRose, Tan, 105);
		addMix(SandyBrown, Olive, DarkGoldenrod, 95);
		addMix(SandyBrown, OliveDrab, DarkGoldenrod, 90);
		addMix(SandyBrown, Orange, DarkOrange, 115);
		addMix(SandyBrown, PaleGreen, DarkKhaki, 80);
		addMix(SandyBrown, PaleTurquoise, Wheat, 85);
		addMix(SandyBrown, PaleVioletRed, Salmon, 90);
		addMix(SandyBrown, Peru, DarkOrange, 115);
		addMix(SandyBrown, Pink, DarkSalmon, 100);
		addMix(SandyBrown, Plum, DarkSalmon, 85);
		addMix(SandyBrown, Purple, PaleVioletRed, 60);
		addMix(SandyBrown, Red, Coral, 100);
		addMix(SandyBrown, RosyBrown, DarkSalmon, 105);
		addMix(SandyBrown, Salmon, DarkSalmon, 105);
		addMix(SeaGreen, Aquamarine, MediumAquamarine, 95);
		addMix(SeaGreen, Blue, DarkSlateBlue, 70);
		addMix(SeaGreen, CadetBlue, LightSeaGreen, 105);
		addMix(SeaGreen, Chocolate, Olive, 75);
		addMix(SeaGreen, Coral, Olive, 70);
		addMix(SeaGreen, Crimson, Brown, 55);
		addMix(SeaGreen, Cyan, MediumAquamarine, 90);
		addMix(SeaGreen, DarkGoldenrod, OliveDrab, 90);
		addMix(SeaGreen, DarkGray, CadetBlue, 100);
		addMix(SeaGreen, DarkGreen, Green, 110);
		addMix(SeaGreen, DarkKhaki, DarkSeaGreen, 100);
		addMix(SeaGreen, DarkOliveGreen, Green, 110);
		addMix(SeaGreen, DarkOrange, Olive, 75);
		addMix(SeaGreen, DarkSeaGreen, MediumSeaGreen, 110);
		addMix(SeaGreen, DarkSlateBlue, DarkSlateGray, 80);
		addMix(SeaGreen, DarkTurquoise, LightSeaGreen, 100);
		addMix(SeaGreen, DarkViolet, DarkSlateBlue, 75);
		addMix(SeaGreen, DeepPink, MediumVioletRed, 45);
		addMix(SeaGreen, DeepSkyBlue, CadetBlue, 85);
		addMix(SeaGreen, DimGray, Teal, 100);
		addMix(SeaGreen, DodgerBlue, SteelBlue, 80);
		addMix(SeaGreen, Gold, YellowGreen, 85);
		addMix(SeaGreen, Goldenrod, OliveDrab, 90);
		addMix(SeaGreen, Green, DarkGreen, 115);
		addMix(SeaGreen, HotPink, RosyBrown, 50);
		addMix(SeaGreen, IndianRed, DimGray, 65);
		addMix(SeaGreen, Indigo, DarkSlateBlue, 70);
		addMix(SeaGreen, Khaki, DarkSeaGreen, 90);
		addMix(SeaGreen, Lavender, MediumAquamarine, 85);
		addMix(SeaGreen, LemonChiffon, DarkSeaGreen, 85);
		addMix(SeaGreen, LightGray, DarkSeaGreen, 90);
		addMix(SeaGreen, LightSeaGreen, MediumSeaGreen, 105);
		addMix(SeaGreen, LightSteelBlue, CadetBlue, 90);
		addMix(SeaGreen, Lime, LimeGreen, 95);
		addMix(SeaGreen, LimeGreen, MediumSeaGreen, 105);
		addMix(SeaGreen, Magenta, DarkViolet, 75);
		addMix(SeaGreen, MediumAquamarine, MediumSeaGreen, 105);
		addMix(SeaGreen, MediumPurple, SlateGray, 80);
		addMix(SeaGreen, MistyRose, DarkSeaGreen, 80);
		addMix(SeaGreen, Navy, DarkSlateBlue, 70);
		addMix(SeaGreen, Olive, OliveDrab, 105);
		addMix(SeaGreen, OliveDrab, Green, 110);
		addMix(SeaGreen, Orange, Olive, 80);
		addMix(SeaGreen, PaleGreen, MediumSeaGreen, 95);
		addMix(SeaGreen, PaleTurquoise, MediumAquamarine, 90);
		addMix(SeaGreen, PaleVioletRed, Gray, 60);
		addMix(SeaGreen, Peru, OliveDrab, 85);
		addMix(SeaGreen, Pink, DarkSeaGreen, 70);
		addMix(SeaGreen, Plum, SlateGray, 80);
		addMix(SeaGreen, Purple, DarkSlateBlue, 75);
		addMix(SeaGreen, Red, Sienna, 60);
		addMix(SeaGreen, RoyalBlue, SteelBlue, 80);
		addMix(SeaGreen, SandyBrown, OliveDrab, 80);
		addMix(Sienna, Aquamarine, DarkSeaGreen, 60);
		addMix(Sienna, Blue, DarkSlateBlue, 75);
		addMix(Sienna, Brown, Maroon, 115);
		addMix(Sienna, CadetBlue, Gray, 85);
		addMix(Sienna, Coral, Chocolate, 105);
		addMix(Sienna, Crimson, Brown, 110);
		addMix(Sienna, Cyan, LightSeaGreen, 60);
		addMix(Sienna, DarkGoldenrod, Peru, 100);
		addMix(Sienna, DarkGray, RosyBrown, 95);
		addMix(Sienna, DarkGreen, DarkOliveGreen, 80);
		addMix(Sienna, DarkKhaki, Peru, 90);
		addMix(Sienna, DarkOrange, Chocolate, 100);
		addMix(Sienna, DarkSalmon, Chocolate, 100);
		addMix(Sienna, DarkTurquoise, CadetBlue, 70);
		addMix(Sienna, DarkViolet, Purple, 80);
		addMix(Sienna, DeepPink, Crimson, 90);
		addMix(Sienna, DeepSkyBlue, CadetBlue, 70);
		addMix(Sienna, DodgerBlue, SlateGray, 75);
		addMix(Sienna, Gold, Goldenrod, 80);
		addMix(Sienna, Goldenrod, Peru, 95);
		addMix(Sienna, Green, DarkOliveGreen, 75);
		addMix(Sienna, HotPink, IndianRed, 90);
		addMix(Sienna, IndianRed, Brown, 110);
		addMix(Sienna, Indigo, Purple, 80);
		addMix(Sienna, Khaki, Tan, 80);
		addMix(Sienna, Lavender, RosyBrown, 80);
		addMix(Sienna, LemonChiffon, Tan, 75);
		addMix(Sienna, LightGray, RosyBrown, 85);
		addMix(Sienna, LightSeaGreen, SeaGreen, 75);
		addMix(Sienna, LightSteelBlue, RosyBrown, 80);
		addMix(Sienna, Lime, OliveDrab, 55);
		addMix(Sienna, LimeGreen, OliveDrab, 65);
		addMix(Sienna, Magenta, MediumVioletRed, 80);
		addMix(Sienna, Maroon, Brown, 110);
		addMix(Sienna, MediumOrchid, MediumVioletRed, 85);
		addMix(Sienna, MediumSeaGreen, DarkOliveGreen, 70);
		addMix(Sienna, MediumVioletRed, Crimson, 95);
		addMix(Sienna, MistyRose, DarkSalmon, 85);
		addMix(Sienna, Navy, Purple, 75);
		addMix(Sienna, Olive, DarkGoldenrod, 95);
		addMix(Sienna, OliveDrab, Olive, 85);
		addMix(Sienna, Orange, Peru, 95);
		addMix(Sienna, PaleGreen, DarkKhaki, 65);
		addMix(Sienna, PaleTurquoise, DarkGray, 70);
		addMix(Sienna, PaleVioletRed, IndianRed, 95);
		addMix(Sienna, Peru, Chocolate, 105);
		addMix(Sienna, Pink, DarkSalmon, 90);
		addMix(Sienna, Plum, PaleVioletRed, 85);
		addMix(Sienna, Purple, MediumVioletRed, 85);
		addMix(Sienna, Red, Crimson, 110);
		addMix(Sienna, RosyBrown, IndianRed, 100);
		addMix(Sienna, Salmon, IndianRed, 100);
		addMix(Sienna, SandyBrown, Peru, 100);
		addMix(Sienna, SeaGreen, DarkOliveGreen, 80);
		addMix(SkyBlue, Aquamarine, Turquoise, 100);
		addMix(SkyBlue, Black, DarkSlateGray, 55);
		addMix(SkyBlue, Blue, RoyalBlue, 75);
		addMix(SkyBlue, Brown, RosyBrown, 60);
		addMix(SkyBlue, CadetBlue, DarkTurquoise, 110);
		addMix(SkyBlue, Chocolate, Tan, 75);
		addMix(SkyBlue, Coral, RosyBrown, 75);
		addMix(SkyBlue, Crimson, PaleVioletRed, 60);
		addMix(SkyBlue, Cyan, DarkTurquoise, 110);
		addMix(SkyBlue, DarkGoldenrod, DarkSeaGreen, 80);
		addMix(SkyBlue, DarkGray, LightSteelBlue, 105);
		addMix(SkyBlue, DarkGreen, SeaGreen, 70);
		addMix(SkyBlue, DarkKhaki, DarkSeaGreen, 85);
		addMix(SkyBlue, DarkOliveGreen, CadetBlue, 80);
		addMix(SkyBlue, DarkOrange, Tan, 80);
		addMix(SkyBlue, DarkSalmon, DarkGray, 80);
		addMix(SkyBlue, DarkSeaGreen, MediumAquamarine, 95);
		addMix(SkyBlue, DarkSlateBlue, SteelBlue, 75);
		addMix(SkyBlue, DarkSlateGray, CadetBlue, 80);
		addMix(SkyBlue, DarkTurquoise, Turquoise, 115);
		addMix(SkyBlue, DarkViolet, MediumPurple, 80);
		addMix(SkyBlue, DeepPink, MediumOrchid, 65);
		addMix(SkyBlue, DimGray, CadetBlue, 90);
		addMix(SkyBlue, DodgerBlue, DeepSkyBlue, 105);
		addMix(SkyBlue, Gold, DarkKhaki, 75);
		addMix(SkyBlue, Goldenrod, DarkKhaki, 80);
		addMix(SkyBlue, Gray, CadetBlue, 100);
		addMix(SkyBlue, Green, MediumSeaGreen, 75);
		addMix(SkyBlue, HotPink, Plum, 75);
		addMix(SkyBlue, IndianRed, RosyBrown, 70);
		addMix(SkyBlue, Indigo, SlateBlue, 60);
		addMix(SkyBlue, Khaki, DarkSeaGreen, 85);
		addMix(SkyBlue, Lavender, LightSteelBlue, 105);
		addMix(SkyBlue, LemonChiffon, PaleTurquoise, 95);
		addMix(SkyBlue, LightGray, LightSteelBlue, 110);
		addMix(SkyBlue, LightSeaGreen, DarkTurquoise, 110);
		addMix(SkyBlue, LightSteelBlue, DeepSkyBlue, 115);
		addMix(SkyBlue, Lime, SpringGreen, 80);
		addMix(SkyBlue, LimeGreen, MediumAquamarine, 80);
		addMix(SkyBlue, Magenta, MediumOrchid, 85);
		addMix(SkyBlue, MediumAquamarine, DarkTurquoise, 100);
		addMix(SkyBlue, MediumOrchid, MediumPurple, 90);
		addMix(SkyBlue, MediumPurple, LightSteelBlue, 95);
		addMix(SkyBlue, MediumSeaGreen, MediumAquamarine, 90);
		addMix(SkyBlue, MediumVioletRed, MediumOrchid, 70);
		addMix(SkyBlue, MistyRose, LightSteelBlue, 90);
		addMix(SkyBlue, Navy, RoyalBlue, 55);
		addMix(SkyBlue, Olive, DarkSeaGreen, 75);
		addMix(SkyBlue, OliveDrab, DarkSeaGreen, 80);
		addMix(SkyBlue, Orange, DarkKhaki, 80);
		addMix(SkyBlue, PaleGreen, MediumAquamarine, 85);
		addMix(SkyBlue, PaleTurquoise, DarkTurquoise, 115);
		addMix(SkyBlue, PaleVioletRed, Thistle, 75);
		addMix(SkyBlue, Peru, DarkGray, 80);
		addMix(SkyBlue, Pink, LightSteelBlue, 85);
		addMix(SkyBlue, Plum, LightSteelBlue, 90);
		addMix(SkyBlue, Purple, MediumPurple, 65);
		addMix(SkyBlue, Red, IndianRed, 65);
		addMix(SkyBlue, RosyBrown, LightSteelBlue, 85);
		addMix(SkyBlue, RoyalBlue, DodgerBlue, 95);
		addMix(SkyBlue, Salmon, RosyBrown, 75);
		addMix(SkyBlue, SandyBrown, DarkGray, 85);
		addMix(SkyBlue, SeaGreen, LightSeaGreen, 90);
		addMix(SkyBlue, Sienna, Gray, 70);
		addMix(SlateBlue, Aquamarine, DeepSkyBlue, 70);
		addMix(SlateBlue, Black, DarkSlateBlue, 85);
		addMix(SlateBlue, Blue, DarkViolet, 110);
		addMix(SlateBlue, Brown, Purple, 90);
		addMix(SlateBlue, CadetBlue, SteelBlue, 95);
		addMix(SlateBlue, Coral, PaleVioletRed, 75);
		addMix(SlateBlue, Crimson, MediumVioletRed, 90);
		addMix(SlateBlue, Cyan, DeepSkyBlue, 70);
		addMix(SlateBlue, DarkGoldenrod, RosyBrown, 65);
		addMix(SlateBlue, DarkGray, MediumPurple, 90);
		addMix(SlateBlue, DarkGreen, DarkSlateGray, 70);
		addMix(SlateBlue, DarkKhaki, Gray, 60);
		addMix(SlateBlue, DarkOrange, IndianRed, 65);
		addMix(SlateBlue, DarkSalmon, PaleVioletRed, 80);
		addMix(SlateBlue, DarkSeaGreen, SlateGray, 75);
		addMix(SlateBlue, DarkSlateGray, DarkSlateBlue, 100);
		addMix(SlateBlue, DarkTurquoise, DodgerBlue, 80);
		addMix(SlateBlue, DarkViolet, Blue, 115);
		addMix(SlateBlue, DeepPink, MediumOrchid, 95);
		addMix(SlateBlue, DeepSkyBlue, DodgerBlue, 90);
		addMix(SlateBlue, DimGray, DarkSlateBlue, 100);
		addMix(SlateBlue, DodgerBlue, RoyalBlue, 105);
		addMix(SlateBlue, Gold, Tan, 50);
		addMix(SlateBlue, Goldenrod, RosyBrown, 60);
		addMix(SlateBlue, Gray, MediumPurple, 100);
		addMix(SlateBlue, Green, Teal, 70);
		addMix(SlateBlue, HotPink, MediumOrchid, 95);
		addMix(SlateBlue, IndianRed, MediumOrchid, 90);
		addMix(SlateBlue, Indigo, DarkSlateBlue, 105);
		addMix(SlateBlue, Khaki, DarkGray, 55);
		addMix(SlateBlue, Lavender, LightSteelBlue, 85);
		addMix(SlateBlue, LemonChiffon, Thistle, 60);
		addMix(SlateBlue, LightGray, MediumPurple, 85);
		addMix(SlateBlue, LightSeaGreen, SteelBlue, 85);
		addMix(SlateBlue, LightSteelBlue, MediumPurple, 95);
		addMix(SlateBlue, Lime, MediumSeaGreen, 55);
		addMix(SlateBlue, LimeGreen, CadetBlue, 60);
		addMix(SlateBlue, Magenta, MediumOrchid, 100);
		addMix(SlateBlue, Maroon, Purple, 80);
		addMix(SlateBlue, MediumAquamarine, SteelBlue, 75);
		addMix(SlateBlue, MediumOrchid, MediumPurple, 110);
		addMix(SlateBlue, MediumPurple, RoyalBlue, 115);
		addMix(SlateBlue, MediumSeaGreen, SteelBlue, 75);
		addMix(SlateBlue, MediumVioletRed, DarkViolet, 100);
		addMix(SlateBlue, MistyRose, Plum, 80);
		addMix(SlateBlue, Navy, DarkSlateBlue, 100);
		addMix(SlateBlue, Olive, DimGray, 60);
		addMix(SlateBlue, OliveDrab, DimGray, 55);
		addMix(SlateBlue, Orange, DarkSalmon, 60);
		addMix(SlateBlue, PaleGreen, CadetBlue, 60);
		addMix(SlateBlue, PaleTurquoise, LightSteelBlue, 80);
		addMix(SlateBlue, PaleVioletRed, MediumOrchid, 95);
		addMix(SlateBlue, Pink, Plum, 85);
		addMix(SlateBlue, Plum, MediumPurple, 95);
		addMix(SlateBlue, Purple, DarkViolet, 105);
		addMix(SlateBlue, Red, MediumVioletRed, 80);
		addMix(SlateBlue, RosyBrown, MediumPurple, 90);
		addMix(SlateBlue, RoyalBlue, MediumPurple, 120);
		addMix(SlateBlue, Salmon, PaleVioletRed, 85);
		addMix(SlateBlue, SandyBrown, RosyBrown, 70);
		addMix(SlateBlue, SeaGreen, SteelBlue, 80);
		addMix(SlateBlue, SkyBlue, DodgerBlue, 90);
		addMix(SlateGray, Aquamarine, MediumAquamarine, 85);
		addMix(SlateGray, Black, DarkSlateGray, 85);
		addMix(SlateGray, Blue, DarkSlateBlue, 100);
		addMix(SlateGray, Chocolate, Sienna, 90);
		addMix(SlateGray, Coral, RosyBrown, 90);
		addMix(SlateGray, Crimson, MediumVioletRed, 90);
		addMix(SlateGray, Cyan, DarkTurquoise, 90);
		addMix(SlateGray, DarkGoldenrod, Olive, 90);
		addMix(SlateGray, DarkGray, Gray, 110);
		addMix(SlateGray, DarkGreen, SeaGreen, 90);
		addMix(SlateGray, DarkOrange, Peru, 85);
		addMix(SlateGray, DarkSalmon, RosyBrown, 90);
		addMix(SlateGray, DarkSeaGreen, CadetBlue, 95);
		addMix(SlateGray, DarkSlateBlue, SlateBlue, 105);
		addMix(SlateGray, DarkSlateGray, DimGray, 105);
		addMix(SlateGray, DarkTurquoise, CadetBlue, 100);
		addMix(SlateGray, DarkViolet, SlateBlue, 105);
		addMix(SlateGray, DeepPink, MediumVioletRed, 90);
		addMix(SlateGray, DeepSkyBlue, SteelBlue, 105);
		addMix(SlateGray, DimGray, Gray, 115);
		addMix(SlateGray, DodgerBlue, SteelBlue, 110);
		addMix(SlateGray, Gold, DarkKhaki, 75);
		addMix(SlateGray, Goldenrod, DarkGoldenrod, 85);
		addMix(SlateGray, Gray, DimGray, 120);
		addMix(SlateGray, Green, SeaGreen, 90);
		addMix(SlateGray, HotPink, PaleVioletRed, 95);
		addMix(SlateGray, IndianRed, RosyBrown, 95);
		addMix(SlateGray, Indigo, DarkSlateBlue, 95);
		addMix(SlateGray, Khaki, DarkKhaki, 80);
		addMix(SlateGray, Lavender, LightSteelBlue, 95);
		addMix(SlateGray, LemonChiffon, DarkGray, 85);
		addMix(SlateGray, LightGray, DarkGray, 100);
		addMix(SlateGray, LightSeaGreen, CadetBlue, 100);
		addMix(SlateGray, LightSteelBlue, DarkGray, 105);
		addMix(SlateGray, Lime, LimeGreen, 75);
		addMix(SlateGray, LimeGreen, MediumSeaGreen, 85);
		addMix(SlateGray, Magenta, MediumOrchid, 100);
		addMix(SlateGray, MediumAquamarine, CadetBlue, 95);
		addMix(SlateGray, MediumOrchid, MediumPurple, 110);
		addMix(SlateGray, MediumPurple, SlateBlue, 115);
		addMix(SlateGray, MediumSeaGreen, SeaGreen, 95);
		addMix(SlateGray, MistyRose, DarkGray, 90);
		addMix(SlateGray, Navy, DarkSlateBlue, 90);
		addMix(SlateGray, Olive, OliveDrab, 90);
		addMix(SlateGray, OliveDrab, SeaGreen, 90);
		addMix(SlateGray, Orange, DarkGoldenrod, 85);
		addMix(SlateGray, PaleGreen, DarkSeaGreen, 80);
		addMix(SlateGray, PaleTurquoise, SkyBlue, 95);
		addMix(SlateGray, PaleVioletRed, RosyBrown, 95);
		addMix(SlateGray, Pink, RosyBrown, 90);
		addMix(SlateGray, Purple, DarkSlateBlue, 95);
		addMix(SlateGray, Red, Crimson, 85);
		addMix(SlateGray, RosyBrown, Gray, 100);
		addMix(SlateGray, RoyalBlue, SteelBlue, 115);
		addMix(SlateGray, Salmon, RosyBrown, 90);
		addMix(SlateGray, SandyBrown, Tan, 90);
		addMix(SlateGray, SeaGreen, Teal, 100);
		addMix(SlateGray, SkyBlue, CadetBlue, 100);
		addMix(SlateGray, SlateBlue, MediumPurple, 115);
		addMix(SpringGreen, Aquamarine, PaleGreen, 110);
		addMix(SpringGreen, Blue, SteelBlue, 45);
		addMix(SpringGreen, CadetBlue, MediumAquamarine, 90);
		addMix(SpringGreen, Chocolate, LimeGreen, 60);
		addMix(SpringGreen, Coral, DarkSeaGreen, 55);
		addMix(SpringGreen, Cyan, Aquamarine, 100);
		addMix(SpringGreen, DarkGoldenrod, LimeGreen, 80);
		addMix(SpringGreen, DarkGray, MediumAquamarine, 95);
		addMix(SpringGreen, DarkGreen, MediumSeaGreen, 80);
		addMix(SpringGreen, DarkKhaki, LimeGreen, 100);
		addMix(SpringGreen, DarkOliveGreen, MediumSeaGreen, 85);
		addMix(SpringGreen, DarkOrange, YellowGreen, 65);
		addMix(SpringGreen, DarkSalmon, DarkSeaGreen, 65);
		addMix(SpringGreen, DarkSeaGreen, PaleGreen, 105);
		addMix(SpringGreen, DarkSlateBlue, LightSeaGreen, 50);
		addMix(SpringGreen, DarkSlateGray, MediumSeaGreen, 65);
		addMix(SpringGreen, DarkTurquoise, MediumAquamarine, 95);
		addMix(SpringGreen, DarkViolet, SteelBlue, 55);
		addMix(SpringGreen, DeepSkyBlue, Turquoise, 75);
		addMix(SpringGreen, DimGray, MediumSeaGreen, 80);
		addMix(SpringGreen, DodgerBlue, DarkTurquoise, 65);
		addMix(SpringGreen, Gold, Lime, 90);
		addMix(SpringGreen, Goldenrod, LimeGreen, 85);
		addMix(SpringGreen, Gray, MediumSeaGreen, 85);
		addMix(SpringGreen, Green, LimeGreen, 90);
		addMix(SpringGreen, IndianRed, MediumSeaGreen, 45);
		addMix(SpringGreen, Khaki, PaleGreen, 100);
		addMix(SpringGreen, Lavender, Aquamarine, 90);
		addMix(SpringGreen, LemonChiffon, PaleGreen, 100);
		addMix(SpringGreen, LightGray, Aquamarine, 95);
		addMix(SpringGreen, LightSeaGreen, MediumAquamarine, 95);
		addMix(SpringGreen, LightSteelBlue, MediumAquamarine, 85);
		addMix(SpringGreen, Lime, PaleGreen, 120);
		addMix(SpringGreen, LimeGreen, Lime, 115);
		addMix(SpringGreen, Magenta, MediumPurple, 60);
		addMix(SpringGreen, MediumAquamarine, PaleGreen, 110);
		addMix(SpringGreen, MediumOrchid, CadetBlue, 65);
		addMix(SpringGreen, MediumPurple, LightSeaGreen, 65);
		addMix(SpringGreen, MediumSeaGreen, LimeGreen, 110);
		addMix(SpringGreen, MistyRose, Aquamarine, 80);
		addMix(SpringGreen, Olive, LimeGreen, 90);
		addMix(SpringGreen, OliveDrab, LimeGreen, 95);
		addMix(SpringGreen, Orange, YellowGreen, 75);
		addMix(SpringGreen, PaleGreen, Lime, 120);
		addMix(SpringGreen, PaleTurquoise, Aquamarine, 100);
		addMix(SpringGreen, Peru, LimeGreen, 75);
		addMix(SpringGreen, Pink, MediumAquamarine, 65);
		addMix(SpringGreen, Plum, MediumAquamarine, 75);
		addMix(SpringGreen, Purple, Teal, 50);
		addMix(SpringGreen, RosyBrown, MediumSeaGreen, 70);
		addMix(SpringGreen, RoyalBlue, LightSeaGreen, 60);
		addMix(SpringGreen, Salmon, DarkSeaGreen, 50);
		addMix(SpringGreen, SandyBrown, LimeGreen, 75);
		addMix(SpringGreen, SeaGreen, MediumSeaGreen, 95);
		addMix(SpringGreen, Sienna, MediumSeaGreen, 55);
		addMix(SpringGreen, SkyBlue, Aquamarine, 85);
		addMix(SpringGreen, SlateBlue, LightSeaGreen, 60);
		addMix(SpringGreen, SlateGray, MediumSeaGreen, 80);
		addMix(SteelBlue, Aquamarine, DarkTurquoise, 80);
		addMix(SteelBlue, Black, DarkSlateBlue, 85);
		addMix(SteelBlue, Blue, SlateBlue, 100);
		addMix(SteelBlue, CadetBlue, SlateGray, 105);
		addMix(SteelBlue, Chocolate, Gray, 80);
		addMix(SteelBlue, Coral, RosyBrown, 80);
		addMix(SteelBlue, Crimson, MediumVioletRed, 80);
		addMix(SteelBlue, Cyan, DarkTurquoise, 90);
		addMix(SteelBlue, DarkGray, SlateGray, 105);
		addMix(SteelBlue, DarkGreen, SeaGreen, 75);
		addMix(SteelBlue, DarkKhaki, CadetBlue, 75);
		addMix(SteelBlue, DarkOliveGreen, Teal, 80);
		addMix(SteelBlue, DarkOrange, DarkGoldenrod, 75);
		addMix(SteelBlue, DarkSalmon, Gray, 85);
		addMix(SteelBlue, DarkSeaGreen, CadetBlue, 85);
		addMix(SteelBlue, DarkSlateBlue, RoyalBlue, 100);
		addMix(SteelBlue, DarkSlateGray, RoyalBlue, 100);
		addMix(SteelBlue, DarkTurquoise, CadetBlue, 100);
		addMix(SteelBlue, DarkViolet, SlateBlue, 95);
		addMix(SteelBlue, DeepPink, MediumOrchid, 80);
		addMix(SteelBlue, DeepSkyBlue, DodgerBlue, 105);
		addMix(SteelBlue, DimGray, SlateGray, 105);
		addMix(SteelBlue, Gold, DarkKhaki, 60);
		addMix(SteelBlue, Gray, SlateGray, 110);
		addMix(SteelBlue, Green, SeaGreen, 75);
		addMix(SteelBlue, HotPink, MediumPurple, 80);
		addMix(SteelBlue, Indigo, DarkSlateBlue, 90);
		addMix(SteelBlue, Khaki, DarkSeaGreen, 70);
		addMix(SteelBlue, Lavender, LightSteelBlue, 90);
		addMix(SteelBlue, LemonChiffon, SkyBlue, 75);
		addMix(SteelBlue, LightGray, LightSteelBlue, 95);
		addMix(SteelBlue, LightSeaGreen, CadetBlue, 100);
		addMix(SteelBlue, LightSteelBlue, DodgerBlue, 105);
		addMix(SteelBlue, Lime, MediumSeaGreen, 65);
		addMix(SteelBlue, LimeGreen, MediumSeaGreen, 70);
		addMix(SteelBlue, Magenta, MediumOrchid, 85);
		addMix(SteelBlue, MediumAquamarine, CadetBlue, 90);
		addMix(SteelBlue, MediumOrchid, MediumPurple, 95);
		addMix(SteelBlue, MediumPurple, RoyalBlue, 105);
		addMix(SteelBlue, MediumSeaGreen, CadetBlue, 85);
		addMix(SteelBlue, MediumVioletRed, DarkViolet, 80);
		addMix(SteelBlue, MistyRose, LightSteelBlue, 85);
		addMix(SteelBlue, Navy, DarkSlateBlue, 90);
		addMix(SteelBlue, Olive, SeaGreen, 75);
		addMix(SteelBlue, OliveDrab, SeaGreen, 75);
		addMix(SteelBlue, Orange, DarkKhaki, 75);
		addMix(SteelBlue, PaleGreen, MediumAquamarine, 70);
		addMix(SteelBlue, PaleTurquoise, SkyBlue, 90);
		addMix(SteelBlue, Peru, Gray, 80);
		addMix(SteelBlue, Pink, LightSteelBlue, 85);
		addMix(SteelBlue, Plum, MediumPurple, 90);
		addMix(SteelBlue, Purple, DarkSlateBlue, 85);
		addMix(SteelBlue, Red, MediumVioletRed, 75);
		addMix(SteelBlue, RosyBrown, SlateGray, 95);
		addMix(SteelBlue, RoyalBlue, DodgerBlue, 115);
		addMix(SteelBlue, Salmon, RosyBrown, 80);
		addMix(SteelBlue, SandyBrown, DarkGray, 80);
		addMix(SteelBlue, SeaGreen, Teal, 90);
		addMix(SteelBlue, Sienna, DimGray, 85);
		addMix(SteelBlue, SkyBlue, DeepSkyBlue, 105);
		addMix(SteelBlue, SlateBlue, RoyalBlue, 110);
		addMix(SteelBlue, SlateGray, RoyalBlue, 115);
		addMix(SteelBlue, SpringGreen, MediumAquamarine, 70);
		addMix(Tan, Aquamarine, DarkSeaGreen, 95);
		addMix(Tan, Black, DimGray, 60);
		addMix(Tan, Blue, SlateBlue, 60);
		addMix(Tan, Brown, IndianRed, 85);
		addMix(Tan, CadetBlue, DarkSeaGreen, 95);
		addMix(Tan, Chocolate, Peru, 105);
		addMix(Tan, Coral, DarkSalmon, 105);
		addMix(Tan, Crimson, IndianRed, 85);
		addMix(Tan, Cyan, Turquoise, 90);
		addMix(Tan, DarkGoldenrod, Goldenrod, 110);
		addMix(Tan, DarkGreen, OliveDrab, 80);
		addMix(Tan, DarkKhaki, Wheat, 115);
		addMix(Tan, DarkOliveGreen, Olive, 90);
		addMix(Tan, DarkOrange, SandyBrown, 105);
		addMix(Tan, DarkSalmon, SandyBrown, 110);
		addMix(Tan, DarkSeaGreen, DarkKhaki, 105);
		addMix(Tan, DarkSlateGray, Gray, 75);
		addMix(Tan, DarkTurquoise, MediumAquamarine, 90);
		addMix(Tan, DarkViolet, MediumOrchid, 65);
		addMix(Tan, DeepPink, PaleVioletRed, 80);
		addMix(Tan, DeepSkyBlue, CadetBlue, 85);
		addMix(Tan, DimGray, Gray, 95);
		addMix(Tan, DodgerBlue, SteelBlue, 80);
		addMix(Tan, Gold, Goldenrod, 105);
		addMix(Tan, Goldenrod, DarkKhaki, 110);
		addMix(Tan, Gray, DarkGray, 100);
		addMix(Tan, Green, OliveDrab, 85);
		addMix(Tan, HotPink, PaleVioletRed, 85);
		addMix(Tan, IndianRed, DarkSalmon, 95);
		addMix(Tan, Khaki, Wheat, 110);
		addMix(Tan, Lavender, LightGray, 100);
		addMix(Tan, LemonChiffon, Wheat, 110);
		addMix(Tan, LightGray, Wheat, 110);
		addMix(Tan, LightSeaGreen, MediumAquamarine, 95);
		addMix(Tan, LightSteelBlue, DarkGray, 100);
		addMix(Tan, Lime, LimeGreen, 90);
		addMix(Tan, LimeGreen, YellowGreen, 95);
		addMix(Tan, Magenta, HotPink, 75);
		addMix(Tan, Maroon, Sienna, 70);
		addMix(Tan, MediumAquamarine, DarkSeaGreen, 95);
		addMix(Tan, MediumOrchid, PaleVioletRed, 75);
		addMix(Tan, MediumPurple, Plum, 80);
		addMix(Tan, MediumSeaGreen, DarkSeaGreen, 95);
		addMix(Tan, MediumVioletRed, PaleVioletRed, 75);
		addMix(Tan, MistyRose, Wheat, 110);
		addMix(Tan, Navy, DarkSlateBlue, 50);
		addMix(Tan, Olive, DarkKhaki, 100);
		addMix(Tan, OliveDrab, DarkKhaki, 100);
		addMix(Tan, Orange, Goldenrod, 110);
		addMix(Tan, PaleGreen, DarkSeaGreen, 95);
		addMix(Tan, PaleTurquoise, LightGray, 95);
		addMix(Tan, PaleVioletRed, RosyBrown, 90);
		addMix(Tan, Peru, SandyBrown, 110);
		addMix(Tan, Pink, DarkSalmon, 100);
		addMix(Tan, Plum, Pink, 90);
		addMix(Tan, Purple, MediumVioletRed, 60);
		addMix(Tan, Red, IndianRed, 90);
		addMix(Tan, RosyBrown, DarkSalmon, 105);
		addMix(Tan, RoyalBlue, SlateGray, 75);
		addMix(Tan, Salmon, DarkSalmon, 100);
		addMix(Tan, SandyBrown, Peru, 115);
		addMix(Tan, SeaGreen, DarkSeaGreen, 90);
		addMix(Tan, Sienna, Peru, 95);
		addMix(Tan, SkyBlue, DarkGray, 95);
		addMix(Tan, SlateGray, DarkGray, 95);
		addMix(Tan, SpringGreen, PaleGreen, 90);
		addMix(Tan, SteelBlue, DarkGray, 85);
		addMix(Teal, Aquamarine, LightSeaGreen, 90);
		addMix(Teal, Black, DarkSlateGray, 85);
		addMix(Teal, Blue, DarkSlateBlue, 85);
		addMix(Teal, Brown, DimGray, 75);
		addMix(Teal, CadetBlue, LightSeaGreen, 115);
		addMix(Teal, Chocolate, DarkOliveGreen, 80);
		addMix(Teal, Coral, Gray, 75);
		addMix(Teal, Cyan, DarkTurquoise, 90);
		addMix(Teal, DarkGoldenrod, OliveDrab, 85);
		addMix(Teal, DarkGray, CadetBlue, 100);
		addMix(Teal, DarkGreen, SeaGreen, 100);
		addMix(Teal, DarkKhaki, SeaGreen, 90);
		addMix(Teal, DarkOliveGreen, SeaGreen, 100);
		addMix(Teal, DarkOrange, OliveDrab, 75);
		addMix(Teal, DarkSalmon, CadetBlue, 80);
		addMix(Teal, DarkSeaGreen, LightSeaGreen, 100);
		addMix(Teal, DarkTurquoise, LightSeaGreen, 105);
		addMix(Teal, DarkViolet, DarkSlateBlue, 90);
		addMix(Teal, DeepPink, Purple, 70);
		addMix(Teal, DeepSkyBlue, CadetBlue, 100);
		addMix(Teal, DodgerBlue, SteelBlue, 95);
		addMix(Teal, Gold, OliveDrab, 75);
		addMix(Teal, Goldenrod, OliveDrab, 80);
		addMix(Teal, Gray, CadetBlue, 105);
		addMix(Teal, Green, SeaGreen, 100);
		addMix(Teal, IndianRed, DimGray, 75);
		addMix(Teal, Indigo, DarkSlateBlue, 85);
		addMix(Teal, Khaki, DarkSeaGreen, 80);
		addMix(Teal, Lavender, CadetBlue, 85);
		addMix(Teal, LemonChiffon, MediumAquamarine, 80);
		addMix(Teal, LightGray, CadetBlue, 90);
		addMix(Teal, LightSeaGreen, CadetBlue, 110);
		addMix(Teal, LightSteelBlue, CadetBlue, 95);
		addMix(Teal, Lime, LimeGreen, 80);
		addMix(Teal, LimeGreen, MediumSeaGreen, 90);
		addMix(Teal, Magenta, DarkViolet, 85);
		addMix(Teal, Maroon, Gray, 70);
		addMix(Teal, MediumAquamarine, LightSeaGreen, 100);
		addMix(Teal, MediumOrchid, RoyalBlue, 85);
		addMix(Teal, MediumPurple, SteelBlue, 90);
		addMix(Teal, MediumSeaGreen, SeaGreen, 100);
		addMix(Teal, MediumVioletRed, DarkSlateBlue, 75);
		addMix(Teal, MistyRose, CadetBlue, 75);
		addMix(Teal, Navy, DarkSlateBlue, 80);
		addMix(Teal, Olive, SeaGreen, 95);
		addMix(Teal, OliveDrab, SeaGreen, 95);
		addMix(Teal, Orange, OliveDrab, 75);
		addMix(Teal, PaleGreen, MediumSeaGreen, 85);
		addMix(Teal, PaleTurquoise, LightSeaGreen, 95);
		addMix(Teal, PaleVioletRed, SlateGray, 70);
		addMix(Teal, Peru, SeaGreen, 85);
		addMix(Teal, Pink, CadetBlue, 65);
		addMix(Teal, Plum, SteelBlue, 80);
		addMix(Teal, Purple, DarkSlateBlue, 80);
		addMix(Teal, Red, Brown, 70);
		addMix(Teal, RosyBrown, CadetBlue, 85);
		addMix(Teal, RoyalBlue, SteelBlue, 95);
		addMix(Teal, Salmon, Gray, 70);
		addMix(Teal, SandyBrown, SeaGreen, 80);
		addMix(Teal, Sienna, DarkOliveGreen, 80);
		addMix(Teal, SkyBlue, CadetBlue, 100);
		addMix(Teal, SlateBlue, SteelBlue, 95);
		addMix(Teal, SlateGray, CadetBlue, 105);
		addMix(Teal, SpringGreen, MediumSeaGreen, 85);
		addMix(Teal, Tan, CadetBlue, 85);
		addMix(Thistle, Aquamarine, PaleTurquoise, 85);
		addMix(Thistle, Black, DimGray, 55);
		addMix(Thistle, Blue, SlateBlue, 75);
		addMix(Thistle, Brown, PaleVioletRed, 80);
		addMix(Thistle, CadetBlue, LightSteelBlue, 90);
		addMix(Thistle, Chocolate, DarkSalmon, 90);
		addMix(Thistle, Coral, DarkSalmon, 95);
		addMix(Thistle, Crimson, PaleVioletRed, 85);
		addMix(Thistle, Cyan, DarkTurquoise, 80);
		addMix(Thistle, DarkGoldenrod, Tan, 85);
		addMix(Thistle, DarkGray, LightGray, 110);
		addMix(Thistle, DarkGreen, SeaGreen, 60);
		addMix(Thistle, DarkKhaki, Tan, 85);
		addMix(Thistle, DarkOliveGreen, DarkGray, 75);
		addMix(Thistle, DarkOrange, SandyBrown, 90);
		addMix(Thistle, DarkSalmon, Pink, 100);
		addMix(Thistle, DarkSeaGreen, DarkGray, 85);
		addMix(Thistle, DarkSlateBlue, MediumPurple, 75);
		addMix(Thistle, DarkSlateGray, SlateGray, 70);
		addMix(Thistle, DarkTurquoise, SkyBlue, 85);
		addMix(Thistle, DarkViolet, MediumOrchid, 85);
		addMix(Thistle, DeepPink, HotPink, 95);
		addMix(Thistle, DeepSkyBlue, SkyBlue, 85);
		addMix(Thistle, DimGray, DarkGray, 90);
		addMix(Thistle, DodgerBlue, LightSteelBlue, 90);
		addMix(Thistle, Gold, Khaki, 80);
		addMix(Thistle, Goldenrod, Tan, 85);
		addMix(Thistle, Gray, DarkGray, 100);
		addMix(Thistle, Green, MediumSeaGreen, 65);
		addMix(Thistle, HotPink, Plum, 105);
		addMix(Thistle, IndianRed, RosyBrown, 95);
		addMix(Thistle, Indigo, MediumOrchid, 60);
		addMix(Thistle, Khaki, Wheat, 85);
		addMix(Thistle, Lavender, MistyRose, 115);
		addMix(Thistle, LemonChiffon, MistyRose, 90);
		addMix(Thistle, LightGray, Lavender, 110);
		addMix(Thistle, LightSeaGreen, CadetBlue, 85);
		addMix(Thistle, LightSteelBlue, Lavender, 110);
		addMix(Thistle, Lime, LimeGreen, 65);
		addMix(Thistle, LimeGreen, DarkSeaGreen, 70);
		addMix(Thistle, Magenta, Violet, 95);
		addMix(Thistle, Maroon, IndianRed, 65);
		addMix(Thistle, MediumAquamarine, PaleTurquoise, 90);
		addMix(Thistle, MediumOrchid, Plum, 95);
		addMix(Thistle, MediumPurple, Plum, 100);
		addMix(Thistle, MediumSeaGreen, DarkSeaGreen, 85);
		addMix(Thistle, MediumVioletRed, HotPink, 90);
		addMix(Thistle, MistyRose, Pink, 115);
		addMix(Thistle, Navy, SlateBlue, 55);
		addMix(Thistle, Olive, DarkKhaki, 75);
		addMix(Thistle, OliveDrab, DarkKhaki, 75);
		addMix(Thistle, Orange, SandyBrown, 85);
		addMix(Thistle, PaleGreen, DarkSeaGreen, 75);
		addMix(Thistle, PaleTurquoise, LightSteelBlue, 90);
		addMix(Thistle, PaleVioletRed, Plum, 105);
		addMix(Thistle, Peru, DarkSalmon, 90);
		addMix(Thistle, Pink, MistyRose, 115);
		addMix(Thistle, Plum, Pink, 115);
		addMix(Thistle, Purple, MediumOrchid, 75);
		addMix(Thistle, Red, IndianRed, 85);
		addMix(Thistle, RosyBrown, Pink, 110);
		addMix(Thistle, RoyalBlue, MediumPurple, 90);
		addMix(Thistle, Salmon, Pink, 100);
		addMix(Thistle, SandyBrown, DarkSalmon, 95);
		addMix(Thistle, SeaGreen, CadetBlue, 85);
		addMix(Thistle, Sienna, RosyBrown, 85);
		addMix(Thistle, SkyBlue, LightSteelBlue, 90);
		addMix(Thistle, SlateBlue, MediumPurple, 90);
		addMix(Thistle, SlateGray, DarkGray, 100);
		addMix(Thistle, SpringGreen, MediumAquamarine, 85);
		addMix(Thistle, SteelBlue, LightSteelBlue, 90);
		addMix(Thistle, Tan, MistyRose, 100);
		addMix(Thistle, Teal, CadetBlue, 80);
		addMix(Turquoise, Aquamarine, MediumAquamarine, 115);
		addMix(Turquoise, Black, Teal, 50);
		addMix(Turquoise, Blue, RoyalBlue, 60);
		addMix(Turquoise, Brown, Gray, 55);
		addMix(Turquoise, CadetBlue, LightSeaGreen, 110);
		addMix(Turquoise, Chocolate, DarkSeaGreen, 70);
		addMix(Turquoise, Coral, DarkSeaGreen, 70);
		addMix(Turquoise, Crimson, Gray, 50);
		addMix(Turquoise, Cyan, DarkTurquoise, 120);
		addMix(Turquoise, DarkGoldenrod, DarkSeaGreen, 80);
		addMix(Turquoise, DarkGray, DarkTurquoise, 100);
		addMix(Turquoise, DarkGreen, MediumSeaGreen, 80);
		addMix(Turquoise, DarkKhaki, MediumAquamarine, 95);
		addMix(Turquoise, DarkOliveGreen, MediumSeaGreen, 85);
		addMix(Turquoise, DarkOrange, DarkKhaki, 75);
		addMix(Turquoise, DarkSalmon, DarkSeaGreen, 75);
		addMix(Turquoise, DarkSeaGreen, MediumAquamarine, 110);
		addMix(Turquoise, DarkSlateBlue, SteelBlue, 65);
		addMix(Turquoise, DarkSlateGray, CadetBlue, 75);
		addMix(Turquoise, DarkTurquoise, Cyan, 120);
		addMix(Turquoise, DarkViolet, RoyalBlue, 65);
		addMix(Turquoise, DeepPink, MediumPurple, 55);
		addMix(Turquoise, DeepSkyBlue, DarkTurquoise, 100);
		addMix(Turquoise, DimGray, CadetBlue, 85);
		addMix(Turquoise, DodgerBlue, DeepSkyBlue, 90);
		addMix(Turquoise, Gold, YellowGreen, 85);
		addMix(Turquoise, Goldenrod, DarkSeaGreen, 85);
		addMix(Turquoise, Gray, LightSeaGreen, 95);
		addMix(Turquoise, Green, MediumSeaGreen, 90);
		addMix(Turquoise, HotPink, LightSteelBlue, 65);
		addMix(Turquoise, IndianRed, CadetBlue, 60);
		addMix(Turquoise, Indigo, RoyalBlue, 50);
		addMix(Turquoise, Khaki, MediumAquamarine, 95);
		addMix(Turquoise, Lavender, PaleTurquoise, 95);
		addMix(Turquoise, LemonChiffon, Aquamarine, 100);
		addMix(Turquoise, LightGray, PaleTurquoise, 100);
		addMix(Turquoise, LightSeaGreen, DarkTurquoise, 115);
		addMix(Turquoise, LightSteelBlue, DarkTurquoise, 100);
		addMix(Turquoise, Lime, SpringGreen, 95);
		addMix(Turquoise, LimeGreen, MediumSeaGreen, 100);
		addMix(Turquoise, Magenta, MediumPurple, 75);
		addMix(Turquoise, Maroon, DimGray, 45);
		addMix(Turquoise, MediumAquamarine, DarkTurquoise, 120);
		addMix(Turquoise, MediumOrchid, DodgerBlue, 75);
		addMix(Turquoise, MediumPurple, DeepSkyBlue, 80);
		addMix(Turquoise, MediumSeaGreen, MediumAquamarine, 110);
		addMix(Turquoise, MediumVioletRed, MediumPurple, 60);
		addMix(Turquoise, MistyRose, PaleTurquoise, 90);
		addMix(Turquoise, Navy, SteelBlue, 45);
		addMix(Turquoise, Olive, MediumSeaGreen, 85);
		addMix(Turquoise, OliveDrab, MediumSeaGreen, 90);
		addMix(Turquoise, Orange, YellowGreen, 80);
		addMix(Turquoise, PaleGreen, Aquamarine, 105);
		addMix(Turquoise, PaleTurquoise, Cyan, 115);
		addMix(Turquoise, PaleVioletRed, DarkGray, 60);
		addMix(Turquoise, Peru, DarkSeaGreen, 80);
		addMix(Turquoise, Pink, PaleTurquoise, 75);
		addMix(Turquoise, Plum, SkyBlue, 80);
		addMix(Turquoise, Purple, RoyalBlue, 55);
		addMix(Turquoise, Red, RosyBrown, 55);
		addMix(Turquoise, RosyBrown, CadetBlue, 80);
		addMix(Turquoise, RoyalBlue, DeepSkyBlue, 80);
		addMix(Turquoise, Salmon, DarkGray, 65);
		addMix(Turquoise, SandyBrown, DarkSeaGreen, 80);
		addMix(Turquoise, SeaGreen, MediumAquamarine, 100);
		addMix(Turquoise, Sienna, DarkSeaGreen, 65);
		addMix(Turquoise, SkyBlue, DarkTurquoise, 110);
		addMix(Turquoise, SlateBlue, DodgerBlue, 75);
		addMix(Turquoise, SlateGray, LightSeaGreen, 95);
		addMix(Turquoise, SpringGreen, Aquamarine, 105);
		addMix(Turquoise, SteelBlue, CadetBlue, 90);
		addMix(Turquoise, Tan, MediumAquamarine, 95);
		addMix(Turquoise, Teal, LightSeaGreen, 100);
		addMix(Turquoise, Thistle, PaleTurquoise, 85);
		addMix(Violet, Aquamarine, LightSteelBlue, 75);
		addMix(Violet, Black, Purple, 60);
		addMix(Violet, Blue, SlateBlue, 85);
		addMix(Violet, Brown, PaleVioletRed, 85);
		addMix(Violet, CadetBlue, Plum, 95);
		addMix(Violet, Chocolate, PaleVioletRed, 80);
		addMix(Violet, Coral, PaleVioletRed, 85);
		addMix(Violet, Crimson, DeepPink, 90);
		addMix(Violet, Cyan, DeepSkyBlue, 70);
		addMix(Violet, DarkGoldenrod, Salmon, 65);
		addMix(Violet, DarkGray, Plum, 100);
		addMix(Violet, DarkKhaki, RosyBrown, 65);
		addMix(Violet, DarkOliveGreen, RosyBrown, 55);
		addMix(Violet, DarkOrange, Salmon, 75);
		addMix(Violet, DarkSalmon, HotPink, 90);
		addMix(Violet, DarkSeaGreen, Thistle, 60);
		addMix(Violet, DarkSlateBlue, MediumOrchid, 85);
		addMix(Violet, DarkSlateGray, MediumPurple, 80);
		addMix(Violet, DarkTurquoise, DodgerBlue, 75);
		addMix(Violet, DarkViolet, MediumOrchid, 95);
		addMix(Violet, DeepPink, HotPink, 110);
		addMix(Violet, DeepSkyBlue, DodgerBlue, 75);
		addMix(Violet, DimGray, MediumOrchid, 90);
		addMix(Violet, DodgerBlue, MediumPurple, 90);
		addMix(Violet, Gold, SandyBrown, 55);
		addMix(Violet, Goldenrod, DarkSalmon, 65);
		addMix(Violet, Gray, Plum, 95);
		addMix(Violet, HotPink, Plum, 115);
		addMix(Violet, IndianRed, PaleVioletRed, 95);
		addMix(Violet, Indigo, DarkViolet, 80);
		addMix(Violet, Khaki, Pink, 60);
		addMix(Violet, Lavender, Plum, 100);
		addMix(Violet, LemonChiffon, Pink, 70);
		addMix(Violet, LightGray, Plum, 95);
		addMix(Violet, LightSteelBlue, Plum, 100);
		addMix(Violet, Magenta, MediumOrchid, 115);
		addMix(Violet, Maroon, MediumVioletRed, 70);
		addMix(Violet, MediumAquamarine, Thistle, 80);
		addMix(Violet, MediumOrchid, Magenta, 115);
		addMix(Violet, MediumPurple, MediumOrchid, 110);
		addMix(Violet, MediumSeaGreen, DarkGray, 75);
		addMix(Violet, MediumVioletRed, MediumOrchid, 100);
		addMix(Violet, MistyRose, Plum, 95);
		addMix(Violet, Navy, DarkViolet, 75);
		addMix(Violet, Olive, RosyBrown, 55);
		addMix(Violet, OliveDrab, RosyBrown, 50);
		addMix(Violet, Orange, DarkSalmon, 65);
		addMix(Violet, PaleTurquoise, Thistle, 90);
		addMix(Violet, PaleVioletRed, HotPink, 110);
		addMix(Violet, Peru, PaleVioletRed, 80);
		addMix(Violet, Pink, Plum, 105);
		addMix(Violet, Plum, HotPink, 120);
		addMix(Violet, Purple, MediumOrchid, 85);
		addMix(Violet, Red, DeepPink, 85);
		addMix(Violet, RosyBrown, Plum, 100);
		addMix(Violet, RoyalBlue, MediumPurple, 95);
		addMix(Violet, Salmon, HotPink, 95);
		addMix(Violet, SandyBrown, PaleVioletRed, 80);
		addMix(Violet, Sienna, PaleVioletRed, 80);
		addMix(Violet, SkyBlue, Plum, 90);
		addMix(Violet, SlateBlue, MediumPurple, 100);
		addMix(Violet, SlateGray, Plum, 100);
		addMix(Violet, SpringGreen, LightSeaGreen, 70);
		addMix(Violet, SteelBlue, MediumPurple, 90);
		addMix(Violet, Tan, Plum, 80);
		addMix(Violet, Teal, MediumPurple, 80);
		addMix(Violet, Thistle, Plum, 105);
		addMix(Violet, Turquoise, LightSteelBlue, 75);
		addMix(Wheat, Aquamarine, PaleGreen, 100);
		addMix(Wheat, Blue, MediumPurple, 50);
		addMix(Wheat, Brown, DarkSalmon, 75);
		addMix(Wheat, CadetBlue, DarkSeaGreen, 90);
		addMix(Wheat, Chocolate, SandyBrown, 95);
		addMix(Wheat, Coral, SandyBrown, 100);
		addMix(Wheat, Crimson, Salmon, 80);
		addMix(Wheat, Cyan, Turquoise, 90);
		addMix(Wheat, DarkGoldenrod, Goldenrod, 100);
		addMix(Wheat, DarkGray, Tan, 105);
		addMix(Wheat, DarkGreen, OliveDrab, 75);
		addMix(Wheat, DarkKhaki, Khaki, 110);
		addMix(Wheat, DarkOliveGreen, DarkKhaki, 85);
		addMix(Wheat, DarkOrange, Orange, 100);
		addMix(Wheat, DarkSalmon, Tan, 105);
		addMix(Wheat, DarkSeaGreen, DarkKhaki, 105);
		addMix(Wheat, DarkSlateBlue, RosyBrown, 60);
		addMix(Wheat, DarkSlateGray, DarkGray, 70);
		addMix(Wheat, DarkTurquoise, MediumAquamarine, 90);
		addMix(Wheat, DarkViolet, MediumOrchid, 60);
		addMix(Wheat, DeepPink, PaleVioletRed, 75);
		addMix(Wheat, DeepSkyBlue, SkyBlue, 80);
		addMix(Wheat, DimGray, Tan, 85);
		addMix(Wheat, DodgerBlue, SkyBlue, 75);
		addMix(Wheat, Gold, Khaki, 110);
		addMix(Wheat, Goldenrod, DarkKhaki, 105);
		addMix(Wheat, Gray, Tan, 95);
		addMix(Wheat, Green, DarkSeaGreen, 85);
		addMix(Wheat, HotPink, Pink, 80);
		addMix(Wheat, IndianRed, DarkSalmon, 85);
		addMix(Wheat, Khaki, LemonChiffon, 115);
		addMix(Wheat, Lavender, LightGray, 100);
		addMix(Wheat, LemonChiffon, Khaki, 120);
		addMix(Wheat, LightGray, LemonChiffon, 110);
		addMix(Wheat, LightSeaGreen, MediumAquamarine, 90);
		addMix(Wheat, LightSteelBlue, LightGray, 95);
		addMix(Wheat, Lime, PaleGreen, 95);
		addMix(Wheat, LimeGreen, YellowGreen, 95);
		addMix(Wheat, Magenta, Violet, 70);
		addMix(Wheat, Maroon, IndianRed, 60);
		addMix(Wheat, MediumAquamarine, DarkSeaGreen, 100);
		addMix(Wheat, MediumOrchid, Plum, 70);
		addMix(Wheat, MediumPurple, Thistle, 75);
		addMix(Wheat, MediumSeaGreen, DarkSeaGreen, 95);
		addMix(Wheat, MediumVioletRed, PaleVioletRed, 70);
		addMix(Wheat, MistyRose, Tan, 110);
		addMix(Wheat, Olive, DarkKhaki, 95);
		addMix(Wheat, OliveDrab, DarkKhaki, 95);
		addMix(Wheat, Orange, Goldenrod, 105);
		addMix(Wheat, PaleGreen, LemonChiffon, 100);
		addMix(Wheat, PaleTurquoise, LemonChiffon, 100);
		addMix(Wheat, PaleVioletRed, Pink, 85);
		addMix(Wheat, Peru, Tan, 100);
		addMix(Wheat, Pink, MistyRose, 100);
		addMix(Wheat, Plum, Pink, 85);
		addMix(Wheat, Purple, PaleVioletRed, 55);
		addMix(Wheat, Red, Salmon, 85);
		addMix(Wheat, RosyBrown, Tan, 100);
		addMix(Wheat, RoyalBlue, LightSteelBlue, 70);
		addMix(Wheat, Salmon, DarkSalmon, 95);
		addMix(Wheat, SandyBrown, Tan, 110);
		addMix(Wheat, SeaGreen, DarkSeaGreen, 90);
		addMix(Wheat, Sienna, Peru, 85);
		addMix(Wheat, SkyBlue, PaleTurquoise, 95);
		addMix(Wheat, SlateBlue, Plum, 65);
		addMix(Wheat, SlateGray, DarkGray, 90);
		addMix(Wheat, SpringGreen, PaleGreen, 95);
		addMix(Wheat, SteelBlue, DarkGray, 75);
		addMix(Wheat, Tan, DarkKhaki, 115);
		addMix(Wheat, Teal, DarkSeaGreen, 80);
		addMix(Wheat, Thistle, MistyRose, 95);
		addMix(Wheat, Turquoise, MediumAquamarine, 95);
		addMix(Wheat, Violet, Pink, 75);
		addMix(White, Aquamarine, PaleTurquoise, 100);
		addMix(White, Blue, MediumPurple, 60);
		addMix(White, Brown, RosyBrown, 70);
		addMix(White, CadetBlue, PaleTurquoise, 95);
		addMix(White, Chocolate, Tan, 85);
		addMix(White, Coral, DarkSalmon, 90);
		addMix(White, Crimson, PaleVioletRed, 75);
		addMix(White, Cyan, PaleTurquoise, 100);
		addMix(White, DarkGoldenrod, Tan, 85);
		addMix(White, DarkGray, LightGray, 105);
		addMix(White, DarkGreen, DarkSeaGreen, 70);
		addMix(White, DarkKhaki, LemonChiffon, 100);
		addMix(White, DarkOliveGreen, DarkSeaGreen, 75);
		addMix(White, DarkOrange, SandyBrown, 90);
		addMix(White, DarkSalmon, MistyRose, 95);
		addMix(White, DarkSlateGray, DarkGray, 70);
		addMix(White, DarkTurquoise, PaleTurquoise, 95);
		addMix(White, DarkViolet, Violet, 70);
		addMix(White, DeepPink, HotPink, 85);
		addMix(White, DeepSkyBlue, SkyBlue, 95);
		addMix(White, DimGray, DarkGray, 85);
		addMix(White, DodgerBlue, SkyBlue, 85);
		addMix(White, Gold, Khaki, 95);
		addMix(White, Goldenrod, Wheat, 95);
		addMix(White, Gray, LightGray, 95);
		addMix(White, Green, DarkSeaGreen, 75);
		addMix(White, HotPink, Pink, 90);
		addMix(White, IndianRed, Pink, 85);
		addMix(White, Indigo, MediumPurple, 50);
		addMix(White, Khaki, LemonChiffon, 105);
		addMix(White, Lavender, LightGray, 115);
		addMix(White, LemonChiffon, Wheat, 110);
		addMix(White, LightGray, Lavender, 120);
		addMix(White, LightSeaGreen, PaleTurquoise, 95);
		addMix(White, LightSteelBlue, Lavender, 110);
		addMix(White, Lime, PaleGreen, 95);
		addMix(White, LimeGreen, PaleGreen, 90);
		addMix(White, Magenta, Violet, 85);
		addMix(White, Maroon, RosyBrown, 55);
		addMix(White, MediumAquamarine, PaleTurquoise, 100);
		addMix(White, MediumOrchid, Plum, 80);
		addMix(White, MediumPurple, Thistle, 85);
		addMix(White, MediumSeaGreen, MediumAquamarine, 90);
		addMix(White, MediumVioletRed, Plum, 75);
		addMix(White, MistyRose, LightGray, 115);
		addMix(White, Olive, DarkKhaki, 85);
		addMix(White, OliveDrab, DarkSeaGreen, 85);
		addMix(White, Orange, Wheat, 95);
		addMix(White, PaleGreen, Aquamarine, 100);
		addMix(White, PaleVioletRed, Pink, 90);
		addMix(White, Peru, Tan, 90);
		addMix(White, Pink, MistyRose, 105);
		addMix(White, Plum, Thistle, 100);
		addMix(White, Purple, Plum, 60);
		addMix(White, Red, Salmon, 80);
		addMix(White, RosyBrown, MistyRose, 95);
		addMix(White, RoyalBlue, LightSteelBlue, 80);
		addMix(White, Salmon, Pink, 95);
		addMix(White, SandyBrown, Wheat, 95);
		addMix(White, SeaGreen, DarkSeaGreen, 85);
		addMix(White, Sienna, DarkSalmon, 75);
		addMix(White, SkyBlue, PaleTurquoise, 105);
		addMix(White, SlateBlue, LightSteelBlue, 75);
		addMix(White, SlateGray, LightGray, 90);
		addMix(White, SpringGreen, Aquamarine, 95);
		addMix(White, SteelBlue, LightSteelBlue, 85);
		addMix(White, Tan, Wheat, 105);
		addMix(White, Teal, DarkTurquoise, 80);
		addMix(White, Thistle, Lavender, 105);
		addMix(White, Turquoise, PaleTurquoise, 100);
		addMix(White, Violet, Plum, 95);
		addMix(White, Wheat, LemonChiffon, 110);
		addMix(Yellow, Aquamarine, PaleGreen, 95);
		addMix(Yellow, Brown, Goldenrod, 55);
		addMix(Yellow, CadetBlue, YellowGreen, 80);
		addMix(Yellow, Chocolate, Goldenrod, 80);
		addMix(Yellow, Coral, Goldenrod, 75);
		addMix(Yellow, Crimson, DarkOrange, 55);
		addMix(Yellow, Cyan, PaleGreen, 85);
		addMix(Yellow, DarkGoldenrod, Gold, 95);
		addMix(Yellow, DarkGray, Khaki, 90);
		addMix(Yellow, DarkGreen, YellowGreen, 70);
		addMix(Yellow, DarkKhaki, Khaki, 105);
		addMix(Yellow, DarkOliveGreen, YellowGreen, 80);
		addMix(Yellow, DarkOrange, Gold, 90);
		addMix(Yellow, DarkSalmon, Gold, 80);
		addMix(Yellow, DarkSeaGreen, YellowGreen, 95);
		addMix(Yellow, DarkSlateGray, DarkKhaki, 60);
		addMix(Yellow, DarkTurquoise, PaleGreen, 80);
		addMix(Yellow, DeepSkyBlue, PaleGreen, 60);
		addMix(Yellow, DimGray, DarkKhaki, 75);
		addMix(Yellow, DodgerBlue, DarkSeaGreen, 45);
		addMix(Yellow, Gold, Khaki, 115);
		addMix(Yellow, Goldenrod, Gold, 100);
		addMix(Yellow, Gray, DarkKhaki, 80);
		addMix(Yellow, Green, YellowGreen, 80);
		addMix(Yellow, HotPink, SandyBrown, 50);
		addMix(Yellow, IndianRed, Goldenrod, 65);
		addMix(Yellow, Khaki, Gold, 115);
		addMix(Yellow, Lavender, Khaki, 80);
		addMix(Yellow, LemonChiffon, Khaki, 105);
		addMix(Yellow, LightGray, Khaki, 95);
		addMix(Yellow, LightSeaGreen, YellowGreen, 80);
		addMix(Yellow, LightSteelBlue, Khaki, 75);
		addMix(Yellow, Lime, SpringGreen, 105);
		addMix(Yellow, LimeGreen, YellowGreen, 100);
		addMix(Yellow, Maroon, DarkGoldenrod, 45);
		addMix(Yellow, MediumAquamarine, YellowGreen, 90);
		addMix(Yellow, MediumSeaGreen, YellowGreen, 90);
		addMix(Yellow, MistyRose, Khaki, 90);
		addMix(Yellow, Olive, DarkKhaki, 90);
		addMix(Yellow, OliveDrab, YellowGreen, 90);
		addMix(Yellow, Orange, Gold, 95);
		addMix(Yellow, PaleGreen, YellowGreen, 105);
		addMix(Yellow, PaleTurquoise, Khaki, 90);
		addMix(Yellow, PaleVioletRed, Goldenrod, 55);
		addMix(Yellow, Peru, Gold, 90);
		addMix(Yellow, Pink, Gold, 75);
		addMix(Yellow, Plum, Khaki, 55);
		addMix(Yellow, Red, DarkOrange, 60);
		addMix(Yellow, RosyBrown, Gold, 75);
		addMix(Yellow, Salmon, Goldenrod, 70);
		addMix(Yellow, SandyBrown, Gold, 90);
		addMix(Yellow, SeaGreen, YellowGreen, 85);
		addMix(Yellow, Sienna, Goldenrod, 70);
		addMix(Yellow, SkyBlue, YellowGreen, 75);
		addMix(Yellow, SlateGray, DarkKhaki, 70);
		addMix(Yellow, SpringGreen, Lime, 100);
		addMix(Yellow, SteelBlue, YellowGreen, 55);
		addMix(Yellow, Tan, Gold, 100);
		addMix(Yellow, Teal, YellowGreen, 70);
		addMix(Yellow, Thistle, Khaki, 75);
		addMix(Yellow, Turquoise, PaleGreen, 85);
		addMix(Yellow, Wheat, Khaki, 105);
		addMix(Yellow, White, Khaki, 95);
		addMix(YellowGreen, Aquamarine, PaleGreen, 100);
		addMix(YellowGreen, Black, DarkOliveGreen, 55);
		addMix(YellowGreen, Brown, DarkGoldenrod, 55);
		addMix(YellowGreen, CadetBlue, DarkSeaGreen, 90);
		addMix(YellowGreen, Chocolate, Goldenrod, 75);
		addMix(YellowGreen, Coral, Goldenrod, 75);
		addMix(YellowGreen, Crimson, Chocolate, 50);
		addMix(YellowGreen, Cyan, SpringGreen, 90);
		addMix(YellowGreen, DarkGoldenrod, DarkKhaki, 95);
		addMix(YellowGreen, DarkGray, DarkKhaki, 100);
		addMix(YellowGreen, DarkGreen, OliveDrab, 85);
		addMix(YellowGreen, DarkOliveGreen, OliveDrab, 95);
		addMix(YellowGreen, DarkOrange, Goldenrod, 85);
		addMix(YellowGreen, DarkSalmon, DarkKhaki, 80);
		addMix(YellowGreen, DarkSeaGreen, LimeGreen, 110);
		addMix(YellowGreen, DarkSlateGray, OliveDrab, 70);
		addMix(YellowGreen, DarkTurquoise, MediumSeaGreen, 90);
		addMix(YellowGreen, DeepSkyBlue, MediumAquamarine, 70);
		addMix(YellowGreen, DimGray, OliveDrab, 85);
		addMix(YellowGreen, DodgerBlue, LightSeaGreen, 55);
		addMix(YellowGreen, Gold, Yellow, 105);
		addMix(YellowGreen, Goldenrod, DarkKhaki, 100);
		addMix(YellowGreen, Gray, OliveDrab, 90);
		addMix(YellowGreen, Green, OliveDrab, 100);
		addMix(YellowGreen, HotPink, Tan, 45);
		addMix(YellowGreen, IndianRed, DarkGoldenrod, 65);
		addMix(YellowGreen, Khaki, DarkKhaki, 110);
		addMix(YellowGreen, Lavender, DarkSeaGreen, 85);
		addMix(YellowGreen, LemonChiffon, Khaki, 105);
		addMix(YellowGreen, LightGray, DarkKhaki, 100);
		addMix(YellowGreen, LightSeaGreen, MediumSeaGreen, 95);
		addMix(YellowGreen, LightSteelBlue, DarkSeaGreen, 80);
		addMix(YellowGreen, Lime, LimeGreen, 110);
		addMix(YellowGreen, LimeGreen, Lime, 115);
		addMix(YellowGreen, MediumAquamarine, LimeGreen, 105);
		addMix(YellowGreen, MediumPurple, DarkGray, 45);
		addMix(YellowGreen, MediumSeaGreen, LimeGreen, 110);
		addMix(YellowGreen, MistyRose, Khaki, 90);
		addMix(YellowGreen, Olive, OliveDrab, 105);
		addMix(YellowGreen, OliveDrab, LimeGreen, 110);
		addMix(YellowGreen, Orange, Gold, 90);
		addMix(YellowGreen, PaleGreen, LimeGreen, 110);
		addMix(YellowGreen, PaleTurquoise, PaleGreen, 95);
		addMix(YellowGreen, PaleVioletRed, Tan, 60);
		addMix(YellowGreen, Peru, DarkKhaki, 90);
		addMix(YellowGreen, Pink, DarkKhaki, 75);
		addMix(YellowGreen, Plum, DarkKhaki, 55);
		addMix(YellowGreen, Red, Chocolate, 55);
		addMix(YellowGreen, RosyBrown, DarkKhaki, 80);
		addMix(YellowGreen, RoyalBlue, CadetBlue, 55);
		addMix(YellowGreen, Salmon, Goldenrod, 70);
		addMix(YellowGreen, SandyBrown, DarkKhaki, 90);
		addMix(YellowGreen, SeaGreen, MediumSeaGreen, 100);
		addMix(YellowGreen, Sienna, Olive, 70);
		addMix(YellowGreen, SkyBlue, DarkSeaGreen, 80);
		addMix(YellowGreen, SlateGray, DarkSeaGreen, 80);
		addMix(YellowGreen, SpringGreen, LimeGreen, 110);
		addMix(YellowGreen, SteelBlue, DarkSeaGreen, 65);
		addMix(YellowGreen, Tan, DarkKhaki, 100);
		addMix(YellowGreen, Teal, MediumSeaGreen, 85);
		addMix(YellowGreen, Thistle, DarkKhaki, 75);
		addMix(YellowGreen, Turquoise, PaleGreen, 95);
		addMix(YellowGreen, Wheat, Khaki, 100);
		addMix(YellowGreen, White, Khaki, 95);
		addMix(YellowGreen, Yellow, Khaki, 110);
	}

	private static void addMix(EnumFlowerColor start1, EnumFlowerColor start2, EnumFlowerColor result, int chance) {
		ColorMix colorMix = new ColorMix(start1.getFlowerColorAllele(), start2.getFlowerColorAllele(), result.getFlowerColorAllele(), chance);
		BotanyAPI.flowerRoot.registerColourMix(colorMix);
	}
}
