/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.worldgen;

import com.google.common.base.Predicate;
import forestry.api.apiculture.hives.IHiveGen;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WorldGenHiveRock
implements IHiveGen {
    private boolean hasAirOnOneSide(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos sidePos = pos.func_177972_a(facing);
            if (!world.func_175667_e(sidePos) || !world.func_175623_d(sidePos)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public BlockPos getPosForHive(World world, int x, int z) {
        BlockPos topPos = world.func_175645_m(new BlockPos(x, 0, z));
        int worldHeight = topPos.func_177956_o();
        if (topPos.func_177956_o() == 0) {
            return null;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(topPos);
        for (int i = 0; i < 10; ++i) {
            pos.func_185336_p(world.field_73012_v.nextInt(worldHeight));
            if (!this.isValidLocation(world, (BlockPos)pos)) continue;
            return pos;
        }
        return null;
    }

    public boolean isValidLocation(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block.isReplaceableOreGen(blockState, (IBlockAccess)world, pos, (Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150348_b))) {
            return this.hasAirOnOneSide(world, pos);
        }
        return false;
    }

    public boolean canReplace(IBlockState blockState, World world, BlockPos pos) {
        Block block = blockState.func_177230_c();
        return block.isReplaceableOreGen(blockState, (IBlockAccess)world, pos, (Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150348_b));
    }
}

