package binnie.core.modules;

import java.io.File;
import java.util.Set;

import net.minecraftforge.common.config.Configuration;

import net.minecraftforge.fml.client.event.ConfigChangedEvent;

public interface IModuleContainer {

	/**
	 * @return Unique identifier for the module container, no spaces!
	 */
	String getID();

	/**
	 * @return The config folder of this container.
	 */
	File getConfigFolder();

	void enableModule(String uid);

	boolean isModuleEnabled(String moduleID);

	Set<Module> getLoadedModules();

	Set<Module> getUnloadedModules();

	boolean isAvailable();

	Configuration getModulesConfig();

	void registerConfigHandler(IConfigHandler handler);

	void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event);
}
