package binnie.extratrees.genetics.fruits;

import java.util.Locale;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import binnie.core.Constants;

public enum FruitSprite {
	TINY,
	SMALL,
	AVERAGE,
	LARGE,
	LARGER,
	PEAR;

	public static final FruitSprite[] VALUES = values();
	protected boolean isRegistered;
	private final ResourceLocation location;

	FruitSprite() {
		location = new ResourceLocation(Constants.EXTRA_TREES_MOD_ID, "blocks/fruit/" + name().toLowerCase(Locale.ENGLISH));
	}

	public ResourceLocation getLocation() {
		return location;
	}

	@SideOnly(Side.CLIENT)
	public void registerSprites() {
		if (!isRegistered) {
			TextureMap map = Minecraft.getMinecraft().getTextureMapBlocks();
			map.registerSprite(location);
			isRegistered = true;
		}
	}
}
