/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.modules;

import binnie.core.Mods;
import binnie.core.machines.MachineGroup;
import binnie.core.machines.inventory.ValidatorSprite;
import binnie.core.modules.BlankModule;
import binnie.core.util.RecipeUtil;
import binnie.genetics.CreativeTabGenetics;
import binnie.genetics.Genetics;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.machine.AdvGeneticMachine;
import binnie.genetics.machine.GeneticMachine;
import binnie.genetics.machine.LaboratoryMachine;
import binnie.genetics.machine.acclimatiser.Acclimatiser;
import binnie.genetics.machine.incubator.Incubator;
import forestry.api.modules.ForestryModule;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.oredict.OreDictionary;

@ForestryModule(moduleID="genetics.machines", containerID="genetics", name="Machines", unlocalizedDescription="genetics.module.machines")
public class ModuleMachine
extends BlankModule {
    private static ValidatorSprite spriteSequencer;
    private static ValidatorSprite spriteSerum;
    private static ValidatorSprite spriteEnzyme;
    private static ValidatorSprite spriteDye;
    private static ValidatorSprite spriteBacteria;
    private static ValidatorSprite spriteNugget;
    private static MachineGroup packageGenetic;
    private static MachineGroup packageAdvGenetic;
    private static MachineGroup packageLabMachine;

    public static ValidatorSprite getSpriteSequencer() {
        return spriteSequencer;
    }

    public static ValidatorSprite getSpriteSerum() {
        return spriteSerum;
    }

    public static ValidatorSprite getSpriteEnzyme() {
        return spriteEnzyme;
    }

    public static ValidatorSprite getSpriteDye() {
        return spriteDye;
    }

    public static ValidatorSprite getSpriteBacteria() {
        return spriteBacteria;
    }

    public static ValidatorSprite getSpriteNugget() {
        return spriteNugget;
    }

    public static MachineGroup getPackageGenetic() {
        return packageGenetic;
    }

    public static MachineGroup getPackageAdvGenetic() {
        return packageAdvGenetic;
    }

    public static MachineGroup getPackageLabMachine() {
        return packageLabMachine;
    }

    public ModuleMachine() {
        super("genetics", "core");
    }

    public void preInit() {
        packageGenetic = new MachineGroup(Genetics.instance, "machine", "machine", GeneticMachine.values());
        packageGenetic.setCreativeTab(CreativeTabGenetics.INSTANCE);
        packageLabMachine = new MachineGroup(Genetics.instance, "machine.lab_machine", "lab_machine", LaboratoryMachine.values());
        packageLabMachine.setCreativeTab(CreativeTabGenetics.INSTANCE);
        packageAdvGenetic = new MachineGroup(Genetics.instance, "machine.adv_machine", "adv_machine", AdvGeneticMachine.values());
        packageAdvGenetic.setCreativeTab(CreativeTabGenetics.INSTANCE);
        spriteSequencer = new ValidatorSprite(Genetics.instance, "validator/sequencer.0", "validator/sequencer.1");
        spriteSerum = new ValidatorSprite(Genetics.instance, "validator/serum.0", "validator/serum.1");
        spriteEnzyme = new ValidatorSprite(Genetics.instance, "validator/enzyme.0", "validator/enzyme.1");
        spriteDye = new ValidatorSprite(Genetics.instance, "validator/dye.0", "validator/dye.1");
        spriteNugget = new ValidatorSprite(Genetics.instance, "validator/nugget.0", "validator/nugget.1");
        spriteBacteria = new ValidatorSprite(Genetics.instance, "validator/bacteria.0", "validator/bacteria.1");
    }

    public void doInit() {
        Incubator.addRecipes();
        RecipeUtil recipeUtil = new RecipeUtil("genetics");
        Acclimatiser.setupRecipes();
        Object[] standardCircuit = new Object[]{Mods.Forestry.stack("chipsets", 1, 1)};
        Object[] advCircuit = new Object[]{GeneticsItems.IntegratedCircuit.get(1)};
        String ironGear = !OreDictionary.getOres((String)"gearIron").isEmpty() ? "gearIron" : "ingotIron";
        String goldGear = !OreDictionary.getOres((String)"gearGold").isEmpty() ? "gearGold" : "ingotIron";
        String diamondGear = !OreDictionary.getOres((String)"gearDiamond").isEmpty() ? "gearDiamond" : "ingotIron";
        for (Object circuit : standardCircuit) {
            recipeUtil.addRecipe("incubator", LaboratoryMachine.Incubator.get(1), "gFg", "cCc", "aPa", Character.valueOf('C'), GeneticsItems.LaboratoryCasing.get(1), Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('c'), circuit, Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('P'), "gearBronze", Character.valueOf('a'), ironGear);
            Item alyzer = Mods.Forestry.item("portable_alyzer");
            recipeUtil.addRecipe("analyzer", LaboratoryMachine.Analyser.get(1), "gBg", "cCc", "aPa", Character.valueOf('C'), GeneticsItems.LaboratoryCasing.get(1), Character.valueOf('B'), alyzer, Character.valueOf('c'), circuit, Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('P'), "gearBronze", Character.valueOf('a'), GeneticsItems.DNADye.get(1));
            recipeUtil.addRecipe("genepool", LaboratoryMachine.Genepool.get(1), "gBg", "cCc", "aPa", Character.valueOf('C'), GeneticsItems.LaboratoryCasing.get(1), Character.valueOf('B'), "gearBronze", Character.valueOf('c'), circuit, Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('P'), "gearBronze", Character.valueOf('a'), Blocks.field_150359_w);
            recipeUtil.addRecipe("acclimatizer", LaboratoryMachine.Acclimatiser.get(1), "gBg", "cCc", "aPa", Character.valueOf('C'), GeneticsItems.LaboratoryCasing.get(1), Character.valueOf('B'), Items.field_151129_at, Character.valueOf('c'), circuit, Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('P'), "gearBronze", Character.valueOf('a'), Items.field_151131_as);
        }
        for (Object circuit : advCircuit) {
            recipeUtil.addRecipe("isolator", GeneticMachine.Isolator.get(1), "gBg", "cCc", "aPa", Character.valueOf('C'), GeneticsItems.LaboratoryCasing.get(1), Character.valueOf('B'), goldGear, Character.valueOf('c'), circuit, Character.valueOf('g'), Items.field_151074_bl, Character.valueOf('P'), "gearBronze", Character.valueOf('a'), GeneticsItems.Enzyme.get(1));
            recipeUtil.addRecipe("polymeriser", GeneticMachine.Polymeriser.get(1), "gBg", "cCc", "gPg", Character.valueOf('C'), GeneticsItems.LaboratoryCasing.get(1), Character.valueOf('B'), ironGear, Character.valueOf('c'), circuit, Character.valueOf('g'), Items.field_151074_bl, Character.valueOf('P'), "gearBronze");
            recipeUtil.addRecipe("sequencer", GeneticMachine.Sequencer.get(1), "gBg", "cCc", "aPa", Character.valueOf('C'), GeneticsItems.LaboratoryCasing.get(1), Character.valueOf('B'), "gearBronze", Character.valueOf('c'), circuit, Character.valueOf('g'), Items.field_151074_bl, Character.valueOf('P'), "gearBronze", Character.valueOf('a'), GeneticsItems.FluorescentDye.get(1));
            recipeUtil.addRecipe("inoculator", GeneticMachine.Inoculator.get(1), "gBg", "cCc", "aPa", Character.valueOf('C'), GeneticsItems.LaboratoryCasing.get(1), Character.valueOf('B'), diamondGear, Character.valueOf('c'), circuit, Character.valueOf('g'), Items.field_151074_bl, Character.valueOf('P'), "gearBronze", Character.valueOf('a'), Items.field_151166_bC);
        }
        recipeUtil.addRecipe("splicer", AdvGeneticMachine.Splicer.get(1), "gBg", "cCc", "aPa", Character.valueOf('C'), GeneticsItems.IntegratedCasing.get(1), Character.valueOf('B'), diamondGear, Character.valueOf('c'), GeneticsItems.IntegratedCPU.get(1), Character.valueOf('g'), Items.field_151074_bl, Character.valueOf('P'), "gearBronze", Character.valueOf('a'), Items.field_151072_bj);
        recipeUtil.addRecipe("lab_machine", LaboratoryMachine.LabMachine.get(1), "igi", "gCg", "igi", Character.valueOf('C'), GeneticsItems.LaboratoryCasing.get(1), Character.valueOf('i'), "ingotIron", Character.valueOf('g'), Blocks.field_150410_aZ);
    }
}

