/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.splicer;

import binnie.core.api.genetics.IGene;
import binnie.core.machines.Machine;
import binnie.core.machines.errors.ErrorState;
import binnie.core.machines.errors.IErrorStateDefinition;
import binnie.core.machines.power.ComponentProcess;
import binnie.core.machines.power.IProcess;
import binnie.genetics.api.IItemSerum;
import binnie.genetics.config.ConfigurationMain;
import binnie.genetics.genetics.Engineering;
import binnie.genetics.machine.GeneticsErrorCode;
import binnie.genetics.machine.splicer.Splicer;
import com.google.common.base.Preconditions;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class SplicerLogic
extends ComponentProcess
implements IProcess {
    public static final int PROCESS_ENERGY = ConfigurationMain.splicerEnergy;
    public static final int PROCESS_LENGTH = ConfigurationMain.splicerTime;
    private int nOfGenes = 0;

    public SplicerLogic(Machine machine) {
        super(machine);
    }

    public static int getProcessLength(int numberOfGenes) {
        int temp;
        float n = numberOfGenes;
        if (n > 1.0f) {
            n = 1.0f + (n - 1.0f) * 0.5f;
        }
        return (temp = (int)((float)PROCESS_LENGTH * n)) != 0 ? temp : 1;
    }

    public static int getProcessEnergy(int numberOfGenes) {
        float n = numberOfGenes;
        if (n > 1.0f) {
            n = 1.0f + (n - 1.0f) * 0.5f;
        }
        return (int)((float)PROCESS_ENERGY * n);
    }

    public static int getGenesToUse(ItemStack serum, ItemStack target) {
        if (serum.func_190926_b() || target.func_190926_b()) {
            return 1;
        }
        IIndividual ind = AlleleManager.alleleRegistry.getIndividual(target);
        IGene[] genes = ((IItemSerum)serum.func_77973_b()).getGenes(serum);
        if (ind.getGenome().getSpeciesRoot() != ((IItemSerum)serum.func_77973_b()).getSpeciesRoot(serum)) {
            return 1;
        }
        int i = 0;
        for (IGene gene : genes) {
            if (ind.getGenome().getActiveAllele(gene.getChromosome()) == gene.getAllele() && ind.getGenome().getInactiveAllele(gene.getChromosome()) == gene.getAllele()) continue;
            ++i;
        }
        return i < 1 ? 1 : i;
    }

    @Override
    public int getProcessLength() {
        int n = this.getNumberOfGenes();
        return SplicerLogic.getProcessLength(n);
    }

    @Override
    public int getProcessEnergy() {
        int n = this.getNumberOfGenes();
        return SplicerLogic.getProcessEnergy(n);
    }

    @Override
    public void onInventoryUpdate() {
        super.onInventoryUpdate();
        ItemStack serum = this.getUtil().getStack(0);
        ItemStack target = this.getUtil().getStack(9);
        this.nOfGenes = SplicerLogic.getGenesToUse(serum, target);
    }

    private int getFullNumberOfGenes() {
        ItemStack serum = this.getUtil().getStack(0);
        if (serum.func_190926_b()) {
            return 1;
        }
        return Engineering.getGenes(serum).length;
    }

    private int getNumberOfGenes() {
        return this.nOfGenes;
    }

    @Override
    public String getTooltip() {
        int n = this.getNumberOfGenes();
        int f = this.getFullNumberOfGenes();
        return "Splicing in " + n + (f > 1 ? "/" + f : "") + " gene" + (n > 1 ? "s" : "");
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().isSlotEmpty(9)) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.NO_INDIVIDUAL, 9);
        }
        ItemStack serum = this.getUtil().getStack(0);
        if (serum.func_190926_b()) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.NO_SERUM, 0);
        }
        ErrorState state = this.isValidSerum();
        if (state != null) {
            return state;
        }
        if (Engineering.getCharges(serum) == 0) {
            return new ErrorState(GeneticsErrorCode.EMPTY_SERUM);
        }
        return super.canWork();
    }

    @Nullable
    public ErrorState isValidSerum() {
        ItemStack serum = this.getUtil().getStack(0);
        if (serum.func_190926_b()) {
            return null;
        }
        ItemStack target = this.getUtil().getStack(9);
        IGene[] genes = Engineering.getGenes(serum);
        if (genes.length == 0) {
            return new ErrorState(GeneticsErrorCode.INVALID_SERUM_NO);
        }
        if (!genes[0].getSpeciesRoot().isMember(target)) {
            return new ErrorState(GeneticsErrorCode.INVALID_SERUM_MISMATCH);
        }
        IIndividual individual = genes[0].getSpeciesRoot().getMember(target);
        boolean hasAll = true;
        for (IGene gene : genes) {
            if (!hasAll) continue;
            IAllele a = individual.getGenome().getActiveAllele(gene.getChromosome());
            IAllele b = individual.getGenome().getInactiveAllele(gene.getChromosome());
            hasAll = hasAll && a.getUID().equals(gene.getAllele().getUID()) && b.getUID().equals(gene.getAllele().getUID());
        }
        if (hasAll) {
            return new ErrorState(GeneticsErrorCode.DEFUNCT_SERUM);
        }
        return null;
    }

    @Override
    protected void onFinishTask() {
        IGene[] genes;
        super.onFinishTask();
        ItemStack serum = this.getUtil().getStack(0);
        Preconditions.checkState((!serum.func_190926_b() ? 1 : 0) != 0);
        ItemStack target = this.getUtil().getStack(9);
        Preconditions.checkState((!target.func_190926_b() ? 1 : 0) != 0);
        for (IGene gene : genes = ((IItemSerum)serum.func_77973_b()).getGenes(serum)) {
            Splicer.setGene(gene, target, true, true);
        }
        this.getUtil().damageItem(serum, 0, 1);
    }
}

