/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.modules;

import binnie.botany.Botany;
import binnie.botany.CreativeTabBotany;
import binnie.botany.api.BotanyAPI;
import binnie.botany.api.gardening.IBlockSoil;
import binnie.botany.api.genetics.EnumFlowerChromosome;
import binnie.botany.api.genetics.EnumFlowerStage;
import binnie.botany.api.genetics.IFlower;
import binnie.botany.api.genetics.IFlowerRoot;
import binnie.botany.blocks.BlockFlower;
import binnie.botany.core.BotanyCore;
import binnie.botany.genetics.FlowerBreedingSystem;
import binnie.botany.genetics.FlowerColorMutations;
import binnie.botany.genetics.FlowerDefinition;
import binnie.botany.genetics.FlowerFactory;
import binnie.botany.genetics.allele.AlleleEffectNone;
import binnie.botany.items.ItemFlowerGE;
import binnie.botany.modules.ModuleGardening;
import binnie.botany.tile.TileEntityFlower;
import binnie.core.Binnie;
import binnie.core.BinnieCore;
import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.modules.BlankModule;
import binnie.core.modules.ModuleManager;
import binnie.core.util.RecipeUtil;
import binnie.core.util.TileUtil;
import forestry.api.apiculture.FlowerManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.modules.ForestryModule;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.IBackpackDefinition;
import forestry.api.storage.IBackpackInterface;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.storage.BackpackDefinition;
import java.awt.Color;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@ForestryModule(moduleID="botany.flowers", containerID="botany", name="Flowers", unlocalizedDescription="botany.module.flowers")
public class ModuleFlowers
extends BlankModule {
    public static final AlleleEffectNone alleleEffectNone = new AlleleEffectNone();
    @Nullable
    public static Item botanistBackpack;
    public static BlockFlower flower;
    public static ItemFlowerGE flowerItem;
    public static ItemFlowerGE seed;
    public static ItemFlowerGE pollen;
    public static IBreedingSystem flowerBreedingSystem;

    public ModuleFlowers() {
        super("botany", "botany.gardening");
    }

    public void setupAPI() {
        BotanyAPI.flowerFactory = new FlowerFactory();
        AlleleManager.alleleRegistry.registerSpeciesRoot((ISpeciesRoot)BotanyCore.getFlowerRoot());
    }

    public void registerItemsAndBlocks() {
        AlleleManager.alleleRegistry.registerAllele((IAllele)alleleEffectNone, new IChromosomeType[0]);
        FlowerColorMutations.registerFlowerColorMutations();
        FlowerDefinition.preInitFlowers();
        IBackpackInterface backpackInterface = BackpackManager.backpackInterface;
        if (ModuleManager.isModuleEnabled("forestry", "backpacks")) {
            Predicate filter = BackpackManager.backpackInterface.createNaturalistBackpackFilter("rootFlowers");
            BackpackDefinition definition = new BackpackDefinition(new Color(16181310), Color.WHITE, filter);
            BackpackManager.backpackInterface.registerBackpackDefinition("botanist", (IBackpackDefinition)definition);
            botanistBackpack = ((Item)backpackInterface.createNaturalistBackpack("botanist", (ISpeciesRoot)BotanyAPI.flowerRoot).setRegistryName("botanist_bag")).func_77655_b("botany.botanist_bag");
            Botany.proxy.registerItem(botanistBackpack);
            botanistBackpack.func_77637_a(CreativeTabBotany.INSTANCE);
        } else {
            botanistBackpack = null;
        }
        flower = new BlockFlower();
        flowerItem = new ItemFlowerGE("itemFlower", EnumFlowerStage.FLOWER, "");
        pollen = new ItemFlowerGE("pollen", EnumFlowerStage.POLLEN, "pollen");
        seed = new ItemFlowerGE("seed", EnumFlowerStage.SEED, "germling");
        Botany.proxy.registerBlock((Block)flower);
        Botany.proxy.registerItem(flowerItem);
        Botany.proxy.registerItem(pollen);
        Botany.proxy.registerItem(seed);
        BinnieCore.getBinnieProxy().registerTileEntity(TileEntityFlower.class, "botany.tile.flower");
    }

    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        flowerBreedingSystem = new FlowerBreedingSystem();
        Binnie.GENETICS.registerBreedingSystem(flowerBreedingSystem);
    }

    public void doInit() {
        if (!ModuleManager.isModuleEnabled("forestry", "apiculture")) {
            try {
                Method createAlleles = ReflectionHelper.findMethod(AlleleHelper.class, (String)"createAlleles", null, (Class[])new Class[]{Class.class, IChromosomeType[].class});
                createAlleles.invoke((Object)AlleleHelper.getInstance(), new Object[]{EnumAllele.Fertility.class, new EnumFlowerChromosome[]{EnumFlowerChromosome.FERTILITY}});
                createAlleles.invoke((Object)AlleleHelper.getInstance(), new Object[]{EnumAllele.Territory.class, new EnumFlowerChromosome[]{EnumFlowerChromosome.TERRITORY}});
                if (!ModuleManager.isModuleEnabled("forestry", "lepidopterology")) {
                    createAlleles.invoke((Object)AlleleHelper.getInstance(), new Object[]{EnumAllele.Tolerance.class, new EnumFlowerChromosome[]{EnumFlowerChromosome.TEMPERATURE_TOLERANCE, EnumFlowerChromosome.HUMIDITY_TOLERANCE}});
                    createAlleles.invoke((Object)AlleleHelper.getInstance(), new Object[]{EnumAllele.Lifespan.class, new EnumFlowerChromosome[]{EnumFlowerChromosome.LIFESPAN}});
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to find method 'createAlleles' of the " + AlleleHelper.class, e);
            }
        }
        FlowerColorMutations.registerFlowerColorAlleles();
        FlowerDefinition.initFlowers();
        RecipeUtil recipeUtil = new RecipeUtil("botany");
        if (FlowerManager.flowerRegistry != null) {
            FlowerManager.flowerRegistry.registerAcceptableFlower((Block)flower, new String[]{"flowersVanilla"});
        }
        recipeUtil.addRecipe("botanist_backpack", botanistBackpack, new Object[]{"X#X", "VYZ", "X#X", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('X'), Items.field_151007_F, Character.valueOf('V'), ModuleGardening.soilMeter, Character.valueOf('Z'), "toolTrowel", Character.valueOf('Y'), "chestWood"});
    }

    @SubscribeEvent
    public void onShearFlower(PlayerInteractEvent.RightClickBlock event) {
        IFlower pollen;
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_190926_b()) {
            return;
        }
        TileEntity tile = event.getWorld().func_175625_s(event.getPos());
        if (!(tile instanceof TileEntityFlower)) {
            return;
        }
        TileEntityFlower flower = (TileEntityFlower)tile;
        if (heldItem.func_77973_b() == Items.field_151097_aZ) {
            flower.onShear();
            heldItem.func_77972_a(1, (EntityLivingBase)player);
        } else if (heldItem.func_77973_b() == ModuleFlowers.pollen && (pollen = BotanyCore.getFlowerRoot().getMember(heldItem)) != null && flower.canMateWith(pollen)) {
            flower.mateWith(pollen);
            if (!player.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
        }
    }

    @SubscribeEvent
    public void plantVanilla(BlockEvent.PlaceEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (!BotanyCore.getGardening().isSoil(block)) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        ItemStack heldItem = player.func_184586_b(event.getHand());
        IFlowerRoot flowerRoot = BotanyCore.getFlowerRoot();
        IFlower flower = flowerRoot.getConversion(heldItem);
        if (flower != null) {
            flowerRoot.plant(world, pos, flower, player.func_146103_bH());
        }
    }

    @Deprecated
    public void onPlantVanilla(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        ItemStack heldItem = player.func_184614_ca();
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (heldItem.func_190926_b()) {
            return;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        int py = -1;
        if (block instanceof IBlockSoil && (world.func_175623_d(pos.func_177984_a()) || block.func_176200_f((IBlockAccess)world, pos))) {
            py = 1;
        }
        if (py < 0) {
            return;
        }
        IFlowerRoot flowerRoot = BotanyCore.getFlowerRoot();
        IFlower flower = flowerRoot.getConversion(heldItem);
        if (flower != null && flowerRoot.plant(world, pos.func_177982_a(0, py, 0), flower, player.func_146103_bH()) && !player.field_71075_bZ.field_75098_d) {
            heldItem.func_190918_g(1);
        }
    }

    @SubscribeEvent
    public void onBonemeal(BonemealEvent event) {
        BlockPos pos = event.getPos();
        TileEntityFlower tile = TileUtil.getTile((IBlockAccess)event.getWorld(), pos, TileEntityFlower.class);
        if (tile != null && tile.onBonemeal()) {
            event.setResult(Event.Result.ALLOW);
        }
    }
}

