/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.liquid;

import binnie.core.liquid.FluidContainerType;
import binnie.core.liquid.FluidType;
import binnie.core.liquid.IFluidDefinition;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.alcohol.CocktailLiquid;
import binnie.extratrees.alcohol.ICocktailIngredient;
import binnie.extratrees.alcohol.ICocktailIngredientProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public enum Liqueur implements IFluidDefinition,
ICocktailIngredientProvider
{
    Almond("liqueur.almond", 14966063, 0.3, 0.2f),
    Orange("liqueur.orange", 16353536, 0.4, 0.2f),
    Banana("liqueur.banana", 16302592, 0.5, 0.2f),
    Chocolate("liqueur.chocolate", 12667680, 0.3, 0.2f),
    Mint("liqueur.mint", 2737788, 0.4, 0.2f),
    Hazelnut("liqueur.hazelnut", 15570987, 0.3, 0.2f),
    Cinnamon("liqueur.cinnamon", 0xE55000, 0.3, 0.2f),
    Coffee("liqueur.coffee", 9847577, 0.4, 0.2f),
    Melon("liqueur.melon", 11584049, 0.4, 0.2f),
    Anise("liqueur.anise", 14344681, 0.3, 0.2f),
    Peach("liqueur.peach", 16684384, 0.4, 0.2f),
    Lemon("liqueur.lemon", 16311405, 0.4, 0.2f),
    Herbal("liqueur.herbal", 16700673, 0.3, 0.2f),
    Cherry("liqueur.cherry", 14096641, 0.5, 0.2f),
    Blackcurrant("liqueur.blackcurrant", 6962541, 0.5, 0.2f),
    Blackberry("liqueur.blackberry", 6837581, 0.5, 0.2f),
    Raspberry("liqueur.raspberry", 10158848, 0.5, 0.2f);

    private final float abv;
    private final FluidType type;
    private final CocktailLiquid cocktailLiquid;

    private Liqueur(String ident, int color, double transparency, float abv) {
        this.abv = abv;
        this.type = new FluidType(ident, String.format("%s.fluid.%s.%s", ExtraTrees.instance.getModId(), "Liqueur", this.name()), color).setTransparency(transparency).setTextures(new ResourceLocation("extratrees", "blocks/liquids/liquid")).setShowHandler(type -> type == FluidContainerType.GLASS);
        this.cocktailLiquid = new CocktailLiquid(this.type, abv);
    }

    private void addFlavour(String oreDict) {
    }

    public String toString() {
        return this.type.toString();
    }

    @Override
    public FluidStack get(int amount) {
        return this.type.get(amount);
    }

    @Override
    public FluidType getType() {
        return this.type;
    }

    @Override
    public ICocktailIngredient getIngredient() {
        return this.cocktailLiquid;
    }

    static {
        Almond.addFlavour("cropAlmond");
        Orange.addFlavour("cropOrange");
        Banana.addFlavour("cropBanana");
        Chocolate.addFlavour("cropCocoa");
        Mint.addFlavour("cropMint");
        Hazelnut.addFlavour("cropHazelnut");
        Cinnamon.addFlavour("cropCinnamon");
        Coffee.addFlavour("cropCoffee");
        Melon.addFlavour("cropMelon");
        Anise.addFlavour("cropAnise");
        Peach.addFlavour("cropPeach");
        Lemon.addFlavour("cropLemon");
        Herbal.addFlavour("cropHerbal");
        Cherry.addFlavour("cropCherry");
        Blackcurrant.addFlavour("cropBlackcurrant");
        Blackberry.addFlavour("cropBlackberry");
        Raspberry.addFlavour("cropRaspberry");
    }
}

