/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.incubator;

import binnie.core.machines.Machine;
import binnie.core.machines.errors.CoreErrorCode;
import binnie.core.machines.errors.ErrorState;
import binnie.core.machines.errors.IErrorStateDefinition;
import binnie.core.machines.power.ComponentProcessIndefinate;
import binnie.core.machines.power.IProcess;
import binnie.core.machines.transfer.TransferRequest;
import binnie.core.machines.transfer.TransferResult;
import binnie.genetics.config.ConfigurationMain;
import binnie.genetics.machine.GeneticsErrorCode;
import binnie.genetics.machine.incubator.IIncubatorRecipe;
import binnie.genetics.machine.incubator.Incubator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class IncubatorLogic
extends ComponentProcessIndefinate
implements IProcess {
    @Nullable
    private IIncubatorRecipe recipe = null;
    private final Random rand = new Random();
    private boolean roomForOutput = true;

    public IncubatorLogic(Machine machine) {
        super(machine, ConfigurationMain.incubatorEnergy);
    }

    private static boolean isStackValid(ItemStack stack, IIncubatorRecipe recipe) {
        return OreDictionary.itemMatches((ItemStack)recipe.getInputStack(), (ItemStack)stack, (boolean)false);
    }

    @Override
    public ErrorState canWork() {
        if (this.recipe == null) {
            return new ErrorState(CoreErrorCode.NO_RECIPE);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        if (this.recipe != null) {
            if (!this.recipe.isInputLiquidSufficient(this.getUtil().getFluid(0))) {
                return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.INCUBATOR_INSUFFICIENT_LIQUID, 0);
            }
            if (!this.roomForOutput) {
                return new ErrorState((IErrorStateDefinition)CoreErrorCode.NO_SPACE_TANK, 1);
            }
        }
        return super.canProgress();
    }

    @Override
    protected void onTickTask() {
        if (this.recipe != null && this.rand.nextInt(20) == 0 && this.rand.nextFloat() < this.recipe.getChance()) {
            this.recipe.doTask(this.getUtil());
        }
    }

    @Override
    public boolean inProgress() {
        return this.recipe != null;
    }

    @Nullable
    private IIncubatorRecipe getRecipe(ItemStack stack, FluidStack liquid) {
        for (IIncubatorRecipe recipe : Incubator.getRecipes()) {
            boolean rightLiquid = recipe.isInputLiquid(liquid);
            boolean rightItem = IncubatorLogic.isStackValid(stack, recipe);
            if (!rightLiquid || !rightItem) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public void onInventoryUpdate() {
        super.onInventoryUpdate();
        if (!this.getUtil().isServer()) {
            return;
        }
        FluidStack liquid = this.getUtil().getFluid(0);
        ItemStack incubator = this.getUtil().getStack(3);
        this.checkAvailability(liquid, incubator);
        this.addSameFromInputToIncubator(incubator);
        if (this.recipe == null && liquid != null) {
            IIncubatorRecipe recipe;
            if (!incubator.func_190926_b() && (recipe = this.getRecipe(incubator, liquid)) != null) {
                this.recipe = recipe;
                return;
            }
            IIncubatorRecipe potential = null;
            int potentialSlot = 0;
            for (int slot : Incubator.SLOT_QUEUE) {
                ItemStack stack = this.getUtil().getStack(slot);
                if (stack.func_190926_b()) continue;
                for (IIncubatorRecipe recipe2 : Incubator.getRecipes()) {
                    boolean rightLiquid = recipe2.isInputLiquid(liquid);
                    boolean rightItem = IncubatorLogic.isStackValid(stack, recipe2);
                    if (!rightLiquid || !rightItem) continue;
                    potential = recipe2;
                    potentialSlot = slot;
                    break;
                }
                if (potential != null) break;
            }
            if (potential != null && this.tryEmptyIncubator(incubator)) {
                this.recipe = potential;
                ItemStack stack2 = this.getUtil().getStack(potentialSlot);
                this.getUtil().setStack(potentialSlot, ItemStack.field_190927_a);
                this.getUtil().setStack(3, stack2);
            }
        }
        if (this.recipe != null) {
            this.roomForOutput = this.recipe.roomForOutput(this.getUtil());
        }
    }

    private void addSameFromInputToIncubator(ItemStack incubator) {
        if (incubator.func_190926_b() || incubator.func_190916_E() == incubator.func_77976_d()) {
            return;
        }
        for (int slot : Incubator.SLOT_QUEUE) {
            ItemStack stack = this.getUtil().getStack(slot);
            if (stack.func_190926_b()) continue;
            NonNullList<ItemStack> result = TransferRequest.mergeStacks(stack, incubator);
            this.getUtil().setStack(slot, (ItemStack)result.get(0));
            this.getUtil().setStack(3, (ItemStack)result.get(1));
            if (incubator.func_190916_E() == incubator.func_77976_d()) break;
        }
    }

    private void checkAvailability(@Nullable FluidStack liquid, ItemStack incubator) {
        if (!(this.recipe == null || !incubator.func_190926_b() && liquid != null && this.recipe.isInputLiquid(liquid) && IncubatorLogic.isStackValid(incubator, this.recipe))) {
            this.recipe = null;
            this.tryEmptyIncubator(incubator);
        }
    }

    private boolean tryEmptyIncubator(ItemStack incubator) {
        NonNullList<ItemStack> results;
        if (incubator.func_190926_b()) {
            return true;
        }
        TransferRequest transferRequest = new TransferRequest(incubator, this.getInventory()).setTargetSlots(Incubator.SLOT_OUTPUT).ignoreValidation();
        TransferResult transferResult = transferRequest.transfer(null, true);
        if (transferResult.isSuccess() && (results = transferResult.getRemaining()).size() == 1) {
            ItemStack leftover = (ItemStack)results.get(0);
            this.getUtil().setStack(3, leftover);
            return leftover.func_190926_b();
        }
        return false;
    }
}

