/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics;

import binnie.core.genetics.ForestryAllele;
import binnie.extratrees.gen.WorldGenAlder;
import binnie.extratrees.gen.WorldGenApple;
import binnie.extratrees.gen.WorldGenAsh;
import binnie.extratrees.gen.WorldGenBanana;
import binnie.extratrees.gen.WorldGenBeech;
import binnie.extratrees.gen.WorldGenConifer;
import binnie.extratrees.gen.WorldGenEucalyptus;
import binnie.extratrees.gen.WorldGenFir;
import binnie.extratrees.gen.WorldGenHolly;
import binnie.extratrees.gen.WorldGenJungle;
import binnie.extratrees.gen.WorldGenLazy;
import binnie.extratrees.gen.WorldGenMaple;
import binnie.extratrees.gen.WorldGenPalm;
import binnie.extratrees.gen.WorldGenPoplar;
import binnie.extratrees.gen.WorldGenShrub;
import binnie.extratrees.gen.WorldGenSorbus;
import binnie.extratrees.gen.WorldGenTree;
import binnie.extratrees.gen.WorldGenTree2;
import binnie.extratrees.gen.WorldGenTree3;
import binnie.extratrees.gen.WorldGenTropical;
import binnie.extratrees.gen.WorldGenWalnut;
import binnie.extratrees.genetics.AlleleETFruitDefinition;
import binnie.extratrees.genetics.ETLeafProvider;
import binnie.extratrees.genetics.EnumSaplingType;
import binnie.extratrees.genetics.WoodProvider;
import binnie.extratrees.genetics.fruits.ETFruitFamily;
import binnie.extratrees.wood.EnumETLog;
import binnie.extratrees.wood.EnumShrubLog;
import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumLeafType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IAlleleTreeSpeciesBuilder;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.IGrowthProvider;
import forestry.api.arboriculture.ILeafProvider;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenerator;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.IWoodProvider;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.ModuleArboriculture;
import forestry.arboriculture.genetics.ClimateGrowthProvider;
import forestry.arboriculture.genetics.ITreeDefinition;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.arboriculture.worldgen.WorldGenLemon;
import forestry.arboriculture.worldgen.WorldGenPlum;
import forestry.core.genetics.alleles.AlleleBoolean;
import forestry.core.tiles.TileUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.commons.lang3.StringUtils;

public enum ETTreeDefinition implements IStringSerializable,
ITreeDefinition,
ITreeGenerator
{
    OrchardApple("malus", "domestica", EnumLeafType.DECIDUOUS, new Color(648830), new Color(16751859), EnumSaplingType.Default, EnumETLog.Apple, new Color(0x7B7A7B)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenApple.OrchardApple(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Apple.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Higher.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    SweetCrabapple("malus", "coronaria", EnumLeafType.DECIDUOUS, new Color(8034643), new Color(16528799), EnumSaplingType.Default, EnumETLog.Apple, new Color(0x7B7A7B)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenApple.SweetCrabapple(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Crabapple.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.High.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Average.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    FloweringCrabapple("malus", "hopa", EnumLeafType.DECIDUOUS, new Color(8034643), new Color(16528799), EnumSaplingType.Default, EnumETLog.Apple, new Color(0x7B7A7B)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenApple.FloweringCrabapple(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Crabapple.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Average.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    PrairieCrabapple("malus", "ioensis", EnumLeafType.DECIDUOUS, new Color(8034643), new Color(16528799), EnumSaplingType.Default, EnumETLog.Apple, new Color(0x7B7A7B)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenApple.PrairieCrabapple(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Crabapple.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Average.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Blackthorn("prunus", "spinosa", EnumLeafType.DECIDUOUS, new Color(7180062), new Color(16746439), EnumSaplingType.Fruit, (IWoodType)EnumForestryWoodType.PLUM, new Color(11961953)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenPlum(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Blackthorn.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Low.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Average.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    CherryPlum("prunus", "cerasifera", EnumLeafType.DECIDUOUS, new Color(7180062), new Color(16746439), EnumSaplingType.Fruit, (IWoodType)EnumForestryWoodType.PLUM, new Color(11961953)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenPlum(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.CherryPlum.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Lower.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Average.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Peach("prunus", "persica", EnumLeafType.DECIDUOUS, new Color(7180062), new Color(16721562), EnumSaplingType.Fruit, (IWoodType)EnumForestryWoodType.PLUM, new Color(11961953)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenPlum(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Peach.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Average.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Nectarine("prunus", "nectarina", EnumLeafType.DECIDUOUS, new Color(7180062), new Color(16721562), EnumSaplingType.Fruit, (IWoodType)EnumForestryWoodType.PLUM, new Color(11961953)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenPlum(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Nectarine.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Average.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Apricot("prunus", "armeniaca", EnumLeafType.DECIDUOUS, new Color(7180062), new Color(16103640), EnumSaplingType.Fruit, (IWoodType)EnumForestryWoodType.PLUM, new Color(11961953)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenPlum(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Apricot.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Low.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Average.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Almond("prunus", "amygdalus", EnumLeafType.DECIDUOUS, new Color(7180062), new Color(16090304), EnumSaplingType.Fruit, (IWoodType)EnumForestryWoodType.PLUM, new Color(11961953)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenPlum(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Almond.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Lower.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    WildCherry("prunus", "avium", EnumLeafType.DECIDUOUS, new Color(7180062), new Color(16247798), EnumSaplingType.Fruit, EnumETLog.Cherry, new Color(7432272)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenPlum(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.WildCherry.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Lower.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
            species.setTemperature(EnumTemperature.NORMAL);
            species.setRarity(0.0015f);
            species.setGrowthProvider((IGrowthProvider)new ClimateGrowthProvider(EnumTemperature.NORMAL, EnumTolerance.BOTH_1, EnumHumidity.NORMAL, EnumTolerance.NONE));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    SourCherry("prunus", "cerasus", EnumLeafType.DECIDUOUS, new Color(7180062), new Color(16247798), EnumSaplingType.Fruit, EnumETLog.Cherry, new Color(7432272)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenPlum(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.SourCherry.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Lower.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    BlackCherry("prunus", "serotina", EnumLeafType.DECIDUOUS, new Color(7180062), new Color(16441848), EnumSaplingType.Fruit, EnumETLog.Cherry, new Color(7432272)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenPlum(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.BlackCherry.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Lowest.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Orange("citrus", "sinensis", EnumLeafType.JUNGLE, new Color(8957780), new Color(10729552), EnumSaplingType.Fruit, (IWoodType)EnumForestryWoodType.CITRUS, new Color(5983033)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLemon(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Orange.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Average.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Manderin("citrus", "reticulata", EnumLeafType.JUNGLE, new Color(8957780), new Color(10729552), EnumSaplingType.Fruit, (IWoodType)EnumForestryWoodType.CITRUS, new Color(5983033)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLemon(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Manderin.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.High.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Satsuma("citrus", "unshiu", EnumLeafType.JUNGLE, new Color(8957780), new Color(10729552), EnumSaplingType.Fruit, (IWoodType)EnumForestryWoodType.CITRUS, new Color(5983033)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLemon(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Satsuma.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Low.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Tangerine("citrus", "tangerina", EnumLeafType.JUNGLE, new Color(8957780), new Color(10729552), EnumSaplingType.Fruit, (IWoodType)EnumForestryWoodType.CITRUS, new Color(5983033)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLemon(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Tangerine.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Average.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Faster.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Lime("citrus", "latifolia", EnumLeafType.JUNGLE, new Color(8957780), new Color(10729552), EnumSaplingType.Fruit, (IWoodType)EnumForestryWoodType.CITRUS, new Color(5983033)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLemon(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Lime.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    KeyLime("citrus", "aurantifolia", EnumLeafType.JUNGLE, new Color(8957780), new Color(10729552), EnumSaplingType.Fruit, (IWoodType)EnumForestryWoodType.CITRUS, new Color(5983033)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLemon(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.KeyLime.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Lowest.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    FingerLime("citrus", "australasica", EnumLeafType.JUNGLE, new Color(8957780), new Color(10729552), EnumSaplingType.Fruit, (IWoodType)EnumForestryWoodType.CITRUS, new Color(5983033)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLemon(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.FingerLime.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.High.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Pomelo("citrus", "maxima", EnumLeafType.JUNGLE, new Color(8957780), new Color(10729552), EnumSaplingType.Fruit, (IWoodType)EnumForestryWoodType.CITRUS, new Color(5983033)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLemon(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Pomelo.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Grapefruit("citrus", "paradisi", EnumLeafType.JUNGLE, new Color(8957780), new Color(10729552), EnumSaplingType.Fruit, (IWoodType)EnumForestryWoodType.CITRUS, new Color(5983033)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLemon(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Grapefruit.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Kumquat("citrus", "margarita", EnumLeafType.JUNGLE, new Color(8957780), new Color(10729552), EnumSaplingType.Fruit, (IWoodType)EnumForestryWoodType.CITRUS, new Color(5983033)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLemon(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Kumquat.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.High.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Citron("citrus", "medica", EnumLeafType.JUNGLE, new Color(8957780), new Color(10729552), EnumSaplingType.Fruit, (IWoodType)EnumForestryWoodType.CITRUS, new Color(5983033)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLemon(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Citron.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.High.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Average.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    BuddhaHand("citrus", "sarcodactylus", EnumLeafType.JUNGLE, new Color(8957780), new Color(10729552), EnumSaplingType.Fruit, (IWoodType)EnumForestryWoodType.CITRUS, new Color(5983033)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLemon(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.BuddhaHand.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Banana("musa", "sinensis", EnumLeafType.PALM, new Color(10603918), new Color(4515072), EnumSaplingType.Default, EnumETLog.Banana, new Color(8753743)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenBanana(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Banana.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Low.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
        }
    }
    ,
    RedBanana("musa", "rubra", EnumLeafType.PALM, new Color(10603918), new Color(4515072), EnumSaplingType.Default, EnumETLog.Banana, new Color(8753743)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenBanana(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.RedBanana.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
        }
    }
    ,
    Plantain("musa", "paradisiaca", EnumLeafType.PALM, new Color(10603918), new Color(4515072), EnumSaplingType.Default, EnumETLog.Banana, new Color(8753743)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenBanana(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Plantain.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Average.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Lower.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
        }
    }
    ,
    Butternut("juglans", "cinerea", EnumLeafType.DECIDUOUS, new Color(8566156), new Color(8576396), EnumSaplingType.Default, EnumETLog.Butternut, new Color(12037536)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenWalnut.Butternut(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Butternut.getAllele());
            template.set(EnumTreeChromosome.GIRTH, ForestryAllele.Int.Int2.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smaller.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Low.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Rowan("sorbus", "aucuparia", EnumLeafType.DECIDUOUS, new Color(10405787), new Color(10414258), EnumSaplingType.Default, EnumETLog.Rowan, new Color(11972763)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenSorbus.Rowan(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Larger.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.BERRY);
        }
    }
    ,
    Hemlock("tsuga", "heterophylla", EnumLeafType.CONIFERS, new Color(6073458), new Color(6082930), EnumSaplingType.Default, EnumETLog.Hemlock, new Color(11379611)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenConifer.WesternHemlock(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Average.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Slower.getAllele());
            template.set(EnumTreeChromosome.GIRTH, ForestryAllele.Int.Int2.getAllele());
        }
    }
    ,
    Ash("fraxinus", "excelsior", EnumLeafType.DECIDUOUS, new Color(4754987), new Color(4777003), EnumSaplingType.Default, EnumETLog.Ash, new Color(0x898982)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenAsh.CommonAsh(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }
    }
    ,
    Alder("alnus", "glutinosa", EnumLeafType.DECIDUOUS, new Color(6916659), new Color(6925875), EnumSaplingType.Default, EnumETLog.Alder, new Color(13025464)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenAlder.CommonAlder(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }
    }
    ,
    Beech("fagus", "sylvatica", EnumLeafType.DECIDUOUS, new Color(8626252), new Color(8635980), EnumSaplingType.Default, EnumETLog.Beech, new Color(11702654)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenBeech.CommonBeech(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Beechnut.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Average.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Lower.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    CopperBeech("fagus", "purpurea", EnumLeafType.DECIDUOUS, new Color(8393496), new Color(13720397), EnumSaplingType.Default, EnumETLog.Beech, new Color(11702654)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenBeech.CopperBeech(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Beechnut.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Slow.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Aspen("populus", "tremula", EnumLeafType.DECIDUOUS, new Color(9096247), new Color(9101711), EnumSaplingType.Default, (IWoodType)EnumForestryWoodType.POPLAR, new Color(9217671)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenPoplar.Aspen(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }
    }
    ,
    Yew("taxus", "baccata", EnumLeafType.CONIFERS, new Color(9734733), new Color(9743949), EnumSaplingType.Default, EnumETLog.Yew, new Color(13745089)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenConifer.Yew(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Large.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
        }
    }
    ,
    Cypress("chamaecyparis", "lawsoniana", EnumLeafType.CONIFERS, new Color(9030055), new Color(9035206), EnumSaplingType.Poplar, EnumETLog.Cypress, new Color(10126467)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenConifer.Cypress(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Larger.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Slow.getAllele());
        }
    }
    ,
    DouglasFir("pseudotsuga", "menziesii", EnumLeafType.CONIFERS, new Color(10073474), new Color(10080682), EnumSaplingType.Default, EnumETLog.Fir, new Color(0x828382)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenFir.DouglasFir(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.GIRTH, ForestryAllele.Int.Int2.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smaller.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Slower.getAllele());
        }
    }
    ,
    Hazel("Corylus", "avellana", EnumLeafType.DECIDUOUS, new Color(10204498), new Color(10215762), EnumSaplingType.Default, EnumETLog.Hazel, new Color(11180143)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTree3.Hazel(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Hazelnut.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Average.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Low.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Sycamore("ficus", "sycomorus", EnumLeafType.DECIDUOUS, new Color(10528047), new Color(11851100), EnumSaplingType.Default, EnumETLog.Fig, new Color(8418135)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTree3.Sycamore(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Fig.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Lowest.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Whitebeam("sorbus", "aria", EnumLeafType.DECIDUOUS, new Color(12242585), new Color(7505471), EnumSaplingType.Default, EnumETLog.Whitebeam, new Color(7891565)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenSorbus.Whitebeam(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smaller.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
        }
    }
    ,
    Hawthorn("crataegus", "monogyna", EnumLeafType.DECIDUOUS, new Color(7055434), new Color(10008443), EnumSaplingType.Default, EnumETLog.Hawthorn, new Color(6248261)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTree3.Hawthorn(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Average.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }
    }
    ,
    Pecan("carya", "illinoinensis", EnumLeafType.DECIDUOUS, new Color(8762996), new Color(2906139), EnumSaplingType.Default, EnumETLog.Hickory, new Color(4076848)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTree3.Pecan(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Pecan.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Large.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Slow.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Elm("ulmus", "procera", EnumLeafType.DECIDUOUS, new Color(8163400), new Color(8175176), EnumSaplingType.Default, EnumETLog.Elm, new Color(8684422)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTree3.Elm(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smaller.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Average.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
        }
    }
    ,
    Elder("sambucus", "nigra", EnumLeafType.DECIDUOUS, new Color(11450483), new Color(14739389), EnumSaplingType.Default, EnumETLog.Elder, new Color(14202996)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTree3.Elder(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Elderberry.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smaller.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.BERRY);
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Holly("ilex", "aquifolium", EnumLeafType.DECIDUOUS, new Color(2444108), new Color(7246468), EnumSaplingType.Default, EnumETLog.Holly, new Color(11905669)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenHolly.Holly(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }
    }
    ,
    Hornbeam("carpinus", "betulus", EnumLeafType.DECIDUOUS, new Color(9873179), new Color(9887003), EnumSaplingType.Default, EnumETLog.Hornbeam, new Color(10719862)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTree3.Hornbeam(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smaller.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Slow.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }
    }
    ,
    Sallow("salix", "caprea", EnumLeafType.WILLOW, new Color(11449123), new Color(12053541), EnumSaplingType.Default, (IWoodType)EnumForestryWoodType.WILLOW, new Color(10590869)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTree3.Sallow(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Large.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }
    }
    ,
    AcornOak("quercus", "robur", EnumLeafType.DECIDUOUS, new Color(6714174), new Color(10396209), EnumSaplingType.Default, (IWoodType)EnumVanillaWoodType.OAK, new Color(6376752)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTree3.AcornOak(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Acorn.getAllele());
            template.set(EnumTreeChromosome.GIRTH, ForestryAllele.Int.Int2.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Large.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Low.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Fir("abies", "alba", EnumLeafType.CONIFERS, new Color(7306272), new Color(7328032), EnumSaplingType.Default, EnumETLog.Fir, new Color(0x828382)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenFir.SilverFir(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Large.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Slow.getAllele());
        }
    }
    ,
    Cedar("cedrus", "libani", EnumLeafType.CONIFERS, new Color(9806704), new Color(9824368), EnumSaplingType.Default, EnumETLog.Cedar, new Color(11368015)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenConifer.Cedar(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.GIRTH, ForestryAllele.Int.Int2.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smaller.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Slower.getAllele());
        }
    }
    ,
    Olive("olea", "europaea", EnumLeafType.DECIDUOUS, new Color(3950644), new Color(3950644), EnumSaplingType.Default, EnumETLog.Olive, new Color(8089706)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTree2.Olive(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Olive.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    RedMaple("acer", "ubrum", EnumLeafType.MAPLE, new Color(15216151), new Color(15216151), EnumSaplingType.Default, (IWoodType)EnumForestryWoodType.MAPLE, new Color(9078657)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenMaple.RedMaple(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.High.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }
    }
    ,
    BalsamFir("abies", "balsamea", EnumLeafType.CONIFERS, new Color(7643260), new Color(7643260), EnumSaplingType.Default, EnumETLog.Fir, new Color(0x828382)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenFir.BalsamFir(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Slow.getAllele());
        }
    }
    ,
    LoblollyPine("pinus", "taeda", EnumLeafType.CONIFERS, new Color(7309895), new Color(7309895), EnumSaplingType.Default, (IWoodType)EnumForestryWoodType.PINE, new Color(7558729)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenConifer.LoblollyPine(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smaller.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Slow.getAllele());
        }
    }
    ,
    Sweetgum("liquidambar", "styraciflua", EnumLeafType.DECIDUOUS, new Color(9144162), new Color(9144162), EnumSaplingType.Default, EnumETLog.Sweetgum, new Color(10592668)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTree2.Sweetgum(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Average.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.High.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Low.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Average.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }
    }
    ,
    Locust("robinia", "pseudoacacia", EnumLeafType.DECIDUOUS, new Color(8942336), new Color(8942336), EnumSaplingType.Default, EnumETLog.Locust, new Color(11381948)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTree2.Locust(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }
    }
    ,
    Pear("pyrus", "communis", EnumLeafType.DECIDUOUS, new Color(6195238), new Color(6195238), EnumSaplingType.Default, EnumETLog.Pear, new Color(11048825)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTree2.Pear(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Pear.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smaller.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.High.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    OsangeOrange("maclura", "pomifera", EnumLeafType.JUNGLE, new Color(6847056), new Color(6847056), EnumSaplingType.Default, EnumETLog.Maclura, new Color(9131828)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenJungle.OsangeOsange(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.OsangeOsange.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Lower.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    OldFustic("maclura", "tinctoria", EnumLeafType.JUNGLE, new Color(6847056), new Color(6847056), EnumSaplingType.Default, EnumETLog.Maclura, new Color(9131828)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenJungle.OldFustic(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smaller.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
        }
    }
    ,
    Brazilwood("caesalpinia", "echinata", EnumLeafType.JUNGLE, new Color(6321241), new Color(6321241), EnumSaplingType.Default, EnumETLog.Brazilwood, new Color(10387560)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenJungle.Brazilwood(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smaller.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Lower.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
        }
    }
    ,
    Logwood("haematoxylum", "campechianum", EnumLeafType.JUNGLE, new Color(8953707), new Color(8953707), EnumSaplingType.Default, EnumETLog.Logwood, new Color(16376530)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenJungle.Logwood(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Average.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
        }
    }
    ,
    Rosewood("dalbergia", "latifolia", EnumLeafType.JUNGLE, new Color(8887074), new Color(8887074), EnumSaplingType.Default, EnumETLog.Rosewood, new Color(0x998666)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenJungle.Rosewood(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lowest.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
        }
    }
    ,
    Purpleheart("peltogyne", "spp", EnumLeafType.JUNGLE, new Color(7835477), new Color(7835477), EnumSaplingType.Default, EnumETLog.Purpleheart, new Color(9671330)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenJungle.Purpleheart(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Large.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
        }
    }
    ,
    Iroko("milicia", "excelsa", EnumLeafType.DECIDUOUS, new Color(11520108), new Color(11520108), EnumSaplingType.Default, EnumETLog.Iroko, new Color(6315099)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTree2.Iroko(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Average.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }
    }
    ,
    Gingko("ginkgo", "biloba", EnumLeafType.JUNGLE, new Color(7444049), new Color(7444049), EnumSaplingType.Default, EnumETLog.Gingko, new Color(11382428)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTree2.Gingko(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.GingkoNut.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Large.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Lower.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Brazilnut("bertholletia", "excelsa", EnumLeafType.JUNGLE, new Color(8163195), new Color(8163195), EnumSaplingType.Default, (IWoodType)EnumVanillaWoodType.JUNGLE, new Color(5456154)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenJungle.BrazilNut(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.BrazilNut.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Larger.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Low.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    RoseGum("eucalyptus", "grandis", EnumLeafType.JUNGLE, new Color(10265176), new Color(10265176), EnumSaplingType.Default, EnumETLog.Eucalyptus, new Color(0xEADEDA)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenEucalyptus.RoseGum(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Largest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Lower.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Slowest.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
        }
    }
    ,
    SwampGum("eucalyptus", "grandis", EnumLeafType.JUNGLE, new Color(10667654), new Color(10667654), EnumSaplingType.Default, EnumETLog.Eucalyptus2, new Color(8814181)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenEucalyptus.SwampGum(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.GIRTH, ForestryAllele.Int.Int2.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Lowest.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Slower.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
        }
    }
    ,
    Box("boxus", "sempervirens", EnumLeafType.DECIDUOUS, new Color(7510381), new Color(7510381), EnumSaplingType.Default, EnumETLog.Box, new Color(11235159)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTree2.Box(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smaller.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Faster.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }
    }
    ,
    Clove("syzygium", "aromaticum", EnumLeafType.DECIDUOUS, new Color(8028703), new Color(8028703), EnumSaplingType.Default, EnumETLog.Syzgium, new Color(11235159)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTree2.Clove(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Clove.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smaller.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.High.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Coffee("coffea", "arabica", EnumLeafType.JUNGLE, new Color(7311461), new Color(7311461), EnumSaplingType.Default, (IWoodType)EnumVanillaWoodType.JUNGLE, new Color(5456154)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenJungle.Coffee(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Coffee.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Large.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    MonkeyPuzzle("araucaria", "araucana", EnumLeafType.CONIFERS, new Color(5726552), new Color(5726552), EnumSaplingType.Default, (IWoodType)EnumForestryWoodType.PINE, new Color(7558729)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenConifer.MonkeyPuzzle(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.GIRTH, ForestryAllele.Int.Int2.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Average.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Lower.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }
    }
    ,
    RainbowGum("eucalyptus", "deglupta", EnumLeafType.JUNGLE, new Color(12054565), new Color(12054565), EnumSaplingType.Default, EnumETLog.Eucalyptus3, new Color(7123007)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenEucalyptus.RainbowGum(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Lower.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }
    }
    ,
    PinkIvory("berchemia", "zeyheri", EnumLeafType.DECIDUOUS, new Color(8163673), new Color(8163673), EnumSaplingType.Default, EnumETLog.PinkIvory, new Color(8349012)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTree(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }
    }
    ,
    Blackcurrant("ribes", "nigrum", EnumLeafType.DECIDUOUS, new Color(10934876), new Color(10934876), EnumSaplingType.Shrub, EnumShrubLog.INSTANCE, new Color(0xFFFFFF)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenShrub.Shrub(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Blackcurrant.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Faster.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.BERRY);
            species.setRarity(0.0025f);
            species.setGrowthProvider((IGrowthProvider)new ClimateGrowthProvider(EnumTemperature.NORMAL, EnumTolerance.BOTH_1, EnumHumidity.NORMAL, EnumTolerance.NONE));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Redcurrant("ribes", "rubrum", EnumLeafType.DECIDUOUS, new Color(7646208), new Color(7646208), EnumSaplingType.Shrub, EnumShrubLog.INSTANCE, new Color(0xFFFFFF)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenShrub.Shrub(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Redcurrant.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Average.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Faster.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.BERRY);
            species.setRarity(0.0025f);
            species.setGrowthProvider((IGrowthProvider)new ClimateGrowthProvider(EnumTemperature.NORMAL, EnumTolerance.BOTH_1, EnumHumidity.NORMAL, EnumTolerance.NONE));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Blackberry("rubus", "fruticosus", EnumLeafType.DECIDUOUS, new Color(9617755), new Color(9617755), EnumSaplingType.Shrub, EnumShrubLog.INSTANCE, new Color(0xFFFFFF)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenShrub.Shrub(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Blackberry.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.High.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Faster.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.BERRY);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Raspberry("rubus", "idaeus", EnumLeafType.DECIDUOUS, new Color(8632686), new Color(8632686), EnumSaplingType.Shrub, EnumShrubLog.INSTANCE, new Color(0xFFFFFF)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenShrub.Shrub(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Raspberry.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Faster.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.BERRY);
            species.setRarity(0.0025f);
            species.setGrowthProvider((IGrowthProvider)new ClimateGrowthProvider(EnumTemperature.NORMAL, EnumTolerance.BOTH_1, EnumHumidity.NORMAL, EnumTolerance.NONE));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Blueberry("vaccinium", "corymbosum", EnumLeafType.DECIDUOUS, new Color(7522128), new Color(7522128), EnumSaplingType.Shrub, EnumShrubLog.INSTANCE, new Color(0xFFFFFF)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenShrub.Shrub(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Blueberry.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Average.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Faster.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.BERRY);
            species.setRarity(0.0025f);
            species.setGrowthProvider((IGrowthProvider)new ClimateGrowthProvider(EnumTemperature.NORMAL, EnumTolerance.BOTH_1, EnumHumidity.NORMAL, EnumTolerance.NONE));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Cranberry("vaccinium", "oxycoccos", EnumLeafType.DECIDUOUS, new Color(9884025), new Color(9884025), EnumSaplingType.Shrub, EnumShrubLog.INSTANCE, new Color(0xFFFFFF)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenShrub.Shrub(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Cranberry.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Average.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.High.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Faster.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.BERRY);
            species.setRarity(0.0025f);
            species.setGrowthProvider((IGrowthProvider)new ClimateGrowthProvider(EnumTemperature.NORMAL, EnumTolerance.BOTH_1, EnumHumidity.NORMAL, EnumTolerance.NONE));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Juniper("juniperus", "communis", EnumLeafType.CONIFERS, new Color(9482569), new Color(9482569), EnumSaplingType.Shrub, EnumShrubLog.INSTANCE, new Color(0xFFFFFF)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenShrub.Shrub(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Juniper.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Low.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Faster.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.BERRY);
            species.setRarity(0.0025f);
            species.setGrowthProvider((IGrowthProvider)new ClimateGrowthProvider(EnumTemperature.NORMAL, EnumTolerance.BOTH_1, EnumHumidity.NORMAL, EnumTolerance.NONE));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Gooseberry("ribes", "grossularia", EnumLeafType.DECIDUOUS, new Color(7977728), new Color(7977728), EnumSaplingType.Shrub, EnumShrubLog.INSTANCE, new Color(0xFFFFFF)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenShrub.Shrub(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Gooseberry.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.High.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.High.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Faster.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.BERRY);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    GoldenRaspberry("rubus", "occidentalis", EnumLeafType.DECIDUOUS, new Color(8632686), new Color(8632686), EnumSaplingType.Shrub, EnumShrubLog.INSTANCE, new Color(0xFFFFFF)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenShrub.Shrub(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.GoldenRaspberry.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smaller.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fastest.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.BERRY);
            species.setRarity(0.0025f);
            species.setGrowthProvider((IGrowthProvider)new ClimateGrowthProvider(EnumTemperature.NORMAL, EnumTolerance.BOTH_1, EnumHumidity.NORMAL, EnumTolerance.NONE));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Cinnamon("cinnamomum", "cassia", EnumLeafType.JUNGLE, new Color(7573003), new Color(7573003), EnumSaplingType.Default, EnumETLog.Cinnamon, new Color(8804412)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLazy.Tree(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Average.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }
    }
    ,
    Coconut("cocous", "nucifera", EnumLeafType.PALM, new Color(6592803), new Color(6592803), EnumSaplingType.Default, (IWoodType)EnumVanillaWoodType.JUNGLE, new Color(5456154)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenPalm.Coconut(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Coconut.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smaller.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
        }
    }
    ,
    Cashew("anacardium", "occidentale", EnumLeafType.JUNGLE, new Color(11254114), new Color(11254114), EnumSaplingType.Default, (IWoodType)EnumVanillaWoodType.JUNGLE, new Color(5456154)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLazy.Tree(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Cashew.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Low.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Avacado("persea", "americana", EnumLeafType.JUNGLE, new Color(9872245), new Color(9872245), EnumSaplingType.Default, (IWoodType)EnumVanillaWoodType.JUNGLE, new Color(5456154)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLazy.Tree(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Avacado.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Nutmeg("myristica", "fragrans", EnumLeafType.JUNGLE, new Color(4754764), new Color(4754764), EnumSaplingType.Default, (IWoodType)EnumVanillaWoodType.JUNGLE, new Color(5456154)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLazy.Tree(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Nutmeg.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smaller.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.High.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Allspice("pimenta", "dioica", EnumLeafType.JUNGLE, new Color(8165156), new Color(8165156), EnumSaplingType.Default, (IWoodType)EnumVanillaWoodType.JUNGLE, new Color(5456154)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLazy.Tree(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Allspice.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.High.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Chilli("capsicum", "annuum", EnumLeafType.JUNGLE, new Color(2793217), new Color(2793217), EnumSaplingType.Default, (IWoodType)EnumVanillaWoodType.JUNGLE, new Color(5456154)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLazy.Tree(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Chilli.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smaller.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Higher.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    StarAnise("illicium", "verum", EnumLeafType.JUNGLE, new Color(8373257), new Color(8373257), EnumSaplingType.Default, (IWoodType)EnumVanillaWoodType.JUNGLE, new Color(5456154)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLazy.Tree(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.StarAnise.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Average.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.High.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Mango("mangifera", "indica", EnumLeafType.JUNGLE, new Color(8893812), new Color(8893812), EnumSaplingType.Default, (IWoodType)EnumVanillaWoodType.JUNGLE, new Color(5456154)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenTropical.Mango(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Mango.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smaller.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Low.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Starfruit("averrhoa", "carambola", EnumLeafType.JUNGLE, new Color(7186733), new Color(7186733), EnumSaplingType.Default, (IWoodType)EnumVanillaWoodType.JUNGLE, new Color(5456154)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLazy.Tree(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Starfruit.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Average.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Fast.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily((IFruitFamily)ETFruitFamily.CITRUS);
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    Candlenut("aleurites", "moluccana", EnumLeafType.DECIDUOUS, new Color(9085804), new Color(9085804), EnumSaplingType.Default, (IWoodType)EnumVanillaWoodType.JUNGLE, new Color(5456154)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenLazy.Tree(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Candlenut.getAllele());
            template.set(EnumTreeChromosome.HEIGHT, ForestryAllele.TreeHeight.Smallest.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Lowest.getAllele());
            template.set(EnumTreeChromosome.YIELD, ForestryAllele.Yield.Low.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Low.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    }
    ,
    DwarfHazel("Corylus", "americana", EnumLeafType.DECIDUOUS, new Color(10204498), new Color(10215762), EnumSaplingType.Shrub, EnumETLog.Hazel, new Color(11180143)){

        public WorldGenerator getWorldGenerator(ITreeGenData tree) {
            return new WorldGenShrub.Shrub(tree);
        }

        @Override
        protected void setAlleles(AlleleTemplate template) {
            template.set(EnumTreeChromosome.FRUITS, (IAllele)AlleleETFruitDefinition.Hazelnut.getAllele());
            template.set(EnumTreeChromosome.FERTILITY, ForestryAllele.Saplings.Average.getAllele());
            template.set(EnumTreeChromosome.SAPPINESS, ForestryAllele.Sappiness.Lower.getAllele());
            template.set(EnumTreeChromosome.MATURATION, ForestryAllele.Maturation.Faster.getAllele());
        }

        @Override
        protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes"));
            species.addFruitFamily(AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts"));
        }

        @Override
        public boolean hasFruitLeaves() {
            return true;
        }
    };

    private static final String unlocalizedName = "extratrees.species.%s.name";
    private static final String unlocalizedDesc = "extratrees.species.%s.desc";
    public static final ETTreeDefinition[] VALUES;
    private final String branchName;
    private final String binomial;
    private final Color leafColor;
    private final Color leafPollinatedColor;
    private final Color woodColor;
    private final EnumLeafType leafType;
    private final ILeafSpriteProvider leafSpriteProvider;
    private final EnumSaplingType saplingType;
    private final IWoodType woodType;
    private final IWoodProvider woodProvider;
    private IClassification branch;
    private IAlleleTreeSpecies species;
    private ITreeGenome genome;
    private AlleleTemplate template;

    private ETTreeDefinition(String branch, String binomial, EnumLeafType leafType, Color leafColor, Color leafPollinatedColor, EnumSaplingType saplingType, IWoodType woodType, Color woodColor) {
        this.binomial = binomial;
        this.leafType = leafType;
        this.leafColor = leafColor;
        this.leafPollinatedColor = leafPollinatedColor;
        this.leafSpriteProvider = TreeManager.treeFactory.getLeafIconProvider(leafType, leafColor, leafPollinatedColor);
        this.saplingType = saplingType;
        this.woodType = woodType;
        this.woodProvider = new WoodProvider(woodType);
        this.woodColor = woodColor;
        this.branchName = branch;
    }

    public static void initTrees() {
        for (ETTreeDefinition tree : ETTreeDefinition.values()) {
            tree.init();
        }
        for (ETTreeDefinition tree : ETTreeDefinition.values()) {
            tree.registerMutations();
        }
    }

    public static void preInitTrees() {
        for (ETTreeDefinition tree : ETTreeDefinition.values()) {
            tree.preInit();
        }
    }

    public static ETTreeDefinition byMetadata(int meta) {
        if (meta < 0 || meta >= VALUES.length) {
            meta = 0;
        }
        return VALUES[meta];
    }

    public void preInit() {
        String scientific = StringUtils.capitalize((String)this.branchName);
        String uid = "trees." + this.branchName;
        this.branch = AlleleManager.alleleRegistry.getClassification("genus." + uid);
        if (this.branch == null) {
            this.branch = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.GENUS, uid, scientific);
        }
        IAlleleTreeSpeciesBuilder speciesBuilder = TreeManager.treeFactory.createSpecies(this.getUID(), String.format(unlocalizedName, this.getUID()), this.getAuthority(), String.format(unlocalizedDesc, this.getUID()), this.isDominant(), this.branch, this.getBinomial(), "extratrees", this.leafSpriteProvider, this.saplingType.getGermlingModelProvider(this.leafColor, this.woodColor), this.woodProvider, (ITreeGenerator)this, (ILeafProvider)new ETLeafProvider());
        this.setSpeciesProperties(speciesBuilder);
        this.species = speciesBuilder.build();
        this.branch.addMemberSpecies((IAlleleSpecies)this.species);
    }

    public void init() {
        this.template = new AlleleTemplate();
        this.template.set(EnumTreeChromosome.SPECIES, (IAllele)this.species);
        this.setAlleles(this.template);
        this.genome = TreeManager.treeRoot.templateAsGenome(this.template.getAlleles());
        TreeManager.treeRoot.registerTemplate(this.template.getAlleles());
    }

    public final ITreeGenome getGenome() {
        return this.genome;
    }

    public final ITree getIndividual() {
        return new Tree(this.genome);
    }

    public final ItemStack getMemberStack(EnumGermlingType treeType) {
        ITree tree = this.getIndividual();
        return TreeManager.treeRoot.getMemberStack((IIndividual)tree, (ISpeciesType)treeType);
    }

    public final IAllele[] getTemplate() {
        IAllele[] alleles = this.template.getAlleles();
        return Arrays.copyOf(alleles, alleles.length);
    }

    protected void setSpeciesProperties(IAlleleTreeSpeciesBuilder species) {
    }

    protected void setAlleles(AlleleTemplate template) {
    }

    protected void registerMutations() {
    }

    public boolean hasFruitLeaves() {
        return false;
    }

    public String getUID() {
        return this.name().toLowerCase();
    }

    public boolean isDominant() {
        return true;
    }

    public String getBinomial() {
        return this.binomial;
    }

    public String getAuthority() {
        return "Binnie";
    }

    public Color getLeafColor() {
        return this.leafColor;
    }

    public Color getWoodColor() {
        return this.woodColor;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public IAlleleTreeSpecies getSpecies() {
        return this.species;
    }

    public int getMetadata() {
        return this.ordinal();
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public boolean setLogBlock(ITreeGenome genome, World world, BlockPos pos, EnumFacing facing) {
        AlleleBoolean fireproofAllele = (AlleleBoolean)genome.getActiveAllele((IChromosomeType)EnumTreeChromosome.FIREPROOF);
        boolean fireproof = fireproofAllele.getValue();
        IBlockState logBlock = TreeManager.woodAccess.getBlock(this.woodType, WoodBlockKind.LOG, fireproof);
        BlockLog.EnumAxis axis = BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k());
        if (logBlock.func_177230_c() instanceof BlockLog) {
            logBlock = logBlock.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)axis);
        }
        return world.func_175656_a(pos, logBlock);
    }

    public boolean setLeaves(ITreeGenome genome, World world, @Nullable GameProfile owner, BlockPos pos) {
        return this.setLeaves(genome, world, owner, pos, world.field_73012_v);
    }

    public boolean setLeaves(ITreeGenome genome, World world, @Nullable GameProfile owner, BlockPos pos, Random rand) {
        if (owner == null && genome.matchesTemplateGenome()) {
            IFruitProvider fruitProvider = genome.getFruitProvider();
            String speciesUid = genome.getPrimary().getUID();
            IBlockState defaultLeaves = fruitProvider.isFruitLeaf(genome, world, pos) && rand.nextFloat() <= fruitProvider.getFruitChance(genome, world, pos) ? ModuleArboriculture.getBlocks().getDefaultLeavesFruit(speciesUid) : ModuleArboriculture.getBlocks().getDefaultLeaves(speciesUid);
            return world.func_175656_a(pos, defaultLeaves);
        }
        boolean placed = world.func_175656_a(pos, ModuleArboriculture.getBlocks().leaves.func_176223_P());
        if (!placed) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (ModuleArboriculture.getBlocks().leaves != block) {
            world.func_175698_g(pos);
            return false;
        }
        TileLeaves tileLeaves = (TileLeaves)TileUtil.getTile((IBlockAccess)world, (BlockPos)pos, TileLeaves.class);
        if (tileLeaves == null) {
            world.func_175698_g(pos);
            return false;
        }
        tileLeaves.getOwnerHandler().setOwner(owner);
        tileLeaves.setTree((ITree)new Tree(genome));
        world.func_175704_b(pos, pos);
        return true;
    }

    static {
        VALUES = ETTreeDefinition.values();
    }

    private static class AlleleTemplate {
        private final IAllele[] alleles;

        protected AlleleTemplate() {
            this.alleles = TreeManager.treeRoot.getDefaultTemplate();
            this.alleles[EnumTreeChromosome.FRUITS.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.fruitNone");
        }

        protected AlleleTemplate(IAllele[] alleles) {
            this.alleles = alleles;
        }

        public <T extends Enum<T>> void set(T chromosomeType, IAllele allele) {
            Preconditions.checkNotNull((Object)allele, (Object)"Allele must not be null");
            if (!((IChromosomeType)chromosomeType).getAlleleClass().isInstance(allele)) {
                throw new IllegalArgumentException("Allele is the wrong type. Expected: " + chromosomeType + " Got: " + allele);
            }
            this.alleles[chromosomeType.ordinal()] = allele;
        }

        public IAllele[] getAlleles() {
            return this.alleles;
        }
    }
}

