/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst.tree;

import binnie.core.api.gui.IArea;
import binnie.core.api.gui.ITitledWidget;
import binnie.core.api.gui.IWidget;
import binnie.core.genetics.Tolerance;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.controls.ControlToleranceBar;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.util.I18N;
import binnie.genetics.api.analyst.IClimatePlugin;
import binnie.genetics.gui.analyst.ControlBiome;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import net.minecraft.init.Biomes;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AnalystPageClimate<T extends IIndividual>
extends Control
implements ITitledWidget {
    public AnalystPageClimate(IWidget parent, IArea area, T ind, IClimatePlugin<T> plugin) {
        super(parent, area);
        this.setColor(26163);
        EnumTemperature temp = ind.getGenome().getPrimary().getTemperature();
        EnumTolerance tempTol = plugin.getTemperatureTolerance(ind);
        EnumHumidity humid = ind.getGenome().getPrimary().getHumidity();
        EnumTolerance humidTol = plugin.getHumidityTolerance(ind);
        int y = 4;
        new ControlTextCentered((IWidget)this, y, TextFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        new ControlText(this, new Area(4, y += 16, this.getWidth() - 8, 14), I18N.localise("genetics.gui.analyst.climate.temp"), TextJustification.MIDDLE_CENTER).setColor(this.getColor());
        this.createTemperatureBar(this, (this.getWidth() - 100) / 2, y += 12, 100, 10, temp, tempTol);
        y += 16;
        if (plugin.showHumiditySection()) {
            new ControlText(this, new Area(4, y, this.getWidth() - 8, 14), I18N.localise("genetics.gui.analyst.climate.hum"), TextJustification.MIDDLE_CENTER).setColor(this.getColor());
            this.createHumidity(this, (this.getWidth() - 100) / 2, y += 12, 100, 10, humid, humidTol);
            y += 16;
        }
        new ControlText(this, new Area(4, y, this.getWidth() - 8, 14), I18N.localise("genetics.gui.analyst.climate.biomes"), TextJustification.MIDDLE_CENTER).setColor(this.getColor());
        y += 12;
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (biome == null || biome == Biomes.field_76776_l || !Tolerance.canTolerate(temp, EnumTemperature.getFromBiome((Biome)biome), tempTol) || !Tolerance.canTolerate(humid, EnumHumidity.getFromValue((float)biome.func_76727_i()), humidTol)) continue;
            boolean match = false;
            for (Biome eBiome : biomes) {
                if (!biome.func_185359_l().contains(eBiome.func_185359_l()) || EnumHumidity.getFromValue((float)eBiome.func_76727_i()) != EnumHumidity.getFromValue((float)biome.func_76727_i()) || EnumTemperature.getFromBiome((Biome)eBiome) != EnumTemperature.getFromBiome((Biome)biome)) continue;
                match = true;
            }
            if (match) continue;
            biomes.add(biome);
        }
        int maxBiomePerLine = (this.getWidth() + 2 - 16) / 18;
        int biomeListX = (this.getWidth() - (Math.min(maxBiomePerLine, biomes.size()) * 18 - 2)) / 2;
        int dx = 0;
        int dy = 0;
        for (Biome biome2 : biomes) {
            new ControlBiome(this, biomeListX + dx, y + dy, 16, 16, biome2);
            if ((dx += 18) < 18 * maxBiomePerLine) continue;
            dx = 0;
            dy += 18;
        }
        this.setSize(new Point(this.getWidth(), y + dy + 18 + 8));
    }

    protected void createTemperatureBar(IWidget parent, int x, int y, int w, int h, EnumTemperature value, EnumTolerance tol) {
        new TemperatureBar(parent, x, y, w, h).setValues(value, tol);
    }

    protected void createHumidity(IWidget parent, int x, int y, int w, int h, EnumHumidity value, EnumTolerance tol) {
        new HumidityBar(parent, x, y, w, h).setValues(value, tol);
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.climate.title");
    }

    private static class HumidityBar
    extends ControlToleranceBar<EnumHumidity> {
        public HumidityBar(IWidget parent, int x, int y, int w, int h) {
            super(parent, x, y, w, h, EnumHumidity.class);
        }

        @Override
        protected String getName(EnumHumidity value) {
            return value.name;
        }

        @Override
        protected int getColour(EnumHumidity value) {
            return (new int[]{16770979, 1769216, 3177727})[value.ordinal()];
        }
    }

    private static class TemperatureBar
    extends ControlToleranceBar<EnumTemperature> {
        public TemperatureBar(IWidget parent, int x, int y, int w, int h) {
            super(parent, x, y, w, h, EnumTemperature.class);
        }

        @Override
        protected String getName(EnumTemperature value) {
            return value.name;
        }

        @Override
        protected int getColour(EnumTemperature value) {
            return (new int[]{65531, 7912447, 5242672, 0xFFFF00, 16753152, 0xFF0000})[value.ordinal() - 1];
        }
    }
}

