/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.inventory.AccessDirection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.EnumFacing;

class SidedAccess {
    private final Map<EnumFacing, AccessDirection> accesses = new HashMap<EnumFacing, AccessDirection>();
    private AccessDirection base = AccessDirection.Both;
    private boolean insertLocked = false;
    private boolean extractLocked = false;

    public AccessDirection getAccess(EnumFacing side) {
        return this.accesses.getOrDefault(side, this.base);
    }

    public boolean canInsert(EnumFacing side) {
        return this.getAccess(side).canInsert();
    }

    public boolean canExtract(EnumFacing side) {
        return this.getAccess(side).canExtract();
    }

    public boolean canAccess(EnumFacing side) {
        return this.getAccess(side).canAccess();
    }

    public boolean canChangeInsert() {
        return !this.insertLocked;
    }

    public boolean canChangeExtract() {
        return !this.extractLocked;
    }

    public void forbidInsertChange() {
        this.insertLocked = true;
    }

    public void forbidExtractChange() {
        this.extractLocked = true;
    }

    public Collection<EnumFacing> getInsertionSides() {
        ArrayList<EnumFacing> dirs = new ArrayList<EnumFacing>();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.getAccess(dir).canInsert()) continue;
            dirs.add(dir);
        }
        return dirs;
    }

    public Collection<EnumFacing> getExtractionSides() {
        ArrayList<EnumFacing> dirs = new ArrayList<EnumFacing>();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.getAccess(dir).canExtract()) continue;
            dirs.add(dir);
        }
        return dirs;
    }

    public void setInsert(EnumFacing side, boolean b) {
        if (this.getAccess(side).canInsert() != b) {
            this.accesses.put(side, this.getAccess(side).changeInsert(b));
        }
    }

    public void setExtract(EnumFacing side, boolean b) {
        if (this.getAccess(side).canExtract() != b) {
            this.accesses.put(side, this.getAccess(side).changeExtract(b));
        }
    }

    public void setInsert(boolean b) {
        if (this.base.canInsert() != b) {
            this.base = this.base.changeInsert(b);
        }
    }

    public void setExtract(boolean b) {
        if (this.base.canExtract() != b) {
            this.base = this.base.changeExtract(b);
        }
    }
}

