/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.blocks.properties;

import binnie.botany.api.genetics.IAlleleFlowerSpecies;
import binnie.botany.api.genetics.IFlowerType;
import com.google.common.base.Optional;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.properties.PropertyHelper;

public class PropertyFlower<I extends IFlowerType<I>>
extends PropertyHelper<I> {
    public PropertyFlower(String name, Class<I> flowerTypeClass) {
        super(name, flowerTypeClass);
    }

    public List<I> getAllowedValues() {
        ArrayList<IFlowerType> flowerTypes = new ArrayList<IFlowerType>();
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            IFlowerType flowerType;
            if (!(allele instanceof IAlleleFlowerSpecies) || flowerTypes.contains(flowerType = ((IAlleleFlowerSpecies)allele).getType())) continue;
            flowerTypes.add(flowerType);
        }
        return flowerTypes;
    }

    public String getName(IFlowerType value) {
        return value.getName().toLowerCase(Locale.ENGLISH);
    }

    public Optional<I> func_185929_b(String value) {
        IAllele allele = AlleleManager.alleleRegistry.getAllele(value);
        if (IAlleleFlowerSpecies.class.isInstance(allele)) {
            IAlleleFlowerSpecies alleleValue = (IAlleleFlowerSpecies)IAlleleFlowerSpecies.class.cast(allele);
            return Optional.of((Object)alleleValue.getType());
        }
        return Optional.absent();
    }
}

