/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.minecraft.control;

import binnie.core.api.gui.IPoint;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.Attribute;
import binnie.core.gui.ITooltip;
import binnie.core.gui.Tooltip;
import binnie.core.gui.Widget;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.renderer.RenderUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlItemDisplay
extends Control
implements ITooltip {
    private boolean hasTooltip = false;
    private ItemStack itemStack = ItemStack.field_190927_a;
    private boolean rotating = false;

    public ControlItemDisplay(IWidget parent, int x, int y) {
        this(parent, x, y, 16);
    }

    public ControlItemDisplay(IWidget parent, int f, int y, ItemStack stack, boolean tooltip) {
        this(parent, f, y, 16);
        this.setItemStack(stack);
        if (tooltip) {
            this.setTooltip();
        }
    }

    public ControlItemDisplay(IWidget parent, int x, int y, int size) {
        super(parent, x, y, size, size);
    }

    public void setTooltip() {
        this.hasTooltip = true;
        this.addAttribute(Attribute.MOUSE_OVER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        if (this.itemStack.func_190926_b()) {
            return;
        }
        IPoint relativeToWindow = this.getAbsolutePosition().sub(this.getTopParent().getPosition());
        if (relativeToWindow.xPos() > ((Widget)Window.get(this)).getSize().xPos() + 100 || relativeToWindow.yPos() > ((Widget)Window.get(this)).getSize().yPos() + 100) {
            return;
        }
        GlStateManager.func_179126_j();
        if (this.getSize().xPos() != 16) {
            GlStateManager.func_179094_E();
            float scale = (float)this.getSize().xPos() / 16.0f;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            RenderUtil.drawItem(Point.ZERO, this.itemStack, this.rotating);
            GlStateManager.func_179121_F();
        } else {
            RenderUtil.drawItem(Point.ZERO, this.itemStack, this.rotating);
        }
        GlStateManager.func_179141_d();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return this.getItemStack();
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        if (this.hasTooltip && !this.itemStack.func_190926_b()) {
            List itemStackTooltip = this.itemStack.func_82840_a(((Window)this.getTopParent()).getPlayer(), tooltipFlag);
            tooltip.add(itemStackTooltip);
            tooltip.setItemStack(this.itemStack);
        }
        super.getTooltip(tooltip, tooltipFlag);
    }

    public void setRotating() {
        this.rotating = true;
    }

    public void setHasTooltip(boolean hasTooltip) {
        this.hasTooltip = hasTooltip;
    }
}

