/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.core.Binnie;
import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.genetics.IItemStackRepresentitive;
import binnie.core.resource.BinnieSprite;
import binnie.core.util.I18N;
import binnie.core.util.collect.ListMultiMap;
import com.mojang.authlib.GameProfile;
import forestry.api.core.ForestryEvent;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BreedingSystem
implements IBreedingSystem,
IItemStackRepresentitive {
    private float discoveredSpeciesPercentage;
    private int totalSpeciesCount;
    private int discoveredSpeciesCount;
    private int totalSecretCount;
    private int discoveredSecretCount;
    private float discoveredBranchPercentage;
    private int totalBranchCount;
    private int discoveredBranchCount;
    protected BinnieSprite iconUndiscovered;
    protected BinnieSprite iconDiscovered;
    protected List<IAlleleSpecies> allActiveSpecies;
    protected String currentEpithet;
    private List<IClassification> allBranches = new ArrayList<IClassification>();
    private List<IAlleleSpecies> allSpecies;
    private List<IMutation> allMutations;
    private final ListMultiMap<IAlleleSpecies, IMutation> resultantMutations;
    private final ListMultiMap<IAlleleSpecies, IMutation> furtherMutations;
    private final ListMultiMap<IAlleleSpecies, IMutation> allResultantMutations;
    private final ListMultiMap<IAlleleSpecies, IMutation> allFurtherMutations;
    private int totalSecretBranchCount;
    private int discoveredSecretBranchCount;

    public BreedingSystem() {
        this.allActiveSpecies = new ArrayList<IAlleleSpecies>();
        this.allSpecies = new ArrayList<IAlleleSpecies>();
        this.allMutations = new ArrayList<IMutation>();
        this.resultantMutations = new ListMultiMap();
        this.furtherMutations = new ListMultiMap();
        this.allResultantMutations = new ListMultiMap();
        this.allFurtherMutations = new ListMultiMap();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public String getChromosomeName(IChromosomeType chromo) {
        return I18N.localise("binniecore." + this.getSpeciesRoot().getUID() + ".chromosome." + chromo.getName());
    }

    @Override
    public String getChromosomeShortName(IChromosomeType chromo) {
        return I18N.localise("binniecore." + this.getSpeciesRoot().getUID() + ".chromosome." + chromo.getName() + ".short");
    }

    @Override
    public final String getEpitome(float discoveredPercentage) {
        int i = 0;
        if (discoveredPercentage == 1.0f) {
            i = 6;
        } else if (discoveredPercentage < 0.1f) {
            i = 0;
        } else if (discoveredPercentage < 0.3f) {
            i = 1;
        } else if (discoveredPercentage < 0.5f) {
            i = 2;
        } else if (discoveredPercentage < 0.7f) {
            i = 3;
        } else if (discoveredPercentage < 0.9f) {
            i = 4;
        } else if (discoveredPercentage < 1.0f) {
            i = 5;
        }
        return I18N.localise("binniecore." + this.getSpeciesRoot().getUID() + ".epitome." + i);
    }

    @Override
    public abstract ISpeciesRoot getSpeciesRoot();

    @Override
    public final List<IClassification> getAllBranches() {
        return this.allBranches;
    }

    @Override
    public final Collection<IAlleleSpecies> getAllSpecies() {
        return this.allActiveSpecies;
    }

    @Override
    public final Collection<IMutation> getAllMutations() {
        return this.allMutations;
    }

    @Override
    public void calculateArrays() {
        ISpeciesRoot speciesRoot = this.getSpeciesRoot();
        this.calculateAlleles(speciesRoot);
        this.calculateBranches(speciesRoot);
        this.calculateMutations(speciesRoot);
    }

    @Override
    public void calculateAlleles(ISpeciesRoot speciesRoot) {
        this.allSpecies = new ArrayList<IAlleleSpecies>();
        this.allActiveSpecies = new ArrayList<IAlleleSpecies>();
        this.resultantMutations.clear();
        this.furtherMutations.clear();
        this.allResultantMutations.clear();
        this.allFurtherMutations.clear();
        Collection allAlleles = AlleleManager.alleleRegistry.getRegisteredAlleles().values();
        for (IAllele allele : allAlleles) {
            String uid = allele.getUID();
            IAllele[] template = speciesRoot.getTemplate(uid);
            if (template == null) continue;
            IAlleleSpecies species = (IAlleleSpecies)allele;
            this.allSpecies.add(species);
            if (this.isBlacklisted(allele) || uid.contains("speciesBotAlfheim")) continue;
            this.allActiveSpecies.add((IAlleleSpecies)allele);
        }
    }

    @Override
    public void calculateBranches(ISpeciesRoot speciesRoot) {
        Collection allRegBranches = AlleleManager.alleleRegistry.getRegisteredClassifications().values();
        this.allBranches = new ArrayList<IClassification>();
        for (IClassification branch : allRegBranches) {
            IAlleleSpecies firstSpecies;
            IAllele[] template;
            IAlleleSpecies[] species = branch.getMemberSpecies();
            if (species.length <= 0 || (template = speciesRoot.getTemplate((firstSpecies = species[0]).getUID())) == null) continue;
            boolean possible = false;
            for (IAlleleSpecies species2 : branch.getMemberSpecies()) {
                if (!this.allActiveSpecies.contains(species2)) continue;
                possible = true;
            }
            if (!possible) continue;
            this.allBranches.add(branch);
        }
    }

    @Override
    public void calculateMutations(ISpeciesRoot speciesRoot) {
        this.allMutations = new ArrayList<IMutation>();
        List speciesMutations = speciesRoot.getMutations(false);
        if (!speciesMutations.isEmpty()) {
            LinkedHashSet mutations = new LinkedHashSet();
            mutations.addAll(speciesMutations);
            for (IMutation mutation : mutations) {
                this.allMutations.add(mutation);
                LinkedHashSet<IAlleleSpecies> participatingSpecies = new LinkedHashSet<IAlleleSpecies>();
                participatingSpecies.add(mutation.getAllele0());
                participatingSpecies.add(mutation.getAllele1());
                for (IAlleleSpecies species : participatingSpecies) {
                    this.allFurtherMutations.put(species, mutation);
                    if (!this.allActiveSpecies.contains(species)) continue;
                    this.furtherMutations.put(species, mutation);
                }
                IAllele[] template = mutation.getTemplate();
                IAlleleSpecies speciesAllele = (IAlleleSpecies)template[0];
                this.allResultantMutations.put(speciesAllele, mutation);
                this.resultantMutations.put(speciesAllele, mutation);
            }
        }
    }

    @Override
    public final boolean isBlacklisted(IAllele allele) {
        return AlleleManager.alleleRegistry.isBlacklisted(allele.getUID());
    }

    @Override
    public final List<IMutation> getResultantMutations(IAlleleSpecies species) {
        if (this.resultantMutations.isEmpty()) {
            this.calculateArrays();
        }
        return (List)this.resultantMutations.get(species);
    }

    @Override
    public final List<IMutation> getFurtherMutations(IAlleleSpecies species) {
        if (this.furtherMutations.isEmpty()) {
            this.calculateArrays();
        }
        return (List)this.furtherMutations.get(species);
    }

    @Override
    public final boolean isMutationDiscovered(IMutation mutation, World world, GameProfile name) {
        return this.isMutationDiscovered(mutation, this.getSpeciesRoot().getBreedingTracker(world, name));
    }

    @Override
    public final boolean isMutationDiscovered(IMutation mutation, IBreedingTracker tracker) {
        return tracker.isDiscovered(mutation);
    }

    @Override
    public final boolean isSpeciesDiscovered(IAlleleSpecies species, World world, GameProfile name) {
        return this.isSpeciesDiscovered(species, this.getSpeciesRoot().getBreedingTracker(world, name));
    }

    @Override
    public final boolean isSpeciesDiscovered(IAlleleSpecies species, IBreedingTracker tracker) {
        return tracker.isDiscovered(species);
    }

    @Override
    public final boolean isSecret(IAlleleSpecies species) {
        return !species.isCounted();
    }

    @Override
    public final boolean isSecret(IClassification branch) {
        for (IAlleleSpecies species : branch.getMemberSpecies()) {
            if (this.isSecret(species)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Collection<IClassification> getDiscoveredBranches(World world, GameProfile player) {
        ArrayList<IClassification> branches = new ArrayList<IClassification>();
        for (IClassification branch : this.getAllBranches()) {
            boolean discovered = false;
            for (IAlleleSpecies species : branch.getMemberSpecies()) {
                if (!this.isSpeciesDiscovered(species, world, player)) continue;
                discovered = true;
            }
            if (!discovered) continue;
            branches.add(branch);
        }
        return branches;
    }

    @Override
    public final Collection<IClassification> getDiscoveredBranches(IBreedingTracker tracker) {
        ArrayList<IClassification> branches = new ArrayList<IClassification>();
        for (IClassification branch : this.getAllBranches()) {
            boolean discovered = false;
            for (IAlleleSpecies species : branch.getMemberSpecies()) {
                if (!this.isSpeciesDiscovered(species, tracker)) continue;
                discovered = true;
            }
            if (!discovered) continue;
            branches.add(branch);
        }
        return branches;
    }

    @Override
    public final Collection<IAlleleSpecies> getDiscoveredSpecies(World world, GameProfile player) {
        ArrayList<IAlleleSpecies> speciesList = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : this.getAllSpecies()) {
            if (!this.isSpeciesDiscovered(species, world, player)) continue;
            speciesList.add(species);
        }
        return speciesList;
    }

    @Override
    public final Collection<IAlleleSpecies> getDiscoveredSpecies(IBreedingTracker tracker) {
        ArrayList<IAlleleSpecies> speciesList = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : this.getAllSpecies()) {
            if (!this.isSpeciesDiscovered(species, tracker)) continue;
            speciesList.add(species);
        }
        return speciesList;
    }

    @Override
    public final List<IMutation> getDiscoveredMutations(World world, GameProfile player) {
        ArrayList<IMutation> speciesList = new ArrayList<IMutation>();
        for (IMutation species : this.getAllMutations()) {
            if (!this.isMutationDiscovered(species, world, player)) continue;
            speciesList.add(species);
        }
        return speciesList;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getUndiscoveredIcon() {
        return this.iconUndiscovered.getSprite();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getDiscoveredIcon() {
        return this.iconDiscovered.getSprite();
    }

    @Override
    public abstract float getChance(IMutation var1, EntityPlayer var2, IAlleleSpecies var3, IAlleleSpecies var4);

    @Override
    @SubscribeEvent
    public final void onSyncBreedingTracker(ForestryEvent.SyncedBreedingTracker event) {
        IBreedingTracker tracker = event.tracker;
        if (!this.getTrackerClass().isInstance(tracker)) {
            return;
        }
        this.syncTracker(tracker);
    }

    @Override
    public final void syncTracker(IBreedingTracker tracker) {
        if (this.allActiveSpecies.isEmpty()) {
            this.calculateArrays();
        }
        this.discoveredSpeciesPercentage = 0.0f;
        this.totalSpeciesCount = 0;
        this.discoveredSpeciesCount = 0;
        this.totalSecretCount = 0;
        this.discoveredSecretCount = 0;
        Collection<IAlleleSpecies> discoveredSpecies = this.getDiscoveredSpecies(tracker);
        Collection<IAlleleSpecies> allSpecies = this.getAllSpecies();
        for (IAlleleSpecies species : allSpecies) {
            if (!this.isSecret(species)) {
                ++this.totalSpeciesCount;
                if (!this.isSpeciesDiscovered(species, tracker)) continue;
                ++this.discoveredSpeciesCount;
                continue;
            }
            ++this.totalSecretCount;
            if (!this.isSpeciesDiscovered(species, tracker)) continue;
            ++this.discoveredSecretCount;
        }
        this.discoveredBranchPercentage = 0.0f;
        this.totalBranchCount = 0;
        this.discoveredBranchCount = 0;
        Collection<IClassification> discoveredBranches = this.getDiscoveredBranches(tracker);
        List<IClassification> allBranches = this.getAllBranches();
        for (IClassification branch : allBranches) {
            if (!this.isSecret(branch)) {
                ++this.totalBranchCount;
                if (!discoveredBranches.contains(branch)) continue;
                ++this.discoveredBranchCount;
                continue;
            }
            ++this.totalSecretBranchCount;
            if (!discoveredBranches.contains(branch)) continue;
            ++this.discoveredSecretBranchCount;
        }
        this.discoveredSpeciesPercentage = this.discoveredSpeciesCount / this.totalSpeciesCount;
        this.discoveredBranchPercentage = this.discoveredBranchCount / this.totalBranchCount;
        String epithet = this.getEpitome();
        this.onSyncBreedingTracker(tracker);
    }

    @Override
    public void onSyncBreedingTracker(IBreedingTracker tracker) {
    }

    @Override
    public String getEpitome() {
        return this.getEpitome(this.discoveredSpeciesPercentage);
    }

    @Override
    public final String getDescriptor() {
        return I18N.localise("binniecore." + this.getSpeciesRoot().getUID() + ".descriptor");
    }

    @Override
    public final String getIdent() {
        return this.getSpeciesRoot().getUID();
    }

    @Override
    public abstract int getColour();

    @Override
    public String getAlleleName(IChromosomeType chromosome, IAllele allele) {
        if (allele instanceof IAlleleBoolean) {
            IAlleleBoolean alleleBoolean = (IAlleleBoolean)allele;
            return alleleBoolean.getValue() ? I18N.localise("binniecore.allele.true") : I18N.localise("binniecore.allele.false");
        }
        if (Objects.equals(allele.getAlleleName(), "for.gui.maximum")) {
            return I18N.localise("binniecore.allele.fertility.maximum");
        }
        return allele.getAlleleName();
    }

    @Override
    public String getName() {
        return I18N.localise("binniecore." + this.getSpeciesRoot().getUID() + ".shortName");
    }

    @Override
    public ItemStack getItemStackRepresentitive() {
        IIndividual first = (IIndividual)this.getSpeciesRoot().getIndividualTemplates().get(0);
        return this.getSpeciesRoot().getMemberStack(first, this.getDefaultType());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    @Nullable
    public IIndividual getConversion(ItemStack stack) {
        return null;
    }

    @Override
    public final IIndividual getDefaultIndividual() {
        return this.getSpeciesRoot().templateAsIndividual(this.getSpeciesRoot().getDefaultTemplate());
    }

    @Override
    public final ISpeciesType getDefaultType() {
        return this.getActiveTypes()[0];
    }

    @Override
    public abstract void addExtraAlleles(IChromosomeType var1, TreeSet<IAllele> var2);

    @Override
    public ItemStack getConversionStack(ItemStack stack) {
        IIndividual conversion = this.getConversion(stack);
        if (conversion == null) {
            return ItemStack.field_190927_a;
        }
        return this.getSpeciesRoot().getMemberStack(conversion, this.getDefaultType());
    }

    @Override
    public final Collection<IChromosomeType> getActiveKaryotype() {
        return Binnie.GENETICS.getActiveChromosomes(this.getSpeciesRoot());
    }

    @Override
    public ItemStack getDefaultMember(String uid) {
        IIndividual individual = this.getIndividual(uid);
        if (individual == null) {
            return ItemStack.field_190927_a;
        }
        return this.getSpeciesRoot().getMemberStack(individual, this.getDefaultType());
    }

    @Override
    @Nullable
    public IIndividual getIndividual(String uid) {
        IAllele[] template = this.getSpeciesRoot().getTemplate(uid);
        if (template == null) {
            return null;
        }
        return this.getSpeciesRoot().templateAsIndividual(template);
    }

    @Override
    public int getDiscoveredSpeciesCount() {
        return this.discoveredSpeciesCount;
    }

    @Override
    public int getTotalSpeciesCount() {
        return this.totalSpeciesCount;
    }

    @Override
    public float getDiscoveredSpeciesPercentage() {
        return this.discoveredSpeciesPercentage;
    }

    @Override
    public int getTotalSecretCount() {
        return this.totalSecretCount;
    }

    @Override
    public int getDiscoveredSecretCount() {
        return this.discoveredSecretCount;
    }

    @Override
    public float getDiscoveredBranchPercentage() {
        return this.discoveredBranchPercentage;
    }

    @Override
    public int getTotalBranchCount() {
        return this.totalBranchCount;
    }

    @Override
    public int getDiscoveredBranchCount() {
        return this.discoveredBranchCount;
    }
}

