/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.polymeriser;

import binnie.core.machines.Machine;
import binnie.core.machines.errors.ErrorState;
import binnie.core.machines.errors.IErrorStateDefinition;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.IProcess;
import binnie.core.util.I18N;
import binnie.genetics.genetics.Engineering;
import binnie.genetics.machine.GeneticsErrorCode;
import com.google.common.base.Preconditions;
import net.minecraft.item.ItemStack;

public class PolymeriserLogic
extends ComponentProcessSetCost
implements IProcess {
    private static final float chargePerProcess = 0.4f;
    private float dnaDrain = 0.0f;
    private float bacteriaDrain = 0.0f;

    public PolymeriserLogic(Machine machine) {
        super(machine, 96000, 2400);
    }

    public static float getDNAPerProcess(ItemStack serum) {
        return PolymeriserLogic.getNumberOfGenes(serum) * 50;
    }

    public static float getBacteriaPerProcess(ItemStack serum) {
        return 0.2f * PolymeriserLogic.getDNAPerProcess(serum);
    }

    private static int getNumberOfGenes(ItemStack serum) {
        if (serum.func_190926_b()) {
            return 1;
        }
        return Engineering.getGenes(serum).length;
    }

    private float getCatalyst() {
        return this.getUtil().getSlotCharge(1) > 0.0f ? 0.2f : 1.0f;
    }

    @Override
    public int getProcessLength() {
        ItemStack serum = this.getUtil().getStack(0);
        return (int)((float)(super.getProcessLength() * PolymeriserLogic.getNumberOfGenes(serum)) * this.getCatalyst());
    }

    @Override
    public int getProcessEnergy() {
        ItemStack serum = this.getUtil().getStack(0);
        return (int)((float)(super.getProcessEnergy() * PolymeriserLogic.getNumberOfGenes(serum)) * this.getCatalyst());
    }

    @Override
    public void onTickTask() {
        super.onTickTask();
        ItemStack serum = this.getUtil().getStack(0);
        this.getUtil().useCharge(1, 0.4f * this.getProgressPerTick() / 100.0f);
        this.dnaDrain += PolymeriserLogic.getDNAPerProcess(serum) * this.getProgressPerTick() / 100.0f;
        this.bacteriaDrain += PolymeriserLogic.getBacteriaPerProcess(serum) * this.getProgressPerTick() / 100.0f;
        if (this.dnaDrain >= 1.0f) {
            this.getUtil().drainTank(1, 1);
            this.dnaDrain -= 1.0f;
        }
        if (this.bacteriaDrain >= 1.0f) {
            this.getUtil().drainTank(0, 1);
            this.bacteriaDrain -= 1.0f;
        }
    }

    @Override
    public String getTooltip() {
        ItemStack serum = this.getUtil().getStack(0);
        int n = PolymeriserLogic.getNumberOfGenes(serum);
        if (n > 1) {
            return String.format(I18N.localise("genetics.genetics.machine.machine.polymeriser.tooltips.logic.genes"), Integer.valueOf(n).toString());
        }
        return I18N.localise("genetics.genetics.machine.machine.polymeriser.tooltips.logic.gene");
    }

    @Override
    public ErrorState canWork() {
        ItemStack serumStack = this.getUtil().getStack(0);
        if (serumStack.func_190926_b()) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.POLYMERISER_NO_ITEM, 0);
        }
        if (!serumStack.func_77951_h()) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.POLYMERISER_ITEM_FILLED, 0);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        if (this.getUtil().getFluid(0) == null) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.POLYMERISER_INSUFFICIENT_BACTERIA, 0);
        }
        if (this.getUtil().getFluid(1) == null) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.POLYMERISER_INSUFFICIENT_DNA, 1);
        }
        return super.canProgress();
    }

    @Override
    protected void onFinishTask() {
        super.onFinishTask();
        ItemStack serumStack = this.getUtil().getStack(0);
        Preconditions.checkState((!serumStack.func_190926_b() ? 1 : 0) != 0);
        this.getUtil().damageItem(serumStack, 0, -1);
    }
}

