/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.alveary;

import binnie.core.util.NBTUtil;
import binnie.extrabees.alveary.AlvearyLogic;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class AlvearyLogicElectrical
extends AlvearyLogic {
    protected final IEnergyStorage energyStorage;

    protected AlvearyLogicElectrical(int capacity) {
        this.energyStorage = new EnergyStorage(capacity);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        NBTUtil.readFromNBT(this.energyStorage, "Energy", nbt);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTUtil.writeToNBT(this.energyStorage, "Energy", nbt);
        return nbt;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityEnergy.ENERGY ? CapabilityEnergy.ENERGY.cast((Object)this.energyStorage) : super.getCapability(capability, facing));
    }
}

