/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.integration.jei.multifence;

import binnie.extratrees.blocks.decor.FenceDescription;
import binnie.extratrees.blocks.decor.FenceType;
import binnie.extratrees.wood.WoodManager;
import binnie.extratrees.wood.planks.IPlankType;
import java.util.ArrayList;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import net.minecraft.item.ItemStack;

public class MultiFenceRecipeSolidWrapper
implements IShapedCraftingRecipeWrapper {
    private final FenceType fenceType;
    @Nullable
    private final IPlankType plankType;
    @Nullable
    private final IPlankType plankTypeSecondary;

    public MultiFenceRecipeSolidWrapper(FenceType fenceType) {
        this.fenceType = fenceType;
        this.plankType = null;
        this.plankTypeSecondary = null;
    }

    public MultiFenceRecipeSolidWrapper(FenceDescription fenceDesc) {
        this.fenceType = fenceDesc.getFenceType();
        this.plankType = fenceDesc.getPlankType();
        this.plankTypeSecondary = fenceDesc.getSecondaryPlankType();
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<ItemStack> fences = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputFences = new ArrayList<ItemStack>();
        if (this.plankType != null) {
            if (this.plankTypeSecondary == null) {
                for (IPlankType plankTypeSecondary : WoodManager.getAllPlankTypes()) {
                    if (this.plankType == plankTypeSecondary) continue;
                    fences.add(WoodManager.getFence(this.plankType, plankTypeSecondary, new FenceType(this.fenceType.getSize(), false, this.fenceType.isEmbossed()), 1));
                    outputFences.add(WoodManager.getFence(this.plankType, plankTypeSecondary, new FenceType(this.fenceType.getSize(), true, this.fenceType.isEmbossed()), 2));
                }
            } else {
                fences.add(WoodManager.getFence(this.plankType, this.plankTypeSecondary, new FenceType(this.fenceType.getSize(), false, this.fenceType.isEmbossed()), 1));
                outputFences.add(WoodManager.getFence(this.plankType, this.plankTypeSecondary, new FenceType(this.fenceType.getSize(), true, this.fenceType.isEmbossed()), 2));
            }
        } else {
            for (IPlankType plankTypeSecondary : WoodManager.getAllPlankTypes()) {
                for (IPlankType plankType : WoodManager.getAllPlankTypes()) {
                    if (plankType == plankTypeSecondary) continue;
                    fences.add(WoodManager.getFence(plankType, plankTypeSecondary, new FenceType(this.fenceType.getSize(), false, this.fenceType.isEmbossed()), 1));
                    outputFences.add(WoodManager.getFence(plankType, plankTypeSecondary, new FenceType(this.fenceType.getSize(), true, this.fenceType.isEmbossed()), 2));
                }
            }
        }
        ArrayList<ArrayList<ItemStack>> itemInputs = new ArrayList<ArrayList<ItemStack>>();
        itemInputs.add(fences);
        itemInputs.add(fences);
        itemInputs.add(fences);
        ArrayList<ArrayList<ItemStack>> itemOutputs = new ArrayList<ArrayList<ItemStack>>();
        itemOutputs.add(outputFences);
        ingredients.setOutputLists(ItemStack.class, itemOutputs);
        ingredients.setInputLists(ItemStack.class, itemInputs);
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 1;
    }
}

