/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.items;

import binnie.botany.CreativeTabBotany;
import binnie.botany.api.BotanyAPI;
import binnie.botany.api.genetics.EnumFlowerChromosome;
import binnie.botany.api.genetics.EnumFlowerStage;
import binnie.botany.api.genetics.IAlleleFlowerSpecies;
import binnie.botany.api.genetics.IFlower;
import binnie.botany.api.genetics.IFlowerGenome;
import binnie.botany.api.genetics.IFlowerType;
import binnie.botany.blocks.BlockFlower;
import binnie.botany.core.BotanyCore;
import binnie.botany.genetics.Flower;
import binnie.botany.modules.ModuleFlowers;
import binnie.core.util.I18N;
import com.google.common.base.Preconditions;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.core.config.Config;
import forestry.core.items.IColoredItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFlowerGE
extends Item
implements IColoredItem,
IItemModelRegister {
    private final EnumFlowerStage type;
    private final String tag;

    public ItemFlowerGE(String name, EnumFlowerStage type, String tag) {
        this.type = type;
        this.tag = tag;
        this.func_77637_a(CreativeTabBotany.INSTANCE);
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.field_77787_bX = true;
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_77651_p() {
        return true;
    }

    public boolean func_77636_d(ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            return false;
        }
        IIndividual individual = this.getIndividual(itemstack);
        return individual != null && individual.hasEffect();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        IFlower individual = (IFlower)this.getIndividual(itemStack);
        if (individual == null) {
            list.add(TextFormatting.DARK_RED + I18N.localise("item.botany.flower.destroy"));
            return;
        }
        IFlowerGenome genome = individual.getGenome();
        String primaryColor = genome.getPrimaryColor().getColorName();
        String secondaryColor = genome.getSecondaryColor().getColorName();
        String stemColor = genome.getStemColor().getColorName();
        String colorInfo = !primaryColor.equals(secondaryColor) ? I18N.localise("item.botany.grammar.flower.secondary", primaryColor, secondaryColor, stemColor) : I18N.localise("item.botany.grammar.flower", primaryColor, stemColor);
        list.add(TextFormatting.YELLOW + colorInfo);
        if (individual.isAnalyzed()) {
            if (GuiScreen.func_146272_n()) {
                individual.addTooltip(list);
            } else {
                list.add(TextFormatting.ITALIC + "<" + I18N.localise("for.gui.tooltip.tmi") + '>');
            }
        } else {
            list.add('<' + I18N.localise("for.gui.unknown") + '>');
        }
    }

    @Nullable
    public String getCreatorModId(ItemStack itemStack) {
        IIndividual individual = this.getIndividual(itemStack);
        if (individual != null) {
            IAlleleSpecies species = individual.getGenome().getPrimary();
            return species.getModID();
        }
        return super.getCreatorModId(itemStack);
    }

    @Nullable
    protected IIndividual getIndividual(ItemStack itemstack) {
        NBTTagCompound tagCompound = itemstack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        return new Flower(tagCompound);
    }

    private IAlleleFlowerSpecies getPrimarySpecies(ItemStack itemstack) {
        IFlower flower = BotanyCore.getFlowerRoot().getMember(itemstack);
        if (flower == null) {
            return (IAlleleFlowerSpecies)BotanyCore.getFlowerRoot().getDefaultTemplate()[EnumFlowerChromosome.SPECIES.ordinal()];
        }
        return flower.getGenome().getPrimary();
    }

    public String func_77653_i(ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            return I18N.localise("item.botany.flower.corrupted.name");
        }
        IIndividual individual = this.getIndividual(itemstack);
        if (individual != null) {
            return individual.getDisplayName() + (!this.tag.isEmpty() ? ' ' + I18N.localise("item.botany." + this.tag + ".name") : "");
        }
        return I18N.localise("item.botany.flower.corrupted.name");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            this.addCreativeItems(items, true);
        }
    }

    public void addCreativeItems(NonNullList<ItemStack> itemList, boolean hideSecrets) {
        for (IIndividual individual : BotanyCore.getFlowerRoot().getIndividualTemplates()) {
            if (hideSecrets && individual.isSecret() && !Config.isDebug) continue;
            itemList.add((Object)BotanyCore.getFlowerRoot().getMemberStack(individual.copy(), this.type));
        }
    }

    public int getColorFromItemstack(ItemStack stack, int tintIndex) {
        IFlower flower = BotanyCore.getFlowerRoot().getMember(stack);
        if (flower == null) {
            return 0xFFFFFF;
        }
        if (tintIndex == 0) {
            return flower.getGenome().getStemColor().getColor(flower.isWilted());
        }
        return tintIndex == 1 ? flower.getGenome().getPrimaryColor().getColor(flower.isWilted()) : flower.getGenome().getSecondaryColor().getColor(flower.isWilted());
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (IFlowerType flowerType : BlockFlower.FLOWER.getAllowedValues()) {
            flowerType.registerModels(item, manager, this.type);
        }
        manager.registerItemModel(item, (ItemMeshDefinition)new BotanyMeshDefinition());
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.type == EnumFlowerStage.POLLEN) {
            return this.pollinateFlower(world, pos, player, stack);
        }
        return this.placeFlower(player, stack, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    private EnumActionResult pollinateFlower(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        IFlower flower = BotanyAPI.flowerRoot.getMember(stack);
        TileEntity target = world.func_175625_s(pos);
        if (!(target instanceof IPollinatable)) {
            return EnumActionResult.PASS;
        }
        IPollinatable pollinatable = (IPollinatable)target;
        if (!pollinatable.canMateWith((IIndividual)flower)) {
            return EnumActionResult.FAIL;
        }
        pollinatable.mateWith((IIndividual)flower);
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        return EnumActionResult.SUCCESS;
    }

    private EnumActionResult placeFlower(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (stack.func_190916_E() != 0 && player.func_175151_a(pos, facing, stack) && world.func_190527_a((Block)ModuleFlowers.flower, pos, false, facing, null)) {
            int i = this.func_77647_b(stack.func_77960_j());
            IBlockState stateForPlacement = ModuleFlowers.flower.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, i, (EntityLivingBase)player, hand);
            if (this.placeBlockAt(stack, player, world, pos, facing, hitX, hitY, hitZ, stateForPlacement)) {
                SoundType soundType = block.getSoundType(stateForPlacement, world, pos, (Entity)player);
                world.func_184133_a(player, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 3)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == ModuleFlowers.flower) {
            ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            ModuleFlowers.flower.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private class BotanyMeshDefinition
    implements ItemMeshDefinition {
        private BotanyMeshDefinition() {
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            IFlower flower = BotanyCore.getFlowerRoot().getMember(stack);
            Preconditions.checkNotNull((Object)flower);
            IAlleleFlowerSpecies flowerSpecies = flower.getGenome().getPrimary();
            return flowerSpecies.getFlowerModel(ItemFlowerGE.this.type, flower.hasFlowered());
        }
    }
}

