/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.acclimatiser;

import binnie.core.machines.IMachine;
import binnie.core.machines.MachineUtil;
import binnie.core.machines.errors.ErrorState;
import binnie.core.machines.errors.IErrorStateDefinition;
import binnie.core.machines.power.ComponentProcessIndefinate;
import binnie.genetics.machine.GeneticsErrorCode;
import binnie.genetics.machine.acclimatiser.Acclimatiser;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class AcclimatiserLogic
extends ComponentProcessIndefinate {
    public AcclimatiserLogic(IMachine machine) {
        super(machine, 2.0f);
    }

    @Override
    public ErrorState canWork() {
        MachineUtil machineUtil = this.getUtil();
        if (machineUtil.getStack(4).func_190926_b()) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.NO_INDIVIDUAL, 4);
        }
        if (machineUtil.getNonEmptyStacks(Acclimatiser.SLOT_ACCLIMATISER).isEmpty()) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.ACCLIMATISER_NO_ITEM, Acclimatiser.SLOT_ACCLIMATISER);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        MachineUtil machineUtil = this.getUtil();
        if (!Acclimatiser.canAcclimatise(machineUtil.getStack(4), machineUtil.getNonEmptyStacks(Acclimatiser.SLOT_ACCLIMATISER))) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.ACCLIMATISER_CAN_NOT_WORK, 4);
        }
        return super.canProgress();
    }

    @Override
    protected boolean inProgress() {
        return this.canWork() == null;
    }

    @Override
    protected void onTickTask() {
        super.onTickTask();
        if (this.getUtil().getRandom().nextInt(100) == 0) {
            this.attemptAcclimatisation();
        }
    }

    protected void attemptAcclimatisation() {
        ArrayList<ItemStack> acclms = new ArrayList<ItemStack>();
        MachineUtil machineUtil = this.getUtil();
        ItemStack target = machineUtil.getStack(4);
        if (target.func_190926_b()) {
            return;
        }
        for (ItemStack s : machineUtil.getNonEmptyStacks(Acclimatiser.SLOT_ACCLIMATISER)) {
            if (!Acclimatiser.canAcclimatise(target, s)) continue;
            acclms.add(s);
        }
        ItemStack acc = (ItemStack)acclms.get(machineUtil.getRandom().nextInt(acclms.size()));
        ItemStack acclimed = Acclimatiser.acclimatise(target, acc);
        machineUtil.setStack(4, acclimed);
        for (int i : Acclimatiser.SLOT_ACCLIMATISER) {
            ItemStack stack = machineUtil.getStack(i);
            if (stack.func_190926_b() || !stack.func_77969_a(acc)) continue;
            machineUtil.decreaseStack(i, 1);
            break;
        }
    }
}

