/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics.effect;

import binnie.extrabees.ExtraBees;
import binnie.extrabees.genetics.ExtraBeesFlowers;
import binnie.extrabees.genetics.effect.EntityBeeLightning;
import binnie.extrabees.genetics.effect.FireworkCreator;
import binnie.extrabees.utils.Utils;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IEffectData;
import forestry.core.render.ParticleRender;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum ExtraBeesEffect implements IAlleleBeeEffect
{
    ECTOPLASM{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            if (world.field_73012_v.nextInt(100) < 4) {
                if (world.func_175623_d(position) && (world.func_175677_d(position.func_177977_b(), false) || world.func_180495_p(position.func_177977_b()).func_177230_c() == ExtraBees.ectoplasm)) {
                    world.func_175656_a(position, ExtraBees.ectoplasm.func_176223_P());
                }
                return storedData;
            }
            return storedData;
        }
    }
    ,
    ACID{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            if (world.field_73012_v.nextInt(100) < 6) {
                2.doAcid(world, position);
            }
            return storedData;
        }
    }
    ,
    SPAWN_ZOMBIE{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            this.placeMob(world, position, "zombie");
            return storedData;
        }
    }
    ,
    SPAWN_SKELETON{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            this.placeMob(world, position, "skeleton");
            return storedData;
        }
    }
    ,
    SPAWN_CREEPER{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            this.placeMob(world, position, "creeper");
            return storedData;
        }
    }
    ,
    LIGHTNING{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            if (world.field_73012_v.nextInt(100) < 1 && world.func_175710_j(position) && world instanceof WorldServer) {
                world.func_72942_c((Entity)new EntityBeeLightning(world, position.func_177958_n(), position.func_177956_o(), position.func_177952_p()));
            }
            return storedData;
        }
    }
    ,
    RADIOACTIVE{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            for (EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
                int damage = 4;
                if (entity instanceof EntityPlayer) {
                    int count = 7.wearsItems((EntityPlayer)entity);
                    if (count > 3) continue;
                    if (count > 2) {
                        damage = 1;
                    } else if (count > 1) {
                        damage = 2;
                    } else if (count > 0) {
                        damage = 3;
                    }
                }
                entity.func_70097_a(DamageSource.field_76377_j, (float)damage);
            }
            return storedData;
        }
    }
    ,
    METEOR{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            if (world.field_73012_v.nextInt(100) < 1 && world.func_175710_j(position)) {
                world.func_72838_d((Entity)new EntitySmallFireball(world, (double)position.func_177958_n(), (double)(position.func_177956_o() + 64), (double)position.func_177952_p(), 0.0, -0.6, 0.0));
            }
            return storedData;
        }
    }
    ,
    HUNGER{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            for (EntityPlayer player : this.getEntities(EntityPlayer.class, genome, housing)) {
                if (world.field_73012_v.nextInt(4) < 9.wearsItems(player)) continue;
                player.func_71024_bL().func_75113_a(4.0f);
                player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 100));
            }
            return storedData;
        }
    }
    ,
    FOOD{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            for (EntityPlayer player : this.getEntities(EntityPlayer.class, genome, housing)) {
                player.func_71024_bL().func_75122_a(2, 0.2f);
            }
            return storedData;
        }
    }
    ,
    BLINDNESS{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            this.addPotionEffect(genome, housing, world, MobEffects.field_76440_q);
            return storedData;
        }
    }
    ,
    CONFUSION{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            this.addPotionEffect(genome, housing, world, MobEffects.field_76431_k);
            return storedData;
        }
    }
    ,
    FIREWORKS{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            if (world.field_73012_v.nextInt(8) < 1) {
                FireworkCreator.Firework firework = new FireworkCreator.Firework();
                firework.setShape(FireworkCreator.Shape.Ball);
                firework.addColor(genome.getPrimary().getSpriteColour(0));
                firework.addColor(genome.getPrimary().getSpriteColour(0));
                firework.addColor(genome.getPrimary().getSpriteColour(1));
                firework.addColor(genome.getSecondary().getSpriteColour(0));
                firework.addColor(genome.getSecondary().getSpriteColour(0));
                firework.addColor(genome.getPrimary().getSpriteColour(1));
                firework.setTrail();
                EntityFireworkRocket var11 = new EntityFireworkRocket(world, (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), firework.getFirework());
                if (world.func_175710_j(position)) {
                    world.func_72838_d((Entity)var11);
                }
            }
            return storedData;
        }
    }
    ,
    FESTIVAL{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            if (world.field_73012_v.nextInt(this == FIREWORKS ? 8 : 12) < 1) {
                FireworkCreator.Firework firework = new FireworkCreator.Firework();
                EntityFireworkRocket var11 = new EntityFireworkRocket(world, (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), firework.getFirework());
                if (world.func_175710_j(position)) {
                    world.func_72838_d((Entity)var11);
                }
            }
            return storedData;
        }
    }
    ,
    BIRTHDAY{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            if (world.field_73012_v.nextInt(this == FIREWORKS ? 8 : 12) < 1) {
                FireworkCreator.Firework firework = new FireworkCreator.Firework();
                firework.setShape(FireworkCreator.Shape.Star);
                firework.addColor(0xFFDD00);
                for (Birthday birthday : birthdays) {
                    if (!birthday.isToday()) continue;
                    firework.addColor(0xFF0000);
                    firework.addColor(65280);
                    firework.addColor(255);
                    firework.setTrail();
                    break;
                }
                EntityFireworkRocket var11 = new EntityFireworkRocket(world, (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), firework.getFirework());
                if (world.func_175710_j(position)) {
                    world.func_72838_d((Entity)var11);
                }
            }
            return storedData;
        }
    }
    ,
    TELEPORT{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            if (world.field_73012_v.nextInt(80) > 1) {
                return storedData;
            }
            List<Entity> entities = this.getEntities(Entity.class, genome, housing);
            if (entities.size() == 0) {
                return storedData;
            }
            Entity entity = entities.get(world.field_73012_v.nextInt(entities.size()));
            if (!(entity instanceof EntityLiving)) {
                return storedData;
            }
            int y = position.func_177956_o();
            if (y < 4) {
                y = 4;
            }
            if (!world.func_175623_d(position) || !world.func_175623_d(position.func_177984_a())) {
                return storedData;
            }
            entity.func_70634_a((double)position.func_177958_n(), (double)y, (double)position.func_177952_p());
            ((EntityLiving)entity).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 160, 10));
            return storedData;
        }
    }
    ,
    GRAVITY{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            List<Entity> entities = this.getEntities(Entity.class, genome, housing);
            for (Entity entity : entities) {
                double posZ;
                double posY;
                double posX;
                float entityStrength = 1.0f;
                if (entity instanceof EntityPlayer) {
                    entityStrength *= 100.0f;
                }
                if ((posX = (double)position.func_177958_n() - entity.field_70165_t) * posX + (posY = (double)position.func_177956_o() - entity.field_70163_u) * posY + (posZ = (double)position.func_177952_p() - entity.field_70161_v) * posZ < 2.0) {
                    return storedData;
                }
                double strength = 0.5 / (posX * posX + posY * posY + posZ * posZ) * (double)entityStrength;
                entity.func_70024_g(posX * strength, posY * strength, posZ * strength);
            }
            return storedData;
        }
    }
    ,
    THIEF{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            List<EntityPlayer> players = this.getEntities(EntityPlayer.class, genome, housing);
            for (EntityPlayer player : players) {
                double posZ;
                double posY;
                double posX = (double)position.func_177958_n() - player.field_70165_t;
                if (posX * posX + (posY = (double)position.func_177956_o() - player.field_70163_u) * posY + (posZ = (double)position.func_177952_p() - player.field_70161_v) * posZ < 2.0) {
                    return storedData;
                }
                double strength = 0.5 / (posX * posX + posY * posY + posZ * posZ);
                player.func_70024_g(-posX * strength, -posY * strength, -posZ * strength);
            }
            return storedData;
        }
    }
    ,
    WITHER{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            this.addPotionEffect(genome, housing, world, MobEffects.field_82731_v);
            return storedData;
        }
    }
    ,
    WATER{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            if (world.field_73012_v.nextInt(120) > 1) {
                return storedData;
            }
            IFluidHandler fluidHandler = (IFluidHandler)Utils.getCapability(world, position, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
            if (fluidHandler != null) {
                fluidHandler.fill(new FluidStack(FluidRegistry.WATER, 100), true);
                return storedData;
            }
            return storedData;
        }
    }
    ,
    SLOW{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            this.addPotionEffect(genome, housing, world, MobEffects.field_76437_t);
            return storedData;
        }
    }
    ,
    BONEMEAL_SAPLING{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            if (world.field_73012_v.nextInt(20) > 1) {
                return storedData;
            }
            if (ExtraBeesFlowers.SAPLING.isAcceptedFlower(world, position)) {
                ItemDye.func_179234_a((ItemStack)new ItemStack(Blocks.field_150346_d, 1), (World)world, (BlockPos)position);
                return storedData;
            }
            return storedData;
        }
    }
    ,
    BONEMEAL_FRUIT{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            if (world.field_73012_v.nextInt(20) > 1) {
                return storedData;
            }
            if (ExtraBeesFlowers.FRUIT.isAcceptedFlower(world, position)) {
                ItemDye.func_179234_a((ItemStack)new ItemStack(Blocks.field_150346_d, 1), (World)world, (BlockPos)position);
                return storedData;
            }
            return storedData;
        }
    }
    ,
    BONEMEAL_MUSHROOM{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            if (world.field_73012_v.nextInt(20) > 1) {
                return storedData;
            }
            IBlockState blockState = world.func_180495_p(position);
            if (blockState.func_177230_c() == Blocks.field_150338_P || blockState.func_177230_c() == Blocks.field_150337_Q) {
                ItemDye.func_179234_a((ItemStack)new ItemStack(Blocks.field_150346_d, 1), (World)world, (BlockPos)position);
                return storedData;
            }
            return storedData;
        }
    }
    ,
    POWER{

        @Override
        protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
            IEnergyStorage storage;
            TileEntity tile = world.func_175625_s(position);
            if (tile != null && (storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, EnumFacing.UP)) != null) {
                storage.receiveEnergy(5, false);
            }
            return storedData;
        }
    };

    private static final int DEFAULT_POTION_DURATION = 200;
    private static final List<Birthday> birthdays;
    private String fx = "";
    private final boolean combinable;
    private final boolean dominant;
    private final String uid = this.toString().toLowerCase();

    protected void addPotionEffect(IBeeGenome genome, IBeeHousing housing, World world, Potion effect) {
        this.addPotionEffect(genome, housing, world, effect, 200);
    }

    protected void addPotionEffect(IBeeGenome genome, IBeeHousing housing, World world, Potion effect, int duration) {
        for (EntityPlayer player : this.getEntities(EntityPlayer.class, genome, housing)) {
            if (world.field_73012_v.nextInt(4) < ExtraBeesEffect.wearsItems(player)) continue;
            player.func_70690_d(new PotionEffect(effect, duration));
        }
    }

    protected void placeMob(World world, BlockPos position, String mobName) {
        if (world.field_73012_v.nextInt(200) < 2) {
            this.spawnMob(world, position, new ResourceLocation(mobName));
        }
    }

    private ExtraBeesEffect() {
        this.combinable = false;
        this.dominant = true;
    }

    public static void doInit() {
        BLINDNESS.setFX("blindness");
        FOOD.setFX("food");
        GRAVITY.setFX("gravity");
        THIEF.setFX("gravity");
        TELEPORT.setFX("gravity");
        LIGHTNING.setFX("lightning");
        METEOR.setFX("meteor");
        RADIOACTIVE.setFX("radioactive");
        WATER.setFX("water");
        WITHER.setFX("wither");
        for (ExtraBeesEffect effect : ExtraBeesEffect.values()) {
            effect.register();
        }
    }

    public static void doAcid(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150347_e || block == Blocks.field_150348_b) {
            world.func_175656_a(pos, Blocks.field_150351_n.func_176223_P());
        } else if (block == Blocks.field_150346_d | block == Blocks.field_150349_c) {
            world.func_175656_a(pos, Blocks.field_150354_m.func_176223_P());
        }
    }

    public static int wearsItems(EntityPlayer player) {
        return BeeManager.armorApiaristHelper.wearsItems((EntityLivingBase)player, "", false);
    }

    public void register() {
        AlleleManager.alleleRegistry.registerAllele((IAllele)this, new IChromosomeType[0]);
    }

    public boolean isCombinable() {
        return this.combinable;
    }

    public IEffectData validateStorage(IEffectData storedData) {
        return storedData;
    }

    public String getName() {
        return ExtraBees.proxy.localise("effect." + this.name().toLowerCase() + ".name");
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public void spawnMob(World world, BlockPos pos, ResourceLocation name) {
        if (this.anyPlayerInRange(world, pos, 16)) {
            int nearbyEntityCount;
            double particleX = (float)pos.func_177958_n() + world.field_73012_v.nextFloat();
            double particleY = (float)pos.func_177956_o() + world.field_73012_v.nextFloat();
            double particleZ = (float)pos.func_177952_p() + world.field_73012_v.nextFloat();
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, particleX, particleY, particleZ, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, particleX, particleY, particleZ, 0.0, 0.0, 0.0, new int[0]);
            EntityLiving entity = (EntityLiving)EntityList.func_188429_b((ResourceLocation)name, (World)world);
            if (entity != null && (nearbyEntityCount = world.func_72872_a(entity.getClass(), new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)).func_72321_a(8.0, 4.0, 8.0)).size()) < 6) {
                double posX = (double)pos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 4.0;
                double posY = pos.func_177956_o() + world.field_73012_v.nextInt(3) - 1;
                double posZ = (double)pos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 4.0;
                entity.func_70012_b(posX, posY, posZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (entity.func_70601_bi()) {
                    world.func_72838_d((Entity)entity);
                    world.func_175718_b(2004, pos, 0);
                    entity.func_70656_aK();
                }
            }
        }
    }

    private boolean anyPlayerInRange(World world, BlockPos pos, int distance) {
        return world.func_184137_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (double)distance, false) != null;
    }

    public String getUID() {
        return "extrabees.effect." + this.uid;
    }

    protected abstract IEffectData doEffect(IBeeGenome var1, IEffectData var2, IBeeHousing var3, World var4, BlockPos var5);

    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int zPos;
        int yPos;
        World world = housing.getWorldObj();
        BlockPos coordinates = housing.getCoordinates();
        int xHouse = coordinates.func_177958_n();
        int yHouse = coordinates.func_177956_o();
        int zHouse = coordinates.func_177952_p();
        Vec3i area = this.getModifiedArea(genome, housing);
        int offsetX = 1 + area.func_177958_n() / 2;
        int offsetY = 1 + area.func_177956_o() / 2;
        int offsetZ = 1 + area.func_177952_p() / 2;
        int xPos = xHouse - offsetX + world.field_73012_v.nextInt(2 * offsetX + 1);
        BlockPos position = new BlockPos(xPos, yPos = yHouse - offsetY + world.field_73012_v.nextInt(2 * offsetY + 1), zPos = zHouse - offsetZ + world.field_73012_v.nextInt(2 * offsetZ + 1));
        if (world.func_175667_e(position)) {
            this.doEffect(genome, storedData, housing, world, position);
        }
        return storedData;
    }

    protected Vec3i getModifiedArea(IBeeGenome genome, IBeeHousing housing) {
        Vec3i territory = genome.getTerritory();
        if ((territory = new Vec3i(territory.func_177958_n() * (int)(BeeManager.beeRoot.createBeeHousingModifier(housing).getTerritoryModifier(genome, 1.0f) * 3.0f), territory.func_177956_o() * (int)(BeeManager.beeRoot.createBeeHousingModifier(housing).getTerritoryModifier(genome, 1.0f) * 3.0f), territory.func_177952_p() * (int)(BeeManager.beeRoot.createBeeHousingModifier(housing).getTerritoryModifier(genome, 1.0f) * 3.0f))).func_177958_n() < 1) {
            territory = new Vec3i(1, territory.func_177956_o(), territory.func_177952_p());
        }
        if (territory.func_177956_o() < 1) {
            territory = new Vec3i(territory.func_177958_n(), 1, territory.func_177952_p());
        }
        if (territory.func_177952_p() < 1) {
            territory = new Vec3i(territory.func_177958_n(), territory.func_177956_o(), 1);
        }
        return territory;
    }

    @SideOnly(value=Side.CLIENT)
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        IBeekeepingLogic beekeepingLogic = housing.getBeekeepingLogic();
        List flowerPositions = beekeepingLogic.getFlowerPositions();
        ParticleRender.addBeeHiveFX((IBeeHousing)housing, (IBeeGenome)genome, (List)flowerPositions);
        return storedData;
    }

    private void setFX(String string) {
        this.fx = "particles/" + string;
    }

    public <T extends Entity> List<T> getEntities(Class<T> eClass, IBeeGenome genome, IBeeHousing housing) {
        Vec3i area = genome.getTerritory();
        BlockPos coordinates = housing.getCoordinates();
        int[] offset = new int[]{-Math.round(area.func_177958_n() / 2), -Math.round(area.func_177956_o() / 2), -Math.round(area.func_177952_p() / 2)};
        int[] min = new int[]{coordinates.func_177958_n() + offset[0], coordinates.func_177956_o() + offset[1], coordinates.func_177952_p() + offset[2]};
        int[] max = new int[]{coordinates.func_177958_n() + offset[0] + area.func_177958_n(), coordinates.func_177956_o() + offset[1] + area.func_177956_o(), coordinates.func_177952_p() + offset[2] + area.func_177952_p()};
        AxisAlignedBB box = new AxisAlignedBB((double)min[0], (double)min[1], (double)min[2], (double)max[0], (double)max[1], (double)max[2]);
        return housing.getWorldObj().func_72872_a(eClass, box);
    }

    public String getUnlocalizedName() {
        return this.getUID();
    }

    static {
        birthdays = new ArrayList<Birthday>();
        birthdays.add(new Birthday(3, 10, "Binnie"));
    }

    public static class Birthday {
        private final int month;
        private final int date;
        private final String name;

        private Birthday(int month, int date, String name) {
            this.month = month;
            this.date = date + 1;
            this.name = name;
        }

        public boolean isToday() {
            return Calendar.getInstance().get(5) == this.date && Calendar.getInstance().get(2) == this.month;
        }

        public String getName() {
            return this.name;
        }
    }
}

