/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.farming;

import binnie.botany.EnumHelper;
import binnie.botany.api.gardening.EnumAcidity;
import binnie.botany.api.gardening.EnumMoisture;
import binnie.botany.farming.GardenLogic;
import binnie.core.circuits.BinnieCircuit;
import binnie.core.util.I18N;
import com.google.common.base.Preconditions;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class CircuitGarden
extends BinnieCircuit {
    private boolean isManual;
    private final GardenLogic logic;

    public CircuitGarden(EnumMoisture moisture, @Nullable EnumAcidity ph, boolean manual, boolean fertilised, ItemStack recipe, ItemStack icon) {
        super(CircuitGarden.getName(moisture, ph, manual, fertilised), 4, CircuitGarden.getLayout(manual), recipe);
        this.isManual = manual;
        this.logic = new GardenLogic(moisture, ph, this.isManual, fertilised, icon, I18N.localise(this.getUnlocalizedName()));
        String info = I18N.localise("botany.moisture") + ": " + EnumHelper.getLocalisedName(moisture, true) + TextFormatting.GRAY + ", ";
        if (ph != null) {
            info = info + I18N.localise("botany.ph") + ": " + EnumHelper.getLocalisedName(ph, true) + TextFormatting.GRAY + ", ";
        }
        String fertilizedKey = fertilised ? "for.binnie.circuit.garden.fertilized" : "for.binnie.circuit.garden.unfertilized";
        info = info + (fertilised ? TextFormatting.GREEN : TextFormatting.RED) + I18N.localise(fertilizedKey) + TextFormatting.GRAY;
        this.addTooltipString(I18N.localise("for.binnie.circuit.garden.info", info));
    }

    private static ICircuitLayout getLayout(boolean manual) {
        String layoutUid = manual ? "forestry.farms.manual" : "forestry.farms.managed";
        ICircuitLayout layout = ChipsetManager.circuitRegistry.getLayout(layoutUid);
        Preconditions.checkState((layout != null ? 1 : 0) != 0, (String)"Couldn't find Forestry circuit layout %s.", (Object)layoutUid);
        return layout;
    }

    private static String getName(EnumMoisture moisture, @Nullable EnumAcidity ph, boolean manual, boolean fertilised) {
        String name = "garden." + moisture.func_176610_l();
        if (ph != null) {
            name = name + "." + ph.func_176610_l();
        }
        if (manual) {
            name = name + ".manual";
        }
        if (fertilised) {
            name = name + ".fert";
        }
        return name;
    }

    public CircuitGarden setManual() {
        this.isManual = true;
        return this;
    }

    @Override
    public boolean isCircuitable(Object tile) {
        return tile instanceof IFarmHousing;
    }

    @Nullable
    private IFarmHousing getCircuitable(Object tile) {
        if (!this.isCircuitable(tile)) {
            return null;
        }
        return (IFarmHousing)tile;
    }

    @Override
    public void onInsertion(int slot, Object tile) {
        IFarmHousing housing = this.getCircuitable(tile);
        if (housing == null) {
            return;
        }
        this.logic.setManual(this.isManual);
        housing.setFarmLogic(FarmDirection.values()[slot], (IFarmLogic)this.logic);
    }

    @Override
    public void onLoad(int slot, Object tile) {
        this.onInsertion(slot, tile);
    }

    @Override
    public void onRemoval(int slot, Object tile) {
        IFarmHousing farmHousing = this.getCircuitable(tile);
        if (farmHousing == null) {
            return;
        }
        farmHousing.resetFarmLogic(FarmDirection.values()[slot]);
    }

    @Override
    public void onTick(int slot, Object tile) {
    }
}

