/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics.gui.analyst;

import binnie.core.api.gui.IArea;
import binnie.core.api.gui.ITitledWidget;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.gui.minecraft.control.ControlIconDisplay;
import binnie.core.util.I18N;
import binnie.core.util.TimeUtil;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.genetics.gui.analyst.AnalystPageSpecimen;
import binnie.genetics.api.analyst.IAnalystIcons;
import binnie.genetics.api.analyst.IAnalystManager;
import binnie.genetics.api.analyst.IAnalystPagePlugin;
import binnie.genetics.api.analyst.IBehaviourPlugin;
import binnie.genetics.api.analyst.IBiologyPlugin;
import binnie.genetics.api.analyst.IClimatePlugin;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IAlleleButterflyEffect;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import java.util.List;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ButterflyAnalystPagePlugin
implements IAnalystPagePlugin<IButterfly> {
    @Override
    public boolean handles(IIndividual individual) {
        return individual instanceof IButterfly;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addAnalystPages(IButterfly individual, IWidget parent, IArea pageSize, List<ITitledWidget> analystPages, IAnalystManager analystManager) {
        analystPages.add(analystManager.createClimatePage(parent, pageSize, individual, new ClimatePlugin()));
        analystPages.add(new AnalystPageSpecimen(parent, pageSize, individual));
        analystPages.add(analystManager.createBiologyPage(parent, pageSize, individual, new BiologyPlugin()));
        analystPages.add(analystManager.createBehaviorPage(parent, pageSize, individual, new BehaviorPlugin()));
    }

    private static class ClimatePlugin
    implements IClimatePlugin<IButterfly> {
        private ClimatePlugin() {
        }

        @Override
        public EnumTolerance getTemperatureTolerance(IButterfly butterfly) {
            IButterflyGenome genome = butterfly.getGenome();
            IAlleleTolerance tolerance = (IAlleleTolerance)genome.getActiveAllele((IChromosomeType)EnumButterflyChromosome.TEMPERATURE_TOLERANCE);
            return tolerance.getValue();
        }

        @Override
        public EnumTolerance getHumidityTolerance(IButterfly butterfly) {
            IButterflyGenome genome = butterfly.getGenome();
            IAlleleTolerance tolerance = (IAlleleTolerance)genome.getActiveAllele((IChromosomeType)EnumButterflyChromosome.HUMIDITY_TOLERANCE);
            return tolerance.getValue();
        }

        @Override
        public boolean showHumiditySection() {
            return true;
        }
    }

    private static class BehaviorPlugin
    implements IBehaviourPlugin<IButterfly> {
        private BehaviorPlugin() {
        }

        @Override
        public int addBehaviourPages(IButterfly individual, IWidget parent, int y) {
            IButterflyGenome genome = individual.getGenome();
            String metabolismAlleleName = ExtraTrees.mothBreedingSystem.getAlleleName((IChromosomeType)EnumButterflyChromosome.METABOLISM, genome.getActiveAllele((IChromosomeType)EnumButterflyChromosome.METABOLISM));
            new ControlTextCentered(parent, y, I18N.localise("genetics.gui.analyst.behaviour.metabolism", metabolismAlleleName)).setColor(parent.getColor());
            new ControlTextCentered(parent, y += 20, I18N.localise("genetics.gui.analyst.behaviour.pollinatesNearby") + "\n" + genome.getFlowerProvider().getDescription()).setColor(parent.getColor());
            new ControlTextCentered(parent, y += 20, I18N.localise("genetics.gui.analyst.behaviour.everyTime", TimeUtil.getTimeString(1500))).setColor(parent.getColor());
            y += 22;
            IAlleleButterflyEffect effect2 = genome.getEffect();
            if (!effect2.getUID().contains("None")) {
                String effectDesc2 = I18N.localiseOrBlank("binniecore.allele." + effect2.getUID() + ".desc");
                String loc2 = effectDesc2.isEmpty() ? I18N.localise("genetics.gui.analyst.behaviour.effect", effect2.getAlleleName()) : effectDesc2;
                new ControlText(parent, new Area(4, y, parent.getWidth() - 8, 0), loc2, TextJustification.TOP_CENTER).setColor(parent.getColor());
            }
            return y;
        }
    }

    private static class BiologyPlugin
    implements IBiologyPlugin<IButterfly> {
        private BiologyPlugin() {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int addBiologyPages(IButterfly butterfly, IWidget parent, int y, IAnalystManager analystManager) {
            IAnalystIcons icons = analystManager.getIcons();
            if (butterfly.getGenome().getNocturnal()) {
                new ControlIconDisplay(parent, (parent.getWidth() - 64) / 2, y, icons.getIconAllDay()).addTooltip(I18N.localise("genetics.gui.analyst.biology.allDay"));
            } else if (butterfly.getGenome().getPrimary().isNocturnal()) {
                new ControlIconDisplay(parent, (parent.getWidth() - 64) / 2, y, icons.getIconNight()).addTooltip(I18N.localise("genetics.gui.analyst.biology.night"));
            } else {
                new ControlIconDisplay(parent, (parent.getWidth() - 64) / 2, y, icons.getIconDaytime()).addTooltip(I18N.localise("genetics.gui.analyst.biology.day"));
            }
            if (!butterfly.getGenome().getTolerantFlyer()) {
                new ControlIconDisplay(parent, (parent.getWidth() - 64) / 2 + 24, y, icons.getIconNoRain()).addTooltip(I18N.localise("genetics.gui.analyst.biology.notRain"));
            } else {
                new ControlIconDisplay(parent, (parent.getWidth() - 64) / 2 + 24, y, icons.getIconRain()).addTooltip(I18N.localise("genetics.gui.analyst.biology.rain"));
            }
            if (butterfly.getGenome().getFireResist()) {
                new ControlIconDisplay(parent, (parent.getWidth() - 64) / 2 + 48, y, icons.getIconNoFire()).addTooltip(I18N.localise("genetics.gui.analyst.biology.nonflammable"));
            } else {
                new ControlIconDisplay(parent, (parent.getWidth() - 64) / 2 + 48, y, icons.getIconFire()).addTooltip(I18N.localise("genetics.gui.analyst.biology.flammable"));
            }
            y += 30;
            int fertility = butterfly.getGenome().getFertility();
            if (fertility > 1) {
                new ControlTextCentered(parent, y, I18N.localise("genetics.gui.analyst.biology.fertility.moths", fertility)).setColor(parent.getColor());
            } else {
                new ControlTextCentered(parent, y, I18N.localise("genetics.gui.analyst.biology.fertility.moth")).setColor(parent.getColor());
            }
            float caterpillarMatureTime = 1365.3999f * (float)Math.round(butterfly.getGenome().getLifespan() / (butterfly.getGenome().getFertility() * 2));
            new ControlTextCentered(parent, y += 32, I18N.localise("genetics.gui.analyst.biology.caterpillarGestation")).setColor(parent.getColor());
            new ControlTextCentered(parent, y += 12, TextFormatting.BOLD + TimeUtil.getMCDayString(caterpillarMatureTime)).setColor(parent.getColor());
            int speed = (int)(20.0f * butterfly.getGenome().getSpeed());
            new ControlTextCentered(parent, y += 22, I18N.localise("genetics.gui.analyst.biology.flightSpeed")).setColor(parent.getColor());
            new ControlTextCentered(parent, y += 12, TextFormatting.BOLD + I18N.localise("genetics.gui.analyst.biology.blocksPerSec", speed)).setColor(parent.getColor());
            return y += 22;
        }
    }
}

