/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics.gui.analyst;

import binnie.core.api.gui.IArea;
import binnie.core.api.gui.ITitledWidget;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.control.ControlIconDisplay;
import binnie.core.gui.minecraft.control.ControlItemDisplay;
import binnie.core.util.I18N;
import binnie.core.util.UniqueItemStackSet;
import binnie.genetics.api.analyst.IAnalystManager;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IChromosomeType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AnalystPageWood
extends Control
implements ITitledWidget {
    public AnalystPageWood(IWidget parent, IArea area, ITree ind, IAnalystManager analystManager) {
        super(parent, area);
        this.setColor(0x663300);
        ITreeGenome genome = ind.getGenome();
        int y = 4;
        new ControlTextCentered((IWidget)this, y, TextFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        y += 12;
        if (((IAlleleBoolean)ind.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.FIREPROOF)).getValue()) {
            new ControlIconDisplay((IWidget)this, (this.getWidth() - 16) / 2, y, analystManager.getIcons().getIconNoFire()).addTooltip(I18N.localise("genetics.gui.analyst.wood.fireproof"));
        } else {
            new ControlIconDisplay((IWidget)this, (this.getWidth() - 16) / 2, y, analystManager.getIcons().getIconFire()).addTooltip(I18N.localise("genetics.gui.analyst.wood.flammable"));
        }
        y += 30;
        UniqueItemStackSet products = new UniqueItemStackSet();
        IAlleleTreeSpecies treeSpecies = genome.getPrimary();
        ItemStack stackWood = treeSpecies.getWoodProvider().getWoodStack();
        if (!stackWood.func_190926_b()) {
            products.add(stackWood);
        }
        if (products.size() > 0) {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.wood.logs")).setColor(this.getColor());
            y += 10;
            int w = products.size() * 18 - 2;
            int i = 0;
            for (ItemStack stack : products) {
                ControlItemDisplay d = new ControlItemDisplay(this, (this.getWidth() - w) / 2 + 18 * i, y);
                d.setTooltip();
                d.setItemStack(stack);
                ++i;
            }
            y += 26;
        }
        UniqueItemStackSet allProducts = new UniqueItemStackSet();
        allProducts.addAll(products);
        UniqueItemStackSet refinedProducts = new UniqueItemStackSet();
        refinedProducts.addAll(analystManager.getAllProductsAndFluids(allProducts));
        if (refinedProducts.size() > 0) {
            y = analystManager.drawRefined(this, I18N.localise("genetics.gui.analyst.wood.refined"), y, refinedProducts);
            y += 8;
        }
        if (products.size() == 0) {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.wood.noFruits")).setColor(this.getColor());
            y += 28;
        }
        this.setSize(new Point(this.getWidth(), y + 8));
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.wood.title");
    }
}

