/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees;

import binnie.core.Binnie;
import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.gui.BinnieGUIHandler;
import binnie.extrabees.alveary.TileEntityExtraBeesAlvearyPart;
import binnie.extrabees.genetics.BeeBreedingSystem;
import binnie.extrabees.genetics.ExtraBeeDefinition;
import binnie.extrabees.genetics.ExtraBeesFlowers;
import binnie.extrabees.genetics.effect.ExtraBeesEffect;
import binnie.extrabees.genetics.gui.analyst.AnalystPagePlugin;
import binnie.extrabees.gui.ExtraBeesGUID;
import binnie.extrabees.init.BlockRegister;
import binnie.extrabees.init.ItemRegister;
import binnie.extrabees.init.RecipeRegister;
import binnie.extrabees.items.ItemHoneyCrystal;
import binnie.extrabees.items.ItemMiscProduct;
import binnie.extrabees.items.types.EnumHoneyComb;
import binnie.extrabees.proxy.ExtraBeesCommonProxy;
import binnie.extrabees.utils.AlvearyMutationHandler;
import binnie.extrabees.utils.MaterialBeehive;
import binnie.extrabees.utils.config.ConfigHandler;
import binnie.extrabees.utils.config.ConfigurationMain;
import binnie.extrabees.worldgen.ExtraBeesWorldGenerator;
import binnie.genetics.api.GeneticsApi;
import binnie.genetics.api.analyst.IAnalystManager;
import com.google.common.collect.Lists;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleSpeciesRegisterEvent;
import forestry.core.gui.GuiIdRegistry;
import forestry.core.gui.GuiType;
import forestry.core.proxy.Proxies;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="extrabees", name="Binnie's Extra Bees", version="2.5.0.153", acceptedMinecraftVersions="[1.12.2,1.13)", dependencies="required-after:binniecore")
public class ExtraBees {
    public static final String MODID = "extrabees";
    @Mod.Instance(value="extrabees")
    public static ExtraBees instance;
    @SidedProxy(clientSide="binnie.extrabees.proxy.ExtraBeesClientProxy", serverSide="binnie.extrabees.proxy.ExtraBeesCommonProxy")
    public static ExtraBeesCommonProxy proxy;
    public static IBreedingSystem beeBreedingSystem;
    public static ConfigHandler configHandler;
    @Nullable
    public static Material materialBeehive;
    @Nullable
    public static Block hive;
    @Nullable
    public static Block alveary;
    @Nullable
    public static Block ectoplasm;
    @Nullable
    public static Item comb;
    @Nullable
    public static Item propolis;
    @Nullable
    public static Item honeyDrop;
    @Nullable
    public static ItemHoneyCrystal honeyCrystal;
    @Nullable
    public static ItemMiscProduct itemMisc;
    @Nullable
    public static Item dictionaryBees;

    public ExtraBees() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        IAnalystManager analystManager;
        materialBeehive = new MaterialBeehive();
        File configFile = new File(event.getModConfigurationDirectory(), "forestry/extrabees/main.conf");
        configHandler = new ConfigHandler(configFile);
        configHandler.addConfigurable(new ConfigurationMain());
        BlockRegister.preInitBlocks();
        ItemRegister.preInitItems();
        this.registerGuis();
        Proxies.render.registerModels();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new BinnieGUIHandler(ExtraBeesGUID.values()));
        if (BeeManager.beeRoot != null) {
            beeBreedingSystem = new BeeBreedingSystem();
            Binnie.GENETICS.registerBreedingSystem(beeBreedingSystem);
        }
        if ((analystManager = GeneticsApi.analystManager) != null) {
            analystManager.registerAnalystPagePlugin(new AnalystPagePlugin());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        configHandler.reload(true);
        EnumHoneyComb.addSubtypes();
        ExtraBeesWorldGenerator extraBeesWorldGenerator = new ExtraBeesWorldGenerator();
        extraBeesWorldGenerator.doInit();
        GameRegistry.registerWorldGenerator((IWorldGenerator)extraBeesWorldGenerator, (int)0);
        ExtraBeesEffect.doInit();
        ExtraBeesFlowers.doInit();
        ExtraBeeDefinition.doInit();
        BlockRegister.doInitBlocks();
        RecipeRegister.doInitRecipes();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        AlvearyMutationHandler.registerMutationItems();
    }

    private void registerGuis() {
        try {
            Method m = GuiIdRegistry.class.getDeclaredMethod("registerGuiHandlers", GuiType.class, List.class);
            m.setAccessible(true);
            m.invoke(null, GuiType.Tile, Lists.newArrayList((Object[])new Class[]{TileEntityExtraBeesAlvearyPart.class}));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public void onRegisterSpecies(AlleleSpeciesRegisterEvent<IAlleleBeeSpecies> event) {
        if (event.getRoot() != BeeManager.beeRoot) {
            return;
        }
        ExtraBeeDefinition.doPreInit();
    }

    @SubscribeEvent
    public void onMissingItem(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            ResourceLocation newTotem;
            Item value;
            if (!entry.key.toString().equals("genetics:dictionary") || (value = (Item)ForgeRegistries.ITEMS.getValue(newTotem = new ResourceLocation("extrabees:dictionary"))) == null) continue;
            entry.remap((IForgeRegistryEntry)value);
        }
    }
}

