/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.acclimatiser;

import binnie.core.gui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.GeneticMachine;
import binnie.genetics.machine.acclimatiser.Acclimatiser;
import binnie.genetics.machine.acclimatiser.AcclimatiserLogic;
import binnie.genetics.machine.acclimatiser.ValidatorAcclimatiserItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;

public class PackageAcclimatiser
extends GeneticMachine.PackageGeneticBase
implements IMachineInformation {
    public PackageAcclimatiser() {
        super("acclimatiser", 9857609);
    }

    @Override
    public void createMachine(Machine machine) {
        new ComponentGeneticGUI(machine, GeneticsGUI.ACCLIMATISER);
        ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
        InventorySlot slotTarget = inventory.addSlot(4, this.getSlotRL("process"));
        slotTarget.setValidator(new SlotValidator.Individual());
        slotTarget.setReadOnly();
        slotTarget.forbidExtraction();
        for (InventorySlot slot : inventory.addSlotArray(Acclimatiser.SLOT_RESERVE, this.getSlotRL("input"))) {
            slot.forbidExtraction();
            slot.setValidator(new SlotValidator.Individual());
        }
        for (InventorySlot slot : inventory.addSlotArray(Acclimatiser.SLOT_DRONE, this.getSlotRL("output"))) {
            slot.setReadOnly();
            slot.setValidator(new SlotValidator.Individual());
        }
        for (InventorySlot slot : inventory.addSlotArray(Acclimatiser.SLOT_ACCLIMATISER, this.getSlotRL("acclimatiser"))) {
            slot.setValidator(new ValidatorAcclimatiserItem());
        }
        ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
        transfer.addRestock(Acclimatiser.SLOT_RESERVE, 4, 1);
        transfer.addStorage(4, Acclimatiser.SLOT_DRONE, stack -> {
            NonNullList<ItemStack> stacks = machine.getMachineUtil().getNonEmptyStacks(Acclimatiser.SLOT_ACCLIMATISER);
            return !Acclimatiser.canAcclimatise(stack, stacks);
        });
        new ComponentPowerReceptor(machine, 5000);
        new AcclimatiserLogic(machine);
    }

    @Override
    public TileEntity createTileEntity() {
        return new TileEntityMachine(this);
    }
}

