/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.init;

import binnie.extrabees.ExtraBees;
import binnie.extrabees.alveary.BlockAlveary;
import binnie.extrabees.alveary.TileEntityExtraBeesAlvearyPart;
import binnie.extrabees.blocks.BlockEctoplasm;
import binnie.extrabees.blocks.BlockExtraBeeHives;
import binnie.extrabees.blocks.type.EnumHiveType;
import binnie.extrabees.genetics.ExtraBeeDefinition;
import binnie.extrabees.utils.HiveDrop;
import binnie.extrabees.utils.Utils;
import binnie.extrabees.utils.config.ConfigurationMain;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.apiculture.genetics.BeeDefinition;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class BlockRegister {
    public static void preInitBlocks() {
        BlockRegister.registerHives();
        BlockRegister.registerMisc();
        ExtraBees.alveary = ExtraBees.proxy.registerBlock(new BlockAlveary());
        GameRegistry.registerTileEntity(TileEntityExtraBeesAlvearyPart.class, (String)"TileEntityExtraBeesAlvearyPart");
    }

    public static void doInitBlocks() {
        BlockRegister.registerHiveDrops();
    }

    private static void registerMisc() {
        ExtraBees.ectoplasm = new BlockEctoplasm();
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)ExtraBees.ectoplasm);
    }

    private static void registerHives() {
        ExtraBees.hive = new BlockExtraBeeHives();
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)ExtraBees.hive);
    }

    private static void registerHiveDrops() {
        IAlleleBeeSpecies valiantSpecies = Utils.getSpecies(BeeDefinition.VALIANT);
        EnumHiveType.WATER.addDrops(new HiveDrop(ExtraBeeDefinition.WATER, 0.8), new HiveDrop(valiantSpecies, 0.03));
        EnumHiveType.ROCK.addDrops(new HiveDrop(ExtraBeeDefinition.ROCK, 0.8), new HiveDrop(valiantSpecies, 0.03));
        EnumHiveType.NETHER.addDrops(new HiveDrop(ExtraBeeDefinition.BASALT, 0.8), new HiveDrop(valiantSpecies, 0.03));
        EnumHiveType.MARBLE.addDrops(new HiveDrop(ExtraBeeDefinition.MARBLE, 0.8), new HiveDrop(valiantSpecies, 0.03));
        if (!ConfigurationMain.isCanQuarryMineHives()) {
            // empty if block
        }
    }
}

